/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.proxydownload;

import com.kingdee.eas.applet.httpdownload.util.DebugLogger;
import com.kingdee.eas.applet.httpdownload.util.ObjectFIFO;
import com.kingdee.eas.applet.httpdownload.util.ThreadPool;
import com.kingdee.eas.applet.proxydownload.ProxyDMConfig;
import com.kingdee.eas.applet.proxydownload.ProxyDownloadTask;
import com.kingdee.eas.applet.proxydownload.ProxyDownloadWorker;
import com.kingdee.eas.applet.proxydownload.ProxyFileInfo;
import java.util.ArrayList;

final class ProxyDownloadManager
extends Thread {
    private static final ProxyDownloadManager instance = new ProxyDownloadManager();
    private ProxyDMConfig downloadConfig;
    private ThreadPool threadPool;
    private ObjectFIFO downloadWorkers = new ObjectFIFO(10000);

    private ProxyDownloadManager() {
        this.downloadConfig = ProxyDMConfig.getConfig();
        this.threadPool = new ThreadPool(this.downloadConfig.getTotalDownloadThreads());
        this.setName("DownloadMangerThread");
        DebugLogger.getDebugLogger().setLogName("ProxyDownloader");
        this.start();
    }

    public static ProxyDownloadManager getInstance() {
        return instance;
    }

    ProxyDMConfig getDownloadManagerConfig() {
        return this.downloadConfig;
    }

    void runTask(ProxyDownloadTask task) throws InterruptedException {
        ArrayList list = task.getFilesToDownload();
        int filesCount = list.size();
        if (filesCount > 0) {
            for (int i = 0; i < filesCount; ++i) {
                ProxyFileInfo fileToDownload = (ProxyFileInfo)list.get(i);
                this.downloadWorkers.add(new ProxyDownloadWorker(task, fileToDownload));
            }
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.threadPool.execute((ProxyDownloadWorker)this.downloadWorkers.remove());
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }
}

