/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.proxydownload;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class Util {
    private static final Logger logger = Logger.getLogger((Class)Util.class);

    static void close(Object x) {
        block13: {
            try {
                if (x == null) {
                    return;
                }
                if (x instanceof InputStream) {
                    ((InputStream)x).close();
                } else if (x instanceof OutputStream) {
                    ((OutputStream)x).close();
                } else if (x instanceof Socket) {
                    ((Socket)x).close();
                } else if (x instanceof ServerSocket) {
                    ((ServerSocket)x).close();
                } else if (x instanceof DatagramSocket) {
                    ((DatagramSocket)x).close();
                } else {
                    x.getClass().getMethod("close", new Class[0]).invoke(x, new Object[0]);
                }
            }
            catch (Exception e) {
                if (e instanceof IOException) break block13;
                e.printStackTrace();
            }
        }
    }

    public static MessageDigest md5() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
    }

    public static String getMD5(String s) {
        MessageDigest md = Util.md5();
        byte[] d = md.digest(s.getBytes());
        return Util.toString(d);
    }

    public static String getMD5(File file) throws IOException {
        int l;
        MessageDigest md = Util.md5();
        FileInputStream in = new FileInputStream(file);
        byte[] buf = new byte[4096];
        while ((l = in.read(buf)) > 0) {
            md.update(buf, 0, l);
        }
        in.close();
        byte[] d = md.digest();
        return Util.toString(d);
    }

    public static String toString(byte[] b) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            int c = 0xFF & b[i];
            int h = c / 16;
            int l = c & 0xF;
            sb.append((char)(h < 10 ? 48 + h : 97 + h - 10));
            sb.append((char)(l < 10 ? 48 + l : 97 + l - 10));
        }
        return sb.toString();
    }

    public static boolean isNull(String s) {
        return s == null || s.length() == 0 || s.equals("null");
    }

    public static InetAddress getInetAddress(String subnetMask) throws IOException {
        if (Util.isNull(subnetMask)) {
            return null;
        }
        byte[] mask = InetAddress.getByName(subnetMask).getAddress();
        Enumeration<NetworkInterface> ne = NetworkInterface.getNetworkInterfaces();
        while (ne.hasMoreElements()) {
            NetworkInterface nif = ne.nextElement();
            Enumeration<InetAddress> ae = nif.getInetAddresses();
            while (ae.hasMoreElements()) {
                InetAddress addr = ae.nextElement();
                byte[] bytes = addr.getAddress();
                if (mask.length != bytes.length) continue;
                boolean matched = true;
                for (int i = 0; i < mask.length; ++i) {
                    int m = 0xFF & mask[i];
                    int b = 0xFF & bytes[i];
                    if (m == 255 || m == b) continue;
                    matched = false;
                    break;
                }
                if (!matched) continue;
                return addr;
            }
        }
        logger.warn((Object)("none ip address match '" + subnetMask + "'"));
        return null;
    }

    public static String readString(DataInputStream in) throws IOException {
        int len = in.readInt();
        if (len < 0) {
            return null;
        }
        char[] cs = new char[len];
        for (int i = 0; i < len; ++i) {
            cs[i] = in.readChar();
        }
        return new String(cs);
    }

    public static void writeString(DataOutputStream out, String s) throws IOException {
        int len = s == null ? -1 : s.length();
        out.writeInt(len);
        if (len >= 0) {
            for (int i = 0; i < len; ++i) {
                out.writeChar(s.charAt(i));
            }
        }
    }

    public static InetAddress getFirstNonLoopbackAddress() {
        try {
            Enumeration<NetworkInterface> ne = NetworkInterface.getNetworkInterfaces();
            while (ne.hasMoreElements()) {
                NetworkInterface nif = ne.nextElement();
                Enumeration<InetAddress> ae = nif.getInetAddresses();
                while (ae.hasMoreElements()) {
                    InetAddress addr = ae.nextElement();
                    if (addr.isLoopbackAddress()) continue;
                    return addr;
                }
            }
            return InetAddress.getLocalHost();
        }
        catch (IOException ioe) {
            throw new Error("Network error", ioe);
        }
    }

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[4096];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    public static byte[] getStreamData(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Util.copyStream(in, out);
        return out.toByteArray();
    }

    public static String getStreamText(InputStream in) throws IOException {
        return new String(Util.getStreamData(in));
    }

    public static String formatDate(long time) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return df.format(new Date(time));
    }

    public static String formatTime(long time) {
        return "" + time / 3600000L + ":" + time % 3600000L / 60000L + ":" + time % 60000L / 1000L;
    }

    public static class MD5InputStream
    extends InputStream {
        public final InputStream in;
        public final MessageDigest md = Util.md5();

        public MD5InputStream(InputStream in) {
            this.in = in;
        }

        public int available() throws IOException {
            return this.in.available();
        }

        public void close() throws IOException {
            this.in.close();
        }

        public int read() throws IOException {
            int b = this.in.read();
            if (b != -1) {
                this.md.update((byte)b);
            }
            return b;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if ((len = this.in.read(b, off, len)) > 0) {
                this.md.update(b, off, len);
            }
            return len;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }
    }

    public static class MD5OutputStream
    extends OutputStream {
        public final OutputStream out;
        public final MessageDigest md = Util.md5();

        public MD5OutputStream(OutputStream out) {
            this.out = out;
        }

        public void close() throws IOException {
            this.out.close();
        }

        public void flush() throws IOException {
            this.out.flush();
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.md.update(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(int b) throws IOException {
            this.out.write(b);
            this.md.update((byte)b);
        }
    }
}

