/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.webutil;

import com.kingdee.bos.autoupdate.jnl.ApplicationInfo;
import com.kingdee.bos.autoupdate.jnl.JARInfo;
import com.kingdee.bos.autoupdate.jnl.JREInfo;
import com.kingdee.bos.autoupdate.jnl.LaunchInfo;
import com.kingdee.bos.autoupdate.jnl.NativeLibInfo;
import com.kingdee.bos.autoupdate.jnl.PropertyInfo;
import com.kingdee.bos.autoupdate.jnl.ResourceCollection;
import com.kingdee.bos.autoupdate.jnl.ResourceInfo;
import com.kingdee.bos.autoupdate.util.URLUtil;
import com.kingdee.eas.applet.EASCacheEntryInfo;
import com.kingdee.eas.applet.EASJNLPCacheEntryInfo;
import com.twmacinta.util.MD5;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class CreateJNLPResource {
    private static final String JAR_TAG = "jar";
    private static final String JAR_EXT_NAME = ".jar";
    private static final String NATIVELIB_TAG = "nativelib";

    public static void main(String[] args) {
        String baseDir = "C:/kingdee/eas/client";
        if (args.length > 0) {
            baseDir = args[0];
        }
        String traceFlagFile = "update.properties";
        if (args.length > 1) {
            traceFlagFile = args[1];
        }
        String jnlpCodeBase = "http://localhost:6888/easWebClient/";
        if (args.length > 2) {
            jnlpCodeBase = args[2];
        }
        String resxFilted = "/bin/,/logs/";
        if (args.length > 3) {
            resxFilted = args[3];
        }
        try {
            new CreateJNLPResource().createLocalJNLPResource(baseDir, traceFlagFile, jnlpCodeBase, resxFilted);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createLocalJNLPResource(String baseDir, String outFile, String codeBase) throws Exception {
        String pathFiltedStr = "/bin/,/logs/,/cache/,/classloader/,/lib/";
        this.createLocalJNLPResource(baseDir, outFile, codeBase, pathFiltedStr);
    }

    private void scanFileLists(String preFilePath, String path, String extName, StringBuffer sbfile) throws Exception {
        if (path == null || "".equals(path)) {
            throw new Exception("[EAS Portal] path is null.");
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        File folder = new File(path);
        File currentFile = null;
        String[] files = null;
        String file = null;
        String version = null;
        long modifyTime = 0L;
        if (folder.isDirectory()) {
            files = folder.list();
            for (int i = 0; i < files.length; ++i) {
                file = path + files[i];
                currentFile = new File(file);
                if (currentFile.isDirectory()) {
                    this.scanFileLists(preFilePath, file, extName, sbfile);
                    continue;
                }
                if (!currentFile.isFile()) continue;
                if (currentFile.length() == 0L) {
                    currentFile.delete();
                    continue;
                }
                if (this.isPathFilted(file, extName) || file.endsWith(".dl") || file.endsWith(".info")) continue;
                version = MD5.asHex(MD5.getHash(currentFile));
                modifyTime = currentFile.lastModified();
                sbfile.append("<");
                if (file.endsWith(JAR_EXT_NAME)) {
                    sbfile.append(JAR_TAG);
                } else {
                    sbfile.append(NATIVELIB_TAG);
                }
                sbfile.append(" lastModified=\"").append(modifyTime).append("\"");
                sbfile.append(" md5Version=\"").append(version).append("\"");
                file = file.replaceAll(preFilePath, "");
                sbfile.append(" HREF=\"").append(file).append("\"/>\r\n");
            }
        } else {
            currentFile = folder;
            file = path.substring(0, path.length() - 1);
            if (currentFile.length() == 0L) {
                currentFile.delete();
            }
            if (this.isPathFilted(file, extName) || file.endsWith(".dl") || file.endsWith(".info")) {
                // empty if block
            }
            version = MD5.asHex(MD5.getHash(currentFile));
            modifyTime = currentFile.lastModified();
            sbfile.append("<");
            if (file.endsWith(JAR_EXT_NAME)) {
                sbfile.append(JAR_TAG);
            } else {
                sbfile.append(NATIVELIB_TAG);
            }
            sbfile.append(" lastModified=\"").append(modifyTime).append("\"");
            sbfile.append(" md5Version=\"").append(version).append("\"");
            file = file.replaceAll(preFilePath, "");
            sbfile.append(" HREF=\"").append(file).append("\"/>\r\n");
        }
    }

    public void createLocalJNLPResource(String baseDir, String traceFlagFile, String jnlpFullURL, String pathFiltedStr) throws Exception {
        ArrayList<String> relativeResxPaths = new ArrayList<String>();
        relativeResxPaths.add("/");
        this.createLocalJNLPResource(baseDir, traceFlagFile, jnlpFullURL, pathFiltedStr, relativeResxPaths);
    }

    public void createLocalJNLPResource(String baseDir, String traceFlagFile, String jnlpFullURL, String pathFiltedStr, Collection relativeResxPaths) throws Exception {
        String seperator = "\\\\";
        String preFilePath = baseDir = baseDir.replaceAll(seperator, "/");
        if (!baseDir.endsWith("/")) {
            preFilePath = preFilePath + "/";
        }
        String jnlpUrlStr = "eas.jnlp";
        if (jnlpFullURL != null && jnlpFullURL.lastIndexOf("/") > -1) {
            jnlpUrlStr = jnlpFullURL.substring(jnlpFullURL.lastIndexOf("/") + 1);
        }
        StringBuffer sbfile = new StringBuffer();
        Iterator ite = relativeResxPaths.iterator();
        String resxPath = "";
        String relativeResxPath = "";
        File tmpDir = null;
        while (ite.hasNext()) {
            relativeResxPath = (String)ite.next();
            tmpDir = new File(baseDir, relativeResxPath);
            if (!tmpDir.exists()) continue;
            resxPath = tmpDir.getPath();
            resxPath = resxPath.replaceAll(seperator, "/");
            this.scanFileLists(preFilePath, resxPath, pathFiltedStr + ",/" + traceFlagFile + ",/" + jnlpUrlStr, sbfile);
        }
        String jnlpCreatedByLocalScan = "jnlpCreatedByLocalScan=true";
        jnlpUrlStr = jnlpUrlStr.indexOf(63) > -1 ? jnlpUrlStr + "&amp;" + jnlpCreatedByLocalScan : jnlpUrlStr + "?" + jnlpCreatedByLocalScan;
        String codeBase = "http://localhost:6888/";
        if (jnlpFullURL != null) {
            codeBase = jnlpFullURL.substring(0, jnlpFullURL.lastIndexOf("/"));
        }
        StringBuffer sb = new StringBuffer("");
        long createTime = System.currentTimeMillis();
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
        sb.append("<jnlp LASTMODIFIED=\"").append(createTime).append("\" CODEBASE=\"").append(codeBase).append("/\" HREF=\"" + jnlpUrlStr + "\" SPEC=\"1.0+\">\r\n");
        sb.append("\t\t<application-desc MAIN-CLASS=\"com.kingdee.eas.base.uiframe.client.LoginFrame\"/>\r\n");
        sb.append(CreateJNLPResource.appendInfoNode());
        sb.append("\t\t<resources>\r\n");
        sb.append("\t\t").append(sbfile).append("\r\n");
        sb.append("\t\t</resources>\r\n");
        sb.append("</jnlp>\r\n");
        CreateJNLPResource.createEasJnlpWithUTF8(new File(baseDir), sb, jnlpUrlStr);
    }

    private boolean isPathFilted(String file, String pathFiltedStr) {
        boolean result = false;
        if (pathFiltedStr != null && file != null && !"".equals(pathFiltedStr)) {
            if (pathFiltedStr.indexOf(44) > -1) {
                String[] paths = pathFiltedStr.split(",");
                for (int i = 0; i < paths.length; ++i) {
                    if (paths[i] == null || "".equals(paths[i]) || file.toLowerCase().indexOf(paths[i].toLowerCase()) <= -1) continue;
                    result = true;
                    break;
                }
            } else if (file.toLowerCase().indexOf(pathFiltedStr.toLowerCase()) > -1) {
                result = true;
            }
        }
        return result;
    }

    public static String store(File baseDir, LaunchInfo jnlpLaunchInfo, EASJNLPCacheEntryInfo jnlpCache) {
        StringBuffer sb = new StringBuffer("");
        String codeBase = jnlpCache.getCodebase().toString();
        String jnlpUrlStr = jnlpLaunchInfo.getHref().getPath();
        if (jnlpUrlStr != null) {
            int idx = jnlpUrlStr.lastIndexOf("/");
            if (idx > -1) {
                jnlpUrlStr = jnlpUrlStr.substring(idx + 1);
            }
        } else {
            jnlpUrlStr = "eas.jnlp";
        }
        String oldHref = jnlpUrlStr;
        if (jnlpCache.getHref().getQuery() != null) {
            oldHref = oldHref + "?" + jnlpCache.getHref().getQuery();
        } else if (jnlpLaunchInfo.getHref().getQuery() != null) {
            oldHref = oldHref + "?" + jnlpLaunchInfo.getHref().getQuery();
        }
        String jnlpHeader = CreateJNLPResource.appendHeader(codeBase, oldHref);
        sb.append(jnlpHeader);
        String jnlpApp = CreateJNLPResource.appendAppNode(jnlpLaunchInfo.getAppInfo());
        sb.append(jnlpApp);
        String jnlpInfo = CreateJNLPResource.appendInfoNode();
        sb.append(jnlpInfo);
        String jnlpResxs = CreateJNLPResource.appendResxsNode(jnlpLaunchInfo.getResources(), jnlpCache);
        sb.append(jnlpResxs);
        String jnlpTail = CreateJNLPResource.appendTail();
        sb.append(jnlpTail);
        System.out.println("---before store " + jnlpUrlStr + " ---");
        String encoding = System.getProperty("file.encoding");
        System.out.println("Default System Encoding: " + encoding);
        String jnlpFileName = CreateJNLPResource.createEasJnlpWithUTF8(baseDir, sb, jnlpUrlStr);
        System.out.println("---after store eas.jnlp---");
        sb = null;
        return jnlpFileName;
    }

    public static String storeLst(File baseDir, LaunchInfo jnlpLaunchInfo, EASJNLPCacheEntryInfo jnlpCache, String codeBase) {
        StringBuffer sb = new StringBuffer("");
        String jnlpUrlStr = jnlpLaunchInfo.getHref().getPath();
        if (jnlpUrlStr != null) {
            int idx = jnlpUrlStr.lastIndexOf("/");
            if (idx > -1) {
                jnlpUrlStr = jnlpUrlStr.substring(idx + 1);
            }
        } else {
            jnlpUrlStr = "eas.jnlp";
        }
        String oldHref = jnlpUrlStr;
        if (jnlpLaunchInfo.getHref().getQuery() != null) {
            oldHref = oldHref + "?" + jnlpLaunchInfo.getHref().getQuery();
        }
        String jnlpHeader = CreateJNLPResource.appendHeader(codeBase, oldHref);
        sb.append(jnlpHeader);
        String jnlpApp = CreateJNLPResource.appendAppNode(jnlpLaunchInfo.getAppInfo());
        sb.append(jnlpApp);
        String jnlpInfo = CreateJNLPResource.appendInfoNode();
        sb.append(jnlpInfo);
        String jnlpResxs = CreateJNLPResource.appendResxsNodeLst(jnlpLaunchInfo.getResources(), jnlpCache);
        sb.append(jnlpResxs);
        String jnlpTail = CreateJNLPResource.appendTail();
        sb.append(jnlpTail);
        System.out.println("---before store " + jnlpUrlStr + " ---");
        String encoding = System.getProperty("file.encoding");
        System.out.println("Default System Encoding: " + encoding);
        String jnlpFileName = CreateJNLPResource.createEasJnlpWithUTF8(baseDir, sb, jnlpUrlStr);
        System.out.println("---after store eas.jnlp---");
        sb = null;
        return jnlpFileName;
    }

    private static String createEasJnlpWithUTF8(File baseDir, StringBuffer sb, String jnlpUrlStr) {
        try {
            File fl;
            if (jnlpUrlStr != null && jnlpUrlStr.indexOf("?") > -1) {
                jnlpUrlStr = jnlpUrlStr.substring(0, jnlpUrlStr.indexOf("?"));
            }
            if (!(fl = new File(baseDir, jnlpUrlStr)).exists()) {
                fl.createNewFile();
            }
            FileOutputStream fileos = new FileOutputStream(fl);
            String charset = "UTF-8";
            byte[] outBytes = sb.toString().getBytes(charset);
            int bufSize = 4096;
            int start = 0;
            int len = bufSize;
            int i = 1;
            while (start < outBytes.length) {
                if (start + len > outBytes.length) {
                    len = outBytes.length - start;
                }
                fileos.write(outBytes, start, len);
                start = bufSize * (++i - 1);
            }
            fileos.flush();
            fileos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jnlpUrlStr;
    }

    private static void testPrintWriter(File baseDir, LaunchInfo jnlpLaunchInfo, EASJNLPCacheEntryInfo jnlpCache, String jnlpHeader, String jnlpApp, String jnlpInfo, String jnlpTail) {
        try {
            File fl = new File(baseDir, "eas_pw.jnlp");
            if (!fl.exists()) {
                fl.createNewFile();
            }
            FileWriter fw = new FileWriter(fl);
            PrintWriter out = new PrintWriter(fw);
            out.print(jnlpHeader);
            out.print(jnlpApp);
            out.println(jnlpInfo);
            CreateJNLPResource.appendResxsNode(out, jnlpLaunchInfo.getResources(), jnlpCache);
            out.println(jnlpTail);
            out.flush();
            out.close();
            fw.close();
        }
        catch (IOException e) {
            System.out.println("Uh oh, got an IOException error!");
            e.printStackTrace();
        }
    }

    private static void testWriterWithDefaultCharset(File baseDir, StringBuffer sb) {
        try {
            File fl = new File(baseDir, "eas_old.jnlp");
            if (!fl.exists()) {
                fl.createNewFile();
            }
            FileWriter fw = new FileWriter(fl);
            fw.write(sb.toString());
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void appendResxsNode(PrintWriter out, ResourceCollection resources, EASJNLPCacheEntryInfo cache) {
        out.println("<resources>\r\n");
        HashMap resxMap = CreateJNLPResource.toMap(resources.getResources());
        Iterator ite = cache.getCacheEntries().iterator();
        URL codeBase = cache.getCodebase();
        EASCacheEntryInfo entry = null;
        while (ite.hasNext()) {
            entry = (EASCacheEntryInfo)((Object)ite.next());
            out.println(CreateJNLPResource.appendResxNode(entry, resxMap, codeBase));
        }
        out.println("</resources>\r\n");
    }

    private static HashMap toMap(ResourceInfo[] resources) {
        HashMap<String, ResourceInfo> result = new HashMap<String, ResourceInfo>();
        for (int i = 0; i < resources.length; ++i) {
            result.put(resources[i].getHref().toString(), resources[i]);
        }
        return result;
    }

    private static String appendResxsNode(ResourceCollection resources, EASJNLPCacheEntryInfo cache) {
        StringBuffer sb = new StringBuffer("");
        sb.append("<resources>\r\n");
        HashMap resxMap = CreateJNLPResource.toMap(resources.getResources());
        Iterator ite = cache.getCacheEntries().iterator();
        URL codeBase = cache.getCodebase();
        EASCacheEntryInfo entry = null;
        while (ite.hasNext()) {
            entry = (EASCacheEntryInfo)((Object)ite.next());
            sb.append(CreateJNLPResource.appendResxNode(entry, resxMap, codeBase));
        }
        sb.append("</resources>\r\n");
        return sb.toString();
    }

    private static String appendResxsNodeLst(ResourceCollection resources, EASJNLPCacheEntryInfo cache) {
        StringBuffer sb = new StringBuffer("");
        sb.append("<resources>\r\n");
        HashMap resxMap = CreateJNLPResource.toMap(resources.getResources());
        Iterator ite = cache.getCacheEntries().iterator();
        URL codeBase = cache.getCodebase();
        EASCacheEntryInfo entry = null;
        while (ite.hasNext()) {
            entry = (EASCacheEntryInfo)((Object)ite.next());
            sb.append(CreateJNLPResource.appendResxNodeLst(entry, resxMap, codeBase));
        }
        sb.append("</resources>\r\n");
        return sb.toString();
    }

    private static String appendResxNode(EASCacheEntryInfo entry, HashMap resxMap, URL codeBase) {
        String result = "";
        ResourceInfo resx = null;
        String href = entry.getHref().toString();
        if (resxMap.containsKey(href) && !((resx = (ResourceInfo)resxMap.get(href)) instanceof JREInfo)) {
            if (resx instanceof JARInfo) {
                result = CreateJNLPResource.appendJarNode(entry, (JARInfo)resx, codeBase);
            } else if (resx instanceof NativeLibInfo) {
                result = CreateJNLPResource.appendNativeLibNode(entry, (NativeLibInfo)resx, codeBase);
            } else if (resx instanceof PropertyInfo) {
                // empty if block
            }
        }
        return result;
    }

    private static String appendResxNodeLst(EASCacheEntryInfo entry, HashMap resxMap, URL codeBase) {
        String result = "";
        ResourceInfo resx = null;
        String href = entry.getHref().toString();
        if (resxMap.containsKey(href)) {
            resx = (ResourceInfo)resxMap.get(href);
            if (!(resx instanceof JREInfo)) {
                if (resx instanceof JARInfo) {
                    result = CreateJNLPResource.appendJarNode(entry, (JARInfo)resx, codeBase);
                } else if (resx instanceof NativeLibInfo) {
                    result = CreateJNLPResource.appendNativeLibNode(entry, (NativeLibInfo)resx, codeBase);
                } else if (resx instanceof PropertyInfo) {
                    // empty if block
                }
            }
        } else {
            result = entry.getHref().getFile().indexOf(JAR_EXT_NAME) >= 0 ? CreateJNLPResource.appendJarNodeLst(entry, codeBase) : CreateJNLPResource.appendNativeLibNodeLst(entry, codeBase);
        }
        return result;
    }

    private static String appendNativeLibNode(EASCacheEntryInfo entry, NativeLibInfo info, URL codeBase) {
        StringBuffer sb = new StringBuffer();
        sb.append("<nativelib ");
        sb.append("href=\"");
        sb.append(URLUtil.getRelativePath((URL)codeBase, (URL)info.getHref()).toString());
        sb.append("\" ");
        sb.append("lastModified=\"");
        sb.append(new Long(entry.lastModified()).toString());
        sb.append("\" ");
        sb.append("md5Version=\"");
        sb.append(entry.getMd5Version());
        sb.append("\" ");
        sb.append("/>\r\n");
        return sb.toString();
    }

    private static String appendNativeLibNodeLst(EASCacheEntryInfo entry, URL codeBase) {
        StringBuffer sb = new StringBuffer();
        sb.append("<nativelib ");
        sb.append("href=\"");
        sb.append(URLUtil.getRelativePath((URL)codeBase, (URL)entry.getHref()).toString());
        sb.append("\" ");
        sb.append("lastModified=\"");
        sb.append(new Long(entry.lastModified()).toString());
        sb.append("\" ");
        sb.append("md5Version=\"");
        sb.append(entry.getMd5Version());
        sb.append("\" ");
        sb.append("/>\r\n");
        return sb.toString();
    }

    private static String appendJarNode(EASCacheEntryInfo entry, JARInfo info, URL codeBase) {
        StringBuffer sb = new StringBuffer();
        sb.append("<jar ");
        sb.append("href=\"");
        sb.append(URLUtil.getRelativePath((URL)codeBase, (URL)info.getHref()).toString());
        sb.append("\" ");
        sb.append("lastModified=\"");
        sb.append(new Long(entry.lastModified()).toString());
        sb.append("\" ");
        sb.append("md5Version=\"");
        sb.append(entry.getMd5Version());
        sb.append("\" ");
        sb.append("/>\r\n");
        return sb.toString();
    }

    private static String appendJarNodeLst(EASCacheEntryInfo entry, URL codeBase) {
        StringBuffer sb = new StringBuffer();
        sb.append("<jar ");
        sb.append("href=\"");
        sb.append(URLUtil.getRelativePath((URL)codeBase, (URL)entry.getHref()).toString());
        sb.append("\" ");
        sb.append("lastModified=\"");
        sb.append(new Long(entry.lastModified()).toString());
        sb.append("\" ");
        sb.append("md5Version=\"");
        sb.append(entry.getMd5Version());
        sb.append("\" ");
        sb.append("/>\r\n");
        return sb.toString();
    }

    private static String appendInfoNode() {
        StringBuffer sb = new StringBuffer("");
        sb.append("\t\t\t<information>\r\n");
        sb.append("\t\t\t\t<title>client-update</title>\r\n");
        sb.append("\t\t\t\t<vendor>Kingdee</vendor>\r\n");
        sb.append("\t\t\t\t<description>Client of EAS</description>\r\n");
        sb.append("\t\t\t\t<description KIND=\"short\">EAS</description>\r\n");
        sb.append("\t\t\t\t<offline-allowed/>\r\n");
        sb.append("\t\t\t</information>\r\n");
        return sb.toString();
    }

    private static String appendAppNode(ApplicationInfo appInfo) {
        StringBuffer sb = new StringBuffer("");
        sb.append("<application-desc");
        sb.append(" ");
        sb.append("main-class=\"");
        sb.append(appInfo.getMainClass());
        sb.append("\"");
        String[] args = appInfo.getArguments();
        if (args.length > 0) {
            sb.append(">\r\n");
            for (int i = 0; i < args.length; ++i) {
                sb.append("<argument value=\"");
                sb.append(args[i]);
                sb.append("/>\r\n");
            }
            sb.append("</application-desc>\r\n");
        } else {
            sb.append("/>\r\n");
        }
        return sb.toString();
    }

    private static String appendTail() {
        return "</jnlp>";
    }

    private static String appendHeader(String codeBase, String jnlpUrlStr) {
        StringBuffer sb = new StringBuffer("");
        long createTime = System.currentTimeMillis();
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
        sb.append("<jnlp LASTMODIFIED=\"").append(createTime).append("\" CODEBASE=\"").append(codeBase).append("\" HREF=\"" + CreateJNLPResource.encodedXmlData(jnlpUrlStr) + "\" SPEC=\"1.0+\">\r\n");
        return sb.toString();
    }

    public static String encodedXmlData(String str) {
        if (str == null || "".equals(str)) {
            return str;
        }
        StringBuffer sb = new StringBuffer("");
        block7: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    char unicode = ch;
                    if (unicode < ' ' || unicode > '~') {
                        sb.append("&#x");
                        sb.append(Integer.toString(unicode, 16));
                        sb.append(";");
                        continue block7;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public void createLocalJNLPResource(String baseDir, String traceFileName, String jnlpFullURL, String resItemsExcluded, String resPaths) throws Exception {
        ArrayList<String> relativeResxPaths = new ArrayList<String>();
        String[] resPathArray = resPaths.split(",");
        for (int i = 0; i < resPathArray.length; ++i) {
            relativeResxPaths.add(resPathArray[i]);
        }
        this.createLocalJNLPResource(baseDir, traceFileName, jnlpFullURL, resItemsExcluded, relativeResxPaths);
    }
}

