/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.autoupdate.ui;

import com.kingdee.bos.autoupdate.ResourceManager;
import com.kingdee.bos.autoupdate.config.ConfigException;
import com.kingdee.bos.autoupdate.config.ConfigInfo;
import com.kingdee.bos.autoupdate.config.ConfigManager;
import com.kingdee.bos.autoupdate.ui.ExceptionHandler;
import com.kingdee.bos.autoupdate.ui.NetConfigPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;

public class ConfigDialog
extends JDialog {
    private static final String CONFIG_DIALOG_TITLE = "CONFIG_DIALOG_TITLE";
    private static final String CONFIG_DIALOG_NETTABNAME = "CONFIG_DIALOG_NETTABNAME";
    private static final String CONFIG_DIALOG_OK = "CONFIG_DIALOG_OK";
    private static final String CONFIG_DIALOG_CANCEL = "CONFIG_DIALOG_CANCEL";
    JTabbedPane tpConfigPane = new JTabbedPane();
    JButton btOK = new JButton();
    JButton btCancel = new JButton();
    ConfigInfo configInfo;
    final JFrame parent;
    NetConfigPanel netConfig;

    public ConfigDialog(JFrame frame, boolean exitOnClose) {
        super(frame, ResourceManager.getString(CONFIG_DIALOG_TITLE), exitOnClose);
        this.parent = frame;
        try {
            this.configInfo = ConfigManager.load();
            this.netConfig = new NetConfigPanel(this.configInfo);
            this.jbInit();
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation(d.width / 2 - this.getWidth() / 2, d.height / 2 - this.getHeight() / 2);
        }
        catch (ConfigException ce) {
            this.hide();
            frame.show();
            ExceptionHandler.handle(ce);
        }
    }

    private void jbInit() {
        this.getContentPane().setLayout(null);
        this.setSize(410, 400);
        this.tpConfigPane.setTabPlacement(1);
        this.tpConfigPane.setBounds(new Rectangle(5, 5, 390, 325));
        this.tpConfigPane.addTab(ResourceManager.getString(CONFIG_DIALOG_NETTABNAME), this.netConfig);
        this.getContentPane().add((Component)this.tpConfigPane, null);
        this.btOK.setBounds(new Rectangle(225, 340, 80, 25));
        this.btOK.setText(ResourceManager.getString(CONFIG_DIALOG_OK));
        this.btOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    StringBuffer sb;
                    char[] password;
                    ConfigDialog.this.configInfo.setNeedProxy(ConfigDialog.this.netConfig.rbUseProxy.isSelected());
                    ConfigDialog.this.configInfo.setProxyServerUrl(ConfigDialog.this.netConfig.tfProxyServer.getText().trim());
                    ConfigDialog.this.configInfo.setProxyPort(Integer.parseInt(ConfigDialog.this.netConfig.tfProxyPort.getText().trim()));
                    ConfigDialog.this.configInfo.setProxyUserName(ConfigDialog.this.netConfig.tfProxyUser.getText().trim());
                    try {
                        password = ConfigDialog.this.netConfig.pfProxyPass.getPassword();
                        sb = new StringBuffer();
                        sb.append(password);
                        ConfigDialog.this.configInfo.setProxyPassword(sb.toString());
                    }
                    catch (Exception ignore) {
                        ConfigDialog.this.configInfo.setProxyPassword("");
                    }
                    ConfigDialog.this.configInfo.setNeedBaseAuth(ConfigDialog.this.netConfig.rbUseBasicAuth.isSelected());
                    ConfigDialog.this.configInfo.setBaseAuthUserName(ConfigDialog.this.netConfig.tfBasicAuthUser.getText().trim());
                    try {
                        password = ConfigDialog.this.netConfig.pfBasicAuthPass.getPassword();
                        sb = new StringBuffer();
                        sb.append(password);
                        ConfigDialog.this.configInfo.setBaseAuthPassword(sb.toString());
                    }
                    catch (Exception ignore) {
                        ConfigDialog.this.configInfo.setBaseAuthPassword("");
                    }
                    ConfigManager.store(ConfigDialog.this.configInfo);
                    ConfigDialog.this.parent.setVisible(true);
                    ConfigDialog.this.setVisible(false);
                }
                catch (ConfigException ce) {
                    ExceptionHandler.handle(ce);
                }
            }
        });
        this.getContentPane().add(this.btOK);
        this.btCancel.setBounds(new Rectangle(315, 340, 80, 25));
        this.btCancel.setText(ResourceManager.getString(CONFIG_DIALOG_CANCEL));
        this.btCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigDialog.this.hide();
                ConfigDialog.this.parent.show();
                ConfigDialog.this.netConfig.load(ConfigDialog.this.configInfo);
            }
        });
        this.getContentPane().add(this.btCancel);
    }

    private ConfigInfo getConfigInfo() {
        return this.configInfo;
    }
}

