﻿--基础资料
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_BD_Address')
Create Table T_BD_Address ( FID VARCHAR(44) NOT NULL ,FName_L1 NVARCHAR(520),FName_L2 NVARCHAR(520),FName_L3 NVARCHAR(520),FNumber NVARCHAR(80) NOT NULL ,FDescription_L1 NVARCHAR(200),FDescription_L2 NVARCHAR(200),FDescription_L3 NVARCHAR(200),FSimpleName NVARCHAR(80),FPostalCode NVARCHAR(25),FPostalAddress_L1 NVARCHAR(80),FPostalAddress_L2 NVARCHAR(80),FPostalAddress_L3 NVARCHAR(80),FEMailAddress NVARCHAR(80),FLinkMan_L1 NVARCHAR(80),FLinkMan_L2 NVARCHAR(80),FLinkMan_L3 NVARCHAR(80),FPhone NVARCHAR(80),FAvailTime DateTime,FFax NVARCHAR(25),FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FClassID VARCHAR(44),FProvinceID VARCHAR(44),FCountryID VARCHAR(44),FLanguageID VARCHAR(44),FDetailAddress_L1 NVARCHAR(200),FDetailAddress_L2 NVARCHAR(200),FDetailAddress_L3 NVARCHAR(200),FCityIdID VARCHAR(44),FDistrictIdID VARCHAR(44),FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4' NOT NULL ,FAdminCUID VARCHAR(44),CONSTRAINT PK_Address PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_BD_AddressClass')
Create Table T_BD_AddressClass ( FID VARCHAR(44) NOT NULL ,FParentID VARCHAR(44),FLongNumber NVARCHAR(80),FNumber NVARCHAR(80) NOT NULL ,FName_L1 NVARCHAR(80),FName_L2 NVARCHAR(80),FName_L3 NVARCHAR(80),FLevel INT NOT NULL ,FIsLeaf INT NOT NULL ,FDescription_L1 NVARCHAR(200),FDescription_L2 NVARCHAR(200),FDescription_L3 NVARCHAR(200),FSimpleName NVARCHAR(80),FCreatorID VARCHAR(44) NOT NULL ,FCreateTime DateTime,FLastUpdateUserID VARCHAR(44) NOT NULL ,FLastUpdateTime DateTime,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4' NOT NULL ,FDisplayName_L1 NVARCHAR(80),FDisplayName_L2 NVARCHAR(80),FDisplayName_L3 NVARCHAR(80),CONSTRAINT PK_AddressClass PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_BD_City')
Create Table T_BD_City ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FName_L1 NVARCHAR(80),FName_L2 NVARCHAR(80),FName_L3 NVARCHAR(80),FNumber NVARCHAR(80),FDescription_L1 NVARCHAR(200),FDescription_L2 NVARCHAR(200),FDescription_L3 NVARCHAR(200),FSimpleName NVARCHAR(80),FProvinceID VARCHAR(44),FISDIRCITY INT,FCityNumber VARCHAR(44),FDeletedStatus  INT default 1,CONSTRAINT PK_BD_City PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_BD_Country')
Create Table T_BD_Country ( FID VARCHAR(44) NOT NULL ,FName_L1 NVARCHAR(80),FName_L2 NVARCHAR(80),FName_L3 NVARCHAR(80),FNumber NVARCHAR(80) NOT NULL ,FDescription_L1 NVARCHAR(200),FDescription_L2 NVARCHAR(200),FDescription_L3 NVARCHAR(200),FSimpleName NVARCHAR(80),FCreatorID VARCHAR(44) NOT NULL ,FCreateTime DateTime,FLastUpdateUserID VARCHAR(44) NOT NULL ,FLastUpdateTime DateTime,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4' NOT NULL ,FDeletedStatus INT default 1,CONSTRAINT PK_BD_Country PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_BD_Industry')
Create Table T_BD_Industry ( FID VARCHAR(44) NOT NULL ,FName_L1 NVARCHAR(80),FName_L2 NVARCHAR(80),FName_L3 NVARCHAR(80),FNumber NVARCHAR(80) NOT NULL ,FDescription_L1 NVARCHAR(80),FDescription_L2 NVARCHAR(80),FDescription_L3 NVARCHAR(80),FSimpleName NVARCHAR(80),FCreatorID VARCHAR(44) NOT NULL ,FCreateTime DateTime,FLastUpdateUserID VARCHAR(44) NOT NULL ,FLastUpdateTime DateTime,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4' NOT NULL ,CONSTRAINT PK_BD_Industry PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_BD_InvestType')
Create Table T_BD_InvestType ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FName_L1 NVARCHAR(255),FName_L2 NVARCHAR(255),FName_L3 NVARCHAR(255),FNumber NVARCHAR(80),FDescription_L1 NVARCHAR(255),FDescription_L2 NVARCHAR(255),FDescription_L3 NVARCHAR(255),FSimpleName NVARCHAR(80),CONSTRAINT PK_InvestType PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_BD_Language')
Create Table T_BD_Language ( FID VARCHAR(44) NOT NULL ,FName_L1 NVARCHAR(80),FName_L2 NVARCHAR(80),FName_L3 NVARCHAR(80),FNumber NVARCHAR(80) NOT NULL ,FDescription_L1 NVARCHAR(80),FDescription_L2 NVARCHAR(80),FDescription_L3 NVARCHAR(80),FSimpleName NVARCHAR(80),FCreatorID VARCHAR(44) NOT NULL ,FCreateTime DateTime,FLastUpdateUserID VARCHAR(44) NOT NULL ,FLastUpdateTime DateTime,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4' NOT NULL ,CONSTRAINT PK_BD_Language PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_BD_Project')
Create Table T_BD_Project ( FID VARCHAR(44) NOT NULL ,FName_L1 NVARCHAR(80),FName_L2 NVARCHAR(80),FName_L3 NVARCHAR(80),FNumber NVARCHAR(80) NOT NULL ,FDescription_L1 NVARCHAR(200),FDescription_L2 NVARCHAR(200),FDescription_L3 NVARCHAR(200),FSimpleName NVARCHAR(80),FIsLeaf INT,FLevel INT,FLongNumber NVARCHAR(80) NOT NULL ,FType INT,FStatus INT,FDutyPerson NVARCHAR(80),FScheduleStartDate DateTime,FSchedulEndDate DateTime,FCreatorID VARCHAR(44) NOT NULL ,FCreateTime DateTime,FLastUpdateUserID VARCHAR(44) NOT NULL ,FLastUpdateTime DateTime,FParentID VARCHAR(44),FFactStartDate DateTime,FFactEndDate DateTime,FProcess NUMERIC(28,10),FAttachment NVARCHAR(80),FAddress NVARCHAR(200),FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4' NOT NULL ,FDisplayName_L1 NVARCHAR(80),FDisplayName_L2 NVARCHAR(80),FDisplayName_L3 NVARCHAR(80),FPrjManagerID VARCHAR(44),FIsListItem INT DEFAULT 0,FCompanyID VARCHAR(44),CONSTRAINT PK_BD_Project PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_BD_Province')
Create Table T_BD_Province ( FID VARCHAR(44) NOT NULL ,FName_L1 NVARCHAR(80),FName_L2 NVARCHAR(80),FName_L3 NVARCHAR(80),FNumber NVARCHAR(80) NOT NULL ,FDescription_L1 NVARCHAR(200),FDescription_L2 NVARCHAR(200),FDescription_L3 NVARCHAR(200),FSimpleName NVARCHAR(80),FCountryID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44) NOT NULL ,FCreateTime DateTime,FLastUpdateUserID VARCHAR(44) NOT NULL ,FLastUpdateTime DateTime,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4' NOT NULL ,FDeletedStatus  INT default 1,CONSTRAINT PK_BD_Province PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_BD_Region')
Create Table T_BD_Region ( FID VARCHAR(44) NOT NULL ,FName_L1 NVARCHAR(80),FName_L2 NVARCHAR(80),FName_L3 NVARCHAR(80),FNumber NVARCHAR(80) NOT NULL ,FDescription_L1 NVARCHAR(200),FDescription_L2 NVARCHAR(200),FDescription_L3 NVARCHAR(200),FSimpleName NVARCHAR(80),FCityID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44) NOT NULL ,FCreateTime DateTime,FLastUpdateUserID VARCHAR(44) NOT NULL ,FLastUpdateTime DateTime,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4' NOT NULL ,FDeletedStatus  INT default 1,CONSTRAINT PK_BD_Region PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_WorkCalendar')
Create Table T_WorkCalendar ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FStartWorkDate DateTime,FEndWorkDate DateTime,FHourOfHalfWorkDate INT,FHourOfWorkDate INT,FName_L1 NVARCHAR(255),FName_L2 NVARCHAR(255),FName_L3 NVARCHAR(255),FNumber NVARCHAR(80),FOrgUnitID VARCHAR(44),FDefaultWeekend NVARCHAR(80),FHolidayColor NVARCHAR(80),FWorkDayColor NVARCHAR(80),FHalfWorkDayColor NVARCHAR(80),FWeekendColor NVARCHAR(80),CONSTRAINT PK_BD_WorkCalendar PRIMARY KEY (FID));

If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_WorkCalendarDayEntry')
Create Table T_WorkCalendarDayEntry ( FID VARCHAR(44) NOT NULL ,FWorkDate DateTime,FDateType INT,FWorkCanlendarID VARCHAR(44) NOT NULL ,CONSTRAINT PK_WorkCalendarDay PRIMARY KEY (FID));

--创建区域表
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_BD_Area')
Create Table T_BD_Area ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4' NOT NULL ,FName_l1 NVARCHAR(255),FName_l2 NVARCHAR(255),FName_l3 NVARCHAR(255),FNumber NVARCHAR(80) NOT NULL ,FDescription_l1 NVARCHAR(255),FDescription_l2 NVARCHAR(255),FDescription_l3 NVARCHAR(255),FSimpleName NVARCHAR(80),FDeletedStatus INT DEFAULT 1 NOT NULL ,CONSTRAINT PK_Area PRIMARY KEY (FID));

--省份增加"区域"
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FAreaID' AND KSQL_COL_TABNAME='T_BD_Province')
ALTER TABLE T_BD_Province ADD FAreaID VARCHAR(44); 

--建立我的常用短语
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_BD_MyPhrase')
Create Table T_BD_MyPhrase ( FID VARCHAR(44) NOT NULL ,FName_l1 NVARCHAR(255),FName_l2 NVARCHAR(255),FName_l3 NVARCHAR(255),FNumber NVARCHAR(80),FDescription_l1 NVARCHAR(255),FDescription_l2 NVARCHAR(255),FDescription_l3 NVARCHAR(255),FSimpleName NVARCHAR(80),FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4',CONSTRAINT PK_BD_MyPhraseID PRIMARY KEY (FID));

--建表"渠道类型"
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_BD_ChannelType')
Create Table T_BD_ChannelType ( FID VARCHAR(44) NOT NULL ,FNumber NVARCHAR(80),FName_l1 NVARCHAR(255),FName_l2 NVARCHAR(255),FName_l3 NVARCHAR(255),FChannelAttr VARCHAR(100),FDeletedStatus INT DEFAULT 1 NOT NULL,FDescription_l1 NVARCHAR(255),FDescription_l2 NVARCHAR(255),FDescription_l3 NVARCHAR(255),FSimpleName NVARCHAR(80),FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44) DEFAULT '11111111-1111-1111-1111-111111111111CCE7AED4',CONSTRAINT PK_BD_ChannelTID PRIMARY KEY (FID));

--建表 物料关联辅助属性
If not exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_BD_MaterialAsstAttrValue')
Create Table T_BD_MaterialAsstAttrValue ( FID VARCHAR(44) NOT NULL ,FSeq INT,FMaterialID VARCHAR(44),FAsstAttrValueID VARCHAR(44),CONSTRAINT PK_MaterialAsstAV PRIMARY KEY (FID));

--增加冗余表
IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='T_CM_CMStart')
Create Table T_CM_CMStart ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyOrg VARCHAR(44),FBillStatus INT,FAuditTime DateTime,FCalculatePeriod VARCHAR(44),FIsAuto INT DEFAULT 0,FFivouchered INT,FCostcenterID VARCHAR(44),FCostobjectID VARCHAR(44),FManhour NUMERIC(28,3),FOutput NUMERIC(28,3),CONSTRAINT PK_CM_CMStartID PRIMARY KEY (FID));

IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='T_CM_GLFetchDataEntry')
Create Table T_CM_GLFetchDataEntry ( FID VARCHAR(44) NOT NULL ,FSeq INT,FRemark_l1 NVARCHAR(255),FRemark_l2 NVARCHAR(255),FRemark_l3 NVARCHAR(255),FParentID VARCHAR(44),FAccountID VARCHAR(44),FAsstAccount NVARCHAR(100),FFetchDataDirect VARCHAR(100),FCostCenterID VARCHAR(44),FCostItemID VARCHAR(44),FCostObjectID VARCHAR(44),FAsstAccountID NVARCHAR(200),FAsstAccountName NVARCHAR(200),CONSTRAINT PK_CM_GLFDEID PRIMARY KEY (FID));

IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='T_CM_OutputFee')
Create Table T_CM_OutputFee ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyOrg VARCHAR(44),FBillStatus INT,FAuditTime DateTime,FCalculatePeriod VARCHAR(44),FIsAuto INT,FFivouchered INT,FCostCenterID VARCHAR(44),FCostObjectID VARCHAR(44),FFinishOutput NUMERIC(28,10) DEFAULT 0,CONSTRAINT PK_CM_OutputFee PRIMARY KEY (FID));

IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='T_CM_PeriodBalanceFee')
Create Table T_CM_PeriodBalanceFee ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyOrg VARCHAR(44),FBillStatus INT,FAuditTime DateTime,FCalculatePeriod VARCHAR(44),FIsAuto INT DEFAULT 0,FFivouchered INT,FCategoryTime DateTime,FCostObjectID VARCHAR(44),FCostCenterID VARCHAR(44),CONSTRAINT PK_PeriodBalanceFe PRIMARY KEY (FID));

IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='T_CAL_CostObjectRankEntry')
Create Table T_CAL_CostObjectRankEntry ( FID VARCHAR(44) NOT NULL ,FSeq INT,FRemark_l1 NVARCHAR(255),FRemark_l2 NVARCHAR(255),FRemark_l3 NVARCHAR(255),FParentID VARCHAR(44),FRank INT,FCostObjectID VARCHAR(44),CONSTRAINT PK_CostObjectRankE PRIMARY KEY (FID));

--成本项目
IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='T_NCM_CostItem') 
Create Table T_NCM_CostItem ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FName_l1 NVARCHAR(255),FName_l2 NVARCHAR(255),FName_l3 NVARCHAR(255),FNumber NVARCHAR(80),FDescription_l1 NVARCHAR(255),FDescription_l2 NVARCHAR(255),FDescription_l3 NVARCHAR(255),FSimpleName NVARCHAR(80),FAdminCUID VARCHAR(44),FItemType VARCHAR(80),FTypeTreeID VARCHAR(44),FCostProperty VARCHAR(80),CONSTRAINT PK_NcmCostItem PRIMARY KEY (FID));

--成本项目树型表
IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='T_NCM_CostItemTypeTree') 
Create Table T_NCM_CostItemTypeTree ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FName_l1 NVARCHAR(255),FName_l2 NVARCHAR(255),FName_l3 NVARCHAR(255),FNumber NVARCHAR(80),FDescription_l1 NVARCHAR(255),FDescription_l2 NVARCHAR(255),FDescription_l3 NVARCHAR(255),FSimpleName NVARCHAR(80),FIsLeaf INT,FLevel INT,FLongNumber NVARCHAR(80),FDisplayName_l1 NVARCHAR(255),FDisplayName_l2 NVARCHAR(255),FDisplayName_l3 NVARCHAR(255),FTreeType VARCHAR(80),FParentID VARCHAR(44),CONSTRAINT PK_CostItemTypeTre PRIMARY KEY (FID));

--成本对象组
IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='T_NCM_CostObjectSuite') 
Create Table T_NCM_CostObjectSuite ( FID VARCHAR(44) NOT NULL ,FCreatorID VARCHAR(44),FCreateTime DateTime,FLastUpdateUserID VARCHAR(44),FLastUpdateTime DateTime,FControlUnitID VARCHAR(44),FNumber NVARCHAR(80),FBizDate DateTime,FHandlerID VARCHAR(44),FDescription NVARCHAR(80),FHasEffected INT,FAuditorID VARCHAR(44),FSourceBillID NVARCHAR(80),FSourceFunction NVARCHAR(80),FCompanyID VARCHAR(44),FIsSys INT,FName_l1 NVARCHAR(255),FName_l2 NVARCHAR(255),FName_l3 NVARCHAR(255),CONSTRAINT PK_CostObjectSuite PRIMARY KEY (FID));

--成本对象组分录
IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='T_NCM_CostObjectSuiteEntry') 
Create Table T_NCM_CostObjectSuiteEntry ( FID VARCHAR(44) NOT NULL ,FSeq INT,FParentID VARCHAR(44),FCostObjectID VARCHAR(44),FCostObjectName NVARCHAR(80),FModel NVARCHAR(80),CONSTRAINT PK_COSuiteEntry PRIMARY KEY (FID));

--增加项目“归集数量”“计量单位”、“对应单价精度”
If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FIsAllocateQty' and KSQL_COL_TABNAME='T_NCM_CostItem')
ALTER TABLE T_NCM_CostItem ADD FIsAllocateQty INT DEFAULT 0;

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FUnitID' and KSQL_COL_TABNAME='T_NCM_CostItem')
ALTER TABLE T_NCM_CostItem ADD FUnitID VARCHAR(44);

If not exists (select * from KSQL_USERCOLUMNS where KSQL_COL_NAME ='FPricePrecision' and KSQL_COL_TABNAME='T_NCM_CostItem')
ALTER TABLE T_NCM_CostItem ADD FPricePrecision INT DEFAULT 4;

--存在则修改国家"ISO编码"
IF EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FISOCode' AND KSQL_COL_TABNAME='T_BD_Country')
ALTER TABLE T_BD_Country ALTER COLUMN FISOCode NVARCHAR(80); 

--国家增加"ISO编码"
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FISOCode' AND KSQL_COL_TABNAME='T_BD_Country')
ALTER TABLE T_BD_Country ADD FISOCode NVARCHAR(80); 

--项目增加字段“是否系统生成”
IF NOT EXISTS (SELECT * FROM KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FIsSysCreate' AND KSQL_COL_TABNAME='T_BD_Project')
ALTER TABLE T_BD_Project ADD FIsSysCreate INT NOT NULL DEFAULT 0;
