If exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='V_PC_ActEfficencyDetailStat') 
DROP view V_PC_ActEfficencyDetailStat;

CREATE VIEW V_PC_ActEfficencyDetailStat
AS
SELECT T_ORG_Admin.FID AS FADMINORGID, 
      T_ORG_Admin.FName_L1 AS FADMINORGNAME_L1, 
      T_ORG_Admin.FName_L2 AS FADMINORGNAME_L2, 
      T_ORG_Admin.FName_L3 AS FADMINORGNAME_L3, 
      T_ORG_Admin.FLongNumber, T_WFR_ProcInstHst.FPROCDEFID, 
      T_WFR_ProcInstHst.FPROCDEFNAME_L1, 
      T_WFR_ProcInstHst.FPROCDEFNAME_L2, 
      T_WFR_ProcInstHst.FPROCDEFNAME_L3, T_WFR_ActInstHst.FACTDEFID, 
      T_WFR_ActInstHst.FACTDEFNAME_L1, 
      T_WFR_ActInstHst.FACTDEFNAME_L2, 
      T_WFR_ActInstHst.FACTDEFNAME_L3, T_WFR_ActInstHst.FACTINSTID, 
      T_BD_Person.FID AS FPERSONID, 
      T_BD_Person.FName_L1 AS FPERSONNAME_L1, 
      T_BD_Person.FName_L2 AS FPERSONNAME_L2, 
      T_BD_Person.FName_L3 AS FPERSONNAME_L3, 
      T_WFR_ProcInstHst.FCREATEDTIME, 
      ISNULL(T_WFR_ActInstHst.FWORKINGTIME, 0) AS FWORKINGTIME, 
      DATEDIFF(Hour, T_WFR_ActInstHst.FCREATEDTIME, 
      ISNULL(T_WFR_ActInstHst.FCOMLETETIME, GETDATE())) 
      AS FACTTIMECONSUMING
FROM T_WFR_ActInstHst INNER JOIN
      T_WFR_ProcInstHst ON 
      T_WFR_ActInstHst.FPROCINSTID = T_WFR_ProcInstHst.FPROCINSTID INNER
       JOIN
      T_WFR_AssignHst ON 
      T_WFR_AssignHst.FACTINSTID = T_WFR_ActInstHst.FACTINSTID INNER JOIN
      T_PM_User ON 
      T_WFR_AssignHst.FPERSONUSERID = T_PM_User.FID INNER JOIN
      T_BD_Person ON 
      T_PM_User.FPersonId = T_BD_Person.FID INNER JOIN
      T_ORG_PositionMember ON 
      T_BD_Person.FID = T_ORG_PositionMember.FPersonID INNER JOIN
      T_ORG_Position ON 
      T_ORG_PositionMember.FPositionID = T_ORG_Position.FID INNER JOIN
      T_ORG_Admin ON 
      T_ORG_Position.FAdminOrgUnitID = T_ORG_Admin.FID;

If exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='V_PC_AllProcStatDetail') 
DROP view V_PC_AllProcStatDetail;

CREATE VIEW V_PC_AllProcStatDetail
AS
SELECT T_ORG_Admin.FID AS FADMINORGID, 
      T_ORG_Admin.FName_L1 AS FADMINORGNAME_L1, 
      T_ORG_Admin.FName_L2 AS FADMINORGNAME_L2, 
      T_ORG_Admin.FName_L3 AS FADMINORGNAME_L3, 
      T_ORG_Admin.FLongNumber, T_PC_ProcCatalog.FID AS FCTGID, 
      T_PC_ProcCatalog.FLongNumber AS FPROCLNUMBER, 
      T_PC_ProcCatalog.FName_L1 AS FCTGNAME_L1, 
      T_PC_ProcCatalog.FName_L2 AS FCTGNAME_L2, 
      T_PC_ProcCatalog.FName_L3 AS FCTGNAME_L3, 
      T_WFR_ProcInstHst.FPROCINSTID, T_WFR_ProcInstHst.FPROCDEFID, 
      T_WFR_ProcInstHst.FPROCDEFNAME_L1, 
      T_WFR_ProcInstHst.FPROCDEFNAME_L2, 
      T_WFR_ProcInstHst.FPROCDEFNAME_L3, 
      T_BD_Person.FName_L1 AS FINITIATORNAME_L1, 
      T_BD_Person.FName_L2 AS FINITIATORNAME_L2, 
      T_BD_Person.FName_L3 AS FINITIATORNAME_L3, 
      T_WFR_ProcInstHst.FCREATEDTIME, T_WFR_ProcInstHst.FWORKINGTIME, 
      DATEDIFF(Hour, T_WFR_ProcInstHst.FCREATEDTIME, 
      ISNULL(T_WFR_ProcInstHst.FCOMLETETIME, GETDATE())) 
      AS FPROCTIMECONSUMING, T_WFR_ProcInstHst.FSTATE, DATEDIFF(Hour, 
      T_WFR_ProcInstHst.FCREATEDTIME, 
      ISNULL(T_WFR_ProcInstHst.FCOMLETETIME, GETDATE())) 
      - T_WFR_ProcInstHst.FWORKINGTIME AS FOVERTIME
FROM T_PC_ProcCatalog INNER JOIN
      T_PC_ConfigurationItem ON 
      T_PC_ConfigurationItem.FCatalogID = T_PC_ProcCatalog.FID INNER JOIN
      T_WFR_ProcInstHst ON 
      T_PC_ConfigurationItem.FProcDefID = T_WFR_ProcInstHst.FPROCDEFID INNER
       JOIN
      T_PM_User ON 
      T_WFR_ProcInstHst.FINITIATORID = T_PM_User.FID INNER JOIN
      T_BD_Person ON 
      T_PM_User.FPersonId = T_BD_Person.FID INNER JOIN
      T_ORG_PositionMember ON 
      T_BD_Person.FID = T_ORG_PositionMember.FPersonID INNER JOIN
      T_ORG_Position ON 
      T_ORG_PositionMember.FPositionID = T_ORG_Position.FID INNER JOIN
      T_ORG_Admin ON 
      T_ORG_Position.FAdminOrgUnitID = T_ORG_Admin.FID;
      
If exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='V_PC_PersonProcStatDetail') 
DROP view V_PC_PersonProcStatDetail;

CREATE VIEW V_PC_PersonProcStatDetail
AS
SELECT FPROCDEFNAME_L1,FPROCDEFNAME_L2, FPROCDEFNAME_L3,
	   FPROCINSTID, FPROCDEFID, FWORKINGTIME, 
       FCREATEDTIME,FPROCTIMECONSUMING, FOVERTIME,FPARTICIPATORID ,FISINITIATOR
FROM (SELECT DISTINCT 
              T_WFR_ProcInstHst.FPROCDEFNAME_L1, 
              T_WFR_ProcInstHst.FPROCDEFNAME_L2, 
              T_WFR_ProcInstHst.FPROCDEFNAME_L3, T_WFR_ProcInstHst.FPROCINSTID, 
              T_WFR_ProcInstHst.FPROCDEFID, T_WFR_ProcInstHst.FWORKINGTIME, 
              T_WFR_ProcInstHst.FCREATEDTIME, DATEDIFF(Hour, 
              T_WFR_ProcInstHst.FCREATEDTIME, 
              ISNULL(T_WFR_ProcInstHst.FCOMLETETIME, GETDATE())) 
              FPROCTIMECONSUMING, (DATEDIFF(Hour, 
              T_WFR_ProcInstHst.FCREATEDTIME, 
              ISNULL(T_WFR_ProcInstHst.FCOMLETETIME, GETDATE())) 
              - T_WFR_ProcInstHst.FWORKINGTIME) FOVERTIME, 
              T_WFR_AssignHst.FPERSONUSERID FPARTICIPATORID, 
              0 FISINITIATOR
        FROM T_WFR_AssignHst INNER JOIN
              T_WFR_ProcInstHst ON 
              T_WFR_AssignHst.FPROCINSTID = T_WFR_ProcInstHst.FPROCINSTID
        UNION
        SELECT T_WFR_ProcInstHst.FPROCDEFNAME_L1, 
              T_WFR_ProcInstHst.FPROCDEFNAME_L2, 
              T_WFR_ProcInstHst.FPROCDEFNAME_L3, T_WFR_ProcInstHst.FPROCINSTID, 
              T_WFR_ProcInstHst.FPROCDEFID, T_WFR_ProcInstHst.FWORKINGTIME, 
              T_WFR_ProcInstHst.FCREATEDTIME, DATEDIFF(Hour, 
              T_WFR_ProcInstHst.FCREATEDTIME, 
              ISNULL(T_WFR_ProcInstHst.FCOMLETETIME, GETDATE())) 
              FPROCTIMECONSUMING, (DATEDIFF(Hour, 
              T_WFR_ProcInstHst.FCREATEDTIME, 
              ISNULL(T_WFR_ProcInstHst.FCOMLETETIME, GETDATE())) 
              - T_WFR_ProcInstHst.FWORKINGTIME) FOVERTIME, 
              T_WFR_ProcInstHst.FINITIATORID FPARTICIPATORID, 1 FISINITIATOR
        FROM T_WFR_ProcInstHst) A;
        
