﻿
/*指标映射*/
create table T_DW_Dim_CSL_BIItem(
	FID varchar(44) NOT NULL ,
	FNumber nvarchar(255) NULL,
	FItemName nvarchar(255) NOT NULL,
	FItemDefine nvarchar(1024) NULL,
	FBISubjectName nvarchar(255) NOT NULL,
	FRemoveable INT NOT NULL,
	FEditable INT NOT NULL,
	FSequence Decimal(18,6) NOT NULL,
	FUnit INT NOT NULL,
	FINDENT INT NOT NULL Default 0,
	FDescription nvarchar(255) NULL,
	FStandard decimal(18,6) NULL,
	FStandardBad decimal(18,6) NULL,
	FStandardAvg decimal(18,6) NULL,
	FISStandard INT NOT NULL default 0,
	CONSTRAINT PK_DW_DIM_BIITEM PRIMARY KEY (FID)
);

create table T_DW_Dim_CSL_BIItemEntry(
	FID varchar(44) NOT NULL ,
	FItemNumber nvarchar(255) NOT NULL,
	FBIItemID nvarchar(44) NOT NULL,
	CONSTRAINT PK_DW_DIM_BIItemEn PRIMARY KEY (FID)
);

/*商业分析事实表*/
CREATE TABLE DW_FACT_CSLRPT_ITEMDATA(
	FYTBEGIN  decimal(18,6), //年初数
	FENDBALANCE decimal(18,6), //期末数
	FAMOUNT decimal(18,6), //本期发生数
	FYTDAMOUNT decimal(18,6),  //本年累计
	FOrgUnitID varchar(44), //组织 
	FItemID varchar(44),	//指标ID
	FCurrencyID varchar(44),//币别ID
	FSrcCurrencyID varchar(44) NULL,//币别ID
	FPeriodID int  //期间ID
);

/*合并报表期间*/
create table DW_DIM_CSL_PERIOD(
	FID int NOT NULL, //年+期+期间类型 如：20070012
	FYEAR INT NOT NULL,//年
	FPERIOD INT NOT NULL,//期
	FPERIODTYPE INT NOT NULL, //期间类型
	FLastYearID INT NULL, //上年同期
	FLastPeriodID INT NULL, //上年期
	CONSTRAINT PK_DW_CSL_PERIOD PRIMARY KEY (FID)
);
