﻿--资金存量财务主题分析---
--科目维度--
IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='DW_DIM_BD_ACCOUNTVIEW') 
CREATE TABLE DW_DIM_BD_ACCOUNTVIEW
(
  FID             VARCHAR(44) NOT NULL,
  FNAME_L1        NVARCHAR(255),
  FNAME_L2        NVARCHAR(255),
  FNAME_L3        NVARCHAR(255),
  FDISPLAYNAME_L1 NVARCHAR(255),
  FDISPLAYNAME_L2 NVARCHAR(255),
  FDISPLAYNAME_L3 NVARCHAR(255),
  FNUMBER         NVARCHAR(255) NOT NULL,
  FCOMPANYID      VARCHAR(44)
);

--银行账户维度--
IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='DW_DIM_BD_ACCOUNTBANKS') 
CREATE TABLE DW_DIM_BD_ACCOUNTBANKS
(
  FID          VARCHAR(44) NOT NULL,
  FNAME_L1     NVARCHAR(255),
  FNAME_L2     NVARCHAR(255),
  FNAME_L3     NVARCHAR(255),
  FNUMBER     NVARCHAR(255) NOT NULL,
  FCOMPANYID   VARCHAR(44),
  FBANKID      VARCHAR(44),
  FBANKNAME_L1 NVARCHAR(255),
  FBANKNAME_L2 NVARCHAR(255),
  FBANKNAME_L3 NVARCHAR(255),
  CONSTRAINT PK_ACCOUNTBANKS PRIMARY KEY(FID)  
);

--账户用途维度--
IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='DW_DIM_BD_ACCOUNTPROPERTY') 
CREATE TABLE DW_DIM_BD_ACCOUNTPROPERTY
(
  FID      VARCHAR(44) NOT NULL,
  FNAME_L1 NVARCHAR(255),
  FNAME_L2 NVARCHAR(255),
  FNAME_L3 NVARCHAR(255),
  FNUMBER NVARCHAR(255),
  CONSTRAINT PK_ACCOUNTPROPERTY PRIMARY KEY(FID)  
);

--事实表--
IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='DW_FACT_JOURNALBALANCE') 
CREATE TABLE DW_FACT_JOURNALBALANCE
(
  FCOMPANYID          VARCHAR(44),
  FPERIODID           VARCHAR(44),
  FCURRENCYID         VARCHAR(44),
  FBANKID             VARCHAR(44),
  FACCOUNTUSAGEID     VARCHAR(44),
  FACCOUNTBANKID      VARCHAR(44),
  FACCOUNTVIEWID      VARCHAR(44),
  FBEGINYEARBANALCE   NUMERIC(17,4),
  FBEGINMONTHHBALANCE NUMERIC(17,4),
  FDEBITAMT           NUMERIC(17,4),
  FMONTHDEBIT         NUMERIC(17,4),
  FMONTHCREDIT        NUMERIC(17,4),
  FYEARDEBIT          NUMERIC(17,4),
  FYEARCREDIT         NUMERIC(17,4),
  FENDBMONTH          NUMERIC(17,4)
);



--银行存款变动分析事实表--
IF NOT EXISTS (SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME ='DW_FACT_BANKAMOUNT') 
CREATE TABLE DW_FACT_BANKAMOUNT
(
  FCOMPANYID          VARCHAR(44),
  FPERIODID           VARCHAR(44),
  FCURRENCYID         VARCHAR(44),
  FBANKID             VARCHAR(44),
  FACCOUNTUSAGEID     VARCHAR(44),
  FACCOUNTBANKID      VARCHAR(44),
  FACCOUNTVIEWID      VARCHAR(44),
  FMONTHSTARTAMT      NUMERIC(17,4),
  FENDBMONTH          NUMERIC(17,4),
  FBANKAREATYPE       INT
);

IF EXISTS (SELECT * FROM KSQL_CONSTRAINTS WHERE KSQL_CONS_NAME ='PK_ACCOUNTVIEW' 
AND KSQL_CONS_TABNAME ='DW_DIM_BD_ACCOUNTVIEW') 
ALTER TABLE DW_DIM_BD_ACCOUNTVIEW DROP CONSTRAINT PK_ACCOUNTVIEW;
