﻿-----------------------------基础资料---------------------------
--指标
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_AppType')
create index  IX_FDC_AppType on T_FDC_ApportionType(FTargetTypeID);

--财务成本一体化科目设置
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_BfAcctVproA')
create index  IX_FDC_BfAcctVproA on T_FDC_BeforeAccountView(FProAccountID);

IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_BfAcctVsetA')
create index  IX_FDC_BfAcctVsetA on T_FDC_BeforeAccountView(FSettAccountID);

IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_BfAcctVintA')
create index  IX_FDC_BfAcctVintA on T_FDC_BeforeAccountView(FIntendAccountID);

IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_BfAcctVotpA')
create index  IX_FDC_BfAcctVotpA on T_FDC_BeforeAccountView(FOtherProAccountID);

IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_BfAcctVotsA')
create index  IX_FDC_BfAcctVotsA on T_FDC_BeforeAccountView(FOtherSettAccountID);

IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_BfAcctVotiA')
create index  IX_FDC_BfAcctVotiA on T_FDC_BeforeAccountView(FOtherIntendAccountID);

IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_BfAcctVbeoA')
create index  IX_FDC_BfAcctVbeoA on T_FDC_BeforeAccountView(FBeforeOtherAccountID);

IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_BfAcctVbedA')
create index  IX_FDC_BfAcctVbedA on T_FDC_BeforeAccountView(FBeforeDevAccountID);

IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_BfAcctVbesA')
create index  IX_FDC_BfAcctVbesA on T_FDC_BeforeAccountView(FBeforeSettAccountID);

IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_BfAcctVprdA')
create index  IX_FDC_BfAcctVprdA on T_FDC_BeforeAccountView(FProductAccountID);

IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_BfAcctVadmA')
create index  IX_FDC_BfAcctVadmA on T_FDC_BeforeAccountView(FAdminFeesID);

IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_BfAcctVmkfA')
create index  IX_FDC_BfAcctVmkfA on T_FDC_BeforeAccountView(FMarketFeesID);

IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_BfAcctVCom')
create index  IX_FDC_BfAcctVCom on T_FDC_BeforeAccountView(FCompanyID);

--合同编码类型
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_ConCdType')
create index  IX_FDC_ConCdType on T_FDC_ContractCodingType(FContractTypeID);
--合同详细信息定义
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_ConDtType')
create index  IX_FDC_ConDtType on T_FDC_ContractDetailDef(FContractType);
--FParentID
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_ConTypePr')
create index  IX_FDC_ConTypePr on T_FDC_ContractType(FparentId);


--成本科目
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_CostAcctLn')
create index  IX_FDC_CostAcctLn on T_FDC_COSTACCOUNT(FLONGNUMBER, FCURPROJECT);

IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_CostAcctPr')
create index  IX_FDC_CostAcctPr on T_FDC_COSTACCOUNT(FparentId);

IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_CostAcctOrg')
create index  IX_FDC_CostAcctOrg on T_FDC_COSTACCOUNT(FFullOrgUnit);
--成本科目分配记录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_ConActAsOr')
create index  IX_FDC_ConActAsOr on T_FDC_CostAccountAssign(FFullOrgUnit,FCurProject);

IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_ConActAsAc')
create index  IX_FDC_ConActAsAc on T_FDC_CostAccountAssign(FCostAccount);
--成本科目与会计科目关系
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_ConActWiAt')
create index  IX_FDC_ConActWiAt on T_FDC_CostAccountWithAccount(FAccountID);
--当前工程项目成本分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_CurProCoPr')
create index  IX_FDC_CurProCoPr on T_FDC_CurProjCostEntries(FCurProject);
--工程项目
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_CurProLNum')
create index  IX_FDC_CurProLNum on T_FDC_CurProject(FlongNumber);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_CurProCorg')
create index  IX_FDC_CurProCorg on T_FDC_CurProject(FCostOrgID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_CurProjpr')
create index  IX_FDC_CurProjpr on T_FDC_CurProject(FParentID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_CurProOrgd')
create index  IX_FDC_CurProOrgd on T_FDC_CurProject(FFULLORGUNIT);


--当前工程项目产品设置分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_CurProPrdPt')
create index  IX_FDC_CurProPrdPt on T_FDC_CurProjProductEntries(FCurProject,FproductType);
--当前工程项目产品设置分摊数据
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_CurProAppEn')
create index  IX_FDC_CurProAppEn on T_FDC_CurProjProEntrApporData(FCurProjProductEntries);

--内部管理信息
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_InnrMancom')
create index  IX_FDC_InnrMancom on T_FDC_InnerManager(FOwnCompanyID);
--管理项目分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_ManCurProj')
create index  IX_FDC_ManCurProj on T_FDC_ManagerProjectEntry(FCurProjectID);

--付款方式
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_PayMenType')
create index  IX_FDC_PayMenType on T_FDC_PaymentType(FPayTypeID);
--项目指标数据
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_ProjIdType')
create index  IX_FDC_ProjIdType on T_FDC_ProjectIndexData(FProjOrOrgID,FProductTypeID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_ProjIdEnPr')
create index  IX_FDC_ProjIdEnPr on T_FDC_ProjectIndexDataEntry(FParentID);
--工程项目与成本中心的对应关系
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_ProjOURef')
create index  IX_FDC_ProjOURef on T_FDC_ProjectWithCostCenterOU(FCurProjectID,FCostCenterOUID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_ProjOUCt')
create index  IX_FDC_ProjOUCt on T_FDC_ProjectWithCostCenterOU(FCostCenterOUID);
--权益管理信息
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_RightMnCom')
create index  IX_FDC_RightMnCom on T_FDC_RightManager(FRightCompanyID);
--税务登记信息
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_TaxManPr')
create index  IX_FDC_TaxManPr on T_FDC_TaxManager(FParentID);
--组织数据管理
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_UnitManCom')
create index  IX_FDC_UnitManCom on T_FDC_UnitDataManager(FCompanyID);
--工程项目凭证
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_VchProPP')
create index  IX_FDC_VchProPP on T_FDC_VoucherForProject(FCurProjectID,FProductID);
--监事
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_WatcherPr')
create index  IX_FDC_WatcherPr on T_FDC_Watcher(FParentID);

-----------------------------成本---------------------------
--调整分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_AdjRedEnPr')
create index  IX_AIM_AdjRedEnPr on T_AIM_AdjustRecordEntry(FParentID);
--各产品类型目标成本
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_AIMCtPrSpE')
create index  IX_AIM_AIMCtPrSpE on T_AIM_AIMAimCostProdSplitEntry(FProductID,FApportionTypeID);
--目标成本
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_AIMCostOPr')
create index  IX_AIM_AIMCostOPr on T_AIM_AimCost(ForgOrProId);
--各产品类型动态目标成本
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_AIMCtSpEn')
create index  IX_AIM_AIMCtSpEn on T_AIM_AimCostProductSplitEntry(FProductID,FApportionTypeID);
--目标成本条目
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_CostEnHead')
create index  IX_AIM_CostEnHead on T_AIM_CostEntry(FHeadID);
--成本拆分
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_CostSpBill')
create index  IX_AIM_CostSpBill on T_AIM_CostSplit(FCostBillID);
--成本拆分分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_CostSpEnPr')
create index  IX_AIM_CostSpEnPr on T_AIM_CostSplitEntry(FParentID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_CostSpEAcct')
create index  IX_AIM_CostSpEAcct on T_AIM_CostSplitEntry(FCOSTACCOUNTID);
--动态成本
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_DynamiCtCom')
create index  IX_AIM_DynamiCtCom on T_AIM_DynamicCost(FcompanyId,FAccountID);
--动态成本产品拆分分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_DynSpCost')
create index  IX_AIM_DynSpCost on T_AIM_DynCostProduSplitEntry(FdynamicCostId);
--动态成本快照
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_DynCtSpPr')
create index  IX_AIM_DynCtSpPr on T_AIM_DynCostSnapShot(FProjectId);
--动态成本快照产品类型分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_DynCtSpBill')
create index  IX_AIM_DynCtSpBill on T_AIM_DynCostSnpShtProTypEntry(FParentID);
--动态成本快照结算分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_DynCtSpStPr')
create index  IX_AIM_DynCtSpStPr on T_AIM_DynCostSnapShotSettEntry(FParentID);
--待发生成本
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_IntCostPr')
create index  IX_AIM_IntCostPr on T_AIM_IntendingCostEntry(FParentID);
--成本测算
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_MeasCostPr')
create index  IX_AIM_MeasCostPr on T_AIM_MeasureCost(FProjectID);
--默认测算分摊设置
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_MeasDefAcct')
create index  IX_AIM_MeasDefAcct on T_AIM_MeasureDefSplitSet(FCostAccountID);
--测算分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_MeasEnBill')
create index  IX_AIM_MeasEnBill on T_AIM_MeasureEntry(FHeadID);
--规划指标
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_PlanInBill')
create index  IX_AIM_PlanInBill on T_AIM_PlanIndex(FHeadID);
--规则指标分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_PlanInEnPr')
create index  IX_AIM_PlanInEnPr on T_AIM_PlanIndexEntry(FParentID);
--成本测算
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_TmpMeaCtPr')
create index  IX_AIM_TmpMeaCtPr on T_AIM_TemplateMeasureCost(FProjectID);
--测算分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_TmpMeaEnHd')
create index  IX_AIM_TmpMeaEnHd on T_AIM_TemplateMeasureEntry(FHeadID);
--目标成本调整凭证
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_VchDynPro')
create index  IX_AIM_VchDynPro on T_AIM_VoucherForDynamic(FCurProjectID,FProductID);
--规划指标
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_TmpIndHd')
create index  IX_AIM_TmpIndHd on T_AIM_TemplatePlanIndex(FheadID);
--规则指标分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_TmpIndEnPr')
create index  IX_AIM_TmpIndEnPr on T_AIM_TempPlanIndexEntry(FParentID);

-----------------------------合同---------------------------
--变更审批单
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ChgAuBiOr')
create index  IX_CON_ChgAuBiOr on T_CON_ChangeAuditBill(ForgUnitid);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ChgAuBiPr')
create index  IX_CON_ChgAuBiPr on T_CON_ChangeAuditBill(FCurProjectID);
--变更审批单分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ChgAuEnPr')
create index  IX_CON_ChgAuEnPr on T_CON_ChangeAuditEntry(FParentID);
--变更审批单分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ChgSuEnPr')
create index  IX_CON_ChgSuEnPr on T_CON_ChangeSupplierEntry(FParentID);
--违约金
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_CompBicon')
create index  IX_CON_CompBicon on T_CON_CompensationBill(FContractID);
--付款申请单对应的违约金
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ComPaReq')
create index  IX_CON_ComPaReq on T_CON_CompensationOfPayReqBill(FPayRequestBillId);
--变更非成本拆分
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConChgNSpOr')
create index  IX_CON_ConChgNSpOr on T_CON_ConChangeNoCostSplit(ForgUnitId);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConChgNSpCc')
create index  IX_CON_ConChgNSpCc on T_CON_ConChangeNoCostSplit(FContractChangeID);
--变更非成本拆分分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConChgNSpPr')
create index  IX_CON_ConChgNSpPr on T_CON_ChangeNoSplitEntry(FParentID);
--变更拆分
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConChgSpPr')
create index  IX_CON_ConChgSpPr on T_CON_ConChangeSplit(ForgUnitId);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConChgSpCc')
create index  IX_CON_ConChgSpCc on T_CON_ConChangeSplit(FContractChangeID);
--变更拆分分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConChgSpEn')
create index  IX_CON_ConChgSpEn on T_CON_ConChangeSplitEntry(FParentID);
--合同非成本拆分
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConNCsSpCo')
create index  IX_CON_ConNCsSpCo on T_CON_ConNoCostSplit(FContractBillID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConNCsSpOr')
create index  IX_CON_ConNCsSpOr on T_CON_ConNoCostSplit(ForgUnitId);
--合同非成本拆分分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConNCsSpPr')
create index  IX_CON_ConNCsSpPr on T_CON_ConNoCostSplitEntry(FParentID);
--合同基本资料
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConBsDaOr')
create index  IX_CON_ConBsDaOr on T_CON_ContractBaseData(FFiOrgUnitID);
--合同单据
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConBillOr')
create index  IX_CON_ConBillOr on T_CON_ContractBill(FOrgUnitId);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConBillProj')
create index  IX_CON_ConBillProj on T_CON_ContractBill(FCurProjectID);
--合同计划
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConBiPlPr')
create index  IX_CON_ConBiPlPr on T_CON_ContractBillContractPlan(FParentID);
--合同分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConBiEnPr')
create index  IX_CON_ConBiEnPr on T_CON_ContractBillEntry(FParentID);
--合同修订
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConReViCon')
create index IX_CON_ConReViCon on  T_CON_ContractBillRevise(FCONTRACTBILLID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConReViOrg')
create index IX_CON_ConReViOrg on  T_CON_ContractBillRevise(FOrgUnitId);
--合同修订分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConReViEnOr')
create index IX_CON_ConReViEnOr on  T_CON_ContractBillReviseEntry(FParentID);
--变更指令单
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConChgBiPro')
create index IX_CON_ConChgBiPro on  T_CON_ContractChangeBill(FCurProjectID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConChgBiOrg')
create index IX_CON_ConChgBiOrg on  T_CON_ContractChangeBill(FOrgUnitId);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_Con_ConChgBiCon')
create index IX_Con_ConChgBiCon on T_CON_ContractChangeBill(FCONTRACTBILLID);
--变更指令单分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConChgBiEnP')
create index IX_CON_ConChgBiEnP on  T_CON_ContractChangeEntry(FParentID);
--合同正文
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConContCon')
create index IX_CON_ConContCon on  T_CON_ContractContent(FContractID);
--合同拆分
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConCstSpCo')
create index IX_CON_ConCstSpCo on  T_CON_ContractCostSplit(FContractBillID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConCstSpCo')
create index IX_CON_ConCstSpOr on  T_CON_ContractCostSplit(FOrgUnitId);
--合同拆分分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConCstSpEnp')
create index IX_CON_ConCstSpEnp on  T_CON_ContractCostSplitEntry(FParentID);
--合同多甲方
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConLaDeCon')
CREATE  INDEX IX_CON_ConLaDeCon ON T_CON_ContractLandDeveloper(FContractID ASC);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConLaDeLop')
CREATE  INDEX IX_CON_ConLaDeLop ON T_CON_ContractLandDeveloper(FLandDeveloperID ASC);
--合同交底记录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConMovHiCo')
create index IX_CON_ConMovHiCo on  T_CON_ContractMoveHistory(FContractBillID);
--合同修订多甲方
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConReDeCon')
CREATE  INDEX IX_CON_ConReDeCon ON T_CON_ContractRevLandDeveloper(FContractDevID ASC);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConReDeLop')
CREATE  INDEX IX_CON_ConReDeLop ON T_CON_ContractRevLandDeveloper(FLandDeveloperID ASC);
--合同结算单 
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConSetBiCon')
create index IX_CON_ConSetBiCon on  T_CON_ContractSettlementBill(FContractBillID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConSetBiOr')
create index IX_CON_ConSetBiOr on  T_CON_ContractSettlementBill(FOrgUnitId);
--无文本合同
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConNoTexPr')
create index IX_CON_ConNoTexPr on  T_CON_ContractWithoutText(FCurProjectID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConNoTexOr')
create index IX_CON_ConNoTexOr on  T_CON_ContractWithoutText(FOrgUnitId);
--抄送单位分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_CopSupEnPr')
create index IX_CON_CopSupEnPr on  T_CON_CopySupplierEntry(FParentID);
--付款申请单对应的扣款项
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_DedPyReqBi')
create index IX_CON_DedPyReqBi on  T_CON_DeductOfPayReqBill(FPayRequestBillId);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_DedPyBill')
create index IX_CON_DedPyBill on  T_CON_DeductOfPayReqBill(FPaymentBillId);
--付款申请单对应的扣款项分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_DedPyBiEnPr')
create index IX_CON_DedPyBiEnPr on  T_CON_DeductOfPayReqBillEntry(FParentID);
--奖励单
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_GudBiCon')
create index  IX_CON_GudBiCon on T_CON_GuerdonBill(FContractID);
--付款申请单对应的奖励项
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_GudPyReBi')
create index  IX_CON_GudPyReBi on T_CON_GuerdonOfPayReqBill(FPayRequestBillId);
--付款申请单
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_PayReqContr')
create index IX_CON_PayReqContr on  T_CON_PayRequestBill(FCONTRACTID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_PayReqOrgPr')
create index IX_CON_PayReqOrgPr on  T_CON_PayRequestBill(FOrgUnitId,FCurProjectID);
--付款申请单分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_PayReqEnPr')
create index IX_CON_PayReqEnPr on  T_CON_PayRequestBillEntry(FParentID);
--结算单拆分
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_SetCtSpSet')
create index IX_CON_SetCtSpSet on  T_CON_SettlementCostSplit(FSettlementBillID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_SetCtSpOrg')
create index IX_CON_SetCtSpOrg on  T_CON_SettlementCostSplit(FOrgUnitId);
--结算单拆分分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_SetCtSpEn')
create index IX_CON_SetCtSpEn on  T_CON_SettlementCostSplitEntry(FParentID);

--结算非成本拆分
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_SetNCtSpBi')
create index IX_CON_SetNCtSpBi on  T_CON_SettNoCostSplit(FSettlementBillID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_SetNCtSpOr')
create index IX_CON_SetNCtSpOr on  T_CON_SettNoCostSplit(FOrgUnitId);
--结算非成本拆分分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_SetNCtSpEn')
create index IX_CON_SetNCtSpEn on  T_CON_SettNoCostSplitEntry(FParentID);
--下发单位分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_SupConEnPr')
create index IX_CON_SupConEnPr on  T_CON_SupplierContentEntry(FParentID);


-----------------------------成本数据库---------------------------
--目标成本
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_DBAimOrg')
create index  IX_FDC_DBAimOrg on T_FDC_DBAimCost(FOrgOrProId);
--目标成本条目
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_DBAimEnHd')
create index  IX_FDC_DBAimEnHd on T_FDC_DBCostEntry(FHeadID);
--动态成本快照
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CDB_DBDynSnPr')
create index  IX_CDB_DBDynSnPr on T_CDB_DBDynCostSnapShot(FProjectId);
--动态成本快照产品类型分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CDB_DBDynEnPr')
create index  IX_CDB_DBDynEnPr on T_CDB_DBDynCosSnpStProTypEntry(FParentID);
--动态成本快照结算分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CDB_DBDynStPr')
create index  IX_CDB_DBDynStPr on T_CDB_DBDynCosSnpStSettEntry(FParentID);
--材料设备
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FDC_MateProj')
create index  IX_FDC_MateProj on T_FDC_FdcMaterial(FProjectID);

----------------------------财务一体化--------------------------------------
--合同付款计划
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_ConPyPlPro')
create index  IX_FNC_ConPyPlPro on T_FNC_ContractPayPlan(FcompanyID,FContractId);
--扣款单
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_DeduBiPro')
create index IX_FNC_DeduBiPro on  T_FNC_DeductBill(FCurProjectID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_DeduBiOrg')
create index IX_FNC_DeduBiOrg on  T_FNC_DeductBill(FOrgUnitId);

--扣款单分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_DeduBiEnPr')
create index  IX_FNC_DeduBiEnPr on T_FNC_DeductBillEntry(FParentID);
--竣工结算账务处理
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_FiPrdStBi')
create index IX_FNC_FiPrdStBi on  T_FNC_FIProductSettleBill(FCurProjProductEntriesID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_FiPrdStOr')
create index IX_FNC_FiPrdStOr on  T_FNC_FIProductSettleBill(FOrgUnitId);
--竣工账务处理分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_FiPrdStBiPr')
create index  IX_FNC_FiPrdStBiPr on T_FNC_FIProSttBillEntry(FParentID);
--付款非成本科目拆分
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_PyNCtSpBil')
create index IX_FNC_PyNCtSpBil on  T_FNC_PaymentNoCostSplit(FPaymentBillID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_PyNCtSpOrg')
create index IX_FNC_PyNCtSpOrg on  T_FNC_PaymentNoCostSplit(FOrgUnitId);
--付款非成本科目拆分分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_PyNCtSpEnp')
create index  IX_FNC_PyNCtSpEnp on T_FNC_PaymentNoCostSplitEntry(FParentID);
--付款拆分
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_PySpBil')
create index IX_FNC_PySpBil on  T_FNC_PaymentSplit(FPaymentBillID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_PySpOrg')
create index IX_FNC_PySpOrg on  T_FNC_PaymentSplit(FOrgUnitId);
--付款拆分分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_PySpEnp')
create index IX_FNC_PySpEnp on T_FNC_PaymentSplitEntry(FParentID);
--历史进度款
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_PyNSpVcEn')
create index IX_FNC_PyNSpVcEn on T_FNC_PayNoCostSplit4Voucher(FParentID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_PySpVcEn')
create index IX_FNC_PySpVcEn on T_FNC_PaySplit4Voucher(FParentID);
--付款计划
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_PayPlOrg')
create index IX_FNC_PayPlOrg on  T_FNC_PayPlan(FFullOrgUnitID);
--付款计划分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_PayPlEnPr')
create index IX_FNC_PayPlEnPr on T_FNC_PlanEntry(FHeadID);
--产品结算单
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_ProSetBiEn')
create index IX_FNC_ProSetBiEn  on T_FNC_ProductSettleBill(FCurProjProductEntriesID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_ProSetBiOr')
create index IX_FNC_ProSetBiOr on  T_FNC_ProductSettleBill(FOrgUnitId);
--预提成本冲销
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_SetPyVchBi')
create index IX_FNC_SetPyVchBi on T_FNC_SettForPayVoucher(FPaymentBillID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_SetPyVchOr')
create index IX_FNC_SetPyVchOr on  T_FNC_SettForPayVoucher(FOrgUnitId);
--预提冲销分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_SetPyVchEn')
create index IX_FNC_SetPyVchEn on T_FNC_SettForPayVoucherEntry(FParentID);

----------------------------招标管理--------------------------------------
--表头
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_INV_HdColPr')
create index IX_INV_HdColPr on T_INV_HeadColumn(FParentID);
--表头类型
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_INV_HdTypePr')
create index IX_INV_HdTypePr on T_INV_HeadType(FParentID);
--招标类型
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_INV_InvTpPr')
create index IX_INV_InvTpPr on T_INV_InviteType(FParentID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_INV_InvTpOrg')
create index IX_INV_InvTpOrg on T_INV_InviteType(FOrgID);
--清单子目
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_INV_LisItmOrg')
create index IX_INV_LisItmOrg on T_INV_ListingItem(FHeadTypeID);
--清单
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_INV_NeLsItTy')
create index IX_INV_NeLsItTy on T_INV_NewListing(FInviteTypeID,FCurProjectID);
--清单页签列T_INV_NewListingColumn


----------------------------数据导入--------------------------------------
--成本科目对照表
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_MIG_CtAcctMpta')
create index IX_MIG_CtAcctMpta on T_MIG_CostAcctMapTable(FEasCostAcctID);
--工程项目对照表
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_MIG_PrjMpta')
create index IX_MIG_PrjMpta on T_MIG_ProjectTable(FCurProjectID);
--供应商对照表
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_MIG_SupMpta')
create index IX_MIG_SupMpta on T_MIG_SupplierTable(FSupplierID);


----------------------------进度管理--------------------------------------
--进度项目节假日 
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_PRO_ProHolPro')
create index IX_PRO_ProHolPro on T_PRO_ProcessHoliday(FProjectID);
--进度项目 
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_PRO_ProProPro')
create index IX_PRO_ProProPro on T_PRO_ProcessProject(FProjectID);
--进度项目任务
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_PRO_ProProTsPo')
create index IX_PRO_ProProTsPo on T_PRO_ProcessProjectTask(FProjectID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_PRO_ProProTsPr')
create index IX_PRO_ProProTsPr on T_PRO_ProcessProjectTask(FParentID);
--进度模板
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_PRO_ProTemOrg')
create index IX_PRO_ProTemOrg on T_PRO_ProcessTemplate(FOrgID);
--进度项目周末
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_PRO_ProceWekPr')
create index IX_PRO_ProceWekPr on T_PRO_ProcessWeekend(FProjectID);
--质量事件 
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_PRO_QuanEvTa')
create index IX_PRO_QuanEvTa on T_PRO_QualityEvent(FTaskID);
--安全事件
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_PRO_SafeEvTa')
create index IX_PRO_SafeEvTa on T_PRO_SafeEvent(FTaskID);
--任务工程量
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_PRO_TasPrQua')
create index IX_PRO_TasPrQua on T_PRO_TaskProjectQuality(FTaskID);


----------------------------售楼管理--------------------------------------
--楼栋
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_SHE_BuilSub')
create index IX_SHE_BuilSub on T_SHE_Building(FSubareaID);
--建筑性质
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_SHE_BuilPro')
create index IX_SHE_BuilPro on T_SHE_BuildingProperty(FParentID);
--楼栋单元
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_SHE_BulUnit')
create index IX_SHE_BulUnit on T_SHE_BuildingUnit(FBuildingID);
--客户
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_SHE_FDCCusCi')
create index IX_SHE_FDCCusCi on T_SHE_FDCCustomer(FCityID,FRegionID);
--付款明细分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_SHE_PayLiHed')
create index IX_SHE_PayLiHed on T_SHE_PayListEntry(FHeadID);
--房间
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_SHE_RoomBul')
create index IX_SHE_RoomBul on T_SHE_Room(FBuildingID);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_SHE_RomMod')
create index IX_SHE_RomMod on T_SHE_Room(FRoomModelID);
--房间描述
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_SHE_RomDesBul')
create index IX_SHE_RomDesBul on T_SHE_RoomDes(FBuildingID,FRoomModelID);
--户型
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_SHE_RomMoBul')
create index IX_SHE_RomMoBul on T_SHE_RoomModel(FBuildingID);
--销售项目
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_SHE_SelProj')
create index IX_SHE_SelProj on T_SHE_SellProject(FProjectID);
--付款方式
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_SHE_PayTyPro')
create index IX_SHE_PayTyPro on T_SHE_SHEPayType(FProjectID);
--分区
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_SHE_SubSelPro')
create index IX_SHE_SubSelPro on T_SHE_Subarea(FSellProjectID);


---新增的索引
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='In_CON_ConBilTyPr')
create index  In_CON_ConBilTyPr on T_CON_ContractBill(FOrgUnitID,FCurProjectID,FContractTypeID,FCurrencyID);

IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='In_CON_ConRevEntrP')
create index In_CON_ConRevEntrP on T_CON_CONTRACTBILLREVISEENTRY(FPARENTID,FSEQ,FID)  ;        

IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='In_FDC_curproForg')
create index In_FDC_curproForg on T_FDC_CurProject(FFULLORGUNIT,FISENABLED);


IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='In_con_ConSta')
 create index In_con_ConSta on T_CON_ContractBill(FConSplitExecState,Fnumber,   fid);

IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='In_con_ConwithSta')
 create index In_con_ConwithSta on T_CON_ContractWithoutText(FConSplitExecState, Fnumber,  fid);
 
--月结关系表索引
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='In_aim_SetMonthlya')
 create index In_aim_SetMonthlya on T_FNC_SettledMonthly(fEntityID, fsettleperiodid,fobjectid);
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='In_aim_SetMonthlyb')
 create index In_aim_SetMonthlyb on T_FNC_SettledMonthly(fEntityID, fsettleperiodid,FCurProjectID,fobjectid);


--拆分表
IF NOT EXISTS(SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_PYSCOSTBIID')
create index IX_FNC_PYSCOSTBIID on T_FNC_PaymentSplitEntry(FCOSTBILLID);

--月结相关
 IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_CONCSTSPAC')
create index  IX_CON_CONCSTSPAC on  t_con_contractcostsplit(fstate,fperiodid);

 IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_CHASTSPAC')
create index IX_CON_CHASTSPAC on         t_con_conchangesplit(fstate, fperiodid);

 IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_SETTSTSPAC')
create index IX_CON_SETTSTSPAC on   t_con_settlementcostsplit(fstate, fperiodid);

 IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_PAYMSTSPAC')
create index IX_CON_PAYMSTSPAC on t_fnc_paymentsplit(fstate,fperiodid);          

 IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_PYSTSPENP')                                                 
create index IX_CON_PYSTSPENP on t_fnc_paymentsplitentry(fparentid,fcostaccountid);    

--付款计划
 IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConBillRes')
 create index IX_CON_ConBillRes on T_CON_CONTRACTBILL(FRESPDEPTID)
 
 IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_CONPYPCBI')
create index IX_FNC_CONPYPCBI on T_FNC_CONTRACTPAYPLAN(FCONTRACTID);

--月结状态
 IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_PROPERPR')
create index IX_FNC_PROPERPR on T_FNC_PROJECTPERIODSTATUS(FprojectId);

 IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_FNC_DeduBiEnCon')
create index IX_FNC_DeduBiEnCon on T_FNC_DeductBillEntry(fcontractid);

 IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_DedPyBiEnEn')
create index IX_CON_DedPyBiEnEn on t_con_deductofpayreqbillentry(fdeductbillentryid);

 IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_GudOfPGue')
create index IX_CON_GudOfPGue on t_con_guerdonofpayreqbill(FGUERDONID);

 IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_ConBasDC')
create index IX_CON_ConBasDC on T_CON_CONTRACTBASEDATA(FCONTRACTID);


 --付款申请单
 IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_PayReqNum')
 create index IX_CON_PayReqNum on  T_CON_PayRequestBill(Fnumber);
 
 --成本拆分表
  IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_COSTSPSpl')
 create index IX_AIM_COSTSPSpl on T_AIM_CostSplit(FsplitbillId);
  

--合同拆分分录
IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_CONCSTSPENC')
create index IX_CON_CONCSTSPENC on t_con_contractcostsplitentry(FCOSTACCOUNTID);


--月结相关
 IF  EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_CONCSTSPAC')
drop index t_con_contractcostsplit.IX_CON_CONCSTSPAC;
 IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_CONCSTSPAC')
create index  IX_CON_CONCSTSPAC on  t_con_contractcostsplit(fstate,forgunitid,fperiodid);

 IF  EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_CHASTSPAC')
drop index t_con_conchangesplit.IX_CON_CHASTSPAC;
 IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_CHASTSPAC')
create index IX_CON_CHASTSPAC on   t_con_conchangesplit(fstate, forgunitid,fperiodid);

 IF  EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_SETTSTSPAC')
drop index t_con_settlementcostsplit.IX_CON_SETTSTSPAC;
 IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_SETTSTSPAC')
create index IX_CON_SETTSTSPAC on   t_con_settlementcostsplit(fstate, forgunitid,fperiodid);

 IF  EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_PAYMSTSPAC')
drop index t_fnc_paymentsplit.IX_CON_PAYMSTSPAC;
 IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CON_PAYMSTSPAC')
create index IX_CON_PAYMSTSPAC on t_fnc_paymentsplit(fstate,forgunitid,fperiodid);     

--中间表新增字段索引  by sxhong 2008-04-15 09:47:42
 IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_COSTSPENPe')
create index IX_AIM_COSTSPENPe on T_AIM_CostSplitEntry(fparentid,FObjectid);
 IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_COSTSPBIOr')
create index  IX_AIM_COSTSPBIOr on T_AIM_CostSplit(FCostBillType,fcontrolunitid);

--成本日志变化表索引  by sxhong 2008-12-16 13:49:30
 IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_AIM_PrjChgLog')
create index IX_AIM_PrjChgLog on T_AIM_ProjectCostChangeLog (FProjectId);

IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='IX_CAS_PayBiCon')
 create index IX_CAS_PayBiCon on T_CAS_PAYMENTBILL(FCONTRACTBILLID);
 
 IF NOT EXISTS(SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME='In_cas_paybiConSta')
 create index In_cas_paybiConSta on T_CAS_PaymentBill(FCompanyID, FContractBillID, FCurProjectID, FBillStatus, fid);
 
