﻿CREATE EXTENSION IF NOT EXISTS "uuid-ossp";
@


CREATE OR REPLACE FUNCTION hextoraw(pstr character varying)
  RETURNS bytea AS
$BODY$
DECLARE
val_str varchar;
val_str1 bytea;
BEGIN
val_str:='E''\\x'||pstr||'''';
execute  'select '||val_str into val_str1;
return val_str1;
end;
$BODY$
 LANGUAGE PLPGSQL;
@

CREATE OR REPLACE FUNCTION newbosid (typeString VARCHAR) RETURNS VARCHAR
AS $$
DECLARE


s_guid varchar(255);
g_hex varchar(255);

BEGIN

s_guid := uuid_generate_v4();
g_hex :='0123456789ABCDEFabcdef';
IF LENGTH(typeString) = 8 THEN
FOR i IN 1 .. 8 LOOP
  IF (POSITION(SUBSTR(typeString,i,1) in g_hex) = 0) THEN
 RETURN CONCAT(s_guid,typeString);
END IF;
END LOOP;
return encode(hextoraw(REPLACE(CONCAT(s_guid,typeString),'-','')::varchar) , 'base64');
ELSIF  LENGTH(typeString) = 4 THEN
 RETURN CONCAT(s_guid,typeString);
ELSE
RETURN NULL;
END IF;

END;
$$ LANGUAGE PLPGSQL;
@


  
  CREATE OR REPLACE FUNCTION unistr(pstr character varying)
  RETURNS character varying AS
$BODY$
DECLARE
val_str varchar;
val_str1 varchar;
BEGIN
val_str:='u&'''||pstr||'''';
execute  'select '||val_str into val_str1;
return val_str1;
end;
$BODY$
 LANGUAGE PLPGSQL;
 @
 
 CREATE OR REPLACE FUNCTION dateadd(difftype character varying, incrementvalue integer, inputdate timestamp with time zone)
  RETURNS timestamp without time zone AS
$BODY$ 
DECLARE
   YEAR_CONST varchar(15) := 'year';  
   MONTH_CONST varchar(15) := 'month';  
   WEEK_CONST varchar(15) := 'week';  
   DAY_CONST varchar(15) := 'day';  
   HOUR_CONST varchar(15) := 'hour';  
   MIN_CONST varchar(15) :='minute';  
   SECOND_CONST varchar(15) :='second';  
   dateTemp timestamp;  
   intervals interval;  
BEGIN 
   if inputdate is null then return null ; end if;
   IF lower($1) = lower(YEAR_CONST) THEN  
       select cast(cast(incrementvalue as character varying) || ' year' as interval) into intervals;   
   ELSEIF lower($1) = lower(MONTH_CONST) THEN  
       select cast(cast(incrementvalue as character varying) || ' month' as interval) into intervals;  
 
   ELSEIF lower($1) = lower(WEEK_CONST) THEN  
       select cast(cast(incrementvalue as character varying) || ' week' as interval) into intervals;  
   ELSEIF lower($1) = lower(DAY_CONST) THEN  
       select cast(cast(incrementvalue as character varying) || ' day' as interval) into intervals;  
   ELSEIF lower($1) = lower(HOUR_CONST) THEN  
       select cast(cast(incrementvalue as character varying) || ' hour' as interval) into intervals;  
   ELSEIF lower($1) = lower(MIN_CONST) THEN  
       select cast(cast(incrementvalue as character varying) || ' minute' as interval) into intervals;  
   ELSEIF lower($1) = lower(SECOND_CONST) THEN  
       select cast(cast(incrementvalue as character varying) || ' second' as interval) into intervals;     
   END IF;  
  
   dateTemp:= inputdate + intervals;  
  
   RETURN dateTemp;  
END;  
$BODY$
LANGUAGE PLPGSQL;
@




CREATE OR REPLACE FUNCTION dateadd(difftype character varying, incrementvalue numeric, inputdate timestamp with time zone)
  RETURNS timestamp without time zone AS
$BODY$ 
DECLARE
   YEAR_CONST varchar(15) := 'year';  
   MONTH_CONST varchar(15) := 'month';  
   WEEK_CONST varchar(15) := 'week';  
   DAY_CONST varchar(15) := 'day';  
   HOUR_CONST varchar(15) := 'hour';  
   MIN_CONST varchar(15) :='minute';  
   SECOND_CONST varchar(15) :='second';  
   dateTemp timestamp;  
   intervals interval;  
BEGIN 
   if inputdate is null then return null ; end if;
   IF lower($1) = lower(YEAR_CONST) THEN  
       select cast(cast(incrementvalue as character varying) || ' year' as interval) into intervals;   
   ELSEIF lower($1) = lower(MONTH_CONST) THEN  
       select cast(cast(incrementvalue as character varying) || ' month' as interval) into intervals;  
 
   ELSEIF lower($1) = lower(WEEK_CONST) THEN  
       select cast(cast(incrementvalue as character varying) || ' week' as interval) into intervals;  
   ELSEIF lower($1) = lower(DAY_CONST) THEN  
       select cast(cast(incrementvalue as character varying) || ' day' as interval) into intervals;  
   ELSEIF lower($1) = lower(HOUR_CONST) THEN  
       select cast(cast(incrementvalue as character varying) || ' hour' as interval) into intervals;  
   ELSEIF lower($1) = lower(MIN_CONST) THEN  
       select cast(cast(incrementvalue as character varying) || ' minute' as interval) into intervals;  
   ELSEIF lower($1) = lower(SECOND_CONST) THEN  
       select cast(cast(incrementvalue as character varying) || ' second' as interval) into intervals;     
   END IF;  
  
   dateTemp:= inputdate + intervals;  
  
   RETURN dateTemp;  
END;  
$BODY$
LANGUAGE PLPGSQL;
@


CREATE OR REPLACE FUNCTION round(pstr double precision, s1 integer)
  RETURNS double precision AS
$BODY$
DECLARE


BEGIN

return ROUND(cast(pstr as numeric),s1);
end;
$BODY$
LANGUAGE PLPGSQL;
@


CREATE OR REPLACE FUNCTION to_char(pstr double precision)
  RETURNS character varying AS
$BODY$
DECLARE
BEGIN

return cast(pstr as varchar);
end;
$BODY$
LANGUAGE PLPGSQL;
@

CREATE OR REPLACE FUNCTION trunc(pstr numeric, s1 numeric)
  RETURNS numeric AS
$BODY$
DECLARE


BEGIN

return TRUNC(pstr, cast(s1 as int));
end;
$BODY$
LANGUAGE PLPGSQL;
@

CREATE OR REPLACE FUNCTION lower(pstr integer)
  RETURNS integer AS
$BODY$
DECLARE


BEGIN

return pstr;
end;
$BODY$
LANGUAGE PLPGSQL;
@

CREATE OR REPLACE FUNCTION lower(pstr numeric)
  RETURNS numeric AS
$BODY$
DECLARE


BEGIN

return pstr;
end;
$BODY$
LANGUAGE PLPGSQL;
@

 
 
CREATE OR REPLACE FUNCTION to_char(pstr text)
  RETURNS text AS
$BODY$
DECLARE
BEGIN

return pstr;
end;
$BODY$
LANGUAGE PLPGSQL;
@

CREATE OR REPLACE FUNCTION SUBSTR(v numeric, b integer,l integer)
  RETURNS character AS
$BODY$
DECLARE
BEGIN
return SUBSTRING ( 
cast(v as character) ,b,l
);
end;
$BODY$
LANGUAGE PLPGSQL;
@

CREATE OR REPLACE FUNCTION to_char(pstr character varying)
  RETURNS character varying AS
$BODY$
DECLARE
BEGIN

return pstr;
end;
$BODY$
LANGUAGE PLPGSQL;
@