CREATE  CLUSTERED INDEX IX_CntngLtLO_Task ON T_IM_CountingListLocation(FCountingTaskID ASC,FSeq ASC);

CREATE  CLUSTERED INDEX IX_CntngLtLM_Task ON T_IM_CountingListMaterial(FCountingTaskID ASC,FSeq ASC);

CREATE  CLUSTERED INDEX IX_CntngLtWh_Task ON T_IM_CountingListWarehouse(FCountingTaskID ASC,FSeq ASC);

CREATE  INDEX IX_CntngStr_Number ON T_IM_CountingStrategy(FNumber ASC);

CREATE  INDEX IX_CntngStgE_StgID ON T_IM_CountingStrategyEntry(FCountingStrategyID ASC);
CREATE  INDEX IX_CStgE_Parent ON T_IM_CountingStrategyEntry(FCountingStrategyID ASC,FID ASC,FSeq ASC);

CREATE  INDEX IX_CountTab_TaskID ON T_IM_CountingTable(FCountingTaskID ASC,FWarehouseID ASC);

--CREATE  INDEX IX_CountTab_Parent ON T_IM_CountingTableEntry(FParentID ASC,FLocationID ASC);
CREATE  INDEX IX_CountTab_Parent ON T_IM_CountingTableEntry(FParentID ASC,FID ASC,Fseq ASC);

CREATE  INDEX IX_CntngTak_Date ON T_IM_CountingTask(FBizDate DESC);

CREATE  CLUSTERED INDEX IX_DcmpsB_Number ON T_IM_DecomposeBill(FNumber DESC);

CREATE  INDEX IX_DcmpsB_BizDate ON T_IM_DecomposeBill(FBizDate DESC);

--CREATE  CLUSTERED INDEX IX_DcmpsBE_Parent ON T_IM_DecomposeEntry(FParentID ASC,FSeq ASC);
CREATE  CLUSTERED INDEX IX_DcmpsBE_Parent ON T_IM_DecomposeEntry(FParentID ASC,FID ASC,FSeq ASC);

CREATE  CLUSTERED INDEX IX_DcmpsBED_DPBE ON T_IM_DecomposeEntryDetail(FDecompEntryID ASC,FSeq ASC);

CREATE  CLUSTERED INDEX IX_InvStaAj_Number ON T_IM_InvStateAdjustBill(FNumber DESC);

CREATE  INDEX IX_InvStaAj_BizDat ON T_IM_InvStateAdjustBill(FBizDate DESC);

--CREATE  CLUSTERED INDEX IX_InvStaAdjE_Par ON T_IM_InvStateAdjustBillEntry(FParentID ASC,FSeq ASC);
CREATE  CLUSTERED INDEX IX_InvStaAdjE_Par ON T_IM_InvStateAdjustBillEntry(FParentID ASC,FID ASC,FSeq ASC);

CREATE  CLUSTERED INDEX IX_Invntr_SWM ON T_IM_Inventory(FStorageOrgUnitID ASC,FWarehouseID ASC,FMaterialID ASC);

CREATE  INDEX IX_InvntrB_Year ON T_IM_InventoryBalance(FYear DESC);

CREATE  INDEX IX_InvntrIB_Number ON T_IM_InventoryInitBill(FNumber DESC);

CREATE  INDEX IX_InvntrIE_Parent ON T_IM_InventoryInitEntry(FParentID ASC);

CREATE  CLUSTERED INDEX IX_ManuRec_Number ON T_IM_ManufactureRecBill(FNumber DESC);

CREATE  INDEX IX_ManuRec_BizDate ON T_IM_ManufactureRecBill(FBizDate DESC);

--CREATE  CLUSTERED INDEX IX_ManuRecE_Par ON T_IM_ManufactureRecBillEntry(FParentID ASC,FSeq ASC);
CREATE  CLUSTERED INDEX IX_ManuRecE_Par ON T_IM_ManufactureRecBillEntry(FParentID ASC,FID ASC,FSeq ASC);

CREATE  CLUSTERED INDEX IX_MateriRe_Number ON T_IM_MaterialReqBill(FNumber DESC);

CREATE  INDEX IX_MateriRe_BizDat ON T_IM_MaterialReqBill(FBizDate DESC);

--CREATE  CLUSTERED INDEX IX_MaterReqE_Par ON T_IM_MaterialReqBillEntry(FParentID ASC,FSeq ASC);
CREATE  CLUSTERED INDEX IX_MaterReqE_Par ON T_IM_MaterialReqBillEntry(FParentID ASC,FID ASC,FSeq ASC);

CREATE  CLUSTERED INDEX IX_MoveIWB_Number ON T_IM_MoveInWarehsBill(FNumber DESC);

CREATE  INDEX IX_MoveIWB_BizDat ON T_IM_MoveInWarehsBill(FBizDate DESC);

--CREATE  CLUSTERED INDEX IX_MoveIWBE_Parent ON T_IM_MoveInWarehsBillEntry(FParentID ASC,FSeq ASC);
CREATE  CLUSTERED INDEX IX_MoveIWBE_Parent ON T_IM_MoveInWarehsBillEntry(FParentID ASC,FID ASC,FSeq ASC);

CREATE  CLUSTERED INDEX IX_MoveIB_Number ON T_IM_MoveIssueBill(FNumber DESC);

CREATE  INDEX IX_MoveIB_BizDat ON T_IM_MoveIssueBill(FBizDate DESC);

--CREATE  CLUSTERED INDEX IX_MoveIBE_Parent ON T_IM_MoveIssueBillEntry(FParentID ASC,FSeq ASC);
CREATE  CLUSTERED INDEX IX_MoveIBE_Parent ON T_IM_MoveIssueBillEntry(FParentID ASC,FID ASC,FSeq ASC);

CREATE  CLUSTERED INDEX IX_MoveLB_Number ON T_IM_MoveLocationBill(FNumber DESC);

CREATE  INDEX IX_MoveLB_BizDat ON T_IM_MoveLocationBill(FBizDate DESC);

--CREATE  CLUSTERED INDEX IX_MoveLBE_Parent ON T_IM_MoveLocationBillEntry(FParentID ASC,FSeq ASC);
CREATE  CLUSTERED INDEX IX_MoveLBE_Parent ON T_IM_MoveLocationBillEntry(FParentID ASC,FID ASC,FSeq ASC);

CREATE  CLUSTERED INDEX IX_OtherInW_Number ON T_IM_OtherInWarehsBill(FNumber DESC);

CREATE  INDEX IX_OtherInW_BizDat ON T_IM_OtherInWarehsBill(FBizDate DESC);

--CREATE  CLUSTERED INDEX IX_OtherIWE_Number ON T_IM_OtherInWarehsBillEntry(FParentID ASC,FSeq ASC);
CREATE  CLUSTERED INDEX IX_OtherIWE_PARENT ON T_IM_OtherInWarehsBillEntry(FParentID ASC,FID ASC,FSeq ASC);

CREATE  CLUSTERED INDEX IX_OtherIss_Number ON T_IM_OtherIssueBill(FNumber DESC);

CREATE  INDEX IX_OtherIss_BizDat ON T_IM_OtherIssueBill(FBizDate DESC);

--CREATE  CLUSTERED INDEX IX_OtherIssE_Par ON T_IM_OtherIssueBillEntry(FParentID ASC,FSeq ASC);
CREATE  CLUSTERED INDEX IX_OtherIssE_Par ON T_IM_OtherIssueBillEntry(FParentID ASC,FID ASC,FSeq ASC);

CREATE  CLUSTERED INDEX IX_PurInWH_Number ON T_IM_PurInWarehsBill(FNumber ASC);

CREATE  INDEX IX_PurInWH_BizDat ON T_IM_PurInWarehsBill(FBizDate ASC);

--CREATE  CLUSTERED INDEX IX_PurInv_ParentId ON T_IM_PurInWarehsEntry(FParentID ASC,FSeq ASC);
CREATE  CLUSTERED INDEX IX_PurInv_ParentId ON T_IM_PurInWarehsEntry(FParentID ASC,FID ASC,FSeq ASC);

CREATE  CLUSTERED INDEX IX_PurRecB_Number ON T_IM_PurReceivalBill(FNumber DESC);

CREATE  INDEX IX_PurRecB_BizDate ON T_IM_PurReceivalBill(FBizDate DESC);

--CREATE  CLUSTERED INDEX IX_PurRecE_Parent ON T_IM_PurReceivalEntry(FParentID ASC,FSeq ASC);
CREATE  CLUSTERED INDEX IX_PurRecE_Parent ON T_IM_PurReceivalEntry(FParentID ASC,FID ASC,FSeq ASC);

CREATE  CLUSTERED INDEX IX_SaleIss_Number ON T_IM_SaleIssueBill(FNumber DESC);

CREATE  INDEX IX_SaleIss_BizDat ON T_IM_SaleIssueBill(FBizDate DESC);

--CREATE  CLUSTERED INDEX IX_SaleIssE_Parent ON T_IM_SaleIssueEntry(FParentID ASC,FSeq ASC);
CREATE  CLUSTERED INDEX IX_SaleIssE_Parent ON T_IM_SaleIssueEntry(FParentID ASC,FID ASC,FSeq ASC);

CREATE  CLUSTERED INDEX IX_StockTra_Number ON T_IM_StockTransferBill(FNumber DESC);

CREATE  INDEX IX_StockTra_BizDat ON T_IM_StockTransferBill(FBizDate DESC);

--CREATE  CLUSTERED INDEX IX_StockTrE_Parent ON T_IM_StockTransferBillEntry(FParentID ASC,FSeq ASC);
CREATE  CLUSTERED INDEX IX_StockTrE_Parent ON T_IM_StockTransferBillEntry(FParentID ASC,FID ASC,FSeq ASC);

CREATE CLUSTERED INDEX IX_InvLog_BizDate ON T_IM_InventoryLog(FBizDate DESC);

CREATE INDEX IX_InvLog_OrgWhM ON T_IM_InventoryLog(FStorageOrgUnitID,FWarehouseID,FMaterialID);

--陈曦
--2007-3-29
If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_SaleIssueBill_Year')
DROP INDEX T_IM_SaleIssueBill.IX_IM_SaleIssueBill_Year;

If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_MoveIssueBill_Year')
DROP INDEX T_IM_MoveIssueBill.IX_IM_MoveIssueBill_Year;

If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_MaterialReqBill_Year')
DROP INDEX T_IM_MaterialReqBill.IX_IM_MaterialReqBill_Year;

If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_OtherIssueBill_Year')
DROP INDEX T_IM_OtherIssueBill.IX_IM_OtherIssueBill_Year;

If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_SaleIssueEntry_source')
DROP INDEX T_IM_SaleIssueEntry.IX_IM_SaleIssueEntry_source;

If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_MoveIssueEntry_source')
DROP INDEX T_IM_MoveIssueBillEntry.IX_IM_MoveIssueEntry_source;

If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_MaterialReqEntry_source')
DROP INDEX T_IM_MaterialReqBillEntry.IX_IM_MaterialReqEntry_source;

If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_OtherIssueEntry_source')
DROP INDEX T_IM_OtherIssueBillEntry.IX_IM_OtherIssueEntry_source;

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_SaleIss_Year')
create index IX_IM_SaleIss_Year on T_IM_SaleIssuebill(FPeriod,FYear);

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_MoveIss_Year')
create index IX_IM_MoveIss_Year on T_IM_MoveIssueBill(FPeriod,FYear);

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_Materia_Year')
create index IX_IM_Materia_Year on T_IM_MaterialReqBill(FPeriod,FYear);

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_OtherIs_Year')
create index IX_IM_OtherIs_Year on T_IM_OtherIssueBill(FPeriod,FYear);

--20070313 调整来源单据ID索引

If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_SalIE_source')
DROP INDEX T_IM_SaleIssueEntry.IX_IM_SalIE_source ;

If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_MovIE_source')
DROP INDEX  T_IM_MoveIssueBillEntry.IX_IM_MovIE_source;

If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_MateE_source')
DROP INDEX  T_IM_MaterialReqBillEntry.IX_IM_MateE_source;

If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_OthIE_source')
DROP INDEX  T_IM_OtherIssueBillEntry.IX_IM_OthIE_source;


--If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_SalIE_source')
--create index IX_IM_SalIE_source on T_IM_SaleIssueEntry(FSOURCEBILLID,FSOURCEBILLENTRYID);

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_MovIE_source')
create index IX_IM_MovIE_source on T_IM_MoveIssueBillEntry(FSOURCEBILLID,FSOURCEBILLENTRYID);

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_MateE_source')
create index IX_IM_MateE_source on T_IM_MaterialReqBillEntry(FSOURCEBILLID,FSOURCEBILLENTRYID);

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_OthIE_source')
create index IX_IM_OthIE_source on T_IM_OtherIssueBillEntry(FSOURCEBILLID,FSOURCEBILLENTRYID);

--增加物料财务组织索引

If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_SalIE_CompMa')
DROP INDEX T_IM_SaleIssueEntry.IX_IM_SalIE_CompMa ;

If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_MovIE_CompMa')
DROP INDEX  T_IM_MoveIssueBillEntry.IX_IM_MovIE_CompMa;

If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_MateE_CompMa')
DROP INDEX  T_IM_MaterialReqBillEntry.IX_IM_MateE_CompMa;

If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_OthIE_CompMa')
DROP INDEX  T_IM_OtherIssueBillEntry.IX_IM_OthIE_CompMa;

--If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_SalIE_CompMa')
--create index IX_IM_SalIE_CompMa on T_IM_SaleIssueEntry(fmaterialid,fcompanyorgunitid);

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_MovIE_CompMa')
create index IX_IM_MovIE_CompMa on T_IM_MoveIssueBillEntry(fmaterialid,fcompanyorgunitid);

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_MateE_CompMa')
create index IX_IM_MateE_CompMa on T_IM_MaterialReqBillEntry(fmaterialid,fcompanyorgunitid);

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_OthIE_CompMa')
create index IX_IM_OthIE_CompMa on T_IM_OtherIssueBillEntry(fmaterialid,fcompanyorgunitid);

If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_MovIE_StTrBl')
DROP INDEX  T_IM_MoveIssueBillEntry.IX_IM_MovIE_StTrBl;

If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_MovIn_StTrBl')
DROP INDEX  t_im_moveinwarehsbillentry.IX_IM_MovIn_StTrBl;

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_MovIE_StTrBl')
create index IX_IM_MovIE_StTrBl on T_IM_MoveIssueBillEntry(FStockTransferBillID,FStockTransBillEntryID);

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_MovIn_StTrBl')
create index IX_IM_MovIn_StTrBl on t_im_moveinwarehsbillentry(FStockTransferBillID,FStockTransBillEntryID);

--新增FParentID索引
--authour 张亚朋
--2007/04/28

--销售出库单
If  exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_SALE_PARENTID')
	DROP INDEX T_IM_SALEISSUEENTRY.IDX_SALE_PARENTID;
--If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_SALE_PID')
--  CREATE  INDEX  IDX_SALE_PID ON T_IM_SALEISSUEENTRY(FParentID);
 
  --调拔出库单parentid索引	
 If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_MOVOUT_FPARENTID')
 	DROP INDEX T_IM_MoveIssueBillEntry.IDX_MOVOUT_FPARENTID;
 If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_MOVOUT_FPID')
	CREATE INDEX  IDX_MOVOUT_FPID ON  T_IM_MoveIssueBillEntry(FPARENTID);
	
--采购入库单parentid索引	
 If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_PURIN_FPARENTID')
 	DROP INDEX T_IM_PurinwarehsEntry.IDX_PURIN_FPARENTID;
 If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_PURIN_FPID')
	CREATE INDEX  IDX_PURIN_FPID ON  T_IM_PurinwarehsEntry(FPARENTID);

--领料出库单parentid索引
 If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_MATREQ_FPARENTID')
 	DROP INDEX T_IM_MaterialReqBillEntry.IDX_MATREQ_FPARENTID;
 If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_MATREQ_FPID')
	CREATE INDEX  IDX_MATREQ_FPID ON  T_IM_MaterialReqBillEntry(FPARENTID);

--其它出库单parentid索引
 If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_OthISSU_FPARENTID')
 	DROP INDEX T_IM_OtherIssueBillEntry.IDX_OthISSU_FPARENTID;
 If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_OthIU_FPID')
	CREATE INDEX  IDX_OthIU_FPID ON  T_IM_OtherIssueBillEntry(FPARENTID);


  
--新增成本计算索引
--authour 张亚朋
--2007/06/18
If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_MATER_ATP')
 CREATE  INDEX  IDX_MATER_ATP ON T_BD_MATERIALCOMPANYINFO(FAccountType);

--采购入库单索引
IF(EXISTS(SELECT *  FROM KSQL_INDEXES WHERE KSQL_INDNAME ='IX_IM_PURIN_COMPMA'))
  DROP INDEX T_IM_PURINWAREHSENTRY.IX_IM_PURIN_COMPMA;

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_PURINB_YP')
 CREATE  INDEX  IDX_PURINB_YP ON T_IM_PurInWarehsBill(FYEAR,FPERIOD);
If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_PURINE_FF')
 CREATE  INDEX  IDX_PURINE_FF ON T_IM_PURINWAREHSENTRY(FCOMPANYORGUNITID,FMATERIALID);

--生产入库单
IF(EXISTS(SELECT *  FROM KSQL_INDEXES WHERE KSQL_INDNAME ='IX_IM_MATIN_COMPMA'))
  DROP INDEX T_IM_ManufactureRecBillENTRY.IX_IM_MATIN_COMPMA;
  
If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_MANUF_YP')
 CREATE  INDEX  IDX_MANUF_YP ON T_IM_ManufactureRecBill(FYEAR,FPERIOD);
If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_MANUF_FF')
 CREATE  INDEX  IDX_MANUF_FF ON T_IM_ManufactureRecBillENTRY(FCOMPANYORGUNITID,FMATERIALID);
 
--其它入库单
IF(EXISTS(SELECT *  FROM KSQL_INDEXES WHERE KSQL_INDNAME ='IX_IM_OTHIN_COMPMA'))
  DROP INDEX T_IM_OTHERINWAREHSBILLENTRY.IX_IM_OTHIN_COMPMA;
  
If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_OTHIN_YP')
 CREATE  INDEX  IDX_OTHIN_YP ON T_IM_OTHERINWAREHSBILL(FYEAR,FPERIOD);
If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_OTHIN_FF')
 CREATE  INDEX  IDX_OTHIN_FF ON T_IM_OTHERINWAREHSBILLENTRY(FCOMPANYORGUNITID,FMATERIALID);
 
 --成本调整单
If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_COSTADJ_YP')
 CREATE  INDEX  IDX_COSTADJ_YP ON T_CL_COSTADJUSTBILL(FYEAR,FPERIOD);
If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_COSTADJ_FF')
 CREATE  INDEX  IDX_COSTADJ_FF ON T_CL_COSTADJUSTBILLENTRY(FCOMPANYORGUNITID,FMATERIALID);
 
--调拔入库单

IF(EXISTS(SELECT *  FROM KSQL_INDEXES WHERE KSQL_INDNAME ='IX_IM_MOVIN_COMPMA'))
  DROP INDEX T_IM_MOVEINWAREHSBILLENTRY.IX_IM_MOVIN_COMPMA;

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_MOVEIN_YP')
 CREATE  INDEX  IDX_MOVEIN_YP ON T_IM_MOVEINWAREHSBILL(FYEAR,FPERIOD);
If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_MOVEIN_FF')
 CREATE  INDEX  IDX_MOVEIN_FF ON T_IM_MOVEINWAREHSBILLENTRY(FCOMPANYORGUNITID,FMATERIALID);
 
 --其它出库单parentid索引
If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_OTHIN_FPID')
CREATE INDEX  IDX_OTHIN_FPID ON  T_IM_OTHERINWAREHSBILLENTRY(FPARENTID);

 --销售出库关联销售订单及分录索引
If not exists (select * from KSQL_INDEXES where KSQL_INDNAME = 'IX_IM_SIECORE')
CREATE INDEX IX_IM_SIECORE ON T_IM_SaleIssueEntry(FSaleOrderID, FSaleOrderEntryID);

--要货申请单索引

--罗斌 2007-9-10

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_STR_NUMBER')

CREATE INDEX IDX_STR_NUMBER ON T_IM_STOCKREQ(FNumber);

 

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_STR_BIZDATE')

CREATE INDEX IDX_STR_BIZDATE ON T_IM_STOCKREQ(FBizDate);

 

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_STRE_PID')
CREATE INDEX IDX_STRE_PID ON T_IM_STOCKREQENTRY(FParentID ASC,FID ASC, FSeq ASC);
--CREATE INDEX IDX_STRE_PID ON T_IM_STOCKREQENTRY(FParentID, FSeq);

 

--计划订单索引

--罗斌 2007-9-10

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_PLO_NUMBER')

CREATE INDEX IDX_PLO_NUMBER ON T_IM_PLANORDER(FNumber);

 

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_PLO_BIZDATE')

CREATE INDEX IDX_PLO_BIZDATE ON T_IM_PLANORDER(FBizDate);

 

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_PLO_PID')

CREATE INDEX IDX_PLO_PID ON T_IM_PLANORDERENTRY(FParentID, FSeq);

 

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_PLO_PDATE')

CREATE INDEX IDX_PLO_PDATE ON T_IM_PLANORDERENTRY(FPlanDate);

--调拔入库
--增加fbaseCurrencyid字段索引
If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IDX_MOVIN_STORID')
CREATE  INDEX IDX_MOVIN_STORID ON t_im_moveinwarehsbillentry(FStorageOrgUnitID);

--调拨订单索引

IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_TranOrderE_Parent')
DROP INDEX T_IM_TransferOrderBillEntry.IX_TranOrderE_Parent;
IF EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_TOrderE_Parent')
DROP INDEX T_IM_TransferOrderBillEntry.IX_TOrderE_Parent;
IF NOT EXISTS (SELECT * FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IX_TOrderE_Parent')
CREATE  CLUSTERED INDEX IX_TOrderE_Parent ON T_IM_TransferOrderBillEntry(FParentID ASC,FID ASC,FSeq ASC);

 
 --变更描述：库存报表索引脚本
--变更人：jianyujun 
--变更日期：2008-7-30
If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_SIORAGE') 
create index IX_IM_SIORAGE ON T_IM_SALEISSUEEntry(fstorageorgunitid);  

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_MFORAGE') 
create index IX_IM_MFORAGE ON T_IM_ManufactureRecBillEntry(fstorageorgunitid);  

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_MRBESTORAGE') 
create index IX_IM_MRBESTORAGE ON T_IM_MaterialReqBillEntry(fstorageorgunitid);  

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_PIWESTORAGE') 
create index IX_IM_PIWESTORAGE ON T_IM_PurInWarehsEntry(fstorageorgunitid);
 
 
--变更描述：采购合同执行情况表, 入货单分录参与取数
--变更人：卢旭锋
--变更日期：2008-8-7
If NOT exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_PEIOAdEntry')
create index IX_IM_PEIOAdEntry on 
T_IM_PURINWAREHSENTRY(FPurOrderid,FPurOrderentryid ASC);

--同步5.4补丁到SP1
--变更人 肖平春
If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_SALEISS_BIZDAT') 
DROP INDEX T_IM_SALEISSUEBILL.IX_SALEISS_BIZDAT; 

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_SALEISS_BIZDAT') 
CREATE INDEX IX_SALEISS_BIZDAT ON T_IM_SALEISSUEBILL (FBIZDATE);  

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_MRBESTORAGE') 
create index IX_IM_MRBESTORAGE ON T_IM_MaterialReqBillEntry(fstorageorgunitid);  

If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_PIWESTORAGE') 
create index IX_IM_PIWESTORAGE ON T_IM_PurInWarehsEntry(fstorageorgunitid);
--描述：调拨订单--单据--增加索引“变更前单据ID+版本号”，用于查询历史版本时
--日期：2008-08-06
--编写: 肖平春
If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_TrsfOrD_alt')
CREATE  INDEX IX_IM_TrsfOrD_alt ON T_IM_TransferOrderBill(FOldBillID ASC,FVersion DESC);

If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_InvntrB_Year')
DROP INDEX T_IM_InventoryBalance.IX_InvntrB_Year;
If not exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_InvB_CMPYP')
CREATE  INDEX IX_InvB_CMPYP ON T_IM_InventoryBalance(FCompanyorgunitID,FYear,Fperiod);

-- by blee.li 该T_IM_SALEISSUEENTRY(FSOURCEBILLID,FSOURCEBILLENTRYID)已建脚本
-- If NOT exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_SOU_EN')
--	CREATE  INDEX IX_IM_SOU_EN ON T_IM_SALEISSUEENTRY(FSOURCEBILLID,FSOURCEBILLENTRYID);
If NOT exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_SALIE_SOURN')
	CREATE  INDEX IX_IM_SALIE_SOURN ON T_IM_SALEISSUEENTRY(FSOURCEBILLENTRYID,FSOURCEBILLID);
--If NOT exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_SALIE_COMPN')
--	CREATE  INDEX IX_IM_SALIE_COMPN ON T_IM_SALEISSUEENTRY(FMATERIALID,FWAREHOUSEID,FCOMPANYORGUNITID);
If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_SIECORE')
	DROP INDEX T_IM_SALEISSUEENTRY.IX_IM_SIECORE;
If NOT exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_SIECOREN')
	CREATE  INDEX IX_IM_SIECOREN ON T_IM_SALEISSUEENTRY(FSaleOrderEntryID,FSaleOrderID);
-- 变更人：卢旭锋
-- 变更日期：2009-01-16
-- 描述：领料申请单上创建索引
If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_MaterReqUET_Par')
DROP INDEX T_IM_MaterialRequestBillEntry.IX_MaterReqUET_Par;
If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_MRqeT_Parent')
DROP INDEX T_IM_MaterialRequestBillEntry.IX_MRqeT_Parent;
If NOT exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_MRqeT_Parent')
CREATE INDEX IX_MRqeT_Parent ON T_IM_MaterialRequestBillEntry(FParentID,FSeq);

If exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_SALIE_COMPMAN')
  DROP index T_IM_SALEISSUEENTRY.IX_IM_SALIE_COMPMAN;
--If NOT exists (select * from KSQL_INDEXES where KSQL_INDNAME ='IX_IM_SALIE_COMPN')
--	CREATE  INDEX IX_IM_SALIE_COMPN ON T_IM_SALEISSUEENTRY(FMATERIALID,FWAREHOUSEID,FCOMPANYORGUNITID);
