/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.service.imp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxCollection;
import com.kingdee.eas.basedata.assistant.ExchangeAuxFactory;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateCollection;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableCollection;
import com.kingdee.eas.basedata.assistant.ExchangeTableFactory;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTypeEnum;
import com.kingdee.eas.basedata.assistant.IExchangeAux;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.service.IExchangeRateService;
import com.kingdee.eas.basedata.assistant.service.imp.CurrencyServiceImp;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

public class ExchangeRateServiceImp
implements IExchangeRateService {
    Logger logger = Logger.getLogger(CurrencyServiceImp.class);
    private Context context;
    private DateFormat format = new SimpleDateFormat("yyyy-MM-dd");

    public ExchangeRateServiceImp(Context context) {
        this.context = context;
    }

    public Context getContext() throws BOSException, EASBizException {
        return this.context;
    }

    public void setContext(Context context) throws BOSException, EASBizException {
        this.context = context;
    }

    public ExchangeTableCollection getExchangeTableCol() throws BOSException, EASBizException {
        return ExchangeTableFactory.getLocalInstance((Context)this.context).getExchangeTableCollection();
    }

    public CurrencyCollection getCurrencyCol() throws BOSException, EASBizException {
        return CurrencyFactory.getLocalInstance((Context)this.context).getCurrencyCollection();
    }

    public String calAvgExchangeRate(String exchangeTable, String sourceCurrency, String targetCurrency, String convertMode, String exchangeRateType, String beginDate, String endDate) throws BOSException, EASBizException, ParseException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("exchangeAux.precision"));
        sic.add(new SelectorItemInfo("convertRate"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("exchangeAux.exchangeTable.id", (Object)exchangeTable));
        fic.add(new FilterItemInfo("exchangeAux.sourceCurrency.id", (Object)sourceCurrency));
        fic.add(new FilterItemInfo("exchangeAux.targetCurrency.id", (Object)targetCurrency));
        fic.add(new FilterItemInfo("exchangeAux.convertMode", (Object)new Integer(convertMode)));
        fic.add(new FilterItemInfo("exchangeAux.exchangeRateType", (Object)new Integer(exchangeRateType)));
        fic.add(new FilterItemInfo("isUsedBG", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("availTime", (Object)this.format.parse(beginDate), CompareType.GREATER_EQUALS));
        fic.add(new FilterItemInfo("availTime", (Object)this.format.parse(endDate), CompareType.LESS_EQUALS));
        filter.setMaskString("#0 AND #1 AND #2 AND #3 AND #4 AND #5 AND #6 AND #7 ");
        IExchangeRate exCtrl = ExchangeRateFactory.getLocalInstance((Context)this.context);
        ExchangeRateCollection exCol = exCtrl.getExchangeRateCollection(view);
        int pre = 3;
        int count = exCol.size();
        BigDecimal pjrate = null;
        BigDecimal rate = new BigDecimal("0");
        if (count > 0) {
            for (ExchangeRateInfo ex : exCol) {
                ExchangeAuxInfo aux = ex.getExchangeAux();
                pre = aux.getPrecision();
                rate = rate.add(ex.getConvertRate());
            }
            pjrate = rate.divide(new BigDecimal(count), pre, 4);
            return pjrate.toString();
        }
        return rate.toString();
    }

    public ExchangeAuxInfo getExchangeAuxInfo(String exchangeRateAuxId) throws BOSException, EASBizException {
        String oql = "select sourceCurrency.id, sourceCurrency.name,targetCurrency.name,targetCurrency.id,exchangeTable.id,convertMode,exchangeRateType,precision where id='" + exchangeRateAuxId + "'";
        return (ExchangeAuxInfo)ExchangeAuxFactory.getLocalInstance((Context)this.context).getDataBaseInfo(oql);
    }

    public ExchangeTableInfo getExchangeTableInfo(String exchangeTableId) throws BOSException, EASBizException {
        String oql = "select name,number,isReversible,isMulExchange where id='" + exchangeTableId + "'";
        return (ExchangeTableInfo)ExchangeTableFactory.getLocalInstance((Context)this.context).getDataBaseInfo(oql);
    }

    public String addNewExchangeAux(String convertMode, String sourceCurrency, String targetCurrency, String precision, String exchangeRateType, String exchangeTable) throws BOSException, EASBizException {
        IExchangeAux iExchangeAux = ExchangeAuxFactory.getLocalInstance((Context)this.context);
        ExchangeAuxInfo auxVO = new ExchangeAuxInfo();
        ExchangeTableInfo exchangeTableInfo = new ExchangeTableInfo();
        exchangeTableInfo.setId(BOSUuid.read((String)exchangeTable));
        auxVO.setExchangeTable(exchangeTableInfo);
        CurrencyInfo sourceCurrencyInfo = new CurrencyInfo();
        sourceCurrencyInfo.setId(BOSUuid.read((String)sourceCurrency));
        auxVO.setSourceCurrency(sourceCurrencyInfo);
        CurrencyInfo targetCurrencyInfo = new CurrencyInfo();
        targetCurrencyInfo.setId(BOSUuid.read((String)targetCurrency));
        auxVO.setTargetCurrency(targetCurrencyInfo);
        ConvertModeEnum convertModeEnum = ConvertModeEnum.getEnum((int)Integer.parseInt(convertMode));
        auxVO.setConvertMode(convertModeEnum);
        ExchangeTypeEnum exchangeTypeEnum = ExchangeTypeEnum.getEnum((int)Integer.parseInt(exchangeRateType));
        auxVO.setExchangeRateType(exchangeTypeEnum);
        auxVO.setPrecision(Integer.parseInt(precision));
        IObjectPK pk = iExchangeAux.addnew((CoreBaseInfo)auxVO);
        return pk.toString();
    }

    public ExchangeAuxInfo isExchangeAuxExits(String sourceCurrency, String targetCurrency, String exchangeTable) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceCurrency", (Object)sourceCurrency));
        filter.getFilterItems().add(new FilterItemInfo("targetCurrency", (Object)targetCurrency));
        filter.getFilterItems().add(new FilterItemInfo("exchangeTable", (Object)exchangeTable));
        filter.setMaskString("#0 and #1 and #2");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        ExchangeAuxCollection ec = ExchangeAuxFactory.getLocalInstance((Context)this.context).getExchangeAuxCollection(evi);
        if (ec == null || ec.size() <= 0) {
            return null;
        }
        return ec.get(0);
    }
}

