/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.basedata.assistant.service.imp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IO_Period;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.IPeriodRelation;
import com.kingdee.eas.basedata.assistant.O_PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodRelationCollection;
import com.kingdee.eas.basedata.assistant.PeriodRelationFactory;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.service.IPeriodService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.UuidException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class PeriodServiceImp
implements IPeriodService {
    Logger logger = Logger.getLogger(PeriodServiceImp.class);
    private Context context;
    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    private int adjustPeriodCount = 0;

    public PeriodServiceImp(Context context) {
        this.context = context;
    }

    public Context getContext() throws BOSException, EASBizException {
        return this.context;
    }

    public void setContext(Context context) throws BOSException, EASBizException {
        this.context = context;
    }

    public void addNewPeriod(String periodType, String periodYear, String periodNumberGrid, String periodQuarterGrid) throws BOSException, EASBizException {
        try {
            IO_Period iO_Period = O_PeriodFactory.getLocalInstance((Context)this.context);
            try {
                iO_Period.addPeriodCollection(this.createPeriodCollection(periodType, periodYear, periodNumberGrid, periodQuarterGrid));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            PeriodInfo periodInfo = new PeriodInfo();
            CacheServiceFactory.getInstance().discardType(periodInfo.getBOSType());
        }
        catch (BOSException ex) {
            return;
        }
    }

    private PeriodCollection createPeriodCollection(String periodType, String periodYear, String periodNumberGrid, String periodQuarterGrid) throws JSONException {
        int i;
        JSONArray periodNumberJson = new JSONArray(periodNumberGrid);
        JSONArray periodQuarterJson = new JSONArray(periodQuarterGrid);
        PeriodCollection c = new PeriodCollection();
        PeriodTypeInfo typeInfo = new PeriodTypeInfo();
        typeInfo.setId(BOSUuid.read((String)periodType));
        PeriodInfo info = null;
        for (i = 0; i < periodNumberJson.length(); ++i) {
            info = new PeriodInfo();
            JSONObject periodNumberInfo = periodNumberJson.getJSONObject(i);
            try {
                info.setBeginDate(DateTimeUtils.parseDate((String)((String)periodNumberInfo.get("beginDate"))));
                info.setEndDate(new Timestamp(DateTimeUtils.parseDate((String)((String)periodNumberInfo.get("endDate"))).getTime()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            info.setPeriodNumber(i + 1);
            info.setPeriodYear(Integer.parseInt(periodYear));
            info.setPeriodType(typeInfo);
            info.setIsAdjustPeriod(periodNumberInfo.getBoolean("isAdjustPeriod"));
            c.add(info);
        }
        for (i = 0; i < periodQuarterJson.length(); ++i) {
            JSONObject periodQuarterInfo = periodQuarterJson.getJSONObject(i);
            int beginIndex = Integer.parseInt(periodQuarterInfo.getString("beginPeriod"));
            int endIndex = Integer.parseInt(periodQuarterInfo.getString("endPeriod"));
            for (int j = beginIndex - 1; j < endIndex; ++j) {
                c.get(j).setPeriodQuarter(i + 1);
            }
        }
        return c;
    }

    public String getNewPeriodBeginDate(String periodType) throws BOSException, EASBizException {
        return this.format.format(O_PeriodFactory.getLocalInstance((Context)this.context).getNewPeriodRelInfo(periodType).get("BeginDate"));
    }

    public String submit(String periodType, String periodYear, String periodGridData, String removePeriodList) throws BOSException, EASBizException, JSONException, ParseException {
        JSONArray periodGridDataJson = new JSONArray(periodGridData);
        JSONArray removePeriodListson = new JSONArray(removePeriodList);
        String errorMessage = "";
        if (periodGridData.length() != 0) {
            errorMessage = this.checkAllPeriod(periodType, periodYear, periodGridDataJson, removePeriodListson);
            if ("".equals(errorMessage)) {
                this.updateAllPeriod(periodType, periodYear, periodGridDataJson, removePeriodListson);
            }
        } else {
            this.removeAllPeriod(removePeriodListson);
        }
        return errorMessage;
    }

    private String checkAllPeriod(String periodType, String periodYear, JSONArray periodGridData, JSONArray removePeriod) throws JSONException, ParseException, BOSException {
        String errorMessage = "";
        if (!this.checkAdjustPeriod(periodGridData)) {
            errorMessage = "\u8c03\u6574\u671f\u53ea\u80fd\u4e3a\u671f\u95f4\u6700\u540e\u4e00\u671f!";
            return errorMessage;
        }
        if (!this.checkPeriodContinous(periodGridData)) {
            errorMessage = "\u671f\u95f4\u4e0d\u8fde\u7eed!";
            return errorMessage;
        }
        if (!this.checkQuarterContinous(periodGridData)) {
            errorMessage = "\u5b63\u5ea6\u4e0d\u8fde\u7eed!";
            return errorMessage;
        }
        if (!this.checkYearContinous(periodType, Integer.parseInt(periodYear), periodGridData)) {
            errorMessage = "\u5e74\u5ea6\u4e0d\u8fde\u7eed!";
            return errorMessage;
        }
        if (!this.checkPeriodReference(removePeriod)) {
            errorMessage = "\u88ab\u5220\u9664\u7684\u671f\u95f4\u5df2\u542f\u7528\uff0c\u4e0d\u80fd\u5220\u9664!";
            return errorMessage;
        }
        return errorMessage;
    }

    private boolean checkAdjustPeriod(JSONArray periodGridData) throws JSONException {
        int firstAdjustRow = -1;
        JSONObject row = null;
        for (int i = 0; i < periodGridData.length(); ++i) {
            row = periodGridData.getJSONObject(i);
            if (Integer.parseInt(row.get("isAdjustPeriod").toString()) != 1) continue;
            firstAdjustRow = i;
            break;
        }
        if (firstAdjustRow != -1) {
            this.adjustPeriodCount = periodGridData.length() - firstAdjustRow;
            return this.adjustPeriodCount <= 1;
        }
        return true;
    }

    private boolean checkPeriodContinous(JSONArray periodGridData) throws ParseException, JSONException, BOSException {
        int i;
        Date endDate = null;
        Date newBeginDate = null;
        JSONObject row = null;
        JSONObject row2 = null;
        int periodCount = periodGridData.length();
        int adjustCount = this.adjustPeriodCount;
        Date yearEndDate = null;
        yearEndDate = this.format.parse(periodGridData.getJSONObject(periodCount - 1).get("endDate").toString());
        for (i = 0; i < periodCount - adjustCount - 1; ++i) {
            row = periodGridData.getJSONObject(i);
            row2 = periodGridData.getJSONObject(i + 1);
            Date rowBeginDate = this.format.parse(row.getString("beginDate"));
            endDate = this.format.parse(row.getString("endDate"));
            if (endDate == null || endDate.compareTo(rowBeginDate) < 0) {
                return false;
            }
            boolean isAdjuustPeriod = row.getInt("isAdjustPeriod") == 1;
            newBeginDate = this.format.parse(row2.getString("beginDate"));
            if (newBeginDate != null && (isAdjuustPeriod || DateTimeUtils.dateDiff((String)"d", (Date)endDate, (Date)DateTimeUtils.addDay((Date)newBeginDate, (long)-1L)) == 0L)) continue;
            return false;
        }
        row = periodCount - adjustCount != 0 ? periodGridData.getJSONObject(periodCount - adjustCount - 1) : periodGridData.getJSONObject(periodCount - 1);
        endDate = this.format.parse(row.getString("endDate"));
        newBeginDate = this.format.parse(row.getString("beginDate"));
        if (DateTimeUtils.dateDiff((String)"d", (Date)newBeginDate, (Date)endDate) <= 0L) {
            throw new BOSException("\u5f00\u59cb\u65e5\u671f\u5e94\u8be5\u4e3a\u671f\u95f4\u5f00\u59cb\u65e5\u671f");
        }
        if (DateTimeUtils.dateDiff((String)"d", (Date)endDate, (Date)yearEndDate) != 0L) {
            throw new BOSException("\u7ed3\u675f\u65e5\u671f\u5e94\u8be5\u4e3a\u671f\u95f4\u7ed3\u675f\u65e5\u671f");
        }
        for (i = periodCount - adjustCount; i < periodCount; ++i) {
            row = periodGridData.getJSONObject(i);
            endDate = this.format.parse(row.getString("endDate"));
            newBeginDate = this.format.parse(row.getString("beginDate"));
            if (DateTimeUtils.dateDiff((String)"d", (Date)newBeginDate, (Date)yearEndDate) != 0L) {
                throw new BOSException("\u8c03\u6574\u671f\u5f00\u59cb\u65e5\u671f\u5e94\u8be5\u4e3a\u671f\u95f4\u7ed3\u675f\u65e5\u671f");
            }
            if (DateTimeUtils.dateDiff((String)"d", (Date)endDate, (Date)yearEndDate) == 0L) continue;
            throw new BOSException("\u8c03\u6574\u671f\u7ed3\u675f\u65e5\u671f\u5e94\u8be5\u4e3a\u671f\u95f4\u7ed3\u675f\u65e5\u671f");
        }
        return true;
    }

    private boolean checkQuarterContinous(JSONArray periodGridData) throws JSONException {
        int quarter = -1;
        int nextQuarter = -1;
        JSONObject row = null;
        JSONObject row2 = null;
        for (int i = 0; i < periodGridData.length() - 1; ++i) {
            row = periodGridData.getJSONObject(i);
            row2 = periodGridData.getJSONObject(i + 1);
            quarter = Integer.parseInt(row.get("periodQuarter").toString());
            nextQuarter = Integer.parseInt(row2.get("periodQuarter").toString());
            if (nextQuarter - quarter == 0 || nextQuarter - quarter == 1) continue;
            return false;
        }
        return true;
    }

    private boolean checkYearContinous(String typeId, int periodYear, JSONArray periodGridData) throws ParseException, JSONException {
        JSONObject row = periodGridData.getJSONObject(0);
        JSONObject row2 = periodGridData.getJSONObject(periodGridData.length() - 1);
        Date beginDate = null;
        Date endDate = null;
        beginDate = this.format.parse(row.getString("beginDate"));
        endDate = this.format.parse(row2.getString("endDate"));
        PeriodCollection c = null;
        try {
            c = this.getPeriodCollection(typeId, periodYear - 1);
        }
        catch (BOSException ex1) {
            ex1.printStackTrace();
        }
        if (c != null && c.size() == 0) {
            return true;
        }
        Timestamp lastYearEndDate = c.get(c.size() - 1).getEndDate();
        if (DateTimeUtils.dateDiff((String)"d", (Date)lastYearEndDate, (Date)DateTimeUtils.addDay((Date)beginDate, (long)-1L)) != 0L) {
            String resFullName = "com.kingdee.eas.basedata.assistant.client.PeriodResource.YearBeginNotPerYearEnd";
            return false;
        }
        try {
            c = this.getPeriodCollection(typeId, periodYear + 1);
        }
        catch (BOSException ex1) {
            ex1.printStackTrace();
        }
        if (c.size() == 0) {
            return true;
        }
        Date nextYearBeginDate = c.get(0).getBeginDate();
        if (DateTimeUtils.dateDiff((String)"d", (Date)endDate, (Date)DateTimeUtils.addDay((Date)nextYearBeginDate, (long)-1L)) != 0L) {
            String resFullName = "com.kingdee.eas.basedata.assistant.client.PeriodResource.YearEndNotNextYearBegin";
            return false;
        }
        return true;
    }

    private boolean checkPeriodReference(JSONArray removePeriod) throws JSONException {
        for (int i = 0; i < removePeriod.length(); ++i) {
            if (this.getPeriodRelations(removePeriod.getString(i)).size() <= 0) continue;
            String resFullName = "com.kingdee.eas.basedata.assistant.client.PeriodResource.periodReference";
            return false;
        }
        return true;
    }

    private PeriodCollection getPeriodCollection(String typeId, int PeriodYear) throws BOSException {
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)this.context);
        FilterInfo i = new FilterInfo();
        if (typeId != null) {
            i.getFilterItems().add(new FilterItemInfo("periodType", (Object)typeId, CompareType.EQUALS));
        }
        if (PeriodYear != -1) {
            i.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(PeriodYear), CompareType.EQUALS));
        } else if (PeriodYear == 0) {
            i.getFilterItems().add(new FilterItemInfo("periodYear", (Object)"", CompareType.EQUALS));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(i);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("periodYear"));
        evi.getSelector().add(new SelectorItemInfo("periodQuarter"));
        evi.getSelector().add(new SelectorItemInfo("periodNumber"));
        evi.getSelector().add(new SelectorItemInfo("beginDate"));
        evi.getSelector().add(new SelectorItemInfo("endDate"));
        evi.getSelector().add(new SelectorItemInfo("isAdjustPeriod"));
        evi.getSelector().add(new SelectorItemInfo("CU.id"));
        evi.getSelector().add(new SelectorItemInfo("CU.number"));
        evi.getSelector().add(new SelectorItemInfo("CU.name"));
        evi.getSorter().add(new SorterItemInfo("periodNumber"));
        return iPeriod.getPeriodCollection(evi);
    }

    private PeriodRelationCollection getPeriodRelations(String id) {
        FilterInfo i = new FilterInfo();
        i.getFilterItems().add(new FilterItemInfo("sourcePeriodId", (Object)id, CompareType.EQUALS));
        i.getFilterItems().add(new FilterItemInfo("targetPeriodId", (Object)id, CompareType.EQUALS));
        i.setMaskString("#0 or #1");
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(i);
        PeriodRelationCollection c = null;
        try {
            IPeriodRelation iPeriodRelation = PeriodRelationFactory.getLocalInstance((Context)this.context);
            c = iPeriodRelation.getPeriodRelationCollection();
        }
        catch (BOSException ex) {
            String resFullName = "com.kingdee.eas.basedata.assistant.client.PeriodResource.ConnectionLost";
        }
        return c;
    }

    private void updateAllPeriod(String periodType, String periodYear, JSONArray periodGridData, JSONArray removePeriod) throws BOSException, UuidException, JSONException, EASBizException {
        IO_Period iO_Period = O_PeriodFactory.getLocalInstance((Context)this.context);
        IObjectPK[] list = new IObjectPK[removePeriod.length()];
        for (int i = 0; i < removePeriod.length(); ++i) {
            list[i] = new ObjectUuidPK(BOSUuid.read((String)removePeriod.get(i).toString()));
        }
        PeriodCollection pecol = this.getUpdatedPeriodCollection(periodType, periodGridData);
        if (list != null && list.length > 0 || pecol != null && pecol.size() > 0) {
            iO_Period.updatePeriodCollection(pecol, list, periodType, periodYear);
        }
    }

    private void removeAllPeriod(JSONArray removePeriod) throws BOSException, UuidException, JSONException, EASBizException {
        IO_Period iO_Period = O_PeriodFactory.getLocalInstance((Context)this.context);
        IObjectPK[] list = new IObjectPK[removePeriod.length()];
        for (int i = 0; i < removePeriod.length(); ++i) {
            list[i] = new ObjectUuidPK(BOSUuid.read((String)removePeriod.getString(i)));
        }
        iO_Period.removePeriodCollection(list);
    }

    private PeriodCollection getUpdatedPeriodCollection(String periodType, JSONArray periodGridData) throws JSONException {
        PeriodCollection pCollection = new PeriodCollection();
        PeriodTypeInfo typeInfo = new PeriodTypeInfo();
        typeInfo.setId(BOSUuid.read((String)periodType));
        PeriodInfo info = null;
        JSONObject row = null;
        for (int i = 0; i < periodGridData.length(); ++i) {
            row = periodGridData.getJSONObject(i);
            info = new PeriodInfo();
            if (row.getString("id") != null) {
                info.setId(BOSUuid.read((String)row.getString("id")));
            }
            info.setPeriodYear(row.getInt("periodYear"));
            int periodNumber = row.getInt("periodNumber");
            info.setPeriodNumber(periodNumber);
            try {
                info.setBeginDate(this.format.parse(row.getString("beginDate")));
                info.setEndDate(new Timestamp(this.format.parse(row.getString("endDate")).getTime()));
            }
            catch (Exception ex) {
                // empty catch block
            }
            info.setPeriodQuarter(row.getInt("periodQuarter"));
            info.setIsAdjustPeriod(row.getInt("isAdjustPeriod") == 1);
            info.setPeriodType(typeInfo);
            pCollection.add(info);
        }
        return pCollection;
    }
}

