/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.ssc.app.erp.WebServiceSetDao;
import com.kingdee.eas.base.ssc.app.erp.eas.CommonUtil;
import com.kingdee.eas.base.ssc.erp.eas.EASLoginBean;
import com.kingdee.eas.base.ssc.erp.eas.EASWebServiceBean;
import com.kingdee.eas.base.ssc.service.EASWebServiceSetService;
import com.kingdee.eas.common.EASBizException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class EASWebServiceSetServiceImpl
implements EASWebServiceSetService {
    Logger logger = Logger.getLogger(EASWebServiceSetService.class);
    private Context ctx;

    public EASWebServiceSetServiceImpl(Context ctx) {
        this.ctx = ctx;
    }

    public EASLoginBean getEASLoginBean() throws BOSException, EASBizException {
        Properties prop = WebServiceSetDao.getProperties((String)CommonUtil.getAbsoluteEASLOGIN_PATH());
        EASLoginBean easLoginBean = new EASLoginBean();
        easLoginBean.setUserName(prop.getProperty("userName"));
        easLoginBean.setPassword(prop.getProperty("password"));
        easLoginBean.setSlnName(prop.getProperty("slnName"));
        easLoginBean.setLanguage(prop.getProperty("language"));
        easLoginBean.setDcName(prop.getProperty("dcName"));
        easLoginBean.setDbType(prop.getProperty("dbType"));
        return easLoginBean;
    }

    public void saveEASLoginBean(EASLoginBean easLoginBean) throws BOSException, EASBizException {
        if (easLoginBean == null) {
            return;
        }
        Properties prop = new Properties();
        prop.setProperty("userName", easLoginBean.getUserName());
        prop.setProperty("password", easLoginBean.getPassword());
        prop.setProperty("slnName", easLoginBean.getSlnName());
        prop.setProperty("language", easLoginBean.getLanguage());
        prop.setProperty("dcName", easLoginBean.getDcName());
        prop.setProperty("dbType", easLoginBean.getDbType());
        WebServiceSetDao.save((Properties)prop, (String)CommonUtil.getAbsoluteEASLOGIN_PATH());
    }

    public void saveEASWebServiceBean(EASWebServiceBean easWebServiceBean) throws BOSException, EASBizException {
        if (easWebServiceBean == null) {
            return;
        }
        Properties prop = new Properties();
        prop.setProperty("eas.messagecenter.wsdl", easWebServiceBean.getMessage());
        prop.setProperty("eas.login.wsdl", easWebServiceBean.getLogin());
        prop.setProperty("eas.workflow.notify.wsdl", easWebServiceBean.getWorkflow());
        prop.setProperty("eas.orgfacade.wsdl", easWebServiceBean.getOrg());
        prop.setProperty("eas.userfacade.wsdl", easWebServiceBean.getPerson());
        prop.setProperty("eas.bill.url", easWebServiceBean.getBillUrl());
        prop.setProperty("eas.workflow.url", easWebServiceBean.getWorlflowUrl());
        prop.setProperty("eas.picture.url", easWebServiceBean.getPictureUrl());
        prop.setProperty("image.picture.url", easWebServiceBean.getPhoto());
        prop.setProperty("eas.login.ltpa.url", easWebServiceBean.getLoginLtpa());
        prop.setProperty("eas.histore.agreement.url", easWebServiceBean.getHistory());
        WebServiceSetDao.save((Properties)prop, (String)CommonUtil.getAbsoluteREMOTE_PATH());
    }

    public EASWebServiceBean getEASWebServiceBean() throws BOSException, EASBizException {
        Properties prop = WebServiceSetDao.getProperties((String)CommonUtil.getAbsoluteREMOTE_PATH());
        EASWebServiceBean easWebServiceBean = new EASWebServiceBean();
        easWebServiceBean.setBillUrl(prop.getProperty("eas.bill.url"));
        easWebServiceBean.setHistory(prop.getProperty("eas.histore.agreement.url"));
        easWebServiceBean.setLogin(prop.getProperty("eas.login.wsdl"));
        easWebServiceBean.setLoginLtpa(prop.getProperty("eas.login.ltpa.url"));
        easWebServiceBean.setMessage(prop.getProperty("eas.messagecenter.wsdl"));
        easWebServiceBean.setOrg(prop.getProperty("eas.orgfacade.wsdl"));
        easWebServiceBean.setPerson(prop.getProperty("eas.userfacade.wsdl"));
        easWebServiceBean.setPhoto(prop.getProperty("image.picture.url"));
        easWebServiceBean.setPictureUrl(prop.getProperty("eas.picture.url"));
        easWebServiceBean.setWorkflow(prop.getProperty("eas.workflow.notify.wsdl"));
        easWebServiceBean.setWorlflowUrl(prop.getProperty("eas.workflow.url"));
        return easWebServiceBean;
    }

    public boolean testConnection(EASLoginBean easLoginBean, String loginWsdl) throws BOSException, EASBizException {
        if (easLoginBean == null) {
            this.logger.error((Object)"-----easLoginBean is null------");
            return false;
        }
        return CommonUtil.loginEAS((EASLoginBean)easLoginBean, (String)loginWsdl);
    }
}

