/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.ssc.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Param;
import com.kingdee.eas.base.ssc.BussinessAttributeInfo;
import com.kingdee.eas.base.ssc.SingleLoginFacadeFactory;
import com.kingdee.eas.base.ssc.UserFactory;
import com.kingdee.eas.base.ssc.service.UserSingleLoginService;
import com.kingdee.eas.common.EASBizException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class UserSingleLoginServiceImpl
implements UserSingleLoginService {
    private Logger logger = Logger.getLogger(UserSingleLoginServiceImpl.class);
    private Context ctx;

    public UserSingleLoginServiceImpl(Context ctx) {
        this.ctx = ctx;
    }

    public String getUipk(String userId) throws BOSException, EASBizException {
        if (userId == null || "".equals(userId)) {
            return null;
        }
        return SingleLoginFacadeFactory.getLocalInstance((Context)this.ctx).getUipk(userId);
    }

    public String getSscUserId(String erpUserId) throws BOSException, EASBizException {
        if (erpUserId == null || "".equals(erpUserId)) {
            return null;
        }
        return SingleLoginFacadeFactory.getLocalInstance((Context)this.ctx).getSscUserId(erpUserId);
    }

    public List getUserBussAttr(String userId) throws BOSException, EASBizException {
        if (userId == null || "".equals(userId)) {
            return null;
        }
        List bussAttrList = SingleLoginFacadeFactory.getLocalInstance((Context)this.ctx).getUserBussAttr(userId);
        ArrayList result = new ArrayList();
        for (int i = 0; i < bussAttrList.size(); ++i) {
            BussinessAttributeInfo bussAttrInfo = (BussinessAttributeInfo)bussAttrList.get(i);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", bussAttrInfo.getId().toString());
            map.put("name", bussAttrInfo.getName());
            result.add(map);
        }
        return result;
    }

    public String getUserBussAttrStr(@Param(value="userId") String userId) throws BOSException, EASBizException {
        if (userId == null || "".equals(userId)) {
            return null;
        }
        List bussAttrList = SingleLoginFacadeFactory.getLocalInstance((Context)this.ctx).getUserBussAttr(userId);
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < bussAttrList.size(); ++i) {
            BussinessAttributeInfo bussAttrInfo = (BussinessAttributeInfo)bussAttrList.get(i);
            result.append(this.getEncodeUrl(bussAttrInfo.getId().toString())).append(",");
            result.append(this.getEncodeUrl(this.getEncodeUrl(bussAttrInfo.getName()))).append(";");
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    public Boolean isBizAdmin(@Param(value="userId") String userId) throws BOSException, EASBizException {
        return UserFactory.getLocalInstance((Context)this.ctx).isBizAdmin(userId, null);
    }

    private String getEncodeUrl(String url) {
        String encodeUrl = url;
        try {
            encodeUrl = URLEncoder.encode(encodeUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return encodeUrl;
    }

    public Boolean isSystemAdmin(String userId) throws BOSException, EASBizException {
        return SingleLoginFacadeFactory.getLocalInstance((Context)this.ctx).isSystemAdmin(userId);
    }
}

