/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.EntityExecutorFactory;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.event.util.DBUtils;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.base.client.utils.BgEntityUtil;
import com.kingdee.eas.ma.base.utils.BgCodeNumberNHelper;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgTypeInfo;
import com.kingdee.eas.ma.mbg.BgViewDimensionFactory;
import com.kingdee.eas.ma.mbg.BgViewDimensionInfo;
import com.kingdee.eas.ma.mbg.DimensionCollection;
import com.kingdee.eas.ma.mbg.DimensionFactory;
import com.kingdee.eas.ma.mbg.DimensionInfo;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.DimensionSourceCollection;
import com.kingdee.eas.ma.mbg.DimensionSourceFactory;
import com.kingdee.eas.ma.mbg.DimensionSourceInfo;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.common.BgCalcuteColumn;
import com.kingdee.eas.ma.mbg.common.BgDescriptionColumn;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewManagerImpl;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.utils.DimensionFilterHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BgDimensionTemplateImpl {
    private final Context ctx;
    private IMbgViewManager mbgViewManager = null;
    private Map dimensionMap = new HashMap();
    private String subject = null;

    private IBgDimensionManager getDimensionManager() {
        return ((IMbgSheetManager)this.mbgViewManager.getSheetManagers().get(0)).getDimensionManager();
    }

    public BgDimensionTemplateImpl(Context ctx) {
        this.ctx = ctx;
        this.subject = this.getSubjectData();
    }

    public Object getParameter() {
        return null;
    }

    public Object deleteVerify(Map<String, Object> parameter) throws Exception {
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        String billId = (String)parameter.get("billId");
        String number = (String)parameter.get("number");
        if (StringUtils.isEmpty((String)billId) || StringUtils.isEmpty((String)number)) {
            return null;
        }
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put(billId, number);
        Map error = BgTemplateFactory.getLocalInstance((Context)this.ctx).verifyTemplate(dataMap);
        if (error.get("listRefByScheme") != null) {
            return "listRefByScheme";
        }
        if (error.get("listRefByForm") != null) {
            return "listRefByForm";
        }
        if (error.get("listHasChild") != null) {
            return "listHasChild";
        }
        return null;
    }

    public Object initData(Map<String, Object> parameter) throws Exception {
        MeasureUnitInfo unitInfo;
        MeasureUnitGroupInfo groupInfo;
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        String number = null;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        MeasureUnitInfo defaultUnit = null;
        String orgId = (String)parameter.get("orgId");
        FullOrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)this.ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        BgTemplateInfo info = new BgTemplateInfo();
        info.setOrgUnit(orgUnitInfo);
        boolean hasCodeNumber = BgCodeNumberNHelper.hasCodeNumber((Context)this.ctx, (IObjectValue)info, (String)orgId);
        if (hasCodeNumber) {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)this.ctx);
            number = iCodingRuleManager.getNumber((IObjectValue)info, orgId);
        } else {
            number = "EBM-" + orgUnitInfo.getNumber() + "-" + System.currentTimeMillis();
        }
        resultMap.put("number", number);
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("defaultUnit");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)"BUDGET", CompareType.EQUALS));
        CoreBaseCollection col = MeasureUnitGroupFactory.getLocalInstance((Context)this.ctx).getCollection(evi);
        if (col != null && col.size() > 0 && (groupInfo = (MeasureUnitGroupInfo)col.get(0)) != null && (unitInfo = (MeasureUnitInfo)groupInfo.get("defaultUnit")) != null) {
            defaultUnit = this.getMeasureUnit(unitInfo.getId().toString());
        }
        resultMap.put("measureUnit", (String)defaultUnit);
        return resultMap;
    }

    public Object getF7Data(Map<String, Object> parameter) throws Exception {
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        String orgId = (String)parameter.get("orgId");
        String f7Name = (String)parameter.get("f7Name");
        ArrayList resultList = new ArrayList();
        List allMemberList = this.getAllMembers(this.ctx, orgId, f7Name);
        Map cancelMemberCol = this.getCancelMembers(this.ctx, f7Name);
        if (allMemberList != null && allMemberList.size() > 0) {
            for (int i = 0; i < allMemberList.size(); ++i) {
                Map map = (Map)allMemberList.get(i);
                String id = map.get("id").toString();
                String number = (String)map.get("number");
                String name = (String)map.get("name");
                if (cancelMemberCol != null && cancelMemberCol.size() > 0 && cancelMemberCol.containsKey(number)) continue;
                HashMap<String, String> resultMap = new HashMap<String, String>();
                resultMap.put("id", id);
                resultMap.put("number", number);
                resultMap.put("name", name);
                resultList.add(resultMap);
            }
        }
        return resultList;
    }

    public Object loadTemplateData(Map<String, Object> parameter) throws Exception {
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        String billId = (String)parameter.get("billId");
        String orgUnitId = (String)parameter.get("orgId");
        BgViewDimensionInfo viewDimensionInfo = (BgViewDimensionInfo)BgViewDimensionFactory.getLocalInstance((Context)this.ctx).getDimensionByTemplate(billId);
        IMbgViewManager iMbgViewManager = new MbgXMLParser().parse(viewDimensionInfo.getData());
        this.mbgViewManager = TemplateFacadeFactory.getLocalInstance((Context)this.ctx).loadViewManager(orgUnitId, iMbgViewManager);
        BgTemplateInfo bgTemplateInfo = BgTemplateFactory.getLocalInstance((Context)this.ctx).getBgTemplateInfo((IObjectPK)new ObjectUuidPK(billId));
        Map<String, Object> tempLateMap = this.getTemplateData(bgTemplateInfo, orgUnitId);
        return tempLateMap;
    }

    public Map<String, Object> getTemplateData(BgTemplateInfo bgTemplateInfo, String orgUnitId) throws Exception {
        BgDimensionInfo info;
        int i;
        HashMap<String, Object> tempLateMap = new HashMap<String, Object>();
        String rowDimData = "";
        String colDimData = "";
        String pageDimdata = "";
        String allDimensionData = "";
        String calcData = "";
        String desData = "";
        String allColIndex = "";
        int periodListSize = 0;
        boolean projectIsEnable = (Boolean)this.projectIsEnable(null);
        MeasureUnitInfo defaultUnitInfo = bgTemplateInfo.getDefaultMeasureUnit();
        MeasureUnitInfo unitInfo = this.getMeasureUnit(defaultUnitInfo.getId().toString());
        tempLateMap.put("measureUnit", unitInfo.getId().toString() + "," + unitInfo.getNumber() + "," + unitInfo.getName(this.ctx.getLocale()));
        IBgDimensionManager bgDimensionManager = this.getDimensionManager();
        List colDimensions = bgDimensionManager.getColDimension();
        List rowDimensions = bgDimensionManager.getRowDimension();
        List pageDimensions = bgDimensionManager.getPageDimension();
        List allDimensions = bgDimensionManager.getDimension();
        List calcCol = bgDimensionManager.getCalcuteCol();
        List desCol = bgDimensionManager.getDescriptionCol();
        if (colDimensions != null && colDimensions.size() > 0) {
            for (i = 0; i < colDimensions.size(); ++i) {
                info = (BgDimensionInfo)colDimensions.get(i);
                if ("BG_Project".equals(info.getNumber()) && !projectIsEnable) continue;
                colDimData = colDimData + info.getNumber() + ",";
            }
            tempLateMap.put("colDimData", colDimData);
        }
        if (rowDimensions != null && rowDimensions.size() > 0) {
            for (i = 0; i < rowDimensions.size(); ++i) {
                info = (BgDimensionInfo)rowDimensions.get(i);
                if ("BG_Project".equals(info.getNumber()) && !projectIsEnable) continue;
                rowDimData = rowDimData + info.getNumber() + ",";
            }
            tempLateMap.put("rowDimData", rowDimData);
        }
        if (pageDimensions != null && pageDimensions.size() > 0) {
            for (i = 0; i < pageDimensions.size(); ++i) {
                info = (BgDimensionInfo)pageDimensions.get(i);
                if ("BG_Project".equals(info.getNumber()) && !projectIsEnable) continue;
                pageDimdata = pageDimdata + info.getNumber() + ",";
            }
            tempLateMap.put("pageDimdata", pageDimdata);
        }
        if (allDimensions != null && allDimensions.size() > 0) {
            for (i = 0; i < allDimensions.size(); ++i) {
                info = (BgDimensionInfo)allDimensions.get(i);
                if (2 == info.getMemberValueType().getValue() || 1 == info.getMemberValueType().getValue()) continue;
                allDimensionData = allDimensionData + info.getNumber() + ":";
                List memberList = info.getMember();
                if ("BG_Period".equals(info.getNumber())) {
                    periodListSize = memberList.size();
                }
                if (memberList != null && memberList.size() > 0) {
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    if ("BG_Index".equals(info.getNumber())) {
                        param.put("orgId", orgUnitId);
                        param.put("f7Name", "acctItem");
                    } else if ("BG_Project".equals(info.getNumber())) {
                        param.put("orgId", orgUnitId);
                        param.put("f7Name", "project");
                    }
                    Object obj = this.getF7Data(param);
                    List resultList = null;
                    HashMap resultMap = new HashMap();
                    if (obj != null) {
                        resultList = (List)obj;
                        for (int k = 0; k < resultList.size(); ++k) {
                            Map map = (Map)resultList.get(k);
                            resultMap.put(map.get("number"), map.get("id"));
                        }
                    }
                    for (int j = 0; j < memberList.size(); ++j) {
                        BgDimensionMember member = (BgDimensionMember)memberList.get(j);
                        allDimensionData = allDimensionData + member.getNumber() + "/" + member.getName();
                        if (resultMap.containsKey(member.getNumber())) {
                            allDimensionData = allDimensionData + "/" + resultMap.get(member.getNumber());
                        }
                        allDimensionData = allDimensionData + ",";
                    }
                }
                allDimensionData = allDimensionData + ";";
            }
            tempLateMap.put("allDimensionData", allDimensionData);
        }
        if (calcCol != null && calcCol.size() > 0) {
            for (i = 0; i < calcCol.size(); ++i) {
                BgCalcuteColumn calc = (BgCalcuteColumn)calcCol.get(i);
                calcData = calcData + calc.getAlias() + "/" + calc.getFormula() + ";";
            }
            tempLateMap.put("caclColData", calcData);
        }
        if (desCol != null && desCol.size() > 0) {
            for (i = 0; i < desCol.size(); ++i) {
                BgDescriptionColumn des = (BgDescriptionColumn)desCol.get(i);
                desData = desData + des.getAlias() + ";";
            }
            tempLateMap.put("tipColData", desData);
        }
        allColIndex = this.getAllColIndex(calcCol, desCol, colDimData, rowDimensions.size(), periodListSize);
        tempLateMap.put("colDimIndex", allColIndex);
        boolean orgUnitIsValid = this.isValidDim("BG_Organization", pageDimdata, rowDimData, colDimData);
        boolean projectIsValid = this.isValidDim("BG_Project", pageDimdata, rowDimData, colDimData);
        if (!projectIsValid && !projectIsEnable) {
            projectIsValid = true;
        }
        tempLateMap.put("project", projectIsValid);
        tempLateMap.put("orgUnit", orgUnitIsValid);
        return tempLateMap;
    }

    private String getAllColIndex(List calcCol, List desCol, String colDimData, int rowSize, int periodListSize) {
        String allColIndex = "";
        ArrayList allColList = new ArrayList();
        ArrayList<Integer> colIndexList = new ArrayList<Integer>();
        HashMap<Integer, String> allColMap = new HashMap<Integer, String>();
        if (calcCol != null && calcCol.size() > 0) {
            allColList.addAll(calcCol);
        }
        if (desCol != null && desCol.size() > 0) {
            allColList.addAll(desCol);
        }
        int index = 0;
        for (int i = 0; i < allColList.size(); ++i) {
            Object obj = allColList.get(i);
            if (obj instanceof BgCalcuteColumn) {
                index = ((BgCalcuteColumn)obj).getIndex() - rowSize;
                colIndexList.add(index);
                allColMap.put(index, ((BgCalcuteColumn)obj).getAlias());
                continue;
            }
            if (!(obj instanceof BgDescriptionColumn)) continue;
            index = ((BgDescriptionColumn)obj).getIndex() - rowSize;
            colIndexList.add(index);
            allColMap.put(index, ((BgDescriptionColumn)obj).getAlias());
        }
        Collections.sort(colIndexList);
        if (colIndexList.size() == 0) {
            return null;
        }
        int firstIndex = (Integer)colIndexList.get(0);
        int lastIndex = (Integer)colIndexList.get(colIndexList.size() - 1);
        if (firstIndex == periodListSize) {
            allColIndex = allColIndex + colDimData;
            for (int i = 0; i < colIndexList.size(); ++i) {
                int ind = (Integer)colIndexList.get(i);
                allColIndex = allColIndex + allColMap.get(ind) + ",";
            }
        } else if (lastIndex == colIndexList.size() - 1) {
            for (int i = 0; i < colIndexList.size(); ++i) {
                int ind = (Integer)colIndexList.get(i);
                allColIndex = allColIndex + allColMap.get(ind) + ",";
            }
            allColIndex = allColIndex + colDimData;
        } else {
            int cursor = 0;
            for (int i = 0; i < colIndexList.size(); ++i) {
                int ind = (Integer)colIndexList.get(i);
                if (ind - cursor - 1 == periodListSize) {
                    allColIndex = allColIndex + colDimData;
                }
                allColIndex = allColIndex + allColMap.get(ind) + ",";
                cursor = ind;
            }
        }
        return allColIndex;
    }

    public Object saveTemplate(Map<String, Object> parameter) throws Exception {
        if (parameter == null || parameter.isEmpty()) {
            return null;
        }
        String number = (String)parameter.get("number");
        String name = (String)parameter.get("name");
        String measureUnit = (String)parameter.get("measureUnit");
        String pageDimdata = (String)parameter.get("pageDimdata");
        String rowDimData = (String)parameter.get("rowDimData");
        String colDimData = (String)parameter.get("colDimData");
        String caclColData = (String)parameter.get("caclColData");
        String tipColData = (String)parameter.get("tipColData");
        String allDimensionData = (String)parameter.get("allDimensionData");
        String colDimIndex = (String)parameter.get("colDimIndex");
        String orgId = (String)parameter.get("orgId");
        String billId = (String)parameter.get("billId");
        this.mbgViewManager = MbgViewManagerImpl.getDefaultViiewManagerImpl();
        this.mbgViewManager.setDefaultMeasureUnit(this.getMeasureUnit(measureUnit));
        DimensionCollection col = this.getAllDimension();
        this.loadDimensions(col);
        boolean orgUnitIsValid = this.isValidDim("BG_Organization", pageDimdata, rowDimData, colDimData);
        boolean projectIsValid = this.isValidDim("BG_Project", pageDimdata, rowDimData, colDimData);
        if (!orgUnitIsValid) {
            this.storeDimensionToManager(this.getDimensions("BG_Organization"), "view");
        }
        this.storeDimensionToManager(this.getDimensions(rowDimData), "row");
        this.storeDimensionToManager(this.getDimensions(colDimData), "col");
        this.storeDimensionToManager(this.getDimensions(pageDimdata), "page");
        this.dimensionMemberSet(allDimensionData, projectIsValid, orgId);
        this.storeCalcuteData(caclColData);
        this.storeDescriptionData(tipColData);
        this.storeColIndex(colDimIndex);
        BgTemplateInfo bgTemplateInfo = null;
        bgTemplateInfo = StringUtils.isEmpty((String)billId) ? this.creatNewTemplate(number, name, measureUnit, orgId) : this.creatUpdateTemplate(number, name, measureUnit, billId, orgId);
        if (!BgTemFormTypeEnum.VIEWFORM.equals((Object)bgTemplateInfo.getFormType())) {
            return null;
        }
        bgTemplateInfo.setData(null);
        BgViewDimensionInfo bgViewDimensionInfo = new BgViewDimensionInfo();
        bgViewDimensionInfo.setData(MbgXMLParser.unParse((IMbgViewManager)this.mbgViewManager));
        BgViewDimensionFactory.getLocalInstance((Context)this.ctx).addNewView((IObjectValue)bgViewDimensionInfo, (IObjectValue)bgTemplateInfo);
        return null;
    }

    private BgTemplateInfo creatUpdateTemplate(String number, String name, String measureUnit, String billId, String orgId) throws Exception {
        BgTemplateInfo bgTemplateInfo = BgTemplateFactory.getLocalInstance((Context)this.ctx).getBgTemplateInfo((IObjectPK)new ObjectUuidPK(billId));
        if (bgTemplateInfo == null) {
            bgTemplateInfo = this.creatNewTemplate(number, name, measureUnit, orgId);
        }
        bgTemplateInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        bgTemplateInfo.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        bgTemplateInfo.setNumber(number);
        bgTemplateInfo.setName(name);
        bgTemplateInfo.setDefaultMeasureUnit(this.getMeasureUnit(measureUnit));
        return bgTemplateInfo;
    }

    private BgTemplateInfo creatNewTemplate(String number, String name, String measureUnit, String orgId) throws Exception {
        FullOrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)this.ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        BgTemplateInfo info = new BgTemplateInfo();
        info.setFormType(BgTemFormTypeEnum.VIEWFORM);
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setOrgUnit(orgUnitInfo);
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCU(orgUnitInfo.getCU());
        info.setNumber(number);
        info.setName(name);
        BgTypeInfo type = new BgTypeInfo();
        type.setId(BOSUuid.read((String)"GjMAAAAAUgj/bNjg"));
        type.setNumber("expensesbudget");
        type.setName("\ufffd\ufffd\ufffd\ufffd\u0524\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\ufffd\ufffd");
        info.setBgType(type);
        info.setDefaultMeasureUnit(this.getMeasureUnit(measureUnit));
        info.setParent(info);
        info.setRootId(info.getId());
        return info;
    }

    private MeasureUnitInfo getMeasureUnit(String measureUnitId) throws Exception {
        if (StringUtils.isEmpty((String)measureUnitId)) {
            return null;
        }
        MeasureUnitInfo unitInfo = null;
        IMeasureUnit measureUnit = MeasureUnitFactory.getLocalInstance((Context)this.ctx);
        unitInfo = measureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(measureUnitId), this.getSelector());
        return unitInfo;
    }

    private void storeDimensionToManager(List<BgDimensionInfo> bgDimensions, String layout) {
        BgDimensionInfo bgDimensionInfo = null;
        for (int i = 0; i < bgDimensions.size(); ++i) {
            bgDimensionInfo = bgDimensions.get(i);
            bgDimensionInfo.setLayout(layout);
            this.getDimensionManager().addDimensionInfo(bgDimensionInfo);
        }
    }

    private List<BgDimensionInfo> getDimensions(String dimData) {
        if (StringUtils.isEmpty((String)dimData)) {
            return null;
        }
        ArrayList<BgDimensionInfo> hList = new ArrayList<BgDimensionInfo>();
        String[] dimDataStr = dimData.split(",");
        for (int i = 0; i < dimDataStr.length; ++i) {
            String dataStr = dimDataStr[i];
            if (StringUtils.isEmpty((String)dataStr) || !this.dimensionMap.containsKey(dataStr)) continue;
            BgDimensionInfo bgDimensionInfo = (BgDimensionInfo)this.dimensionMap.get(dataStr);
            hList.add(bgDimensionInfo);
        }
        return hList;
    }

    protected DimensionCollection getAllDimension() {
        DimensionCollection col = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("isEnabled", (Object)Boolean.TRUE, CompareType.EQUALS));
            col = DimensionFactory.getLocalInstance((Context)this.ctx).getDimensionCollection(view);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return col;
    }

    private void loadDimensions(DimensionCollection col) {
        DimensionInfo dimensionInfo = null;
        for (int i = 0; i < col.size(); ++i) {
            dimensionInfo = col.get(i);
            BgDimensionInfo bgDimensionInfo = new BgDimensionInfo(this.getDimensionManager());
            bgDimensionInfo.setAlias(dimensionInfo.getName());
            bgDimensionInfo.setName(dimensionInfo.getName());
            bgDimensionInfo.setNumber(dimensionInfo.getNumber());
            bgDimensionInfo.setNecessary(dimensionInfo.isNecessary());
            bgDimensionInfo.setAttribute(dimensionInfo.getRefField());
            this.dimensionMap.put(bgDimensionInfo.getNumber(), bgDimensionInfo);
        }
    }

    private boolean isValidDim(String dimNumber, String pageDimdata, String rowDimData, String colDimData) {
        return !StringUtils.isEmpty((String)pageDimdata) && pageDimdata.indexOf(dimNumber) > -1 || rowDimData.indexOf(dimNumber) > -1 || colDimData.indexOf(dimNumber) > -1;
    }

    private void dimensionMemberSet(String allDimensionData, boolean projectIsValid, String orgId) throws Exception {
        if (StringUtils.isEmpty((String)allDimensionData)) {
            return;
        }
        BgDimensionInfo dimensionInfo = null;
        String[] dimensionData = allDimensionData.split(";");
        for (int i = 0; i < dimensionData.length; ++i) {
            String dimensionNum;
            String data = dimensionData[i];
            if (StringUtils.isEmpty((String)data) || !this.dimensionMap.containsKey(dimensionNum = data.split(":")[0])) continue;
            dimensionInfo = (BgDimensionInfo)this.dimensionMap.get(dimensionNum);
            dimensionInfo.getMember().clear();
            List<BgDimensionMember> dimensionMembers = this.getBgDimensionMembers(dimensionInfo, data.split(":")[1]);
            if (dimensionMembers != null && dimensionMembers.size() > 0) {
                dimensionInfo.getMember().addAll(dimensionMembers);
            }
            dimensionInfo.setMemberValueType(DimensionMemberValueModeEnum.getEnum((int)3));
            dimensionInfo.setShowType("NAME");
        }
        if (allDimensionData.indexOf("BG_Project") == -1 && projectIsValid && (dimensionInfo = (BgDimensionInfo)this.dimensionMap.get("BG_Project")) != null) {
            dimensionInfo.setMemberValueType(DimensionMemberValueModeEnum.getEnum((int)2));
            dimensionInfo.setShowType("NAME");
        }
        if (allDimensionData.indexOf("BG_Index") == -1) {
            dimensionInfo = (BgDimensionInfo)this.dimensionMap.get("BG_Index");
            dimensionInfo.getMember().clear();
            List<BgDimensionMember> dimensionMembers = this.getBgIndexMembers(dimensionInfo, orgId);
            if (dimensionMembers != null && dimensionMembers.size() > 0) {
                dimensionInfo.getMember().addAll(dimensionMembers);
            }
            dimensionInfo.setMemberValueType(DimensionMemberValueModeEnum.getEnum((int)3));
            dimensionInfo.setShowType("NAME");
        }
    }

    private List<BgDimensionMember> getBgIndexMembers(BgDimensionInfo dimensionInfo, String orgId) throws Exception {
        ArrayList<BgDimensionMember> memberList = new ArrayList<BgDimensionMember>();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgId", orgId);
        param.put("f7Name", "acctItem");
        Object obj = this.getF7Data(param);
        List resultList = null;
        if (obj != null) {
            resultList = (List)obj;
        }
        String srcNumber = "";
        String number = null;
        String name = null;
        if ("SUBJECT".equals(this.subject)) {
            srcNumber = "Acc";
        } else if ("COSTYPE".equals(this.subject)) {
            srcNumber = "Exp";
        }
        if (resultList != null && !resultList.isEmpty()) {
            for (int i = 0; i < resultList.size(); ++i) {
                Map memberMap = (Map)resultList.get(i);
                if (memberMap == null || memberMap.isEmpty()) continue;
                name = (String)memberMap.get("name");
                number = (String)memberMap.get("number");
                BgDimensionMember member = new BgDimensionMember(dimensionInfo.getNumber(), dimensionInfo.getAttribute(), name, number);
                member.setSrcNumber(srcNumber);
                memberList.add(member);
            }
        }
        return memberList;
    }

    private List<BgDimensionMember> getBgDimensionMembers(BgDimensionInfo dimensionInfo, String memberData) throws Exception {
        if (StringUtils.isEmpty((String)memberData) || dimensionInfo == null) {
            return null;
        }
        ArrayList<BgDimensionMember> memberList = new ArrayList<BgDimensionMember>();
        String srcNumber = null;
        DimensionSourceCollection srcCol = DimensionFilterHelper.queryDimensionSource((Context)this.ctx, (Object)dimensionInfo, (boolean)false, (boolean)true);
        if (dimensionInfo.getNumber().equals("BG_Index")) {
            if ("SUBJECT".equals(this.subject)) {
                srcNumber = "Acc";
            } else if ("COSTYPE".equals(this.subject)) {
                srcNumber = "Exp";
            }
        } else {
            DimensionSourceInfo source = srcCol.get(0);
            srcNumber = source.getSrcNumber();
        }
        BgDimensionMember member = null;
        String[] memberDatas = memberData.split(",");
        String number = null;
        String name = null;
        for (int i = 0; i < memberDatas.length; ++i) {
            String data = memberDatas[i];
            if (StringUtils.isEmpty((String)data)) continue;
            number = data.split("/")[0];
            name = data.split("/")[1];
            if ("BG_Period".equals(dimensionInfo.getNumber()) && (number = number.toUpperCase().replaceFirst("Y", "!Y.")).endsWith(".")) {
                number = number.substring(0, number.length() - 1);
            }
            member = new BgDimensionMember(dimensionInfo.getNumber(), dimensionInfo.getAttribute(), name, number);
            member.setSrcNumber(srcNumber);
            memberList.add(member);
        }
        return memberList;
    }

    private void storeCalcuteData(String caclColData) {
        if (StringUtils.isEmpty((String)caclColData)) {
            return;
        }
        List calCol = this.getDimensionManager().getCalcuteCol();
        HashMap calMap = new HashMap();
        for (int i = 0; i < calCol.size(); ++i) {
            calMap.put("CALCULATE|" + ((BgCalcuteColumn)calCol.get(i)).getAlias(), calCol.get(i));
        }
        this.getDimensionManager().getCalcuteCol().clear();
        List<BgCalcuteColumn> newCalCol = this.getCalculateValues(caclColData);
        BgCalcuteColumn cur = null;
        String key = null;
        for (int i = 0; i < newCalCol.size(); ++i) {
            cur = newCalCol.get(i);
            key = "CALCULATE|" + cur.getAlias();
            if (calMap.containsKey(key)) {
                cur.setIndex(((BgCalcuteColumn)calMap.get(key)).getIndex());
            }
            this.getDimensionManager().getCalcuteCol().add(cur);
        }
    }

    private List<BgCalcuteColumn> getCalculateValues(String caclColData) {
        ArrayList<BgCalcuteColumn> caclColList = new ArrayList<BgCalcuteColumn>();
        if (StringUtils.isEmpty((String)caclColData)) {
            return caclColList;
        }
        String[] caclColDatas = caclColData.split(";");
        if (caclColDatas != null && caclColDatas.length > 0) {
            String colNameTx = null;
            String colCalculateTxt = null;
            for (int i = 0; i < caclColDatas.length; ++i) {
                String data = caclColDatas[i];
                colNameTx = data.split("/")[0];
                colCalculateTxt = data.split("/")[1];
                BgCalcuteColumn calcuteColumn = new BgCalcuteColumn();
                calcuteColumn.setAlias(colNameTx);
                calcuteColumn.setFormula(colCalculateTxt);
                caclColList.add(calcuteColumn);
            }
        }
        return caclColList;
    }

    private void storeDescriptionData(String tipColData) {
        if (StringUtils.isEmpty((String)tipColData)) {
            return;
        }
        List desCol = this.getDimensionManager().getDescriptionCol();
        HashMap desMap = new HashMap();
        for (int i = 0; i < desCol.size(); ++i) {
            desMap.put("DES|" + ((BgDescriptionColumn)desCol.get(i)).getAlias(), desCol.get(i));
        }
        this.getDimensionManager().getDescriptionCol().clear();
        List<BgDescriptionColumn> newDesCol = this.getTipColDatas(tipColData);
        BgDescriptionColumn cur = null;
        String key = null;
        for (int i = 0; i < newDesCol.size(); ++i) {
            cur = newDesCol.get(i);
            key = "DES|" + cur.getAlias();
            if (desMap.containsKey(key)) {
                cur.setIndex(((BgDescriptionColumn)desMap.get(key)).getIndex());
            }
            this.getDimensionManager().getDescriptionCol().add(cur);
        }
    }

    private List<BgDescriptionColumn> getTipColDatas(String tipColData) {
        ArrayList<BgDescriptionColumn> tipColList = new ArrayList<BgDescriptionColumn>();
        if (StringUtils.isEmpty((String)tipColData)) {
            return tipColList;
        }
        List bindDimension = BgDescriptionColumn.getDescriptionBindDimension((IBgDimensionManager)this.getDimensionManager());
        String[] tipColDatas = tipColData.split(";");
        if (tipColDatas != null && tipColDatas.length > 0) {
            for (int i = 0; i < tipColDatas.length; ++i) {
                BgDescriptionColumn desColumn = new BgDescriptionColumn();
                desColumn.setAlias(tipColDatas[i]);
                desColumn.getDimensions().addAll(bindDimension);
                tipColList.add(desColumn);
            }
        }
        return tipColList;
    }

    private void storeColIndex(String colDimIndex) {
        if (StringUtils.isEmpty((String)colDimIndex)) {
            return;
        }
        List calCol = this.getDimensionManager().getCalcuteCol();
        HashMap calMap = new HashMap();
        for (int i = 0; i < calCol.size(); ++i) {
            calMap.put("CALCULATE_" + ((BgCalcuteColumn)calCol.get(i)).getAlias(), calCol.get(i));
        }
        List desCol = this.getDimensionManager().getDescriptionCol();
        HashMap desMap = new HashMap();
        for (int i = 0; i < desCol.size(); ++i) {
            desMap.put("DES_" + ((BgDescriptionColumn)desCol.get(i)).getAlias(), desCol.get(i));
        }
        List list = this.getDimensionManager().getDimension();
        List periodList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            BgDimensionInfo dimensionInfo = (BgDimensionInfo)list.get(i);
            if (!dimensionInfo.getNumber().equals("BG_Period")) continue;
            periodList = dimensionInfo.getMember();
        }
        int rowDimSize = this.getDimensionManager().getRowDimension().size();
        String[] colDimIndexs = colDimIndex.split(",");
        int index = rowDimSize;
        for (int i = 0; i < colDimIndexs.length; ++i) {
            String colDim = colDimIndexs[i];
            if (StringUtils.isEmpty((String)colDim)) continue;
            if (colDim.startsWith("CALCULATE")) {
                ((BgCalcuteColumn)calMap.get(colDim)).setIndex(index);
                ++index;
                continue;
            }
            if (colDim.startsWith("DES")) {
                ((BgDescriptionColumn)desMap.get(colDim)).setIndex(index);
                ++index;
                continue;
            }
            if (!colDim.endsWith("period")) continue;
            index += periodList.size();
        }
    }

    public CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, String orgId) throws EASBizException, BOSException {
        CostCenterOrgUnitInfo cost = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        CompanyOrgUnitInfo company = null;
        if (cost.isIsCompanyOrgUnit()) {
            company = (CompanyOrgUnitInfo)NewOrgViewHelper.getOrgUnitInfo((Context)ctx, (String)orgId, (OrgType)OrgType.Company);
        } else {
            IOrgUnitRelation our = null;
            our = ctx == null ? OrgUnitRelationFactory.getRemoteInstance() : OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection col = our.getToUnit(orgId, 5, 1);
            if (col != null && !col.isEmpty()) {
                company = (CompanyOrgUnitInfo)col.get(0);
            }
        }
        return company;
    }

    public List getAllMembers(Context ctx, String orgId, String f7Name) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        ArrayList allMemberList = new ArrayList();
        DimensionSourceInfo source = this.getDimensionSourceInfo(f7Name);
        DimensionFilterHelper helper = DimensionFilterHelper.getLocaleIntance((Context)ctx, (DimensionSourceInfo)source, (String)orgId);
        EntityObjectInfo entity = null;
        IDataProvider mainExec = null;
        if (source.getSrcType().getValue() == 0) {
            entity = BgEntityUtil.getEntity((BOSObjectType)BOSObjectType.create((String)source.getSrcID()));
            mainExec = EntityExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)entity.getFullName()));
        }
        evi.setFilter(helper.getFilter());
        if ("acctItem".equals(f7Name) && "SUBJECT".equals(this.subject)) {
            String sql = "select fid from t_bd_accounttype where fproperty='4'";
            evi.getFilter().getFilterItems().add(new FilterItemInfo("accountTypeID.id", (Object)sql, CompareType.INNER));
            evi.getFilter().setMaskString("#0 and #1 and #2 and #3");
        }
        SorterItemInfo sort = new SorterItemInfo("number");
        sort.setSortType(SortType.ASCEND);
        evi.getSorter().add(sort);
        evi.setSelector(this.getSelector());
        mainExec.setObjectView(evi);
        mainExec.option().isAutoTranslateEnum = true;
        mainExec.openQuery();
        mainExec.option().pageCount = 1000;
        IRowSet rs = mainExec.executeQuery();
        SelectorItemCollection sic = evi.getSelector();
        while (rs.next()) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < sic.size(); ++i) {
                String sicName = sic.get(i).getPropertyName();
                map.put(sicName, rs.getString(sicName));
            }
            allMemberList.add(map);
        }
        return allMemberList;
    }

    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getCancelMembers(Context ctx, String f7Name) throws EASBizException, BOSException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String sql = "select e.fnumber number from t_mbg_dimexpression e,t_mbg_dimsrc s where e.fisfreezed = 1 and s.fid=e.fdimsrcid and s.fsrcid=?";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql);
            if ("acctItem".equalsIgnoreCase(f7Name)) {
                if ("SUBJECT".equals(this.subject)) {
                    stmt.setString(1, "9DA99826");
                } else if ("COSTYPE".equals(this.subject)) {
                    stmt.setString(1, "78E4BC94");
                }
            } else if ("project".equalsIgnoreCase(f7Name)) {
                stmt.setString(1, "DADE05EE");
            }
            rs = stmt.executeQuery();
            while (rs.next()) {
                resultMap.put(rs.getString("number"), "");
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DBUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
            DBUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
        }
        DBUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSubjectData() {
        String subject = "SUBJECT";
        String sql = "select fsrcid from t_mbg_dimsrc where fiswebselect=1";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String srcId = rs.getString("fsrcid");
                if (!"78E4BC94".equals(srcId)) continue;
                subject = "COSTYPE";
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DBUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
            DBUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
        }
        DBUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return subject;
    }

    public DimensionSourceInfo getDimensionSourceInfo(String f7Name) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        if ("acctItem".equals(f7Name)) {
            if ("SUBJECT".equals(this.subject)) {
                view.getFilter().getFilterItems().add(new FilterItemInfo("srcID", (Object)"9DA99826", CompareType.EQUALS));
            } else if ("COSTYPE".equals(this.subject)) {
                view.getFilter().getFilterItems().add(new FilterItemInfo("srcID", (Object)"78E4BC94", CompareType.EQUALS));
            }
        } else if ("project".equals(f7Name)) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("srcID", (Object)"DADE05EE", CompareType.EQUALS));
        }
        DimensionSourceCollection colls = DimensionSourceFactory.getLocalInstance((Context)this.ctx).getDimensionSourceCollection(view);
        if (colls == null || colls.isEmpty()) {
            return null;
        }
        DimensionSourceInfo source = colls.get(0);
        return source;
    }

    public Object projectIsEnable(Map<String, Object> parameter) throws Exception {
        boolean projectIsEnable = false;
        DimensionInfo info = DimensionFactory.getLocalInstance((Context)this.ctx).getDimensionInfo((IObjectPK)new ObjectUuidPK("GjMAAAAAUglJf4co"));
        if (info.isIsEnabled()) {
            projectIsEnable = true;
        }
        return projectIsEnable;
    }
}

