/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgSchemeNodeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeNodeInfo;
import com.kingdee.eas.ma.mbg.BgSchemeRefDimFactory;
import com.kingdee.eas.ma.mbg.BgSchemeRefDimInfo;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.IBgScheme;
import com.kingdee.eas.ma.mbg.IBgTemplate;
import com.kingdee.eas.ma.mbg.impl.BgDimensionImpl;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BgSchemeImpl {
    private final Context ctx;

    public BgSchemeImpl(Context ctx) {
        this.ctx = ctx;
    }

    public Object modleLoad(Object parameter) throws Exception {
        if (!(parameter instanceof Map)) {
            return null;
        }
        Map p = (Map)parameter;
        String schemeId = (String)p.get("id");
        BgSchemeInfo info = BgSchemeFactory.getLocalInstance((Context)this.ctx).getBgSchemeInfo((IObjectPK)new ObjectUuidPK(schemeId));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", info.getName());
        map.put("number", info.getNumber());
        map.put("id", info.getId());
        map.put("dateFrom", info.getDateFrom());
        map.put("dateTo", info.getDateTo());
        map.put("parentScheme", info.getParentScheme());
        map.put("orgUnit", info.getOrgUnit());
        return map;
    }

    public Object save(Object parameter) throws Exception {
        if (!(parameter instanceof Map)) {
            return null;
        }
        Map p = (Map)parameter;
        String billId = (String)p.get("id");
        String orgId = (String)p.get("orgId");
        String name = (String)p.get("name");
        String number = (String)p.get("number");
        String benginDate = (String)p.get("beginDate");
        String endDate = (String)p.get("endDate");
        if (StringUtils.isEmpty((String)orgId) || StringUtils.isEmpty((String)benginDate) || StringUtils.isEmpty((String)endDate)) {
            return null;
        }
        HashMap<String, Object> rs = new HashMap<String, Object>();
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance((Context)this.ctx);
        FullOrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)this.ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        Date bData = new Date(Long.valueOf(benginDate));
        Date eDate = new Date(Long.valueOf(endDate));
        if (bData.getTime() > eDate.getTime()) {
            rs.put("success", Boolean.FALSE);
            rs.put("error", "dataError");
            return rs;
        }
        BgSchemeInfo info = null;
        if (!StringUtils.isEmpty((String)billId)) {
            info = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(billId), this.getSchemeSelectors());
        } else {
            info = new BgSchemeInfo();
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            info.setOrgUnit(orgUnitInfo);
        }
        info.setDateFrom(bData);
        info.setDateTo(eDate);
        info.setNumber(number);
        info.setName(name);
        BgSchemeNodeCollection nodes = info.getBgSchemeNodes();
        if (nodes == null) {
            nodes = new BgSchemeNodeCollection();
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("bgType.id");
        sic.add("bgType.number");
        sic.add("bgType.name");
        sic.add("formType");
        sic.add("orgUnit.id");
        view.setSelector(sic);
        view.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("formType", (Object)4, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("bgType.number", (Object)"expensesbudget", CompareType.EQUALS));
        BgTemplateCollection temColls = BgTemplateFactory.getLocalInstance((Context)this.ctx).getBgTemplateCollection(view);
        if (temColls == null || temColls.isEmpty()) {
            rs.put("success", Boolean.FALSE);
            rs.put("error", "templateIsEmpty");
            return rs;
        }
        BgTemplateInfo tInfo = null;
        BgSchemeNodeInfo nodeInfo = null;
        nodes.clear();
        for (int index = 0; index < temColls.size(); ++index) {
            tInfo = temColls.get(index);
            nodeInfo = new BgSchemeNodeInfo();
            nodeInfo.setBgScheme(info);
            nodeInfo.setBgTemplate(tInfo);
            nodes.add(nodeInfo);
        }
        info.put("bgSchemeNodes", (Object)nodes);
        this.checkAutoRefDim(info);
        IObjectPK id = iBgScheme.save((CoreBaseInfo)info);
        rs.put("success", Boolean.TRUE);
        rs.put("id", id.toString());
        return rs;
    }

    private void checkAutoRefDim(BgSchemeInfo editData) throws Exception {
        List refDims;
        String bgSchemeId = editData.getId() != null ? editData.getId().toString() : null;
        ArrayList<String> bgTemplateIds = new ArrayList<String>();
        BgSchemeNodeCollection colls = editData.getBgSchemeNodes();
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            bgTemplateIds.add(colls.get(i).getBgTemplate().getId().toString());
        }
        if (!bgTemplateIds.isEmpty() && !(refDims = BgSchemeRefDimFactory.getLocalInstance((Context)this.ctx).checkRefDim(bgSchemeId, bgTemplateIds)).isEmpty()) {
            BgSchemeRefDimInfo refDimInfo2 = null;
            for (BgSchemeRefDimInfo refDimInfo2 : refDims) {
                refDimInfo2.setBgScheme(editData);
                editData.getRefDims().add(refDimInfo2);
            }
        }
    }

    public Object getParameter() throws Exception {
        return null;
    }

    public Object distr(Object parameter) throws Exception {
        int index;
        if (!(parameter instanceof Map)) {
            return null;
        }
        Map p = (Map)parameter;
        String schemeId = (String)p.get("id");
        String orgs = (String)p.get("orgs");
        if (StringUtils.isEmpty((String)schemeId) || StringUtils.isEmpty((String)orgs)) {
            return null;
        }
        String[] disOrgs = orgs.split("!");
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance((Context)this.ctx);
        BgSchemeInfo schemeInfo = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(schemeId), this.getSchemeSelectors());
        if (schemeInfo == null) {
            return null;
        }
        HashSet<String> addOrgs = new HashSet<String>();
        for (int index2 = 0; index2 < disOrgs.length; ++index2) {
            addOrgs.add(disOrgs[index2]);
        }
        FullOrgUnitCollection failOrgColls = this.dealSchemeDis(schemeInfo, addOrgs);
        HashMap<Object, Serializable> returnData = new HashMap<Object, Serializable>();
        HashMap<String, Object> tempMap = null;
        for (index = 0; index < failOrgColls.size(); ++index) {
            tempMap = new HashMap<String, Object>();
            tempMap.put("id", failOrgColls.get(index).getId());
            tempMap.put("name", failOrgColls.get(index).getName());
            returnData.put(index, tempMap);
        }
        returnData.put("length", Integer.valueOf(index));
        return returnData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FullOrgUnitCollection dealSchemeDis(BgSchemeInfo schemeInfo, Set<String> orgs) throws Exception {
        if (schemeInfo == null || orgs == null || orgs.isEmpty()) {
            return null;
        }
        BgSchemeInfo newSchemeInfo = null;
        IFullOrgUnit iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)this.ctx);
        FullOrgUnitInfo orgInfo = null;
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance((Context)this.ctx);
        FullOrgUnitCollection failOrgunit = new FullOrgUnitCollection();
        Connection conn = null;
        PreparedStatement pmst = null;
        ResultSet rs = null;
        BgSchemeNodeCollection nodes = schemeInfo.getBgSchemeNodes();
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            for (String orgId : orgs) {
                String id = null;
                orgInfo = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
                pmst = conn.prepareStatement("SELECT FID FROM T_MBG_BGSCHEME WHERE FROOTID=(SELECT FROOTID FROM T_MBG_BGSCHEME WHERE FID=?) AND FORGUNITID=?");
                pmst.setString(1, schemeInfo.getId().toString());
                pmst.setString(2, orgId);
                rs = pmst.executeQuery();
                if (rs.next()) {
                    id = rs.getString("FID");
                }
                if (StringUtils.isEmpty(id)) {
                    newSchemeInfo = schemeInfo.deepClone();
                    newSchemeInfo.setId(BOSUuid.create((BOSObjectType)newSchemeInfo.getBOSType()));
                } else {
                    newSchemeInfo = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(id), this.getSchemeSelectors());
                }
                newSchemeInfo.setOrgUnit(orgInfo);
                newSchemeInfo.setLastUpdateTime(new Timestamp(new Date().getTime()));
                newSchemeInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)this.ctx));
                newSchemeInfo.setParentScheme(schemeInfo);
                try {
                    this.dealSchemeNodeColls(newSchemeInfo, nodes, orgInfo);
                    iBgScheme.save((CoreBaseInfo)newSchemeInfo);
                }
                catch (Exception e) {
                    failOrgunit.add(orgInfo);
                }
            }
        }
        finally {
            SQLUtils.cleanup(rs, pmst, (Connection)conn);
        }
        return failOrgunit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealSchemeNodeColls(BgSchemeInfo info, BgSchemeNodeCollection nodes, FullOrgUnitInfo orgInfo) throws Exception {
        if (info == null || orgInfo == null || nodes == null || nodes.isEmpty()) {
            return;
        }
        BgSchemeNodeInfo nodeInfo = null;
        BgTemplateInfo tempInfo = null;
        BgTemplateInfo parentInfo = null;
        IBgTemplate iBgTemplate = BgTemplateFactory.getLocalInstance((Context)this.ctx);
        Connection conn = null;
        PreparedStatement pmst = null;
        ResultSet rs = null;
        boolean isExistTem = false;
        boolean isExistNode = false;
        CoreBaseCollection colls = new CoreBaseCollection();
        if (info.getBgSchemeNodes() == null) {
            info.put("bgSchemeNodes", (Object)new BgSchemeNodeCollection());
        }
        BgSchemeNodeCollection oldNodes = info.getBgSchemeNodes();
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            for (int index = 0; index < nodes.size(); ++index) {
                String templateId = null;
                isExistTem = false;
                isExistNode = false;
                nodeInfo = nodes.get(index);
                tempInfo = nodeInfo.getBgTemplate();
                if (tempInfo.getFormType().getValue() != 4) continue;
                for (int i = 0; i < oldNodes.size(); ++i) {
                    if (!oldNodes.get(i).getBgTemplate().getRootId().toString().equals(tempInfo.getRootId().toString())) continue;
                    nodeInfo = oldNodes.get(i);
                    isExistNode = true;
                }
                if (!isExistNode) {
                    nodeInfo.setId(BOSUuid.create((BOSObjectType)nodeInfo.getBOSType()));
                }
                nodeInfo.setBgScheme(info);
                parentInfo = iBgTemplate.getBgTemplateInfo((IObjectPK)new ObjectUuidPK(tempInfo.getId()), this.getTemplateSelectors());
                pmst = conn.prepareStatement("SELECT FID,FNUMBER,FNAME FROM T_MBG_BGTEMPLATE WHERE FROOTID = (SELECT FROOTID FROM T_MBG_BGTEMPLATE WHERE FID=?) AND FORGUNITID=?");
                pmst.setString(1, tempInfo.getId().toString());
                pmst.setString(2, orgInfo.getId().toString());
                rs = pmst.executeQuery();
                if (rs.next()) {
                    templateId = rs.getString("FID");
                    isExistTem = true;
                    tempInfo = new BgTemplateInfo();
                    tempInfo.setId(BOSUuid.read((String)templateId));
                    tempInfo.setName(rs.getString("FNAME"));
                    tempInfo.setNumber(rs.getString("FNUMBER"));
                    tempInfo.setData(parentInfo.getData());
                    tempInfo.setParent(parentInfo);
                }
                if (isExistTem) {
                    colls.add((CoreBaseInfo)tempInfo);
                } else {
                    tempInfo = parentInfo;
                    tempInfo.setParent(parentInfo);
                    tempInfo.setId(BOSUuid.create((BOSObjectType)tempInfo.getBOSType()));
                    tempInfo.setLastUpdateTime(new Timestamp(new Date().getTime()));
                    tempInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)this.ctx));
                    tempInfo.setOrgUnit(orgInfo);
                    colls.add((CoreBaseInfo)tempInfo);
                    nodeInfo.setBgTemplate(tempInfo);
                }
                oldNodes.add(nodeInfo);
            }
            if (!colls.isEmpty()) {
                iBgTemplate.saveBatchData(colls);
            }
        }
        finally {
            SQLUtils.cleanup(rs, pmst, (Connection)conn);
        }
    }

    private SelectorItemCollection getSchemeSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isFormal"));
        sic.add(new SelectorItemInfo("dateFrom"));
        sic.add(new SelectorItemInfo("dateTo"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("bgSchemeNodes"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.*"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgScheme.*"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgScheme.rootId"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.*"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.rootId"));
        sic.add(new SelectorItemInfo("bgSchemeNodes.bgTemplate.formType"));
        sic.add(new SelectorItemInfo("rootId"));
        sic.add(new SelectorItemInfo("isSubmitByScheme"));
        return sic;
    }

    private SelectorItemCollection getTemplateSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("createTime");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("lastUpdateTime");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("isAllowChange");
        sic.add("data");
        sic.add("canModify");
        sic.add("templateStatus");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("bgType.id");
        sic.add("bgType.name");
        sic.add("bgType.number");
        sic.add("bgMeasureUnit.id");
        sic.add("bgMeasureUnit.bgTemplate.id");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.bgElement.name");
        sic.add("bgMeasureUnit.bgElement.number");
        sic.add("bgMeasureUnit.measureUnit.id");
        sic.add("bgMeasureUnit.measureUnit.name");
        sic.add("bgMeasureUnit.measureUnit.number");
        sic.add("bgMeasureUnit.measureUnit.coefficient");
        sic.add("defaultMeasureUnit.id");
        sic.add("defaultMeasureUnit.name");
        sic.add("defaultMeasureUnit.number");
        sic.add("defaultMeasureUnit.coefficient");
        sic.add("parent.id");
        sic.add("rootId");
        sic.add("formType");
        return sic;
    }

    public Object initDistr(Object parameter) throws Exception {
        if (!(parameter instanceof Map)) {
            return null;
        }
        Map p = (Map)parameter;
        String schemeId = (String)p.get("id");
        if (StringUtils.isEmpty((String)schemeId)) {
            return null;
        }
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance((Context)this.ctx);
        BgSchemeInfo schemeInfo = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(schemeId), this.getSchemeSelectors());
        if (schemeInfo == null) {
            return null;
        }
        boolean isOk = this.isOk(schemeInfo);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (!isOk) {
            map.put("error", "noTemplate");
            return map;
        }
        map.put("success", "msg");
        BgDimensionImpl impl = new BgDimensionImpl(this.ctx);
        map.put("disOrgTreeDate", impl.init(null));
        return map;
    }

    private boolean isOk(BgSchemeInfo schemeInfo) throws Exception {
        BgSchemeNodeCollection nodes = schemeInfo.getBgSchemeNodes();
        if (nodes == null || nodes.isEmpty()) {
            return false;
        }
        HashSet<String> temIds = new HashSet<String>();
        for (int index = 0; index < nodes.size(); ++index) {
            BgSchemeNodeInfo nodeInfo = nodes.get(index);
            temIds.add(nodeInfo.getBgTemplate().getId().toString());
        }
        IBgTemplate iBgTemplate = BgTemplateFactory.getLocalInstance((Context)this.ctx);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("id", temIds, CompareType.INCLUDE));
        view.getFilter().getFilterItems().add(new FilterItemInfo("formType", (Object)4, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("bgType.number", (Object)"expensesbudget", CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("formType");
        sic.add("bgType.number");
        view.setSelector(sic);
        BgTemplateCollection tems = iBgTemplate.getBgTemplateCollection(view);
        return tems != null && !tems.isEmpty();
    }

    public Map delete(Object parameter) throws Exception {
        if (!(parameter instanceof Map)) {
            return null;
        }
        Map p = (Map)parameter;
        String id = (String)p.get("id");
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance((Context)this.ctx);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!iBgScheme.exists((IObjectPK)new ObjectUuidPK(id))) {
            result.put("success", false);
            result.put("message", "schemeIsNotExist");
            return result;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("isFormal");
        BgSchemeInfo bgSchemeInfo = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(id), sic);
        if (bgSchemeInfo.isIsFormal()) {
            result.put("success", false);
            result.put("message", "schemeExecuted");
            return result;
        }
        if (iBgScheme.isQuotedByBgForm(id)) {
            result.put("success", false);
            result.put("message", "schemeHadCreateForm");
            return result;
        }
        if (iBgScheme.hasChildScheme(id)) {
            result.put("success", false);
            result.put("message", "schemeHadDistribute");
            return result;
        }
        try {
            iBgScheme.delete((IObjectPK)new ObjectUuidPK(id));
            result.put("success", true);
        }
        catch (Exception e) {
            result.put("success", false);
            result.put("message", e.getMessage());
            return result;
        }
        return result;
    }
}

