/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.cdo.CommonDataObject;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.CreditControlSTDCollection;
import com.kingdee.eas.cp.bc.CreditControlSTDEntryCollection;
import com.kingdee.eas.cp.bc.CreditControlSTDEntryFactory;
import com.kingdee.eas.cp.bc.CreditControlSTDEntryInfo;
import com.kingdee.eas.cp.bc.CreditControlSTDFactory;
import com.kingdee.eas.cp.bc.CreditControlSTDInfo;
import com.kingdee.eas.cp.bc.StandardException;
import com.kingdee.eas.cp.bc.services.ICreditStandardService;
import com.kingdee.eas.cp.bc.services.util.CommonDataUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.cp.bc.services.ICreditStandardService"})
@Description(value="")
public class CreditStandardService
extends BusinessServices
implements ICreditStandardService {
    public CreditStandardService(Context context) {
        super(context);
    }

    @Override
    public boolean enable(List ids, boolean enable) throws BOSException, EASBizException {
        return false;
    }

    @Override
    public List getAssignPersons(String id) throws BOSException, EASBizException {
        ArrayList<CommonDataObject> result = new ArrayList<CommonDataObject>();
        if (id == null || id.length() < 0) {
            return result;
        }
        CreditControlSTDEntryCollection con = CreditControlSTDEntryFactory.getLocalInstance((Context)this.getContext()).getCreditControlSTDEntryCollection("select person.id,person.number,person.name where parent.id = '" + id + "'");
        Iterator it = con.iterator();
        while (it.hasNext()) {
            AdminOrgUnitInfo adminOrg;
            CommonDataObject person = new CommonDataObject();
            CreditControlSTDEntryInfo info = (CreditControlSTDEntryInfo)it.next();
            person.setBosType(new PersonInfo().getBOSType().toString());
            person.put((Object)"id", (Object)info.getPerson().getId());
            person.put((Object)"number", (Object)info.getPerson().getNumber());
            person.put((Object)"name", (Object)info.getPerson().getName());
            PositionInfo position = PersonFactory.getLocalInstance((Context)this.getContext()).getPrimaryPosition(info.getPerson().getId());
            if (position != null && position.getName() != null) {
                person.put((Object)"Position.name", (Object)position.getName());
            }
            if ((adminOrg = PersonFactory.getLocalInstance((Context)this.getContext()).getPrimaryAdminOrgUnit(info.getPerson().getId())) != null && adminOrg.getName() != null) {
                person.put((Object)"AdminOrgUnit.name", (Object)adminOrg.getName());
            }
            result.add(person);
        }
        return result;
    }

    @Override
    public Map<String, String> getFilterInfoData() throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        FilterInfo fi = new FilterInfo();
        List<String> personIds = CommonDataUtils.getEqAndChildPerson(this.getContext());
        HashSet<String> set = new HashSet<String>();
        set.addAll(personIds);
        fi.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", set, CompareType.INCLUDE));
        result.put("personFilter", fi.toString());
        return result;
    }

    @Override
    public boolean save(String model, List personIds) throws BOSException, EASBizException {
        if (model == null) {
            return false;
        }
        CreditControlSTDInfo info = (CreditControlSTDInfo)JSONUtils.convertJsonToObject((Context)this.getContext(), (String)model, CreditControlSTDInfo.class);
        if (info.getReimburseLV() == null || info.getCompany() == null) {
            return false;
        }
        this.checkInfo(info, personIds);
        CreditControlSTDFactory.getLocalInstance((Context)this.getContext()).save((CoreBaseInfo)info);
        CreditControlSTDEntryFactory.getLocalInstance((Context)this.getContext()).delete("where parent.id = '" + info.getId().toString() + "'");
        if (personIds != null && personIds.size() > 0) {
            CoreBaseCollection con = new CoreBaseCollection();
            Iterator it = personIds.iterator();
            while (it.hasNext()) {
                String personId = it.next().toString();
                PersonInfo person = new PersonInfo();
                person.setId(BOSUuid.read((String)personId));
                CreditControlSTDEntryInfo assignInfo = new CreditControlSTDEntryInfo();
                assignInfo.setPerson(person);
                assignInfo.setParent(info);
                con.add((CoreBaseInfo)assignInfo);
            }
            CreditControlSTDEntryFactory.getLocalInstance((Context)this.getContext()).saveBatchData(con);
        }
        return true;
    }

    private void checkInfo(CreditControlSTDInfo info, List personIds) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.getContext().get((Object)"CompanyInfo");
        String lvId = info.getReimburseLV().getId().toString();
        String infoId = info.getId().toString();
        CreditControlSTDCollection con = CreditControlSTDFactory.getLocalInstance((Context)this.getContext()).getCreditControlSTDCollection("select id where reimburseLV = '" + lvId + "' and company.id = '" + company.getId().toString() + "' and id <> '" + infoId + "'");
        if (con.size() > 0) {
            throw new StandardException(StandardException.CREDITSTANDARD_REPEAT);
        }
        if (personIds != null && personIds.size() > 0) {
            StringBuffer string = new StringBuffer();
            StringBuffer oql = new StringBuffer();
            Iterator it = personIds.iterator();
            while (it.hasNext()) {
                String id = it.next().toString();
                string.append("'").append(id).append("',");
            }
            string.deleteCharAt(string.length() - 1);
            oql.append("select id,person.number,person.name,parent.number where ").append("person.id in (").append(string.toString()).append(") and ").append("parent.reimburseLV.id = '").append(lvId).append("' and ").append("parent.id <> '").append(infoId).append("'");
            CreditControlSTDEntryCollection result = CreditControlSTDEntryFactory.getLocalInstance((Context)this.getContext()).getCreditControlSTDEntryCollection(oql.toString());
            if (result.size() > 0) {
                CreditControlSTDEntryInfo assignInfo = result.get(0);
                String personNumber = assignInfo.getPerson().getNumber();
                String personName = assignInfo.getPerson().getName();
                String person = personName + "(" + personNumber + ")";
                throw new StandardException(StandardException.CREDITSTANDARD_PERSON_REPEAT, new Object[]{person, assignInfo.getParent().getNumber()});
            }
        }
    }

    @Override
    public List<Map<String, Object>> queryAssignPerson(String creditControlSTDId) throws BOSException, EASBizException, SQLException {
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.cp.bc.app.CreditControlSTDAssignPersonQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.getContext(), (IMetaDataPK)queryPK);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)creditControlSTDId));
        filterInfo.getFilterItems().add(new FilterItemInfo("positionMember.isPrimary", (Object)1));
        filterInfo.setMaskString("#0 AND #1");
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        exec.setObjectView(entityViewInfo);
        IRowSet rowSet = exec.executeQuery();
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        while (rowSet.next()) {
            HashMap<String, String> personMap = new HashMap<String, String>();
            personMap.put("id", (String)rowSet.getObject("person.id"));
            personMap.put("person.id", (String)rowSet.getObject("person.id"));
            personMap.put("person.name", (String)rowSet.getObject("person.name"));
            personMap.put("person.number", (String)rowSet.getObject("person.number"));
            personMap.put("adminOrgUnit.name", (String)rowSet.getObject("adminOrgUnit.name"));
            resultList.add(personMap);
        }
        return resultList;
    }
}

