/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.OperationTypeCollection;
import com.kingdee.eas.cp.bc.OperationTypeFactory;
import com.kingdee.eas.cp.bc.OperationTypeInfo;
import com.kingdee.eas.cp.bc.OperationTypeSubjectMappingInfo;
import com.kingdee.eas.cp.bc.services.IOperationTypeService;
import com.kingdee.eas.cp.bc.services.util.ModelUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

@Component(value={"com.kingdee.eas.cp.bc.services.IOperationTypeService"})
@Description(value="")
public class OperationTypeService
extends BusinessServices
implements IOperationTypeService {
    public OperationTypeService(Context context) {
        super(context);
    }

    public OperationTypeInfo buildModel() throws BOSException, EASBizException {
        OperationTypeInfo perationType = new OperationTypeInfo();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.getContext().get((Object)"CompanyInfo");
        company = (CompanyOrgUnitInfo)ModelUtils.simpleClone((CoreBaseInfo)company);
        perationType.setCompany(company);
        return perationType;
    }

    public OperationTypeSubjectMappingInfo buildSubjectMappingModel() throws BOSException, EASBizException {
        OperationTypeSubjectMappingInfo perationTypeSubjectMapping = new OperationTypeSubjectMappingInfo();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.getContext().get((Object)"CompanyInfo");
        company = (CompanyOrgUnitInfo)ModelUtils.simpleClone((CoreBaseInfo)company);
        perationTypeSubjectMapping.setCompany(company);
        return perationTypeSubjectMapping;
    }

    public void enable(List ids, boolean enable) throws BOSException, EASBizException {
        OperationTypeFactory.getLocalInstance((Context)this.getContext()).setUsable(ids, enable);
    }

    public Set getOperationIdsByCompany(String companyId, String billType) throws BOSException, EASBizException {
        HashSet<String> operationIds = new HashSet<String>();
        if (StringUtils.isBlank((String)companyId) || companyId.equals("null")) {
            return operationIds;
        }
        EntityViewInfo operationView = new EntityViewInfo();
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo("select id,longNumber where id = '" + companyId + "'");
        FilterInfo operationFilter = new FilterInfo();
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.cp.bc.app.OperationTypeInitTreeQuery");
        operationFilter.getFilterItems().add(new FilterItemInfo("operationType.isEnable", (Object)Boolean.TRUE));
        operationFilter.getFilterItems().add(new FilterItemInfo("entry.isFilterControl", (Object)Boolean.TRUE));
        operationFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        String ln = company.getLongNumber();
        String[] lnSecs = ln.split("!");
        int size = lnSecs.length;
        HashSet<String> lnUps = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            lnUps.add(lnSecs[i]);
        }
        if (lnUps.size() != 0) {
            operationFilter.getFilterItems().add(new FilterItemInfo("company.number", lnUps, CompareType.INCLUDE));
            operationFilter.setMaskString("(#2 or #3) and #0 and #1");
        }
        if (billType != null) {
            operationFilter.getFilterItems().add(new FilterItemInfo("billType.number", (Object)billType));
            operationFilter.setMaskString("(#2 or #3) and #0 and #1 and #4");
        }
        operationView.setFilter(operationFilter);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.getContext(), (IMetaDataPK)queryPK);
        exec.setObjectView(operationView);
        IRowSet rowSet = exec.executeQuery();
        try {
            while (rowSet.next()) {
                operationIds.add(rowSet.getObject("operationType.id").toString());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return operationIds;
    }

    public List getOperationsByCompany() throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.getContext().get((Object)"CompanyInfo");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
        fic.add(new FilterItemInfo("isEnable", (Object)Boolean.TRUE));
        String ln = company.getLongNumber();
        String[] lnSecs = ln.split("!");
        int size = lnSecs.length;
        HashSet<String> lnUps = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            lnUps.add(lnSecs[i]);
        }
        if (lnUps.size() != 0) {
            fic.add(new FilterItemInfo("company.number", lnUps, CompareType.INCLUDE));
            fi.setMaskString("(#0 or #2) and #1");
        }
        evi.setFilter(fi);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("number"));
        evi.setSorter(sorter);
        OperationTypeCollection otc = OperationTypeFactory.getLocalInstance((Context)this.getContext()).getOperationTypeCollection(evi);
        Iterator it = otc.iterator();
        ArrayList result = new ArrayList();
        while (it.hasNext()) {
            OperationTypeInfo info = (OperationTypeInfo)it.next();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", info.getId().toString());
            map.put("number", info.getNumber().toString());
            map.put("name", info.getName().toString());
            map.put("companyId", info.getCompany().getId().toString());
            result.add(map);
        }
        return result;
    }
}

