/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.OtherBillPlanInfo;
import com.kingdee.eas.fi.ap.OtherBillType;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.arap.impl.BillCreateService;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;

@Component(value={"com.kingdee.eas.fi.arap.IBillCreateService"}, name="AP_APBillCreateService")
@Description(value="\u5e94\u4ed8\u5355\u521b\u5efa\u670d\u52a1")
public class APBillCreateService
extends BillCreateService {
    public APBillCreateService(Context context) {
        super(context);
    }

    public int getOrgType() {
        return 1;
    }

    public String getPermissionItem() {
        return "fi_arap_ApOtherBill_Add";
    }

    public CoreBillBaseInfo createDefaultBill(OrgUnitInfo mainOrg) throws EASBizException, BOSException {
        OtherBillInfo info = new OtherBillInfo();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)mainOrg;
        info.setCompany(company);
        info.setCurrency(company.getBaseCurrency());
        info.setExchangeRate(BigDecimal.ONE);
        info.setBillType(OtherBillType.InvoiceBill);
        info.setIsInTax(true);
        Date date = new Date();
        info.setBillDate(date);
        info.setBizDate(date);
        info.setBillStatus(BillStatusEnum.SAVE);
        UserInfo creator = new UserInfo();
        creator.setId(BOSUuid.read((String)this.getContext().getCaller().toString()));
        info.setCreator(creator);
        info.setCreateTime(new Timestamp(date.getTime()));
        ObjectUuidPK pk = new ObjectUuidPK("2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5");
        IPaymentType iPaymentType = PaymentTypeFactory.getLocalInstance((Context)this.getContext());
        PaymentTypeInfo paymentTypeInfo = iPaymentType.getPaymentTypeInfo((IObjectPK)pk);
        info.setPaymentType(paymentTypeInfo);
        pk = new ObjectUuidPK("YW3xsAEJEADgAAVEwKgTB0c4VZA=");
        AsstActTypeInfo asstActTypeInfo = AsstActTypeFactory.getLocalInstance((Context)this.getContext()).getAsstActTypeInfo((IObjectPK)pk);
        info.setAsstActType(asstActTypeInfo);
        info.setIsInTax(true);
        info.setIsPriceWithoutTax(true);
        info.setPurOrg(this.getDefaultPurchaseOrgUnit(company));
        info.setSourceBillType(VerificateBillTypeEnum.OTHER);
        OtherBillPlanInfo payPlan = new OtherBillPlanInfo();
        payPlan.setRecievePayDate(date);
        payPlan.setRecievePayAmount(BigDecimal.ZERO);
        payPlan.setRecievePayAmountLocal(BigDecimal.ZERO);
        payPlan.setVerifyAmount(BigDecimal.ZERO);
        payPlan.setVerifyAmountLocal(BigDecimal.ZERO);
        info.getPayPlan().add(payPlan);
        return info;
    }

    private PurchaseOrgUnitInfo getDefaultPurchaseOrgUnit(CompanyOrgUnitInfo companyOrgUnitInfo) throws EASBizException, BOSException {
        PurchaseOrgUnitInfo currentPurOrgUnit;
        if (companyOrgUnitInfo == null) {
            return null;
        }
        OrgUnitInfo currentOrgUnit = (OrgUnitInfo)this.getContext().get((Object)OrgType.getEnum((int)1));
        if (currentOrgUnit != null && currentOrgUnit.isIsCompanyOrgUnit() && currentOrgUnit.getId().toString().equals(companyOrgUnitInfo.getId().toString()) && currentOrgUnit.isIsPurchaseOrgUnit() && (currentPurOrgUnit = (PurchaseOrgUnitInfo)this.getContext().get((Object)OrgType.getEnum((int)3))) != null && currentPurOrgUnit.isIsBizUnit()) {
            return currentPurOrgUnit;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sorterItemInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("isBizUnit"));
        OrgUnitCollection orgUnitColl = (OrgUnitCollection)OtherBillFactory.getLocalInstance((Context)this.getContext()).getFromUnit(companyOrgUnitInfo.getId().toString(), 1, 3, viewInfo);
        int size = orgUnitColl.size();
        for (int i = 0; i < size; ++i) {
            if (!((PurchaseOrgUnitInfo)orgUnitColl.get(i)).isIsBizUnit()) continue;
            return (PurchaseOrgUnitInfo)orgUnitColl.get(i);
        }
        return null;
    }
}

