/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.IService;
import com.kingdee.bos.bsf.service.ServiceFactory;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.IBillCreateService;
import com.kingdee.eas.fi.arap.impl.CodeRuleHelper;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;

public abstract class BillCreateService
extends BusinessServices
implements IBillCreateService {
    public BillCreateService(Context context) {
        super(context);
    }

    public CoreBillBaseInfo createBill(String mainOrgId) throws EASBizException, BOSException {
        IService service = ServiceFactory.getLocalInstance((Context)this.getContext());
        OrgUnitInfo mainOrg = null;
        if (mainOrgId == null) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("orgType", this.getOrgType());
            paramMap.put("permissionItem", this.getPermissionItem());
            OrgUnitInfo[] orgs = (OrgUnitInfo[])service.invoke("ARAP_BaseService", "getAuthorizedBizOrgUnits", paramMap);
            if (orgs == null || orgs.length == 0) {
                throw new PermissionException(PermissionException.HAS_NOT_FUNCTION_PERMISSION);
            }
            mainOrg = orgs[0];
            OrgUnitInfo orgInfo = (OrgUnitInfo)this.getContext().get((Object)OrgType.getEnum((int)this.getOrgType()));
            for (int i = 0; i < orgs.length; ++i) {
                if (!orgs[i].getId().equals((Object)orgInfo.getId())) continue;
                mainOrg = orgs[i];
                break;
            }
        } else {
            HashSet<String> idSet = new HashSet<String>(1);
            idSet.add(mainOrgId);
            HashMap<String, Serializable> paramMap = new HashMap<String, Serializable>();
            paramMap.put("keys", idSet);
            paramMap.put("orgTypeValue", Integer.valueOf(this.getOrgType()));
            OrgUnitInfo[] orgs = (OrgUnitInfo[])service.invoke("ARAP_BaseService", "getOrgUnitInfosByType", paramMap);
            mainOrg = orgs[0];
        }
        CoreBillBaseInfo info = this.createDefaultBill(mainOrg);
        CodeRuleHelper codeHelper = new CodeRuleHelper();
        codeHelper.genNewBillNumber(this.getContext(), (IObjectValue)info, mainOrg);
        return info;
    }

    public abstract int getOrgType();

    public abstract String getPermissionItem();

    public abstract CoreBillBaseInfo createDefaultBill(OrgUnitInfo var1) throws EASBizException, BOSException;

    public CoreBillEntryBaseInfo createBillEntry(String companyid) throws EASBizException, BOSException {
        return null;
    }
}

