/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.cdo.ICommonDataObject;
import com.kingdee.bos.cdo.utils.CDOUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgRangeFilterUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.services.FaCommonObject;
import com.kingdee.eas.fi.fa.manage.services.impl.MainOrgFilterImpl;
import com.kingdee.eas.fi.fa.manage.services.util.FaServerUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompanyDataImpl {
    private Context context = null;

    public CompanyDataImpl(Context context) {
        this.context = context;
    }

    public ICommonDataObject getCompanyOrgData(String companyOrgUnitId, String selector, String permissionItem) throws BOSException, EASBizException {
        FaCommonObject info = new FaCommonObject();
        SelectorItemCollection sic = FaServerUtil.getOrgInfoSelector(OrgType.Company);
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)this.context).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitId), sic);
        info.put("company", company);
        HashMap orgParam = FaManageUtils.getFAParameter((BOSUuid)BOSUuid.read((String)companyOrgUnitId), (Context)this.context);
        info.put("orgparam", orgParam);
        FilterInfo filter = new MainOrgFilterImpl(this.context).getFilterInfo(permissionItem);
        info.put("mainorgfilter", filter.toSql());
        String adminRangeFilter = this.getUserAdminOrgRangeFilter();
        info.put("adminrangefilter", adminRangeFilter);
        String adminOrgFilter = this.getAdminOrgUnitRangeFilter();
        info.put("adminorgfilter", adminOrgFilter);
        return CDOUtils.convertObjectInfoToCDO((Context)this.context, (IObjectValue)info);
    }

    public List<Integer> getPeriodYearRange(CompanyOrgUnitInfo company) throws BOSException {
        ArrayList<Integer> years = new ArrayList<Integer>();
        Integer minYear = null;
        Integer maxYear = null;
        if (company == null || company.getAccountPeriodType() == null) {
            return years;
        }
        String periodTypeId = company.getAccountPeriodType().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select min(fperiodyear) fminYear, max(fperiodyear) fmaxYear from t_bd_period where ftypeid ='");
        sql.append(periodTypeId).append("' ");
        IRowSet rs = DbUtil.executeQuery((Context)this.context, (String)sql.toString());
        try {
            if (rs.next()) {
                minYear = rs.getInt("fminYear");
                maxYear = rs.getInt("fmaxYear");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (minYear != null && maxYear != null) {
            for (int i = minYear.intValue(); i <= maxYear; ++i) {
                years.add(i);
            }
        }
        return years;
    }

    public String getAdminOrgUnitRangeFilter() throws EASBizException, BOSException {
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.basedata.org.app", (String)"NewOrgF7Query");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(this.getOrgStructureFilter());
        String querySql = FaServerUtil.getQueryExecutor(this.context, (IMetaDataPK)queryPK, viewInfo).getSQL();
        StringBuffer orgSql = new StringBuffer();
        orgSql.append("id in (select \"ORGSTRUCTURE\".FUnitId ");
        orgSql.append(querySql.substring(querySql.indexOf("FROM"), querySql.indexOf("ORDER BY")));
        orgSql.append(") ");
        return orgSql.toString();
    }

    private FilterInfo getOrgStructureFilter() throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        String rootUnitId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        String treeId = "00000000-0000-0000-0000-0000000000034F2827FD";
        oql.append("select unit.longnumber where unit.id = '").append(rootUnitId).append("' and tree.id = '").append(treeId).append("'");
        OrgStructureInfo structInfo = OrgStructureFactory.getLocalInstance((Context)this.context).getOrgStructureInfo(oql.toString());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)treeId, CompareType.EQUALS));
        String[] rootLongNumbers = new String[]{structInfo.getUnit().getLongNumber()};
        FilterInfo longNumberFilter = new FilterInfo();
        if (rootLongNumbers != null && rootLongNumbers.length > 0) {
            longNumberFilter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)rootLongNumbers[0], CompareType.EQUALS));
            longNumberFilter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(rootLongNumbers[0] + "!%"), CompareType.LIKE));
            longNumberFilter.setMaskString("(#0 or #1)");
        }
        filter.mergeFilter(longNumberFilter, "and");
        return filter;
    }

    public String getUserAdminOrgRangeFilter() throws BOSException {
        Set adminOrgs = null;
        try {
            adminOrgs = AdminOrgRangeFilterUtil.getCurrentUserAdminOrgRange((Context)this.context);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer orgIds = new StringBuffer("id in ('null'");
        if (adminOrgs != null) {
            Iterator iter = adminOrgs.iterator();
            while (iter.hasNext()) {
                orgIds.append(", '").append((String)iter.next()).append("'");
            }
        }
        orgIds.append(") ");
        return orgIds.toString();
    }

    public ICommonDataObject getCompanyAndParamsData(String companyOrgUnitId) throws BOSException, EASBizException {
        FaCommonObject info = new FaCommonObject();
        SelectorItemCollection sic = FaServerUtil.getOrgInfoSelector(OrgType.Company);
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)this.context).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitId), sic);
        info.put("company", company);
        HashMap orgParam = FaManageUtils.getFAParameter((BOSUuid)BOSUuid.read((String)companyOrgUnitId), (Context)this.context);
        info.put("orgparam", orgParam);
        return CDOUtils.convertObjectInfoToCDO((Context)this.context, (IObjectValue)info);
    }
}

