/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaCardOriginEnum;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.services.IFaCurCardService;
import com.kingdee.eas.fi.fa.manage.services.util.FaServerUtil;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

@Component(value={"com.kingdee.eas.fi.fa.manage.services.IFaCurCardService"})
public class FaCurCardServiceImpl
extends BusinessServices
implements IFaCurCardService {
    public FaCurCardServiceImpl(Context context) {
        super(context);
    }

    protected ICoreBase getBizInterface() throws BOSException, EASBizException {
        return FaCurCardFactory.getLocalInstance((Context)this.getContext());
    }

    public CompanyOrgUnitInfo getCurrentCompanyOrgUnitInfo(ICoreBase bizInterface, String[] ids) throws EASBizException, BOSException {
        ObjectUuidPK pk = new ObjectUuidPK(ids[0].toString());
        CoreBaseInfo billInfo = bizInterface.getValue("select company.* where id = '" + pk + "'");
        return (CompanyOrgUnitInfo)billInfo.get("company");
    }

    public void checkObjectsExists(ICoreBase bizInterface, String[] ids) throws EASBizException, BOSException {
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            idSet.add(ids[i]);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SorterItemCollection sorter = new SorterItemCollection();
        IObjectPK[] pklist = bizInterface.getPKList(filter, sorter);
        if (ids.length != pklist.length) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    private CoreBaseCollection getCollection(ICoreBase bizInterface, String[] ids) throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            idSet.add(ids[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("originFlag"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("originFlag", (Object)0, CompareType.NOTEQUALS));
        view.setFilter(filter);
        return bizInterface.getCollection(view);
    }

    public void checkBeforeVoucher(String[] ids) throws EASBizException, BOSException {
        FaCurCardInfo cardInfo;
        Iterator iter;
        ICoreBase bizInterface = this.getBizInterface();
        CompanyOrgUnitInfo companyInfo = this.getCurrentCompanyOrgUnitInfo(bizInterface, ids);
        FaServerUtil.checkFaInit(this.getContext(), companyInfo);
        this.checkObjectsExists(bizInterface, ids);
        CoreBaseCollection coll = this.getCollection(bizInterface, ids);
        int iList = coll.size();
        if (ids.length > 0 && ids.length > iList) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.FaCurCardListUI_IsInitCard");
            throw new FaCardException(FaCardException.UN_SUCCESS, (Object[])new String[]{strMsg});
        }
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            FaCurCardInfo cardInfo2 = (FaCurCardInfo)coll.get(i);
            if (cardInfo2.getCheckedStatus() == null || cardInfo2.getCheckedStatus() != CheckedStatusEnum.UNAUDITED) continue;
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource.billUnauditForbidGoFurther");
            throw new FaCardException(FaCardException.UN_SUCCESS, (Object[])new String[]{cardInfo2.getNumber() + ":" + strMsg});
        }
        FaServerUtil.checkForGenVoucher(this.getContext(), companyInfo);
        HashMap hmParam = FaManageUtils.getFAParameter((BOSUuid)companyInfo.getId(), (Context)this.getContext());
        boolean isSplitOrCombineNoVourcher = "true".equals(hmParam.get("FA_048").toString());
        if (isSplitOrCombineNoVourcher && (iter = coll.iterator()).hasNext() && (cardInfo = (FaCurCardInfo)iter.next()).getOriginFlag() != null && (cardInfo.getOriginFlag().equals((Object)FaCardOriginEnum.SPLIT) || cardInfo.getOriginFlag().equals((Object)FaCardOriginEnum.COMBIN))) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.needNotVourcher_newCard");
            throw new BOSException(cardInfo.getNumber() + ":" + strMsg);
        }
    }

    public void checkBeforeDelVoucher(String[] ids) throws EASBizException, BOSException {
        ICoreBase bizInterface = this.getBizInterface();
        CompanyOrgUnitInfo companyInfo = this.getCurrentCompanyOrgUnitInfo(bizInterface, ids);
        FaServerUtil.checkFaInit(this.getContext(), companyInfo);
        this.checkObjectsExists(bizInterface, ids);
        CoreBaseCollection coll = this.getCollection(bizInterface, ids);
        int iList = coll.size();
        if (ids.length > 0 && ids.length > iList) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.FaCurCardListUI_IsInitCard");
            throw new BOSException(strMsg);
        }
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            FaCurCardInfo cardInfo = (FaCurCardInfo)coll.get(i);
            if (cardInfo.getCheckedStatus() == null || cardInfo.getCheckedStatus() != CheckedStatusEnum.UNAUDITED) continue;
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource.billUnauditForbidGoFurther");
            throw new BOSException(cardInfo.getNumber() + ":" + strMsg);
        }
    }
}

