/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.fa.basedata.FaParamFacadeFactory;
import com.kingdee.eas.fi.fa.basedata.FaParamInfo;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.basedata.FaUtils;
import com.kingdee.eas.fi.fa.basedata.IFaParamFacade;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaDepAsstActCompositCollection;
import com.kingdee.eas.fi.fa.manage.FaDepAsstActCompositFactory;
import com.kingdee.eas.fi.fa.manage.FaDepAsstActCompositInfo;
import com.kingdee.eas.fi.fa.manage.FaDepCalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaDepDistributeCollection;
import com.kingdee.eas.fi.fa.manage.FaDepDistributeFactory;
import com.kingdee.eas.fi.fa.manage.FaDepDistributeInfo;
import com.kingdee.eas.fi.fa.manage.FaDepEntryStatusEnum;
import com.kingdee.eas.fi.fa.manage.FaDepreciationCollection;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryCollection;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationEntryInfo;
import com.kingdee.eas.fi.fa.manage.FaDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationInfo;
import com.kingdee.eas.fi.fa.manage.FaWorkLoadCollection;
import com.kingdee.eas.fi.fa.manage.FaWorkLoadFactory;
import com.kingdee.eas.fi.fa.manage.FaWorkLoadInfo;
import com.kingdee.eas.fi.fa.manage.IFaDepAsstActComposit;
import com.kingdee.eas.fi.fa.manage.IFaDepCalFacade;
import com.kingdee.eas.fi.fa.manage.IFaDepreciation;
import com.kingdee.eas.fi.fa.manage.IFaWorkLoad;
import com.kingdee.eas.fi.fa.manage.app.FaDepCalExecutor;
import com.kingdee.eas.fi.fa.manage.client.FaClientUtils;
import com.kingdee.eas.fi.fa.manage.services.FaDepCalService;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.fi.fa.manage.services.FaDepCalService"})
public class FaDepCalServiceImpl
implements FaDepCalService {
    private static final String RES_PATH = "com.kingdee.eas.fi.fa.manage.FaDepreciationResource";
    private Context ctx = null;

    public FaDepCalServiceImpl(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public Map<String, Object> checkBeforeCal(String orgID) throws BOSException, EASBizException {
        boolean alreadyCal = false;
        alreadyCal = this._checkBeforeCal(orgID);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("alreadyCal", alreadyCal + "");
        if (alreadyCal) {
            result.put("msg", EASResource.getString((String)RES_PATH, (String)"FaDepCal_AlreadyCal"));
        }
        return result;
    }

    protected boolean _checkBeforeCal(String orgID) throws BOSException, EASBizException {
        FaDepCalExecutor executor = new FaDepCalExecutor(orgID);
        return executor._checkBeforeCal(this.ctx);
    }

    @Override
    public Map<String, Object> hasCardOfDeprMethod(String isCurcard, String isAudit, String orgID) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap hmPara = this.constructHasCardDMParameter(isCurcard, isAudit);
        boolean hasCardOfDeprMethodNull = false;
        hasCardOfDeprMethodNull = this._hasCardOfDeprMethodNull(this.ctx, hmPara, orgID);
        result.put("hasCardOfDeprMethod", hasCardOfDeprMethodNull + "");
        result.put("msg", EASResource.getString((String)RES_PATH, (String)"FaDepCal_hasCardOfDeprMethodNull"));
        return result;
    }

    private HashMap constructHasCardDMParameter(String isCurcard, String isAudit) {
        HashMap<String, Comparable<Boolean>> hmPara = new HashMap<String, Comparable<Boolean>>();
        hmPara.put("all", Boolean.valueOf(!Boolean.parseBoolean(isCurcard)));
        hmPara.put("useSQL", Boolean.valueOf(true));
        hmPara.put("isNeedAudit", Boolean.valueOf(!Boolean.parseBoolean(isAudit)));
        hmPara.put("threadCount", new Integer(1));
        return hmPara;
    }

    protected boolean _hasCardOfDeprMethodNull(Context ctx, HashMap hmPara, String orgID) throws BOSException, EASBizException {
        FaDepCalExecutor executor = new FaDepCalExecutor(orgID);
        return executor._hasCardOfDeprMethodNull(ctx, hmPara);
    }

    @Override
    public Map<String, Object> getCurrencyScale(String orgID) throws BOSException, EASBizException {
        int scale = 2;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("baseCurrency.precision"));
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgID), selector);
        scale = company.getBaseCurrency().getPrecision();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("scale", scale + "");
        return result;
    }

    @Override
    public Map<String, Object> saveConfig(String isCurcard, String isAudit) throws BOSException, EASBizException {
        String sqlUpdateIsCurcard = "update T_BAS_Param set FDEFAULTVAL_L1 = '" + isCurcard + "'," + " FDEFAULTVAL_L2 = '" + isCurcard + "'," + " FDEFAULTVAL_L3 = '" + isCurcard + "'" + " where FNumber in ('FA_052')";
        String sqlUpdateIsAuditStr = "update T_BAS_Param set FDEFAULTVAL_L1 = '" + isAudit + "'," + " FDEFAULTVAL_L2 = '" + isAudit + "'," + " FDEFAULTVAL_L3 = '" + isAudit + "'" + " where FNumber in ('FA_053')";
        DbUtil.execute((Context)this.ctx, (String)sqlUpdateIsCurcard);
        DbUtil.execute((Context)this.ctx, (String)sqlUpdateIsAuditStr);
        HashMap<String, Object> result = new HashMap<String, Object>();
        return result;
    }

    @Override
    public Map<String, Object> queryDepCalConfig() throws BOSException, EASBizException {
        String selectIsCurcardConfigSql = "select FDEFAULTVAL_L2 from T_BAS_Param where FNumber in ('FA_052')";
        String selectIsAuditConfigSql = "select FDEFAULTVAL_L2 from T_BAS_Param where FNumber in ('FA_053')";
        IRowSet rsIsCurcard = DbUtil.executeQuery((Context)this.ctx, (String)selectIsCurcardConfigSql);
        IRowSet rsIsAudit = DbUtil.executeQuery((Context)this.ctx, (String)selectIsAuditConfigSql);
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.constructResult(rsIsCurcard, rsIsAudit, result);
        return result;
    }

    private void constructResult(IRowSet rsIsCurcard, IRowSet rsIsAudit, Map<String, Object> result) {
        try {
            rsIsCurcard.next();
            rsIsAudit.next();
            String isCurcardStr = rsIsCurcard.getString("FDEFAULTVAL_L2");
            String isAuditStr = rsIsAudit.getString("FDEFAULTVAL_L2");
            result.put("isCurcard", isCurcardStr);
            result.put("isAudit", isAuditStr);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, Object> checkPermission(String orgID) throws BOSException, EASBizException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)this.ctx);
        ObjectUuidPK userPk = new ObjectUuidPK(BOSUuid.read((String)userInfo.getId().toString()));
        ObjectUuidPK orgPk = new ObjectUuidPK(BOSUuid.read((String)orgID));
        PermissionFactory.getLocalInstance((Context)this.ctx).checkFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, "fa_dep_audit");
        HashMap<String, Object> result = new HashMap<String, Object>();
        return result;
    }

    @Override
    public Map<String, Object> depCal(String isCurcard, String isAudit, String orgID) throws BOSException, EASBizException {
        IFaDepCalFacade depCalFacade = FaDepCalFacadeFactory.getLocalInstance((Context)this.ctx);
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap hmPara = this.getDepCalParameter(isCurcard, isAudit);
        long start = System.currentTimeMillis();
        HashMap hm = depCalFacade.calDep(hmPara, orgID);
        long end = System.currentTimeMillis();
        long total = (end - start) / 1000L;
        return this.makeReturnMessage(result, hm, total);
    }

    private HashMap getDepCalParameter(String isCurcard, String isAudit) {
        HashMap<String, Comparable<Boolean>> hmPara = new HashMap<String, Comparable<Boolean>>();
        hmPara.put("all", Boolean.valueOf(!Boolean.parseBoolean(isCurcard)));
        hmPara.put("useSQL", Boolean.valueOf(Boolean.parseBoolean("true")));
        hmPara.put("isNeedAudit", Boolean.valueOf(!Boolean.parseBoolean(isAudit)));
        hmPara.put("threadCount", new Integer(1));
        return hmPara;
    }

    private Map<String, Object> makeReturnMessage(Map<String, Object> result, HashMap hm, long total) throws EASBizException, BOSException {
        String msg = (String)hm.get("msg");
        if (msg != null && msg.length() > 0) {
            String title = EASResource.getString((String)RES_PATH, (String)"later_period_exists_business");
            result.put("title", title);
            result.put("msgType", 1);
            return result;
        }
        int scale = 2;
        if (SysContext.getSysContext().getCurrentFIUnit() != null && SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency() != null) {
            scale = FaClientUtils.getCurrencyScale();
        }
        String patten = this.getFormatPattern(scale);
        DecimalFormat format = new DecimalFormat(patten);
        String str = EASResource.getString((String)RES_PATH, (String)"FaDepCal_Message1") + "<br>";
        str = str + EASResource.getString((String)RES_PATH, (String)"FaDepCal_Message2");
        Object depCount = hm.get("DepCount");
        str = MessageFormat.format(str, depCount) + "<br>";
        str = str + EASResource.getString((String)RES_PATH, (String)"FaDepCal_Message4");
        String depAmount = format.format(hm.get("DepAmount") != null ? ((BigDecimal)hm.get("DepAmount")).setScale(scale, 4) : new BigDecimal("0.00"));
        str = MessageFormat.format(str, depAmount) + "<br>";
        str = str + FaResUtil.getRes((String)"totalTime");
        str = MessageFormat.format(str, total) + "\ufffd\ufffd";
        result.put("msg", str);
        return result;
    }

    private String getFormatPattern(int scale) {
        String pattern = null;
        switch (scale) {
            case 0: {
                pattern = "#,##0";
                break;
            }
            case 1: {
                pattern = "#,##0.0";
                break;
            }
            case 2: {
                pattern = "#,##0.00";
                break;
            }
            case 3: {
                pattern = "#,##0.000";
                break;
            }
            case 4: {
                pattern = "#,##0.0000";
                break;
            }
            default: {
                StringBuffer buf = new StringBuffer("#,##0.00000");
                for (int i = 5; i < scale; ++i) {
                    buf.append("0");
                }
                pattern = buf.toString();
            }
        }
        return pattern;
    }

    @Override
    public Map<String, Object> submit(String orgID, String updateRowDataStr) throws BOSException, EASBizException {
        String[] args = updateRowDataStr.split("@");
        HashMap workloadSchemes = FaUtils.getUserDepreciationMode((Context)this.ctx, (boolean)true);
        HashMap<String, Object> result = new HashMap<String, Object>();
        FaDepreciationEntryCollection depEntry = this.getEnryByIDSet(args);
        FaDepreciationEntryCollection depEntryByUI = this.getEntryCollectionByUIParameter(args, workloadSchemes, depEntry);
        Map valideResultMap = this.validate(depEntryByUI, args);
        if (valideResultMap.get("result").equals("false")) {
            return this.getResultMap(result, false, valideResultMap.get("msg").toString());
        }
        try {
            if (this.checkHasUnAuditedBill(depEntryByUI)) {
                return this.getResultMap(result, false, EASResource.getString((String)RES_PATH, (String)"FaDepMnt_DepNotBeNull"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.updateEntryCollection(depEntryByUI, orgID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getResultMap(result, true, null);
    }

    private Map<String, Object> getResultMap(Map<String, Object> result, boolean type, String message) {
        if (type) {
            result.put("result", "true");
        } else {
            result.put("result", "false");
            result.put("msg", message);
        }
        return result;
    }

    private Map validate(FaDepreciationEntryCollection depEntry, String[] args) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (int i = 0; i < depEntry.size(); ++i) {
            String cardNumber;
            FaDepreciationEntryInfo entryInfo = depEntry.get(i);
            if (entryInfo.getDepDistribute() == null || entryInfo.getDepDistribute().size() <= 0) continue;
            FaDepDistributeCollection disCollection = entryInfo.getDepDistribute();
            BigDecimal totalDisDep = new BigDecimal("0");
            for (int j = 0; j < disCollection.size(); ++j) {
                totalDisDep = totalDisDep.add(disCollection.get(j).getAmount());
            }
            BigDecimal newDep = entryInfo.getDepreciation();
            String string = cardNumber = entryInfo.get("needReCalRate") == null ? "" : entryInfo.get("needReCalRate").toString();
            if (newDep.compareTo(totalDisDep) == 0) continue;
            resultMap.put("result", "false");
            resultMap.put("msg", cardNumber + EASResource.getString((String)RES_PATH, (String)"FaDepMnt_DepSum"));
            return resultMap;
        }
        resultMap.put("result", "true");
        return resultMap;
    }

    boolean checkHasUnAuditedBill(FaDepreciationEntryCollection c) throws Exception, EASBizException {
        FaDepCalFacadeFactory.getLocalInstance((Context)this.ctx).checkBeforeCal();
        FilterInfo filter = new FilterInfo();
        StringBuffer mask = new StringBuffer("#0 and (");
        filter.getFilterItems().add(new FilterItemInfo("bizStatus", (Object)"%99", CompareType.LIKE));
        for (int i = 1; i <= c.size(); ++i) {
            FaDepreciationEntryInfo element = c.get(i - 1);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)element.getFaCurCard().getId().toString(), CompareType.EQUALS));
            mask.append("#" + i);
            if (i == c.size()) {
                mask.append(")");
                continue;
            }
            mask.append(" or ");
        }
        filter.setMaskString(mask.toString());
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        FaCurCardCollection cCard = FaCurCardFactory.getLocalInstance((Context)this.ctx).getFaCurCardCollection(ev);
        return cCard == null || cCard.size() < c.size();
    }

    protected void updateEntryCollection(FaDepreciationEntryCollection c, String orgIDs) throws Exception {
        PeriodInfo currentPeriod = this.getCurrentPeriod(orgIDs);
        IFaDepreciation iFaDep = FaDepreciationFactory.getLocalInstance((Context)this.ctx);
        iFaDep.updateEntryCollection(currentPeriod, c);
    }

    private PeriodInfo getCurrentPeriod(String orgIDs) throws BOSException, EASBizException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgIDs));
        ArrayList<CompanyOrgUnitInfo> list = new ArrayList<CompanyOrgUnitInfo>();
        list.add(aCompanyOrgUnitInfo);
        HashMap zipData = FaDepreciationFactory.getLocalInstance((Context)this.ctx).getZipDataForRPC(list);
        PeriodInfo currentPeriod = (PeriodInfo)zipData.get("currPeriod");
        return currentPeriod;
    }

    private FaDepreciationEntryCollection getEntryCollectionByUIParameter(String[] args, HashMap workloadSchemes, FaDepreciationEntryCollection depEntry) throws BOSException {
        FaDepreciationEntryCollection entryCollection = new FaDepreciationEntryCollection();
        FaDepreciationEntryInfo info = null;
        for (int i = 0; i < args.length; ++i) {
            if (i % 8 == 0) {
                info = new FaDepreciationEntryInfo();
                info.setId(BOSUuid.read((String)args[i]));
                if (!depEntry.contains((Object)BOSUuid.read((String)args[i]))) continue;
                info.setState(depEntry.get((Object)BOSUuid.read((String)args[i])).getState());
                continue;
            }
            if (i % 8 == 1) {
                FaCurCardInfo card = new FaCurCardInfo();
                card.setId(BOSUuid.read((String)args[i]));
                info.setFaCurCard(card);
                continue;
            }
            if (i % 8 == 2) {
                info.setDepreciation(new BigDecimal(args[i].replace(",", "")));
                continue;
            }
            if (i % 8 == 3) {
                info.setNotDepre(new BigDecimal(args[i].replace(",", "")));
                continue;
            }
            if (i % 8 == 4) continue;
            if (i % 8 == 5) {
                BigDecimal assetValue;
                String deprModeNumber = args[i - 1];
                if (deprModeNumber != null && (deprModeNumber.equals("001") || deprModeNumber.equals("010") || deprModeNumber.equals("002") || workloadSchemes.containsKey(deprModeNumber)) && (assetValue = new BigDecimal(args[i].replace(",", ""))) != null && assetValue.intValue() > 0) {
                    info.put("needReCalRate", (Object)true);
                    info.getFaCurCard().setAssetValue(assetValue);
                }
                this.makeDepCompositeInfoForWrong(this.ctx, info);
                continue;
            }
            if (i % 8 == 6) {
                String lnkFaDepreEntryStateStr = args[i];
                int lnkFaDepreEntryStateInt = Integer.parseInt(lnkFaDepreEntryStateStr);
                FaDepEntryStatusEnum state = FaDepEntryStatusEnum.getEnum((int)lnkFaDepreEntryStateInt);
                info.setState(state);
                continue;
            }
            if (i % 8 != 7) continue;
            if (!args[i].equals("")) {
                String distributeInfoString = args[i];
                String[] distributeArray = distributeInfoString.split(",");
                FaDepDistributeInfo faDepDistributeInfo = null;
                for (int j = 0; j < distributeArray.length; ++j) {
                    if (j % 2 == 0 && depEntry.contains((Object)BOSUuid.read((String)args[i - 7]))) {
                        if (depEntry.get((Object)BOSUuid.read((String)args[i - 7])).getDepDistribute().contains((Object)BOSUuid.read((String)distributeArray[j]))) {
                            // empty if block
                        }
                        faDepDistributeInfo = depEntry.get((Object)BOSUuid.read((String)args[i - 7])).getDepDistribute().get((Object)BOSUuid.read((String)distributeArray[j]));
                    }
                    if (j % 2 != 1) continue;
                    faDepDistributeInfo.setAmount(new BigDecimal(distributeArray[j].replace(",", "")));
                    info.getDepDistribute().add(faDepDistributeInfo);
                }
            } else {
                FaDepDistributeCollection faDepDistributeCollection = depEntry.get((Object)BOSUuid.read((String)args[i - 7])).getDepDistribute();
                for (int z = 0; z < faDepDistributeCollection.size(); ++z) {
                    info.getDepDistribute().add(faDepDistributeCollection.get(z));
                }
            }
            entryCollection.add(info);
        }
        return entryCollection;
    }

    protected void makeDepCompositeInfoForWrong(Context ctx, FaDepreciationEntryInfo entryInfo) throws BOSException {
        IFaDepAsstActComposit iFaDepAsstActComposit = FaDepAsstActCompositFactory.getLocalInstance((Context)ctx);
        FaDepAsstActCompositCollection depAsstActCompositCollection = null;
        FaDepDistributeCollection disCollection = entryInfo.getDepDistribute();
        for (int i = 0; i < disCollection.size(); ++i) {
            FaDepDistributeInfo depDistributeInfo = disCollection.get(i);
            depAsstActCompositCollection = depDistributeInfo.getDepAsstActComposit();
            depAsstActCompositCollection = iFaDepAsstActComposit.getFaDepAsstActCompositCollection(this.getDepAsstActCompositView(depDistributeInfo.getId()));
            if (depAsstActCompositCollection == null || depAsstActCompositCollection.size() <= 0) continue;
            depDistributeInfo.getDepAsstActComposit().addCollection(depAsstActCompositCollection);
        }
    }

    private EntityViewInfo getDepAsstActCompositView(Object pk) {
        EntityViewInfo depAsstActCompositView = null;
        if (depAsstActCompositView == null) {
            depAsstActCompositView = new EntityViewInfo();
            depAsstActCompositView.getSelector().add("*");
            depAsstActCompositView.getSelector().add(new SelectorItemInfo("asstActType.*"));
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billid", pk, CompareType.EQUALS));
        depAsstActCompositView.setFilter(filterInfo);
        return depAsstActCompositView;
    }

    private FaDepreciationEntryCollection getEnryByIDSet(String[] args) throws BOSException {
        Set idSet = this.getIDSetFromArgs(args);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection coll = this.getFaDepreciationEntrySelectors();
        view.setSelector(coll);
        view.setFilter(filter);
        FaDepreciationEntryCollection depEntry = new FaDepreciationEntryCollection();
        depEntry = FaDepreciationEntryFactory.getLocalInstance((Context)this.ctx).getFaDepreciationEntryCollection(view);
        return depEntry;
    }

    private Set getIDSetFromArgs(String[] args) {
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < args.length; ++i) {
            if (i % 8 != 0) continue;
            idSet.add(args[i]);
        }
        return idSet;
    }

    protected static HashSet getLastPeriodChangeCard(Context ctx, FaDepreciationEntryCollection depEntry) throws BOSException {
        HashSet<String> cardSet = new HashSet<String>();
        for (int i = 0; i < depEntry.size(); ++i) {
            FaDepreciationEntryInfo entryInfo = depEntry.get(i);
            cardSet.add(entryInfo.getFaCurCard().getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        filter.getFilterItems().add(new FilterItemInfo("id", cardSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("lastPeriodChange", (Object)new Integer(0)));
        FaCurCardCollection cards = FaCurCardFactory.getLocalInstance((Context)ctx).getFaCurCardCollection(view);
        cardSet.clear();
        for (int i = 0; i < cards.size(); ++i) {
            cardSet.add(cards.get(i).getId().toString());
        }
        return cardSet;
    }

    private SelectorItemCollection getFaDepreciationEntrySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("depDistribute.*"));
        return sic;
    }

    @Override
    public Map<String, Object> audit(String orgID, String lnkfadepreentryID) throws BOSException, EASBizException {
        this.checkPermission(orgID);
        String id = this.getDepIDByEntryID(lnkfadepreentryID);
        PeriodInfo currentPeriod = this.getCurrentPeriod(orgID);
        FaDepCalFacadeFactory.getLocalInstance((Context)this.ctx).auditBill(currentPeriod.getId().toString(), orgID, id);
        HashMap<String, Object> result = new HashMap<String, Object>();
        return result;
    }

    private String getDepIDByEntryID(String lnkfadepreentryID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)lnkfadepreentryID));
        view.setFilter(filter);
        FaDepreciationEntryCollection depCollection = new FaDepreciationEntryCollection();
        depCollection = FaDepreciationEntryFactory.getLocalInstance((Context)this.ctx).getFaDepreciationEntryCollection(view);
        String Depid = depCollection.get(0).getLnkFaDepreEntry().getId().toString();
        return Depid;
    }

    @Override
    public Map<String, Object> unDep(String orgID) throws BOSException, EASBizException {
        PeriodInfo currentPeriod = this.getCurrentPeriod(orgID);
        FaDepCalFacadeFactory.getLocalInstance((Context)this.ctx).checkBeforeUnAudit(currentPeriod.getId().toString(), orgID);
        FaDepCalExecutor executor = new FaDepCalExecutor(orgID);
        executor._undoDep(this.ctx);
        HashMap<String, Object> result = new HashMap<String, Object>();
        return result;
    }

    @Override
    public Map<String, Object> getDistributeInfo(String orgID, String lnkFaDepreEntryId, String realDep, String precision) throws BOSException, EASBizException, SQLException {
        String scale = this.getCurrencyScale(orgID).get("scale").toString();
        IRowSet editRowSet = null;
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.fa.manage", "FaDepreationQuery"));
        EntityViewInfo view = this.getFilter(lnkFaDepreEntryId);
        this.setExec(exec, view);
        editRowSet = exec.executeQuery();
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            this.setReturnData(orgID, editRowSet, realDep, result, precision);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.setIsRelAccount(orgID, result);
        this.configDistributeView(lnkFaDepreEntryId, view);
        FaDepreciationEntryCollection depCollection = new FaDepreciationEntryCollection();
        FaDepDistributeCollection faDepDistributeCollection = this.setDistributeInfo(view, result);
        this.getActCompositInitData(result, faDepDistributeCollection);
        return result;
    }

    private void setIsRelAccount(String orgID, Map<String, Object> result) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = null;
        ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx);
        String isRelAccount = "" + ictrol.isRelatedAccount(orgID, SystemEnum.FIXEDASSETS);
        result.put("isRelAccount", isRelAccount);
    }

    private FaDepDistributeCollection setDistributeInfo(EntityViewInfo view, Map<String, Object> result) throws BOSException {
        FaDepreciationEntryCollection depCollection = FaDepreciationEntryFactory.getLocalInstance((Context)this.ctx).getFaDepreciationEntryCollection(view);
        FaDepDistributeCollection faDepDistributeCollection = depCollection.get(0).getDepDistribute();
        ArrayList distributeInfoLoadData = new ArrayList();
        for (int i = 0; i < faDepDistributeCollection.size(); ++i) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            FaDepDistributeInfo faDepDistributeInfo = faDepDistributeCollection.get(i);
            row.put("distributeInfoId", faDepDistributeInfo.getId().toString());
            row.put("accountView", faDepDistributeInfo.getAccountView().toString());
            BigDecimal apportionScale = faDepDistributeInfo.getApportionScale() == null ? new BigDecimal("0.00") : faDepDistributeInfo.getApportionScale();
            apportionScale.setScale(2, 4);
            DecimalFormat df = new DecimalFormat("0.00");
            row.put("apportionScale", df.format(apportionScale));
            row.put("amount", faDepDistributeInfo.getAmount());
            row.put("remark", faDepDistributeInfo.getRemark());
            distributeInfoLoadData.add(row);
        }
        result.put("faDepDistributeInitData", distributeInfoLoadData);
        return faDepDistributeCollection;
    }

    private void configDistributeView(String lnkFaDepreEntryId, EntityViewInfo view) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)lnkFaDepreEntryId));
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("depDistribute.*"));
        coll.add(new SelectorItemInfo("depDistribute.accountView.*"));
        coll.add(new SelectorItemInfo("depDistribute.DepAsstActComposit.*"));
        coll.add(new SelectorItemInfo("depDistribute.DepAsstActComposit.asstActType.*"));
        view.setSelector(coll);
        view.setFilter(filter);
    }

    private void getActCompositInitData(Map<String, Object> result, FaDepDistributeCollection faDepDistributeCollection) throws BOSException, SQLException {
        if (faDepDistributeCollection.size() == 0) {
            result.put("asstActCompositInitData", "");
            return;
        }
        FaDepDistributeInfo depDistributeInfoForActC = faDepDistributeCollection.get(0);
        FaDepAsstActCompositCollection asstActCompositCollection = depDistributeInfoForActC.getDepAsstActComposit();
        String getAsstActItemObjSql = "select t.FNAME_L2 from T_FA_AssistActItem t where t.FID = ? and t.FASSTACTTYPE = ?";
        ArrayList asstActCompositLoadData = new ArrayList();
        for (int i = 0; i < asstActCompositCollection.size(); ++i) {
            FaDepAsstActCompositInfo asstActCompositInfo = asstActCompositCollection.get(i);
            HashMap<String, String> row = new HashMap<String, String>();
            row.put("asstActCompositInfoId", asstActCompositInfo.getId().toString());
            row.put("asstActType", asstActCompositInfo.getAsstActType().toString());
            ArrayList<String> params = new ArrayList<String>();
            params.add(asstActCompositInfo.getAsstActItem());
            params.add(asstActCompositInfo.getAsstActType().getId().toString());
            IRowSet asstActItemObjSet = DbUtil.executeQuery((Context)this.ctx, (String)getAsstActItemObjSql, (Object[])params.toArray());
            asstActItemObjSet.next();
            String asstActItemObj = asstActItemObjSet.getString("FNAME_L2");
            row.put("asstActItemObj", asstActItemObj);
            asstActCompositLoadData.add(row);
        }
        result.put("asstActCompositInitData", asstActCompositLoadData);
    }

    private void setReturnData(String orgID, IRowSet editRowSet, String realDep, Map<String, Object> result, String precision) throws SQLException, EASBizException, BOSException {
        editRowSet.next();
        String faCurCardNumber = editRowSet.getString("faCurCard.number");
        String assetCatName = editRowSet.getString("assetCat.name");
        String faCurCardAssetName = editRowSet.getString("faCurCard.assetName");
        String faCurCardSpecs = editRowSet.getString("faCurCard.specs");
        PeriodInfo currentPeriod = this.getCurrentPeriod(orgID);
        result.put("faCurCardNumber", faCurCardNumber);
        result.put("assetCatName", assetCatName);
        result.put("faCurCardAssetName", faCurCardAssetName);
        result.put("faCurCardSpecs", faCurCardSpecs);
        result.put("lnkFaDepreEntryDepreciation", realDep);
        result.put("precision", precision);
        result.put("currentPeriodYear", currentPeriod.getPeriodYear());
        result.put("currentPeriodNumber", currentPeriod.getPeriodNumber());
    }

    private void setExec(IQueryExecutor exec, EntityViewInfo view) {
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isIgnorePermissionCheck = true;
        exec.setObjectView(view);
    }

    private EntityViewInfo getFilter(String lnkFaDepreEntryId) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("lnkFaDepreEntry.id", (Object)lnkFaDepreEntryId, CompareType.EQUALS));
        view.setFilter(filter);
        return view;
    }

    @Override
    public Map<String, Object> getAccountingItemInfoByDisId(String distributeInfoId) throws BOSException, EASBizException, SQLException {
        EntityViewInfo view = this.getDistrbuteForAccItemsByIdView(distributeInfoId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        FaDepDistributeCollection faDepDistributeCollection = new FaDepDistributeCollection();
        faDepDistributeCollection = FaDepDistributeFactory.getLocalInstance((Context)this.ctx).getFaDepDistributeCollection(view);
        this.getActCompositInitData(result, faDepDistributeCollection);
        return result;
    }

    private EntityViewInfo getDistrbuteForAccItemsByIdView(String distributeInfoId) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)distributeInfoId));
        SelectorItemCollection coll = new SelectorItemCollection();
        coll.add(new SelectorItemInfo("DepAsstActComposit.*"));
        coll.add(new SelectorItemInfo("DepAsstActComposit.asstActType.*"));
        view.setFilter(filter);
        view.setSelector(coll);
        return view;
    }

    @Override
    public Map<String, Object> getWorkLoad(String orgID, String periodType) throws BOSException, EASBizException, SQLException {
        PeriodInfo period = this.decidePeriod(orgID, periodType);
        FaWorkLoadCollection workLoadCollection = this.queryWorkLoadCollection(orgID, period.getPeriodYear() + "", period.getPeriodNumber() + "");
        HashMap<String, Object> result = new HashMap<String, Object>();
        return this.getReturnValue(workLoadCollection, result);
    }

    private PeriodInfo decidePeriod(String orgID, String periodType) throws BOSException, EASBizException {
        PeriodInfo period = new PeriodInfo();
        period = this.getCurrentPeriod(orgID);
        if (periodType.equals("1")) {
            period = PeriodUtils.getPrePeriodInfo((PeriodInfo)period);
        }
        return period;
    }

    private Map<String, Object> getReturnValue(FaWorkLoadCollection workLoadCollection, Map<String, Object> result) {
        if (workLoadCollection == null) {
            result.put("faWorkLoadData", "");
            return result;
        }
        ArrayList faWorkLoadData = new ArrayList();
        for (int i = 0; i < workLoadCollection.size(); ++i) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            FaWorkLoadInfo workLoadInfo = workLoadCollection.get(i);
            if (workLoadInfo.getId() == null) {
                row.put("id", "");
            } else {
                row.put("id", workLoadInfo.getId().toString());
            }
            row.put("cardCat", workLoadInfo.getCurCard().getAssetCat().getName());
            row.put("number", workLoadInfo.getCurCard().getNumber());
            row.put("name", workLoadInfo.getCurCard().getAssetName());
            row.put("correntWorkLoad", workLoadInfo.getCurrentWorkLoad());
            row.put("totalWorkLoad", workLoadInfo.getTotalWorkLoad());
            row.put("sumWorkLoad", workLoadInfo.getSumWorkLoad());
            row.put("lastWorkLoad", workLoadInfo.getLastWorkLoad());
            row.put("cardId", workLoadInfo.getCurCard().getId().toString());
            row.put("oricorrentWorkLoad", workLoadInfo.getCurrentWorkLoad());
            faWorkLoadData.add(row);
        }
        result.put("faWorkLoadData", faWorkLoadData);
        return result;
    }

    private FaWorkLoadCollection queryWorkLoadCollection(String orgID, String periodPeriodYear, String periodPeriodNumber) throws BOSException, EASBizException {
        IFaWorkLoad workLoad = FaWorkLoadFactory.getLocalInstance((Context)this.ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo viewFilter = new FilterInfo();
        view.setFilter(viewFilter);
        FilterInfo workFilter = this.getWorkFilterInfo(periodPeriodYear, periodPeriodNumber);
        FaWorkLoadCollection workLoadCollection = null;
        workLoadCollection = workLoad.findWorkLoad(view, workFilter, orgID);
        return workLoadCollection;
    }

    public FilterInfo getWorkFilterInfo(String periodPeriodYear, String periodPeriodNumber) {
        FilterInfo workFilterInfo = new FilterInfo();
        FilterItemCollection filterItems = workFilterInfo.getFilterItems();
        FilterItemInfo filterItemInfo = new FilterItemInfo("period.periodYear", (Object)Integer.parseInt(periodPeriodYear));
        filterItems.add(filterItemInfo);
        filterItemInfo = new FilterItemInfo("period.periodNumber", (Object)Integer.parseInt(periodPeriodNumber));
        filterItems.add(filterItemInfo);
        return workFilterInfo;
    }

    @Override
    public Map<String, Object> workLoadSubmit(String orgID, String submitRlDataStr, String periodType) throws BOSException, EASBizException, SQLException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashSet<String> set = new HashSet<String>();
        String[] inputArray = submitRlDataStr.split("@");
        for (int i = 0; i < inputArray.length; i += 4) {
            if (inputArray[i] == null) continue;
            set.add(inputArray[i]);
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        PeriodInfo currentPeriod = this.getCurrentPeriod(orgID);
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)orgID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("period.id", (Object)currentPeriod.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        FaDepreciationCollection depreciationCollection = FaDepreciationFactory.getLocalInstance((Context)this.ctx).getFaDepreciationCollection(viewInfo);
        FaDepreciationInfo depreciationInfo = null;
        if (depreciationCollection != null && depreciationCollection.size() > 0) {
            depreciationInfo = depreciationCollection.get(0);
            FilterInfo filterInfo1 = new FilterInfo();
            filterInfo1.getFilterItems().add(new FilterItemInfo("faCurCard.id", set, CompareType.INCLUDE));
            filterInfo1.getFilterItems().add(new FilterItemInfo("LnkFaDepreEntry", (Object)depreciationInfo.getId().toString()));
            if (FaDepreciationEntryFactory.getLocalInstance((Context)this.ctx).exists(filterInfo1)) {
                result.put("msg", EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"52_FaWorkLoadEditUI"));
                return result;
            }
        }
        FaWorkLoadCollection entryCollection = new FaWorkLoadCollection();
        PeriodInfo period = this.decidePeriod(orgID, periodType);
        entryCollection = this.queryWorkLoadCollection(orgID, period.getPeriodYear() + "", period.getPeriodNumber() + "");
        for (int i = 0; i < entryCollection.size(); ++i) {
            for (int j = 0; j < inputArray.length; j += 4) {
                if (!entryCollection.get(i).getCurCard().getId().toString().equals(inputArray[j])) continue;
                entryCollection.get(i).setCurrentWorkLoad(new BigDecimal(inputArray[j + 1]));
                entryCollection.get(i).setSumWorkLoad(new BigDecimal(inputArray[j + 2]));
                entryCollection.get(i).setLastWorkLoad(new BigDecimal(inputArray[j + 3]));
            }
        }
        IFaWorkLoad workLoad = FaWorkLoadFactory.getLocalInstance((Context)this.ctx);
        workLoad.batchUpdate((IObjectCollection)entryCollection);
        result.put("msg", "");
        return result;
    }

    @Override
    public Map<String, Object> queryUndepPermission(String orgID) throws BOSException, EASBizException, SQLException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FaParamInfo aFaPasramInfo = this.queryCompanyParamItemInfo(orgID);
        result.put("canDepUnAudit", aFaPasramInfo.isCanDepUnAudit());
        return result;
    }

    private FaParamInfo queryCompanyParamItemInfo(String orgID) throws BOSException, EASBizException {
        FaParamInfo aFaPasramInfo = null;
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgID));
        IFaParamFacade iFaParamFacade = FaParamFacadeFactory.getLocalInstance((Context)this.ctx);
        aFaPasramInfo = iFaParamFacade.getFaParamInfo(aCompanyOrgUnitInfo);
        return aFaPasramInfo;
    }
}

