/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.cdo.CommonDataObject;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaContrastSolutionCollection;
import com.kingdee.eas.fi.fa.manage.FaContrastSolutionInfo;
import com.kingdee.eas.fi.fa.manage.services.IFaManageService;
import com.kingdee.eas.fi.fa.manage.services.impl.BatchAddCardImpl;
import com.kingdee.eas.fi.fa.manage.services.impl.CompanyDataImpl;
import com.kingdee.eas.fi.fa.manage.services.impl.FaCardSubmit;
import com.kingdee.eas.fi.fa.manage.services.impl.FaContrastCalculator;
import com.kingdee.eas.fi.fa.manage.services.impl.MainOrgFilterImpl;
import com.kingdee.eas.fi.fa.manage.services.impl.predepre.FaPreDepre;
import com.kingdee.eas.fi.fa.manage.services.util.FaServerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.fi.fa.manage.services.IFaManageService"})
public class FaManageService
implements IFaManageService {
    private Context context = null;

    public FaManageService(Context context) {
        this.context = context;
    }

    @Override
    public Map<String, Object> batchAddCard(String bosType, String cardId, int addNumber) throws BOSException, EASBizException {
        return new BatchAddCardImpl(this.context).batchAddCard(bosType, cardId, addNumber);
    }

    @Override
    public String submitFaCard(CommonDataObject dataObject) throws BOSException, EASBizException {
        return new FaCardSubmit(this.context).submitFaCard(dataObject);
    }

    @Override
    public Map<String, Object> initFaContrastData(String mainOrgUnitId, String permissionItem) throws BOSException, EASBizException {
        HashMap<String, Object> info = new HashMap<String, Object>();
        CompanyOrgUnitInfo mainOrgUnit = null;
        if (mainOrgUnitId != null) {
            SelectorItemCollection sic = FaServerUtil.getOrgInfoSelector(OrgType.Company);
            mainOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)this.context).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainOrgUnitId), sic);
        } else {
            mainOrgUnit = (CompanyOrgUnitInfo)FaServerUtil.getDefaultMainBizOrg(this.context, OrgType.Company, permissionItem);
        }
        info.put("company", mainOrgUnit);
        if (mainOrgUnit != null) {
            FilterInfo filter = new MainOrgFilterImpl(this.context).getFilterInfo(permissionItem);
            info.put("mainorgfilter", filter.toSql());
            String oql = "select orgID,ownerID,name where orgID='" + mainOrgUnit.getId().toString() + "' order by name";
            IObjectCollection solutions = DynamicObjectFactory.getLocalInstance((Context)this.context).getCollection(new BOSObjectType("0CE4859F"), oql);
            info.put("solutions", solutions);
            List<Integer> years = new CompanyDataImpl(this.context).getPeriodYearRange(mainOrgUnit);
            info.put("years", years);
        }
        return info;
    }

    @Override
    public Map<String, Object> faContrastCalculate(String solutionId, int periodYear, int periodNumber) throws BOSException, EASBizException {
        return new FaContrastCalculator(this.context).calculate(solutionId, periodYear, periodNumber);
    }

    @Override
    public FaContrastSolutionInfo getFaContrastSolution(String solutionId) throws BOSException, EASBizException {
        return new FaContrastCalculator(this.context).getSolution(solutionId);
    }

    @Override
    public FaContrastSolutionInfo saveContrastSolution(CommonDataObject solutionObj) throws BOSException, EASBizException {
        return new FaContrastCalculator(this.context).saveSolution(solutionObj);
    }

    @Override
    public FaContrastSolutionCollection getFaContrastSolutions(String orgUnitId) throws BOSException, EASBizException {
        return new FaContrastCalculator(this.context).getSolutions(orgUnitId);
    }

    @Override
    public void deleteContrastSolution(String orgUnitId) throws BOSException, EASBizException {
        new FaContrastCalculator(this.context).deleteSolution(orgUnitId);
    }

    @Override
    public Map<String, Object> preDepre(CommonDataObject faCardInfo) throws BOSException, EASBizException {
        return new FaPreDepre(this.context).preDepre(faCardInfo);
    }

    @Override
    public Map<String, Object> faContrast(String companyId, int periodYear, int periodNumber) throws BOSException, EASBizException {
        return new FaContrastCalculator(this.context).contrast(companyId, periodYear, periodNumber);
    }
}

