/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.services.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import sun.misc.Compare;
import sun.misc.Sort;

public class FaServerUtil {
    public static OrgUnitInfo getDefaultMainBizOrg(Context context, OrgType orgType, String permissionItem) throws EASBizException, BOSException {
        OrgUnitInfo currentMainOrg = ContextUtil.getCurrentOrgUnit((Context)context, (OrgType)orgType);
        OrgUnitInfo[] mainOrgs = FaServerUtil.getAuthorizedBizOrgUnits(context, (IObjectPK)new ObjectStringPK(currentMainOrg.getId().toString()), orgType, permissionItem);
        if (mainOrgs == null || mainOrgs.length == 0) {
            return null;
        }
        if (mainOrgs.length > 0) {
            mainOrgs = (OrgUnitInfo[])FaServerUtil.sortDataByNumber((DataBaseInfo[])mainOrgs, true);
        }
        if (currentMainOrg != null && mainOrgs.length > 0) {
            for (int i = 0; i < mainOrgs.length; ++i) {
                if (!currentMainOrg.getId().toString().equals(mainOrgs[i].getId().toString())) continue;
                return mainOrgs[i];
            }
        }
        if (mainOrgs.length > 0) {
            return mainOrgs[0];
        }
        return null;
    }

    public static DataBaseInfo[] sortDataByNumber(DataBaseInfo[] datas, boolean isAsc) {
        if (datas == null || datas.length < 2) {
            return datas;
        }
        class DataCompare
        implements Compare {
            private boolean isAsc = true;

            public DataCompare(boolean isAsc) {
                this.isAsc = isAsc;
            }

            public int doCompare(Object arg0, Object arg1) {
                return this.isAsc ? ((DataBaseInfo)arg0).getNumber().compareTo(((DataBaseInfo)arg1).getNumber()) : ((DataBaseInfo)arg1).getNumber().compareTo(((DataBaseInfo)arg0).getNumber());
            }
        }
        Sort.quicksort((Object[])datas, (Compare)new DataCompare(isAsc));
        return datas;
    }

    public static OrgUnitInfo[] getAuthorizedBizOrgUnits(Context context, IObjectPK userPK, OrgType orgType, String permissionItem) throws EASBizException, BOSException {
        OrgUnitCollection collection = FaServerUtil.getAuthOrgByPermItem(context, orgType, permissionItem);
        IObjectCollection bizOrgs = FaServerUtil.getOrgUnitInfosByType(context, collection, orgType);
        if (bizOrgs == null) {
            return null;
        }
        int size = bizOrgs.size();
        OrgUnitInfo[] results = new OrgUnitInfo[size];
        if (size > 0) {
            Object[] objects = bizOrgs.toArray();
            System.arraycopy(objects, 0, results, 0, size);
        }
        return results;
    }

    public static OrgUnitCollection getAuthOrgByPermItem(Context context, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        IPermission permission = PermissionFactory.getLocalInstance((Context)context);
        if (orgType == null) {
            return null;
        }
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        FullOrgUnitCollection result = permission.getAuthorizedOrg(context.getCaller(), orgType, (IObjectPK)treePK, permItem);
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        return collection;
    }

    public static IObjectCollection getOrgUnitInfosByType(Context ctx, OrgUnitCollection orgs, OrgType orgType) throws BOSException {
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.size(); ++i) {
            keys.add(orgs.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        if (!orgType.equals((Object)OrgType.Admin)) {
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Boolean.TRUE, CompareType.EQUALS));
        }
        view.setFilter(filter);
        view.setSelector(FaServerUtil.getOrgInfoSelector(orgType));
        BOSObjectType bosType = FaServerUtil.getOrgBOSType(orgType);
        if (bosType == null) {
            return null;
        }
        return DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(bosType, view);
    }

    public static BOSObjectType getOrgBOSType(OrgType orgType) {
        BOSObjectType bosType = null;
        if (OrgType.Company.equals((Object)orgType)) {
            bosType = new BOSObjectType("16FD9F90");
        } else if (OrgType.Admin.equals((Object)orgType)) {
            bosType = new BOSObjectType("6A6435BE");
        } else if (OrgType.Purchase.equals((Object)orgType)) {
            bosType = new BOSObjectType("DF1A22A2");
        } else if (OrgType.Storage.equals((Object)orgType)) {
            bosType = new BOSObjectType("EB1F7FD2");
        } else if (OrgType.Sale.equals((Object)orgType)) {
            bosType = new BOSObjectType("6F9FB21C");
        }
        return bosType;
    }

    public static SelectorItemCollection getOrgInfoSelector(OrgType orgType) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("CU.id"));
        selector.add(new SelectorItemInfo("isCU"));
        selector.add(new SelectorItemInfo("isBizUnit"));
        selector.add(new SelectorItemInfo("isSaleOrgUnit"));
        selector.add(new SelectorItemInfo("isAdminOrgUnit"));
        selector.add(new SelectorItemInfo("isPurchaseOrgUnit"));
        selector.add(new SelectorItemInfo("isStorageOrgUnit"));
        selector.add(new SelectorItemInfo("isCompanyOrgUnit"));
        selector.add(new SelectorItemInfo("isTransportOrgUnit"));
        selector.add(new SelectorItemInfo("isFreeze"));
        selector.add(new SelectorItemInfo("isGrouping"));
        selector.add(new SelectorItemInfo("isCostOrgUnit"));
        selector.add(new SelectorItemInfo("isStart"));
        selector.add(new SelectorItemInfo("code"));
        selector.add(new SelectorItemInfo("orgTypeStr"));
        if (OrgType.Company.equals((Object)orgType)) {
            selector.add(new SelectorItemInfo("baseExchangeTable.id"));
            selector.add(new SelectorItemInfo("baseCurrency.id"));
            selector.add(new SelectorItemInfo("baseCurrency.name"));
            selector.add(new SelectorItemInfo("baseCurrency.number"));
            selector.add(new SelectorItemInfo("baseCurrency.precision"));
            selector.add(new SelectorItemInfo("accountTable.id"));
            selector.add(new SelectorItemInfo("accountTable.name"));
            selector.add(new SelectorItemInfo("accountTable.number"));
            selector.add(new SelectorItemInfo("accountPeriodType.id"));
            selector.add(new SelectorItemInfo("accountPeriodType.name"));
            selector.add(new SelectorItemInfo("accountPeriodType.number"));
        }
        return selector;
    }

    public static Date getBizDate(CompanyOrgUnitInfo company, PeriodInfo currenctPeriod) {
        Date bizDate = new Date(System.currentTimeMillis());
        bizDate = DateTimeUtils.truncateDate((Date)bizDate);
        if (currenctPeriod == null || company == null) {
            return bizDate;
        }
        if (DateTimeUtils.dayBefore((Date)bizDate, (Date)currenctPeriod.getBeginDate())) {
            bizDate = currenctPeriod.getBeginDate();
        }
        if (DateTimeUtils.dayAfter((Date)bizDate, (Date)currenctPeriod.getEndDate())) {
            bizDate = currenctPeriod.getEndDate();
        }
        bizDate = new Date(bizDate.getTime());
        return bizDate;
    }

    public static IQueryExecutor getQueryExecutor(Context context, IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)context, (IMetaDataPK)queryPK);
        exec.setObjectView(viewInfo);
        return exec;
    }

    public static void mergeSelector(SelectorItemCollection sic, String selector) {
    }

    public static IObjectValue getInfoById(IObjectCollection cols, String id) {
        IObjectValue info = null;
        for (int i = 0; i < cols.size() && !id.equals((info = cols.getObject(i)).getBOSUuid("id").toString()); ++i) {
        }
        return info;
    }

    public static SelectorItemCollection getSelectors(String selectorAll) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("assetAmt"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("measureUnit.*"));
        } else {
            sic.add(new SelectorItemInfo("measureUnit.id"));
            sic.add(new SelectorItemInfo("measureUnit.number"));
            sic.add(new SelectorItemInfo("measureUnit.name"));
        }
        sic.add(new SelectorItemInfo("accountDate"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("storeCity.*"));
        } else {
            sic.add(new SelectorItemInfo("storeCity.id"));
            sic.add(new SelectorItemInfo("storeCity.number"));
            sic.add(new SelectorItemInfo("storeCity.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("economicPurp.*"));
        } else {
            sic.add(new SelectorItemInfo("economicPurp.id"));
            sic.add(new SelectorItemInfo("economicPurp.number"));
            sic.add(new SelectorItemInfo("economicPurp.name"));
        }
        sic.add(new SelectorItemInfo("specs"));
        sic.add(new SelectorItemInfo("pArea"));
        sic.add(new SelectorItemInfo("mfr"));
        sic.add(new SelectorItemInfo("levFrDate"));
        sic.add(new SelectorItemInfo("paperNo"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("company.*"));
        } else {
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("company.number"));
            sic.add(new SelectorItemInfo("company.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("dept.*"));
        } else {
            sic.add(new SelectorItemInfo("dept.id"));
            sic.add(new SelectorItemInfo("dept.number"));
            sic.add(new SelectorItemInfo("dept.name"));
            sic.add(new SelectorItemInfo("dept.isLeaf"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("keeper.*"));
        } else {
            sic.add(new SelectorItemInfo("keeper.id"));
            sic.add(new SelectorItemInfo("keeper.number"));
            sic.add(new SelectorItemInfo("keeper.name"));
        }
        sic.add(new SelectorItemInfo("originType"));
        sic.add(new SelectorItemInfo("originUnit"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("originMethod.*"));
        } else {
            sic.add(new SelectorItemInfo("originMethod.id"));
            sic.add(new SelectorItemInfo("originMethod.number"));
            sic.add(new SelectorItemInfo("originMethod.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("useStatus.*"));
        } else {
            sic.add(new SelectorItemInfo("useStatus.id"));
            sic.add(new SelectorItemInfo("useStatus.number"));
            sic.add(new SelectorItemInfo("useStatus.name"));
        }
        sic.add(new SelectorItemInfo("fiAccountDate"));
        sic.add(new SelectorItemInfo("wrtyPeriod"));
        sic.add(new SelectorItemInfo("wrtyNumber"));
        sic.add(new SelectorItemInfo("tempUseTermCount"));
        sic.add(new SelectorItemInfo("tempDeprTermCount"));
        sic.add(new SelectorItemInfo("tempDeprMethod"));
        sic.add(new SelectorItemInfo("isOveraged"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("originAmt"));
        sic.add(new SelectorItemInfo("addons"));
        sic.add(new SelectorItemInfo("exRate"));
        sic.add(new SelectorItemInfo("assetValue"));
        sic.add(new SelectorItemInfo("initEvalValue"));
        sic.add(new SelectorItemInfo("buyValue"));
        sic.add(new SelectorItemInfo("buyAccuDepr"));
        sic.add(new SelectorItemInfo("evalLeftPeriod"));
        sic.add(new SelectorItemInfo("useYears"));
        sic.add(new SelectorItemInfo("deliverDate"));
        sic.add(new SelectorItemInfo("startUseDate"));
        sic.add(new SelectorItemInfo("useTermCount"));
        sic.add(new SelectorItemInfo("deprTermCount"));
        sic.add(new SelectorItemInfo("accuDepr"));
        sic.add(new SelectorItemInfo("neatRemValue"));
        sic.add(new SelectorItemInfo("accuDeprTYear"));
        sic.add(new SelectorItemInfo("decValue"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("deprMethod.*"));
        } else {
            sic.add(new SelectorItemInfo("deprMethod.id"));
            sic.add(new SelectorItemInfo("deprMethod.number"));
            sic.add(new SelectorItemInfo("deprMethod.name"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("measureUnitWL.*"));
        } else {
            sic.add(new SelectorItemInfo("measureUnitWL.id"));
            sic.add(new SelectorItemInfo("measureUnitWL.number"));
            sic.add(new SelectorItemInfo("measureUnitWL.name"));
        }
        sic.add(new SelectorItemInfo("neatValue"));
        sic.add(new SelectorItemInfo("neatAmt"));
        sic.add(new SelectorItemInfo("accuDeprAll"));
        sic.add(new SelectorItemInfo("monthDepreRate"));
        sic.add(new SelectorItemInfo("treatmentIncome"));
        sic.add(new SelectorItemInfo("fairValue"));
        sic.add(new SelectorItemInfo("neatLeftRate"));
        sic.add(new SelectorItemInfo("addonFare"));
        sic.add(new SelectorItemInfo("inputTax"));
        sic.add(new SelectorItemInfo("evalAssetValue"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("evalDeprMode.*"));
        } else {
            sic.add(new SelectorItemInfo("evalDeprMode.id"));
            sic.add(new SelectorItemInfo("evalDeprMode.number"));
            sic.add(new SelectorItemInfo("evalDeprMode.name"));
        }
        sic.add(new SelectorItemInfo("evalMonthRate"));
        sic.add(new SelectorItemInfo("evalNeatLeftRate"));
        sic.add(new SelectorItemInfo("evalRemValue"));
        sic.add(new SelectorItemInfo("evalDecValue"));
        sic.add(new SelectorItemInfo("evalNeatValue"));
        sic.add(new SelectorItemInfo("evalNeatAmt"));
        sic.add(new SelectorItemInfo("evalDeprTTerm"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("evalMeasureUnitWL.*"));
        } else {
            sic.add(new SelectorItemInfo("evalMeasureUnitWL.id"));
            sic.add(new SelectorItemInfo("evalMeasureUnitWL.number"));
            sic.add(new SelectorItemInfo("evalMeasureUnitWL.name"));
        }
        sic.add(new SelectorItemInfo("evalYearDepr"));
        sic.add(new SelectorItemInfo("evalAddDepr"));
        sic.add(new SelectorItemInfo("evalTaxLeftPeriod"));
        sic.add(new SelectorItemInfo("evalDeprPeriodNum"));
        sic.add(new SelectorItemInfo("evalUseTermCount"));
        sic.add(new SelectorItemInfo("evalReInAccountDate"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("accountAsset.*"));
        } else {
            sic.add(new SelectorItemInfo("accountAsset.id"));
            sic.add(new SelectorItemInfo("accountAsset.number"));
            sic.add(new SelectorItemInfo("accountAsset.name"));
            sic.add(new SelectorItemInfo("accountAsset.longName"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("accountAccuDepr.*"));
        } else {
            sic.add(new SelectorItemInfo("accountAccuDepr.id"));
            sic.add(new SelectorItemInfo("accountAccuDepr.number"));
            sic.add(new SelectorItemInfo("accountAccuDepr.name"));
            sic.add(new SelectorItemInfo("accountAccuDepr.longName"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("accountDecValue.*"));
        } else {
            sic.add(new SelectorItemInfo("accountDecValue.id"));
            sic.add(new SelectorItemInfo("accountDecValue.number"));
            sic.add(new SelectorItemInfo("accountDecValue.name"));
            sic.add(new SelectorItemInfo("accountDecValue.longName"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.id"));
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.name"));
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.number"));
        }
        sic.add(new SelectorItemInfo("faCurCostCenter.remark"));
        sic.add(new SelectorItemInfo("faCurCostCenter.apportionScale"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.id"));
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.name"));
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.id"));
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.name"));
            sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurCostCenter.accountView.id"));
        }
        sic.add(new SelectorItemInfo("faCurFacility.facilityNumber"));
        sic.add(new SelectorItemInfo("faCurFacility.facilityName"));
        sic.add(new SelectorItemInfo("faCurFacility.facilityModel"));
        sic.add(new SelectorItemInfo("faCurFacility.registerDate"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurFacility.storePlace.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurFacility.storePlace.id"));
            sic.add(new SelectorItemInfo("faCurFacility.storePlace.name"));
            sic.add(new SelectorItemInfo("faCurFacility.storePlace.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurFacility.measureUnit.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurFacility.measureUnit.id"));
            sic.add(new SelectorItemInfo("faCurFacility.measureUnit.name"));
            sic.add(new SelectorItemInfo("faCurFacility.measureUnit.number"));
        }
        sic.add(new SelectorItemInfo("faCurFacility.quantity"));
        sic.add(new SelectorItemInfo("faCurFacility.amount"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurFacility.keeper.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurFacility.keeper.id"));
            sic.add(new SelectorItemInfo("faCurFacility.keeper.name"));
            sic.add(new SelectorItemInfo("faCurFacility.keeper.number"));
        }
        sic.add(new SelectorItemInfo("faCurFacility.remark"));
        sic.add(new SelectorItemInfo("faCurFacility.id"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.id"));
            sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.name"));
            sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.number"));
        }
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("faCurDepartment.usePerson.*"));
        } else {
            sic.add(new SelectorItemInfo("faCurDepartment.usePerson.id"));
            sic.add(new SelectorItemInfo("faCurDepartment.usePerson.name"));
            sic.add(new SelectorItemInfo("faCurDepartment.usePerson.number"));
        }
        sic.add(new SelectorItemInfo("faCurDepartment.usage"));
        sic.add(new SelectorItemInfo("faCurDepartment.remark"));
        sic.add(new SelectorItemInfo("faCurDepartment.id"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("assetCat.*"));
        } else {
            sic.add(new SelectorItemInfo("assetCat.id"));
            sic.add(new SelectorItemInfo("assetCat.number"));
            sic.add(new SelectorItemInfo("assetCat.name"));
            sic.add(new SelectorItemInfo("assetCat.displayName"));
        }
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("assetName"));
        if (selectorAll.equalsIgnoreCase("true")) {
            sic.add(new SelectorItemInfo("creator.*"));
        } else {
            sic.add(new SelectorItemInfo("creator.id"));
            sic.add(new SelectorItemInfo("creator.number"));
            sic.add(new SelectorItemInfo("creator.name"));
        }
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("remark"));
        sic.add(new SelectorItemInfo("oldNumber"));
        sic.add(new SelectorItemInfo("groupNumber"));
        sic.add(new SelectorItemInfo("barCode"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.isoCode"));
        sic.add(new SelectorItemInfo("currency.sign"));
        sic.add(new SelectorItemInfo("currency.baseUnit"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("assetCat.isDeductInputTax"));
        sic.add(new SelectorItemInfo("assetCat.isLeaf"));
        sic.add(new SelectorItemInfo("assetCat.displayName"));
        sic.add(new SelectorItemInfo("assetCat.calcuByEvaluate"));
        sic.add(new SelectorItemInfo("assetCat.DepreciationPolicy.*"));
        sic.add(new SelectorItemInfo("assetCat.measureUnit.name"));
        sic.add(new SelectorItemInfo("assetCat.measureUnit.number"));
        sic.add(new SelectorItemInfo("assetCat.depreMode.number"));
        sic.add(new SelectorItemInfo("assetCat.depreMode.name"));
        sic.add(new SelectorItemInfo("assetCat.depreMode.isCustom"));
        sic.add(new SelectorItemInfo("assetCat.depreMode.isWorkload"));
        sic.add(new SelectorItemInfo("assetCat.classfication.*"));
        sic.add(new SelectorItemInfo("assetCat.classfication.detailCollection.*"));
        sic.add(new SelectorItemInfo("assetCat.classfication.number"));
        sic.add(new SelectorItemInfo("assetCat.company.name"));
        sic.add(new SelectorItemInfo("assetCat.creator.name"));
        sic.add(new SelectorItemInfo("assetCat.creator.name"));
        sic.add(new SelectorItemInfo("assetCat.creator.name"));
        sic.add(new SelectorItemInfo("assetCat.creator.name"));
        sic.add(new SelectorItemInfo("assetCat.id"));
        sic.add(new SelectorItemInfo("assetCat.numberRule"));
        sic.add(new SelectorItemInfo("assetCat.number"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("effectedStatus"));
        sic.add(new SelectorItemInfo("checkedStatus"));
        sic.add(new SelectorItemInfo("originMethod.isLeaf"));
        sic.add(new SelectorItemInfo("useStatus.isLeaf"));
        sic.add(new SelectorItemInfo("useStatus.isDepreciation"));
        sic.add(new SelectorItemInfo("economicPurp.isLeaf"));
        sic.add(new SelectorItemInfo("accountAsset.isLeaf"));
        sic.add(new SelectorItemInfo("accountAccuDepr.isLeaf"));
        sic.add(new SelectorItemInfo("accountDecValue.isLeaf"));
        sic.add(new SelectorItemInfo("faCurFacility.seq"));
        sic.add(new SelectorItemInfo("faCurDepartment.seq"));
        sic.add(new SelectorItemInfo("faCurCostCenter.seq"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActType.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.asstActItem.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.isLeaf"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.longName"));
        sic.add(new SelectorItemInfo("faCurCostCenter.accountView.name"));
        sic.add(new SelectorItemInfo("accountAsset.longName"));
        sic.add(new SelectorItemInfo("accountAccuDepr.longName"));
        sic.add(new SelectorItemInfo("accountDecValue.longName"));
        sic.add(new SelectorItemInfo("deprMethod.isCustom"));
        sic.add(new SelectorItemInfo("deprMethod.isWorkload"));
        sic.add(new SelectorItemInfo("period.beginDate"));
        sic.add(new SelectorItemInfo("period.endDate"));
        sic.add(new SelectorItemInfo("period.periodYear"));
        sic.add(new SelectorItemInfo("period.periodNumber"));
        sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.displayName"));
        sic.add(new SelectorItemInfo("evalDeprMode.isCustom"));
        sic.add(new SelectorItemInfo("evalDeprMode.isWorkload"));
        return sic;
    }

    public static void checkFaInit(Context ctx, CompanyOrgUnitInfo aCompanyOrgUnitInfo) throws EASBizException, BOSException {
        boolean isInitEnd = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        if (!isInitEnd) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaCardResource.FaCurCardEditUI_FANotEndInit");
            throw new BOSException(strMsg);
        }
    }

    public static void checkForGenVoucher(Context ctx, CompanyOrgUnitInfo aCompanyOrgUnitInfo) throws EASBizException, BOSException {
        String strMsg = "";
        boolean isRelAccount = SystemStatusCtrolUtils.isRelAccount((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        if (!isRelAccount) {
            throw new FaCardException(FaCardException.CANNOT_GEN_VOUCHER);
        }
    }

    public static Map getPeriodRange(Context ctx, Set companyIdSet, String periodTypeId) throws BOSException, EASBizException {
        HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
        String sql = FaServerUtil.getPeriodRangeSQL(companyIdSet, periodTypeId);
        IRowSet rs = periodTypeId != null ? DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{periodTypeId, periodTypeId, periodTypeId}) : DbUtil.executeQuery((Context)ctx, (String)sql);
        int[] yearRange = new int[]{-1, -1};
        int maxYear = -1;
        int maxPeriod = -1;
        int minYear = -1;
        int minPeriod = -1;
        try {
            while (rs.next()) {
                int year = rs.getInt("FPeriodYear");
                yearRange[0] = yearRange[0] == -1 ? year : yearRange[0];
                yearRange[1] = year;
                int[] periodRange = new int[]{rs.getInt("MinNumber"), rs.getInt("MaxNumber")};
                if (periodRange[0] <= 0 || periodRange[1] <= 0) {
                    throw new ReportException(ReportException.PERIOD_TYPE_ERROR);
                }
                map.put(new Integer(year), periodRange);
                if (year > maxYear) {
                    maxYear = year;
                    maxPeriod = periodRange[1];
                }
                if (year >= minYear && minYear != -1) continue;
                minYear = year;
                minPeriod = periodRange[0];
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        if (yearRange[0] <= 0 || yearRange[1] <= 0 || map.size() <= 0) {
            throw new ReportException(ReportException.PERIOD_TYPE_ERROR);
        }
        HashMap<String, Object> allMap = new HashMap<String, Object>();
        allMap.put("usedPeriod", map);
        allMap.put("queryPeriod", FaServerUtil.getQueryPeriod(ctx, periodTypeId, minYear, minPeriod));
        allMap.put("currentPeriod", new int[]{maxYear, maxPeriod});
        return allMap;
    }

    private static String getPeriodRangeSQL(Set companyIdSet, String periodTypeId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT TP.FPeriodYear, Min(TP.FPeriodNumber) MinNumber, Max(TP.FPeriodNumber) MaxNumber ");
        sql.append(" FROM T_BD_Period TP,(SELECT Min(TPS.FNumber) FBeginDate,Max(TPC.FNumber) FEndDate ");
        sql.append(" FROM T_BD_SystemStatusCtrol TSSC ");
        sql.append(" INNER JOIN T_BD_SystemStatus tsst ON TSSC.FSystemStatusID=tsst.fid and TSST.fname=").append(14);
        sql.append(" INNER JOIN T_BD_Period TPS\tON TSSC.FStartPeriodID = TPS.FID \t\t\t\t\t\t\t\r\n");
        sql.append(" INNER JOIN T_BD_Period TPC\tON TSSC.FCurrentPeriodID = TPC.FID\t\t\t\t\t\t\t\r\n");
        sql.append(" WHERE TSSC.FCompanyID in (");
        Iterator it = companyIdSet.iterator();
        sql.append("'").append(it.next()).append("'");
        while (it.hasNext()) {
            sql.append(",'").append(it.next()).append("'");
        }
        sql.append(")");
        if (periodTypeId != null) {
            sql.append(" AND TPS.FTypeID = ? AND TPC.FTypeID = ? ");
        }
        sql.append(" ) TPRange ");
        sql.append(" WHERE TP.FNumber >= TPRange.FBeginDate");
        sql.append(" AND TP.FNumber <= TPRange.FEndDate ");
        if (periodTypeId != null) {
            sql.append(" AND TP.FTypeID = ? ");
        }
        sql.append(" GROUP BY TP.FPeriodYear ");
        sql.append(" ORDER BY TP.FPeriodYear ");
        return sql.toString();
    }

    private static Map getQueryPeriod(Context ctx, String periodTypeId, int startYear, int startPeriod) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT TP.FPeriodYear, Min(TP.FPeriodNumber) MinNumber, Max(TP.FPeriodNumber) MaxNumber ");
        sql.append(" FROM T_BD_Period TP ");
        sql.append(" WHERE TP.FNUMBER >= ?");
        if (periodTypeId != null) {
            sql.append(" and TP.FTypeID = ? ");
        }
        sql.append(" GROUP BY TP.FPeriodYear ");
        sql.append(" ORDER BY TP.FPeriodYear ");
        Object[] params = periodTypeId != null ? new Object[]{new Integer(startYear * 100 + startPeriod), periodTypeId} : new Object[]{new Integer(startYear * 100 + startPeriod)};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
        try {
            while (rs.next()) {
                int year = rs.getInt("FPeriodYear");
                int[] periodRange = new int[]{rs.getInt("MinNumber"), rs.getInt("MaxNumber")};
                map.put(new Integer(year), periodRange);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return map;
    }

    public static String getCompanyFilterSQL(String userId, String permssiomId, boolean isFunPerm, CompanyOrgUnitInfo root, String periodTypeID, boolean onlyLeaf, AcountSchemeInfo acountScheme, boolean queryByAccountScheme) {
        StringBuffer sql = new StringBuffer();
        sql.append(" from t_bd_systemstatusctrol ssc ");
        sql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = ").append(14);
        sql.append(" inner join t_org_company cp on cp.fid = ssc.fcompanyid ");
        if (!onlyLeaf) {
            sql.append(" inner join t_org_company pcp on charindex(pcp.flongnumber||'!', cp.flongnumber) = 1 or pcp.fid = cp.fid ");
        }
        sql.append(" where ssc.fstartperiodid is not null ");
        if (acountScheme != null) {
            if (acountScheme.isIsMaster()) {
                sql.append(" and cp.fisAssistantOrg = 0");
            } else if (queryByAccountScheme && acountScheme.getId() != null) {
                sql.append(" and cp.fisAssistantOrg = 1 and cp.faccountschemeid = '").append(acountScheme.getId()).append("'");
            } else {
                sql.append(" and cp.fisAssistantOrg = 1 ");
            }
        }
        sql.append(" and cp.fisbizunit = 1 ");
        sql.append(" and cp.faccounttableid is not null ");
        if (periodTypeID != null) {
            sql.append(" and cp.faccountperiodid = '").append(periodTypeID).append("'");
        }
        if (root != null && !onlyLeaf) {
            sql.append(" and (pcp.flongnumber like '").append(root.getLongNumber()).append("!%' or pcp.fid = '").append(root.getId().toString()).append("')");
        } else if (root != null && onlyLeaf) {
            sql.append(" and (cp.flongnumber like '").append(root.getLongNumber()).append("!%' or cp.fid = '").append(root.getId().toString()).append("')");
        }
        if (isFunPerm) {
            sql.append(" and cp.fid in (").append(FaServerUtil.getOrgPermissonSQL(userId, permssiomId)).append(")");
        }
        return sql.toString();
    }

    public static String getOrgPermissonSQL(String userId, String permssiomId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT UserOrgPerm.FOrgID FOrgID ");
        sql.append(" FROM T_PM_UserOrgPerm UserOrgPerm WHERE UserOrgPerm.FOwner = '").append(userId).append("'");
        sql.append(" AND UserOrgPerm.FPermItemID = '").append(permssiomId).append("'");
        sql.append(" UNION ALL");
        sql.append(" SELECT UserRoleOrg.FOrgID AS FOrgID FROM T_PM_RolePerm RolePerm ");
        sql.append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON  RolePerm.FRoleID = UserRoleOrg.FRoleID");
        sql.append(" WHERE UserRoleOrg.FUserID = '").append(userId).append("'");
        sql.append(" AND RolePerm.FPermItemID = '").append(permssiomId).append("'");
        return sql.toString();
    }
}

