/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.cdo.utils.CDOUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.LanguageInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IVoucherAbstract;
import com.kingdee.eas.basedata.assistant.VoucherAbstractCollection;
import com.kingdee.eas.basedata.assistant.VoucherAbstractFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.app.AssistUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.gl.AsstDataChangeEvent;
import com.kingdee.eas.fi.gl.AsstDataChangeResult;
import com.kingdee.eas.fi.gl.AsstF7Config;
import com.kingdee.eas.fi.gl.GLGeneralFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.asstf7.AsstDataChangeConfig;
import com.kingdee.eas.fi.gl.app.asstf7.AsstF7ConfigFactory;
import com.kingdee.eas.fi.gl.app.asstf7.GLF7Parameter;
import com.kingdee.eas.fi.gl.services.AsstDataChangedResult;
import com.kingdee.eas.fi.gl.services.GLBaseService;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.fi.gl.services.GLBaseService"})
@Description(value="\u603b\u8d26\u7cfb\u7edf\u57fa\u7840\u670d\u52a1")
public class GLBaseServiceImpl
implements GLBaseService {
    private final Context ctx;

    public GLBaseServiceImpl(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public CompanyOrgUnitInfo getFirstCompany(String funPermissionId) throws EASBizException, BOSException {
        return GLGeneralFacadeFactory.getLocalInstance((Context)this.ctx).getFirstCompany(funPermissionId);
    }

    @Override
    public String getAssistantHG(String asstAccountId, Map<String, String> asstDataBaseIdMap) throws EASBizException, BOSException {
        if (asstAccountId == null || "".equals(asstAccountId.trim()) || asstDataBaseIdMap == null || asstDataBaseIdMap.isEmpty()) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectors = view.getSelector();
        selectors.add(new SelectorItemInfo("id"));
        FilterInfo fi = new FilterInfo();
        view.setFilter(fi);
        FilterItemCollection filters = fi.getFilterItems();
        filters.add(new FilterItemInfo("asstAccount.id", (Object)asstAccountId));
        AsstActGroupDetailCollection detailColl = this.getAsstAccountDetailCollection(asstAccountId);
        for (AsstActGroupDetailInfo tetailInfo : detailColl) {
            String propName = tetailInfo.getAsstActType().getAsstHGAttribute();
            String value = asstDataBaseIdMap.get(propName);
            if (value != null) {
                filters.add(new FilterItemInfo(propName + ".id", (Object)value));
                continue;
            }
            filters.add(new FilterItemInfo(propName, null));
        }
        AssistantHGCollection hgColl = AssistantHGFactory.getLocalInstance((Context)this.ctx).getAssistantHGCollection(view);
        if (hgColl.size() > 0) {
            return hgColl.get(0).getId().toString();
        }
        return this.addNewAssistantHG(asstAccountId, detailColl, asstDataBaseIdMap);
    }

    private String addNewAssistantHG(String asstAccountId, AsstActGroupDetailCollection detailColl, Map<String, String> asstDataBaseIdMap) throws EASBizException, BOSException {
        AssistantHGInfo assGrp = new AssistantHGInfo();
        AsstAccountInfo asstAccountInfo = new AsstAccountInfo();
        asstAccountInfo.setId(BOSUuid.read((String)asstAccountId));
        assGrp.setAsstAccount(asstAccountInfo);
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx);
        LanguageCollection langs = loader.getSolution().getLanguages();
        Locale[] locales = new Locale[langs.size()];
        int count = 0;
        for (LanguageInfo lang : langs) {
            locales[count++] = lang.getLocale();
        }
        String defaultLocaleId = this.ctx.getLocale().toString();
        for (int i = 0; i < locales.length; ++i) {
            if ("l1".equalsIgnoreCase(locales[i].getLanguage())) continue;
            StringBuffer grpNameBuf = new StringBuffer();
            StringBuffer grpDisplayNameBuf = new StringBuffer();
            StringBuffer grpNumberBuf = new StringBuffer();
            for (AsstActGroupDetailInfo detailInfo : detailColl) {
                AsstActTypeInfo actTypeInfo = detailInfo.getAsstActType();
                String propName = actTypeInfo.getAsstHGAttribute();
                String dataBaseId = asstDataBaseIdMap.get(propName);
                if (dataBaseId == null) continue;
                CoreBaseInfo obj = this.getDataBaseInfo(dataBaseId, actTypeInfo);
                assGrp.put(propName, (Object)obj);
                grpNameBuf.append(actTypeInfo.getName(locales[i]));
                grpNameBuf.append(": ");
                grpNameBuf.append(obj.get("name", locales[i]));
                grpNameBuf.append("; ");
                grpNumberBuf.append(actTypeInfo.getNumber());
                grpNumberBuf.append("_!");
                grpNumberBuf.append(actTypeInfo.getName(locales[i]));
                grpNumberBuf.append(": ");
                grpNumberBuf.append(obj.get("number"));
                grpNumberBuf.append("_!");
                grpNumberBuf.append(obj.get("name", locales[i]));
                grpNumberBuf.append("; ");
                grpDisplayNameBuf.append(actTypeInfo.getName(locales[i]));
                grpDisplayNameBuf.append(": ");
                if (obj instanceof DataBaseInfo) {
                    DataBaseInfo database = (DataBaseInfo)obj;
                    grpDisplayNameBuf.append(database.getDisplayName(locales[i]));
                } else {
                    grpDisplayNameBuf.append(obj.get("name", locales[i]));
                }
                grpDisplayNameBuf.append("; ");
            }
            String grpName = grpNameBuf.toString();
            if (grpDisplayNameBuf.length() > 400) {
                grpDisplayNameBuf = grpNameBuf;
            }
            assGrp.setLongNameGroup(grpName, locales[i]);
            assGrp.setNumberGroup(grpNumberBuf.toString(), locales[i]);
            assGrp.setDisplayNameGroup(grpDisplayNameBuf.toString(), locales[i]);
            if (!defaultLocaleId.equalsIgnoreCase(locales[i].toString())) continue;
            assGrp.setLongNameGroup(grpName);
            assGrp.setNumberGroup(grpNumberBuf.toString());
            assGrp.setDisplayNameGroup(grpDisplayNameBuf.toString());
        }
        assGrp.setCount(detailColl.size());
        IObjectPK pk = AssistantHGFactory.getLocalInstance((Context)this.ctx).addnew((CoreBaseInfo)assGrp);
        if (pk != null) {
            AssistUtil._modify((Context)this.ctx, (String)pk.toString());
        }
        return pk.toString();
    }

    private AsstActGroupDetailCollection getAsstAccountDetailCollection(String asstAccountId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectors = view.getSelector();
        selectors.add(new SelectorItemInfo("asstActType.id"));
        selectors.add(new SelectorItemInfo("asstActType.name"));
        selectors.add(new SelectorItemInfo("asstActType.number"));
        selectors.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        selectors.add(new SelectorItemInfo("asstActType.isMultilevel"));
        selectors.add(new SelectorItemInfo("asstActType.useLongNumber"));
        FilterInfo fi = new FilterInfo();
        view.setFilter(fi);
        FilterItemCollection filters = fi.getFilterItems();
        filters.add(new FilterItemInfo("asstAccount.id", (Object)asstAccountId));
        AsstActGroupDetailCollection detailColl = AsstActGroupDetailFactory.getLocalInstance((Context)this.ctx).getAsstActGroupDetailCollection(view);
        return detailColl;
    }

    private CoreBaseInfo getDataBaseInfo(String id, AsstActTypeInfo actTypeInfo) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        if (actTypeInfo.isUseLongNumber()) {
            selector.add(new SelectorItemInfo("longNumber"));
        }
        if (actTypeInfo.isIsMultilevel()) {
            selector.add(new SelectorItemInfo("displayName"));
        }
        ICoreBase iCoreBase = (ICoreBase)CDOUtils.getBizInterface((Context)this.ctx, (BOSObjectType)BOSUuid.read((String)id).getType());
        return iCoreBase.getValue((IObjectPK)new ObjectUuidPK(id), selector);
    }

    @Override
    public List<Map<String, String>> getFICompanyList(String permissionItem) throws EASBizException, BOSException {
        String companyIdFilter = this.getFICompanyIDFilter(permissionItem);
        Iterator it = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitCollection("select id,name where id in (" + companyIdFilter + ") order by number").iterator();
        ArrayList<Map<String, String>> companyList = new ArrayList<Map<String, String>>();
        while (it.hasNext()) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)it.next();
            HashMap<String, String> companyMap = new HashMap<String, String>();
            companyMap.put("id", company.getId().toString());
            companyMap.put("name", company.getName());
            companyList.add(companyMap);
        }
        return companyList;
    }

    @Override
    public String getFICompanyIDFilter(String permissionItem) throws EASBizException, BOSException {
        String permissionId = this.getFuncPermissionId(permissionItem);
        String userId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" select cp.fid ");
        AcountSchemeInfo acountScheme = new AcountSchemeInfo();
        acountScheme.setIsMaster(true);
        sql.append(GlUtils.getCompanyFilterSQL((String)userId, (String)permissionId, (boolean)true, null, null, (boolean)true, (AcountSchemeInfo)acountScheme, (boolean)false));
        return sql.toString();
    }

    private String getFuncPermissionId(String permissionItem) throws EASBizException, BOSException {
        String permSql = "select FID from t_pm_permitem where fnumber = '" + permissionItem + "'";
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)permSql);
        try {
            if (rs.next()) {
                return rs.getString("FID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    public Map getAsstGrpInfo(String companyId, String accountId, String asstAccountId, String hgId, Map sysParams) throws BOSException, EASBizException {
        if (asstAccountId == null) {
            return null;
        }
        HashSet<String> asstAccountIdSet = new HashSet<String>();
        asstAccountIdSet.add(asstAccountId);
        AsstActGroupDetailCollection detailColl = this.getAsstActGroupDetailCollection(asstAccountIdSet);
        AssistantHGInfo assistantHGInfo = null;
        if (!StringUtils.isEmpty((String)hgId)) {
            assistantHGInfo = AssistantHGFactory.getLocalInstance((Context)this.ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(hgId), this.getHGSelector(detailColl));
        }
        ArrayList<AsstActTypeInfo> dataBaseList = new ArrayList<AsstActTypeInfo>();
        for (AsstActGroupDetailInfo detailInfo : detailColl) {
            AsstDataChangeConfig[] cfs;
            List configList;
            AsstActTypeInfo asstActTypeInfo = detailInfo.getAsstActType();
            String asstHGAttribute = asstActTypeInfo.getAsstHGAttribute();
            HashSet<String> companyIdSet = new HashSet<String>();
            companyIdSet.add(companyId);
            GLF7Parameter param = new GLF7Parameter(companyIdSet, accountId, true, true, sysParams);
            AsstF7Config cf = AsstF7ConfigFactory.getAsstF7Config((Context)this.ctx, (AsstActTypeInfo)asstActTypeInfo, (GLF7Parameter)param);
            if (cf != null) {
                if (cf.getFilter() != null) {
                    asstActTypeInfo.put("filterItem", (Object)cf.getFilter().toString());
                }
                asstActTypeInfo.put("dispalyFields", (Object)cf.getDispalyFields());
                if (cf.getQueryName() != null) {
                    asstActTypeInfo.setDefaultQueryName(cf.getQueryName());
                }
            }
            if ((configList = AsstF7ConfigFactory.getAsstDataChangeConfigList((Context)this.ctx, (String)asstHGAttribute)) != null && (cfs = configList.toArray(new AsstDataChangeConfig[configList.size()])) != null) {
                asstActTypeInfo.put("asstDataChangeConfigs", (Object)cfs);
            }
            if (assistantHGInfo != null) {
                asstActTypeInfo.put("value", assistantHGInfo.get(asstHGAttribute));
            }
            dataBaseList.add(asstActTypeInfo);
        }
        HashMap<String, Object> assGrp = new HashMap<String, Object>();
        assGrp.put("asstAccountId", asstAccountId);
        assGrp.put("detail", dataBaseList);
        assGrp.put("id", hgId);
        return assGrp;
    }

    private AsstActGroupDetailCollection getAsstActGroupDetailCollection(Set asstAccountIdSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getAsstAccountSelector());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("asstAccount.id", (Object)asstAccountIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("seq"));
        return AsstActGroupDetailFactory.getLocalInstance((Context)this.ctx).getAsstActGroupDetailCollection(view);
    }

    @Override
    public Map<Integer, String> verifyAsstGrp(List<Map> assistRecords) throws BOSException, EASBizException {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        if (assistRecords == null || assistRecords.isEmpty()) {
            return result;
        }
        HashMap asstMap = new HashMap();
        for (Map ass : assistRecords) {
            String asstAccountId = ass.get("asstAccountId").toString();
            HashSet<String> hgIdSet = (HashSet<String>)asstMap.get(asstAccountId);
            if (hgIdSet == null) {
                hgIdSet = new HashSet<String>();
                asstMap.put(asstAccountId, hgIdSet);
            }
            String hgId = ass.get("hgId").toString();
            hgIdSet.add(hgId);
        }
        AsstAccountCollection AsstAccountColl = this.getAsstAccountCollection(asstMap.keySet());
        for (AsstAccountInfo asstAccountInfo : AsstAccountColl) {
            Set hgIdSet;
            AssistantHGCollection hgColl = this.getAssistantHGCollection(asstAccountInfo, hgIdSet = (Set)asstMap.get(asstAccountInfo.getId().toString()));
            if (hgColl.size() <= 0) continue;
            AssistantHGInfo hgInfo = hgColl.get(0);
            AsstActGroupDetailCollection detailColl = asstAccountInfo.getAsstActGpDt();
            for (int i = 0; i < detailColl.size(); ++i) {
                AsstActGroupDetailInfo detInfo = detailColl.get(i);
                AsstActTypeInfo asstActTypeInfo = detInfo.getAsstActType();
                String asstHGAttribute = detInfo.getAsstActType().getAsstHGAttribute();
                if (hgInfo.get(asstHGAttribute) != null) continue;
                String msg = new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{asstActTypeInfo.getName()}).getMessage();
                int entrySeq = this.findEntrySeq(assistRecords, asstAccountInfo.getId().toString(), hgInfo.getId().toString());
                if (entrySeq == -1) continue;
                result.put(entrySeq, msg);
                return result;
            }
        }
        return result;
    }

    private int findEntrySeq(List<Map> assistRecords, String asstAccountId, String hgId) {
        for (Map ass : assistRecords) {
            if (!asstAccountId.equals(ass.get("asstAccountId").toString()) || !hgId.equals(ass.get("hgId").toString())) continue;
            return Integer.parseInt(ass.get("entrySeq").toString());
        }
        return -1;
    }

    private AssistantHGCollection getAssistantHGCollection(AsstAccountInfo asstAccountInfo, Set hgIdSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)hgIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("asstAccount.id", (Object)asstAccountInfo.getId()));
        view.setFilter(filter);
        int index = 0;
        StringBuffer maskString = new StringBuffer("#").append(index++).append(" AND #").append(index++);
        AsstActGroupDetailCollection detailColl = asstAccountInfo.getAsstActGpDt();
        for (int i = 0; i < detailColl.size(); ++i) {
            AsstActGroupDetailInfo detInfo = detailColl.get(i);
            AsstActTypeInfo asstActTypeInfo = detInfo.getAsstActType();
            String asstHGAttribute = detInfo.getAsstActType().getAsstHGAttribute();
            sic.add(new SelectorItemInfo(asstHGAttribute + ".id"));
            filter.getFilterItems().add(new FilterItemInfo(asstHGAttribute + ".id", null, CompareType.IS));
            if (i == 0) {
                maskString.append(" AND (#").append(index++);
                continue;
            }
            maskString.append(" OR #").append(index++);
        }
        maskString.append(")");
        filter.setMaskString(maskString.toString());
        return AssistantHGFactory.getLocalInstance((Context)this.ctx).getAssistantHGCollection(view);
    }

    private AsstAccountCollection getAsstAccountCollection(Set asstAccountIdSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("asstActGpDt.asstActType.name"));
        sic.add(new SelectorItemInfo("asstActGpDt.asstActType.asstHGAttribute"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)asstAccountIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        return AsstAccountFactory.getLocalInstance((Context)this.ctx).getAsstAccountCollection(view);
    }

    private SelectorItemCollection getAsstAccountSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("seq"));
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.defaultQueryName"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        sic.add(new SelectorItemInfo("asstActType.isMultilevel"));
        sic.add(new SelectorItemInfo("asstActType.useLongNumber"));
        return sic;
    }

    private SelectorItemCollection getHGSelector(AsstActGroupDetailCollection detailColl) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        for (AsstActGroupDetailInfo detailInfo : detailColl) {
            AsstActTypeInfo asstActTypeInfo = detailInfo.getAsstActType();
            String asstHGAttribute = asstActTypeInfo.getAsstHGAttribute();
            sic.add(new SelectorItemInfo(asstHGAttribute + ".id"));
            sic.add(new SelectorItemInfo(asstHGAttribute + ".name"));
            sic.add(new SelectorItemInfo(asstHGAttribute + ".number"));
            if (asstActTypeInfo.isUseLongNumber()) {
                sic.add(new SelectorItemInfo(asstHGAttribute + ".longNumber"));
            }
            if (asstActTypeInfo.isIsMultilevel()) {
                sic.add(new SelectorItemInfo(asstHGAttribute + ".displayName"));
            }
            if ("customer".equals(asstHGAttribute) || "supplier".equals(asstHGAttribute)) {
                sic.add(new SelectorItemInfo("browseGroup.displayName"));
                continue;
            }
            if (!"material".equals(asstHGAttribute)) continue;
            sic.add(new SelectorItemInfo("materialGroup.displayName"));
        }
        return sic;
    }

    @Override
    public List<String> getVoucherAbstractList(String cuid, String term) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("name"));
        IVoucherAbstract voucherAbstract = VoucherAbstractFactory.getLocalInstance((Context)this.ctx);
        FilterInfo filter = null;
        if (!StringUtils.isEmpty((String)cuid)) {
            filter = voucherAbstract.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "adminCU");
        }
        if (!StringUtils.isEmpty((String)term)) {
            FilterInfo nameFilter = new FilterInfo();
            nameFilter.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + term + "%"), CompareType.LIKE));
            if (filter == null) {
                filter = nameFilter;
            } else {
                filter.mergeFilter(nameFilter, "AND");
            }
        }
        if (filter != null) {
            view.setFilter(filter);
        }
        VoucherAbstractCollection coll = voucherAbstract.getVoucherAbstractCollection(view);
        ArrayList<String> abstractNameList = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            abstractNameList.add(coll.get(i).getName());
        }
        return abstractNameList;
    }

    @Override
    public Map<String, AsstDataChangedResult> asstDataChanged(String asstName, String[] relatedAsstNames, String asstDataId, String companyId, String accountId) throws BOSException, EASBizException {
        AsstDataChangeEvent event = new AsstDataChangeEvent(asstDataId, companyId, accountId);
        Map result = AsstF7ConfigFactory.dataChanged((Context)this.ctx, (String)asstName, (String[])relatedAsstNames, (AsstDataChangeEvent)event);
        HashMap<String, AsstDataChangedResult> rs = new HashMap<String, AsstDataChangedResult>();
        for (String key : result.keySet()) {
            AsstDataChangeResult value = (AsstDataChangeResult)result.get(key);
            rs.put(key, new AsstDataChangedResult(value.getValue(), value.getFilter() == null ? null : value.getFilter().toString()));
        }
        return rs;
    }
}

