/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CFRequisitionFactory;
import com.kingdee.eas.fi.gl.GLClosePeriodFacadeFactory;
import com.kingdee.eas.fi.gl.GLPeriodEndFacadeFactory;
import com.kingdee.eas.fi.gl.GLPeriodEndFilter;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.GLClosePeriodUtils;
import com.kingdee.eas.fi.gl.services.IGLClosePeriodService;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.fi.gl.services.IGLClosePeriodService"})
@Description(value="\u603b\u8d26\u671f\u672b\u7ed3\u8d26\u670d\u52a1")
public class GLClosePeriodServiceImpl
implements IGLClosePeriodService {
    private Context ctx;

    public GLClosePeriodServiceImpl(Context ctx) {
        this.ctx = ctx;
    }

    @Override
    public Map getData(Map condition) throws BOSException, EASBizException {
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        LinkedList data = new LinkedList();
        result.put("records", Integer.valueOf(0));
        result.put("total", Integer.valueOf(0));
        result.put("page", Integer.valueOf(0));
        result.put("rows", data);
        CompanyOrgUnitInfo org = ContextUtil.getCurrentFIUnit((Context)this.ctx);
        String loc = this.ctx.getLocale().toString();
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)this.ctx);
        BOSUuid userId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId();
        FullOrgUnitCollection orgs = iPermission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userId), OrgType.Company, null, "gl_closePeriod");
        if (orgs == null || orgs.size() == 0) {
            return result;
        }
        StringBuffer orgFilter = new StringBuffer();
        orgFilter.append("(");
        int length = orgs.size();
        for (int i = 0; i < length; ++i) {
            orgFilter.append("'" + orgs.get(i).getId() + "',");
        }
        orgFilter.deleteCharAt(orgFilter.length() - 1);
        orgFilter.append(")");
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("    sc.FID, \n");
        sql.append("    c.FID FOrgID, c.FNumber FOrgNumber, c.FName_" + loc + " FOrgName, \n");
        sql.append("    p.FID FPeriodID, p.FPeriodYear, p.FPeriodNumber FPeriodMonth \n");
        sql.append("from T_BD_SystemStatusCtrol sc \n");
        sql.append("join T_ORG_Company c on c.FID = sc.FCompanyID \n");
        sql.append("join T_BD_SystemStatus s on s.FID = sc.FSystemStatusID \n");
        sql.append("join T_BD_Period p on p.FID = sc.FCurrentPeriodID \n");
        sql.append("where c.FIsBizUnit = 1 and c.FIsSealup = 0 \n");
        sql.append("    and s.FName = 6 \n");
        sql.append("    and c.FID in " + orgFilter + " \n");
        sql.append("    and c.FLongNumber like '" + org.getLongNumber() + "%' \n");
        sql.append("\n");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                String id = rowSet.getString("FID");
                String orgId = rowSet.getString("FOrgID");
                String orgName = rowSet.getString("FOrgName");
                String periodId = rowSet.getString("FPeriodID");
                String periodMonth = rowSet.getString("FPeriodMonth");
                String periodYear = rowSet.getString("FPeriodYear");
                if (periodMonth != null && periodMonth.toString().length() == 1) {
                    periodMonth = "0" + periodMonth;
                }
                String periodName = periodYear + "\u5e74" + periodMonth + "\u671f";
                map.put("id", id);
                map.put("orgId", orgId);
                map.put("orgName", orgName);
                map.put("periodId", periodId);
                map.put("periodName", periodName);
                data.add(map);
            }
            int records = rowSet.size();
            result.put("records", Integer.valueOf(records));
            result.put("total", Integer.valueOf(1));
            result.put("page", Integer.valueOf(1));
            result.put("rows", data);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private Map<String, Object> getSystemStatusCtrol(Context ctx, String orgId) throws BOSException, EASBizException {
        String loc = ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("    c.FNumber FOrgNumber, c.FName_" + loc + " FOrgName, \n");
        sql.append("    c.FControlUnitID, c.FAccountTableID, \n");
        sql.append("    p.FID FPeriodID, p.FPeriodYear, p.FPeriodNumber FPeriodMonth, p.FBeginDate, p.FEndDate, \n");
        sql.append("    sc.FStartPeriodID \n");
        sql.append("from T_BD_SystemStatusCtrol sc \n");
        sql.append("join T_ORG_Company c on c.FID = sc.FCompanyID \n");
        sql.append("join T_BD_SystemStatus s on s.FID = sc.FSystemStatusID \n");
        sql.append("join T_BD_Period p on p.FID = sc.FCurrentPeriodID \n");
        sql.append("where c.FIsBizUnit = 1 and c.FIsSealup = 0 \n");
        sql.append("    and s.FName = 6 \n");
        sql.append("    and c.FID = '" + orgId + "' \n");
        sql.append("\n");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet.next()) {
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("orgId", orgId);
                info.put("orgName", rowSet.getString("FOrgName"));
                info.put("orgNumber", rowSet.getString("FOrgNumber"));
                info.put("cuId", rowSet.getString("FControlUnitID"));
                info.put("accountTableId", rowSet.getString("FAccountTableID"));
                info.put("periodId", rowSet.getString("FPeriodID"));
                String periodYear = rowSet.getString("FPeriodYear");
                String periodMonth = rowSet.getString("FPeriodMonth");
                if (periodMonth != null && periodMonth.toString().length() == 1) {
                    periodMonth = "0" + periodMonth;
                }
                String periodNumber = periodYear + periodMonth;
                String periodName = periodYear + "\u5e74" + periodMonth + "\u671f";
                info.put("periodYear", periodYear);
                info.put("periodMonth", periodMonth);
                info.put("periodNumber", periodNumber);
                info.put("periodName", periodName);
                info.put("beginDate", rowSet.getDate("FBeginDate"));
                info.put("endDate", rowSet.getDate("FEndDate"));
                info.put("startPeriodId", rowSet.getString("FStartPeriodID"));
                return info;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private Map buildError(List<Map<String, Object>> errors, String id, String orgName, Object data) {
        HashMap<String, Object> error = new HashMap<String, Object>();
        error.put("id", id);
        error.put("orgName", orgName);
        error.put("operation", "\u5904\u7406");
        error.put("data", data);
        return error;
    }

    @Override
    public Map closeCheck(Map condition) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList errors = new ArrayList();
        result.put("status", "error");
        result.put("errors", errors);
        result.put("status", "success");
        return result;
    }

    @Override
    public Map closePeriod(Map condition) throws BOSException, EASBizException {
        PeriodInfo nextPeriod;
        SystemStatusCtrolCollection coll;
        HashMap<String, String> error;
        boolean notice;
        boolean plAccount;
        HashMap<String, String> error2;
        boolean voucherNumber;
        boolean unPost;
        HashMap hmAllParam;
        boolean saveVoucher;
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList errors = new ArrayList();
        result.put("status", "error");
        result.put("errors", errors);
        int errorIndex = 0;
        String id = (String)condition.get("id");
        String orgId = (String)condition.get("orgId");
        String periodId = (String)condition.get("periodId");
        if (orgId == null || periodId == null) {
            HashMap<String, String> error3 = new HashMap<String, String>();
            error3.put("id", id + "_" + ++errorIndex);
            error3.put("orgName", "\u7ec4\u7ec7\u6216\u671f\u95f4\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            error3.put("operation", "\u5904\u7406");
            errors.add(error3);
            return result;
        }
        Map<String, Object> sscInfo = this.getSystemStatusCtrol(this.ctx, orgId);
        if (sscInfo == null) {
            HashMap<String, String> error4 = new HashMap<String, String>();
            error4.put("id", id + "_" + ++errorIndex);
            error4.put("orgName", "\u603b\u5e10\u7cfb\u7edf\u672a\u542f\u7528\u6216\u671f\u95f4\u8bbe\u7f6e\u6709\u8bef");
            error4.put("operation", "\u5904\u7406");
            errors.add(error4);
            return result;
        }
        if (!periodId.equals(sscInfo.get("periodId"))) {
            HashMap<String, String> error5 = new HashMap<String, String>();
            error5.put("id", id + "_" + ++errorIndex);
            error5.put("orgName", "\u5f53\u524d\u671f\u95f4\u5df2\u7ecf\u5728" + sscInfo.get("periodName") + ",\u4f60\u4e0d\u80fd\u7ee7\u7eed\u7ed3\u8d26");
            error5.put("operation", "\u5904\u7406");
            errors.add(error5);
            return result;
        }
        String orgName = (String)sscInfo.get("orgName");
        String cuId = (String)sscInfo.get("cuId");
        String accountTableId = (String)sscInfo.get("accountTableId");
        String periodYear = (String)sscInfo.get("periodYear");
        String periodMonth = (String)sscInfo.get("periodMonth");
        String periodNumber = (String)sscInfo.get("periodNumber");
        Date beginDate = (Date)sscInfo.get("beginDate");
        Date endDate = (Date)sscInfo.get("endDate");
        PeriodInfo curPeriodInfo = new PeriodInfo();
        curPeriodInfo.setId(BOSUuid.read((String)periodId));
        curPeriodInfo.setPeriodYear(Integer.parseInt(periodYear));
        curPeriodInfo.setPeriodNumber(Integer.parseInt(periodMonth));
        boolean checkCussent = GlUtils.getDefaultGLParam((Context)this.ctx, (String)orgId, (String)"GL_028");
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)this.ctx);
        ParamItemInfo paramCashflow = pc.getParamItemByNumberAndOrg("GL_070", orgId);
        boolean cashflow = false;
        boolean cashFlowIsCheck = false;
        String cashFlowMsg = null;
        if (paramCashflow == null || "false".equals(paramCashflow.getValue())) {
            cashflow = true;
            cashFlowIsCheck = true;
        } else {
            ParamItemInfo paramClose = pc.getParamItemByNumberAndOrg("GL_071", orgId);
            if ("2".equals(paramClose.getValue())) {
                cashflow = true;
                cashFlowIsCheck = true;
            } else {
                cashflow = false;
                String msg = CFRequisitionFactory.getLocalInstance((Context)this.ctx).checkCanClosePeriod((IObjectPK)new ObjectUuidPK(orgId), (IObjectPK)new ObjectUuidPK(periodId), Integer.parseInt(periodNumber));
                if (msg != null) {
                    cashFlowIsCheck = false;
                    cashFlowMsg = msg;
                } else {
                    cashFlowIsCheck = true;
                }
            }
        }
        boolean isClose = GLClosePeriodUtils.checkCloseInit((Context)this.ctx, (String)orgId, (String)cuId, (String)accountTableId, (boolean)true, (boolean)true, (boolean)checkCussent);
        if (!isClose) {
            HashMap<String, String> error6 = new HashMap<String, String>();
            error6.put("id", id + "_" + ++errorIndex);
            error6.put("orgName", "\u603b\u8d26\u7cfb\u7edf\u672a\u7ed3\u675f\u521d\u59cb\u5316");
            error6.put("operation", "\u5904\u7406");
            errors.add(error6);
        }
        if (!(saveVoucher = Boolean.valueOf((hmAllParam = GLClosePeriodUtils.getDefaultGLParam((Context)this.ctx, (String)orgId)).get("G011").toString()).booleanValue()) && (saveVoucher = GLClosePeriodUtils.checkSaveVoucher((Context)this.ctx, (String)orgId, (String)periodId))) {
            HashMap<String, String> error7 = new HashMap<String, String>();
            error7.put("id", id + "_" + ++errorIndex);
            error7.put("orgName", "\u672c\u671f\u5b58\u5728\u6682\u5b58\u51ed\u8bc1");
            error7.put("operation", "\u5904\u7406");
            errors.add(error7);
        }
        if (unPost = GLClosePeriodUtils.checkCanAdjRate((Context)this.ctx, (String)orgId, (String)periodId)) {
            HashMap<String, String> error8 = new HashMap<String, String>();
            error8.put("id", id + "_" + ++errorIndex);
            error8.put("orgName", "\u672c\u671f\u5b58\u5728\u672a\u8fc7\u8d26\u51ed\u8bc1");
            error8.put("operation", "\u5904\u7406");
            errors.add(error8);
        }
        boolean bl = voucherNumber = Integer.parseInt(hmAllParam.get("GL_051").toString()) != 2;
        if (!voucherNumber) {
            PeriodInfo period = new PeriodInfo();
            period.setPeriodNumber(Integer.parseInt(periodMonth));
            period.setPeriodYear(Integer.parseInt(periodYear));
            period.setId(BOSUuid.read((String)periodId));
            period.setBeginDate((java.util.Date)beginDate);
            voucherNumber = GLClosePeriodUtils.voucherNumber((Context)this.ctx, (String)orgId, (PeriodInfo)period, (String)cuId);
            if (voucherNumber) {
                error2 = new HashMap();
                error2.put("id", id + "_" + ++errorIndex);
                error2.put("orgName", "\u672c\u671f\u5b58\u5728\u65ad\u53f7\u51ed\u8bc1");
                error2.put("operation", "\u5904\u7406");
                errors.add(error2);
            }
        }
        if ((plAccount = Boolean.valueOf(hmAllParam.get("GL_011").toString()).booleanValue()) && (plAccount = GLClosePeriodUtils.checkPlAccount((Context)this.ctx, (String)orgId, (String)periodId))) {
            error2 = new HashMap<String, String>();
            error2.put("id", id + "_" + ++errorIndex);
            error2.put("orgName", "\u672c\u671f\u672a\u7ed3\u8f6c\u635f\u76ca");
            error2.put("operation", "\u5904\u7406");
            errors.add(error2);
        }
        if (!(notice = Boolean.valueOf(hmAllParam.get("GL_026").toString()).booleanValue()) && (notice = GLClosePeriodUtils.checkNotice((Context)this.ctx, (String)orgId, (Date)beginDate, (Date)endDate))) {
            error = new HashMap();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", "\u5b58\u5728\u672a\u786e\u8ba4\u5f80\u6765\u901a\u77e5\u5355");
            error.put("operation", "\u5904\u7406");
            errors.add(error);
        }
        if (!cashflow && !cashFlowIsCheck) {
            error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", "\u5b58\u5728\u672a\u52fe\u7a3d\u73b0\u91d1\u6d41\u91cf\u901a\u77e5\u5355");
            error.put("operation", "\u5904\u7406");
            errors.add(error);
        }
        boolean fcSU = Boolean.valueOf(hmAllParam.get("GL_008").toString());
        boolean isUserReportCurr = Boolean.valueOf(hmAllParam.get("G001").toString());
        Boolean isCheckBalance = Boolean.valueOf(hmAllParam.get("GL_103").toString());
        boolean isbalanceCorrect = false;
        if (isCheckBalance.booleanValue()) {
            isbalanceCorrect = GLPeriodEndFacadeFactory.getLocalInstance((Context)this.ctx).checkBalanceCorrect(fcSU, orgId, periodId, isUserReportCurr);
        }
        if (isCheckBalance.booleanValue() && !isbalanceCorrect) {
            HashMap<String, String> error9 = new HashMap<String, String>();
            error9.put("id", id + "_" + ++errorIndex);
            error9.put("orgName", "\u672c\u671f\u8bd5\u7b97\u4e0d\u5e73\u8861");
            error9.put("operation", "\u5904\u7406");
            errors.add(error9);
        }
        if ((coll = GLClosePeriodUtils.getRelatedNotCloseSystem((Context)this.ctx, (String)orgId, (PeriodInfo)curPeriodInfo, (PeriodInfo)(nextPeriod = PeriodUtils.getNextPeriodInfo((Context)this.ctx, (IObjectPK)new ObjectUuidPK(periodId))))).size() > 0) {
            StringBuffer systems = new StringBuffer();
            for (int i = 0; i < coll.size(); ++i) {
                SystemStatusCtrolInfo info = coll.get(i);
                if (info.getSystemStatus() == null) continue;
                systems.append(info.getSystemStatus().getName() + ",");
            }
            if (systems.length() > 0) {
                systems.deleteCharAt(systems.length() - 1);
            }
            HashMap<String, String> error10 = new HashMap<String, String>();
            error10.put("id", id + "_" + ++errorIndex);
            error10.put("orgName", systems + "\u672a\u7ed3\u8d26");
            error10.put("operation", "\u5904\u7406");
            errors.add(error10);
        }
        if (errors.size() > 0) {
            return result;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("orgId", orgId);
        params.put("orgName", orgName);
        params.put("cuId", cuId);
        params.put("periodId", periodId);
        params.put("accountTableId", accountTableId);
        Map sub = GLClosePeriodFacadeFactory.getLocalInstance((Context)this.ctx).closePeriod(params);
        List subErrors = (List)sub.get("errors");
        if (subErrors != null && subErrors.size() > 0) {
            for (Map subError : subErrors) {
                subError.put("id", id + "_" + ++errorIndex);
            }
            errors.addAll(subErrors);
        }
        if (errors.size() > 0) {
            return result;
        }
        result.put("status", "success");
        return result;
    }

    @Override
    public Map unClosePeriod(Map condition) throws BOSException, EASBizException {
        PeriodInfo acPeriod;
        AccountRefContrastInfo ojbValue;
        String errInfo;
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList errors = new ArrayList();
        result.put("status", "error");
        result.put("errors", errors);
        int errorIndex = 0;
        String id = (String)condition.get("id");
        String orgId = (String)condition.get("orgId");
        String periodId = (String)condition.get("periodId");
        if (orgId == null || periodId == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", "\u7ec4\u7ec7\u6216\u671f\u95f4\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            error.put("operation", "\u5904\u7406");
            errors.add(error);
            return result;
        }
        Map<String, Object> sscInfo = this.getSystemStatusCtrol(this.ctx, orgId);
        if (sscInfo == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", "\u603b\u5e10\u7cfb\u7edf\u672a\u542f\u7528\u6216\u671f\u95f4\u8bbe\u7f6e\u6709\u8bef");
            error.put("operation", "\u5904\u7406");
            errors.add(error);
            return result;
        }
        if (!periodId.equals(sscInfo.get("periodId"))) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", "\u5f53\u524d\u671f\u95f4\u5df2\u7ecf\u5728" + sscInfo.get("periodName") + ",\u4f60\u4e0d\u80fd\u7ee7\u7eed\u53cd\u7ed3\u8d26");
            error.put("operation", "\u5904\u7406");
            errors.add(error);
            return result;
        }
        if (periodId.equals(sscInfo.get("startPeriodId"))) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", "\u7b2c\u4e00\u4e2a\u671f\u95f4\u4e0d\u80fd\u518d\u53cd\u7ed3\u8d26");
            error.put("operation", "\u5904\u7406");
            errors.add(error);
            return result;
        }
        String accountTableId = (String)sscInfo.get("accountTableId");
        GLPeriodEndFilter filter = GLPeriodEndFacadeFactory.getLocalInstance((Context)this.ctx).fetchInitData();
        PeriodInfo curPeriod = filter.getCurPeriod();
        if (filter.isCanNotClosedAfterReport() && (errInfo = CslRptUtil.isHasReportSubmited((Context)this.ctx, (PeriodInfo)curPeriod, (String)orgId)) != null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", errInfo + "\u4e0d\u80fd\u53cd\u7ed3\u8d26");
            error.put("operation", "\u5904\u7406");
            errors.add(error);
            return result;
        }
        String acPrepPeriodid = curPeriod.getId().toString();
        if (curPeriod.isIsAdjustPeriod() && (ojbValue = AccountRefContrastFactory.getLocalInstance((Context)this.ctx).getLastAcctInfo(orgId, accountTableId, periodId)) != null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", "\u671f\u95f4" + curPeriod + "\u542f\u7528\u4e86\u65b0\u79d1\u76ee\u8868\uff0c\u4e0d\u80fd\u53cd\u7ed3\u8d26\u5230\u8be5\u671f\u95f4\u7684\u4e0a\u4e00\u671f");
            error.put("operation", "\u5904\u7406");
            errors.add(error);
            return result;
        }
        SystemStatusCtrolCollection ctrols = SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx).getSystemStatusCtrolCollection("select acPeriod.* where company.id='" + orgId + "' and systemStatus.name=6");
        PeriodInfo periodInfo = acPeriod = ctrols.size() > 0 && ctrols.get(0).getAcPeriod() != null ? ctrols.get(0).getAcPeriod() : null;
        if (acPeriod == null || acPrepPeriodid.equals(acPeriod.getId().toString())) {
            // empty if block
        }
        if (errors.size() > 0) {
            return result;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("orgId", orgId);
        params.put("periodId", periodId);
        Map sub = GLClosePeriodFacadeFactory.getLocalInstance((Context)this.ctx).unClosePeriod(params);
        List subErrors = (List)sub.get("errors");
        if (subErrors != null && subErrors.size() > 0) {
            for (Map subError : subErrors) {
                subError.put("id", id + "_" + ++errorIndex);
            }
            errors.addAll(subErrors);
        }
        if (errors.size() > 0) {
            return result;
        }
        result.put("status", "success");
        return result;
    }

    @Override
    public Map closeYear(Map condition) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList errors = new ArrayList();
        result.put("status", "error");
        result.put("errors", errors);
        int errorIndex = 0;
        String id = (String)condition.get("id");
        String orgId = (String)condition.get("orgId");
        String periodId = (String)condition.get("periodId");
        if (orgId == null || periodId == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", "\u7ec4\u7ec7\u6216\u671f\u95f4\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            error.put("operation", "\u5904\u7406");
            errors.add(error);
            return result;
        }
        Map<String, Object> sscInfo = this.getSystemStatusCtrol(this.ctx, orgId);
        if (sscInfo == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", "\u603b\u5e10\u7cfb\u7edf\u672a\u542f\u7528\u6216\u671f\u95f4\u8bbe\u7f6e\u6709\u8bef");
            error.put("operation", "\u5904\u7406");
            errors.add(error);
            return result;
        }
        if (!periodId.equals(sscInfo.get("periodId"))) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", "\u5f53\u524d\u671f\u95f4\u5df2\u7ecf\u5728" + sscInfo.get("periodName") + ",\u4f60\u4e0d\u80fd\u7ee7\u7eed\u7ed3\u8d26");
            error.put("operation", "\u5904\u7406");
            errors.add(error);
            return result;
        }
        if (errors.size() > 0) {
            return result;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("orgId", orgId);
        params.put("periodId", periodId);
        Map sub = GLClosePeriodFacadeFactory.getLocalInstance((Context)this.ctx).closeYear(params);
        List subErrors = (List)sub.get("errors");
        if (subErrors != null && subErrors.size() > 0) {
            for (Map subError : subErrors) {
                subError.put("id", id + "_" + ++errorIndex);
            }
            errors.addAll(subErrors);
        }
        if (errors.size() > 0) {
            return result;
        }
        result.put("status", "success");
        return result;
    }

    @Override
    public Map unCloseYear(Map condition) throws BOSException, EASBizException {
        String errInfo;
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList errors = new ArrayList();
        result.put("status", "error");
        result.put("errors", errors);
        int errorIndex = 0;
        String id = (String)condition.get("id");
        String orgId = (String)condition.get("orgId");
        String periodId = (String)condition.get("periodId");
        if (orgId == null || periodId == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", "\u7ec4\u7ec7\u6216\u671f\u95f4\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            error.put("operation", "\u5904\u7406");
            errors.add(error);
            return result;
        }
        Map<String, Object> sscInfo = this.getSystemStatusCtrol(this.ctx, orgId);
        if (sscInfo == null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", "\u603b\u5e10\u7cfb\u7edf\u672a\u542f\u7528\u6216\u671f\u95f4\u8bbe\u7f6e\u6709\u8bef");
            error.put("operation", "\u5904\u7406");
            errors.add(error);
            return result;
        }
        if (!periodId.equals(sscInfo.get("periodId"))) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", "\u5f53\u524d\u671f\u95f4\u5df2\u7ecf\u5728" + sscInfo.get("periodName") + ",\u4f60\u4e0d\u80fd\u7ee7\u7eed\u7ed3\u8d26");
            error.put("operation", "\u5904\u7406");
            errors.add(error);
            return result;
        }
        GLPeriodEndFilter filter = GLPeriodEndFacadeFactory.getLocalInstance((Context)this.ctx).fetchInitData();
        PeriodInfo curPeriod = filter.getCurPeriod();
        if (filter.isCanNotClosedAfterReport() && (errInfo = CslRptUtil.isHasReportSubmited((Context)this.ctx, (PeriodInfo)curPeriod, (String)orgId)) != null) {
            HashMap<String, String> error = new HashMap<String, String>();
            error.put("id", id + "_" + ++errorIndex);
            error.put("orgName", errInfo + "\u4e0d\u80fd\u53cd\u5e74\u7ed3");
            error.put("operation", "\u5904\u7406");
            errors.add(error);
            return result;
        }
        if (errors.size() > 0) {
            return result;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("orgId", orgId);
        params.put("periodId", periodId);
        Map sub = GLClosePeriodFacadeFactory.getLocalInstance((Context)this.ctx).unCloseYear(params);
        List subErrors = (List)sub.get("errors");
        if (subErrors != null && subErrors.size() > 0) {
            for (Map subError : subErrors) {
                subError.put("id", id + "_" + ++errorIndex);
            }
            errors.addAll(subErrors);
        }
        if (errors.size() > 0) {
            return result;
        }
        result.put("status", "success");
        return result;
    }
}

