/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.services.impl.base;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.cdo.CommonDataObject;
import com.kingdee.bos.cdo.ICommonDataObject;
import com.kingdee.bos.cdo.utils.CDOUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyCollection;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyFactory;
import com.kingdee.eas.fi.gl.AssistCustomizedPropertyInfo;
import com.kingdee.eas.fi.gl.services.base.AccountCustomPropertyService;
import com.kingdee.eas.fi.gl.services.impl.ServiceWebUtils;
import com.kingdee.eas.framework.DeletedStatusEnum;

@Component(value={"com.kingdee.eas.fi.gl.services.base.AccountCustomPropertyService"})
@Description(value="AccountCustomProperty service.")
public class AccountCustomPropertyServiceImpl
implements AccountCustomPropertyService {
    private final Context ctx;

    public AccountCustomPropertyServiceImpl(Context ctx) {
        this.ctx = ctx;
    }

    public CommonDataObject getAssistCustomizedPropertyCollection(String view) throws EASBizException, BOSException {
        try {
            AssistCustomizedPropertyCollection collection = AssistCustomizedPropertyFactory.getLocalInstance((Context)this.ctx).getAssistCustomizedPropertyCollection(new EntityViewInfo(view));
            AssistCustomizedPropertyInfo info = new AssistCustomizedPropertyInfo();
            info.put("entries", (Object)collection);
            if (collection != null && collection.size() > 0) {
                info.setAccount(collection.get(0).getAccount());
            }
            CommonDataObject returnObject = (CommonDataObject)CDOUtils.convertObjectInfoToCDO((Context)this.ctx, (IObjectValue)info);
            return returnObject;
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void saveAssistCustomizedProperty(CommonDataObject asstCusProperty) throws EASBizException, BOSException {
        AssistCustomizedPropertyInfo customizedPropertyInfo = (AssistCustomizedPropertyInfo)CDOUtils.convertCDOToObjectInfo((Context)this.ctx, (ICommonDataObject)asstCusProperty);
    }

    public void doApprove(String[] ids, int status) throws EASBizException, BOSException {
        if (ids == null) {
            return;
        }
        for (int i = 0; i < ids.length; ++i) {
            AssistCustomizedPropertyFactory.getLocalInstance((Context)this.ctx).doApprove(ids[i], DeletedStatusEnum.getEnum((int)status));
        }
    }

    public void dealAssistRecordAndAccount(String[] accountIds, boolean isApprove) throws EASBizException, BOSException {
        if (accountIds == null) {
            return;
        }
        for (int i = 0; i < accountIds.length; ++i) {
            AssistCustomizedPropertyFactory.getLocalInstance((Context)this.ctx).dealAssistRecordAndAccount(accountIds[i], isApprove);
        }
    }

    public AssistCustomizedPropertyCollection getAccountCustProp(String accountId) throws EASBizException, BOSException {
        return ServiceWebUtils.getAccountCustProp(this.ctx, accountId);
    }
}

