/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.services.impl.rpt;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.services.impl.rpt.GLRptBaseConditionBuilder;
import java.util.Map;

public abstract class GLRptAccountConditionBuilder
extends GLRptBaseConditionBuilder {
    public Map setCustomCondition(Context ctx, GLRptBaseCondition condition) {
        Map map = super.setCustomCondition(ctx, condition);
        Object[] avStart = (Object[])condition.getAccountViewStart();
        if (avStart != null && avStart.length == 1) {
            map.put("accountStart", avStart[0]);
        } else {
            map.put("accountStart", avStart);
        }
        Object[] avEnd = (Object[])condition.getAccountViewEnd();
        if (avEnd != null && avEnd.length == 1) {
            map.put("accountEnd", avEnd[0]);
        } else {
            map.put("accountEnd", avEnd);
        }
        map.put("accountLevel", condition.getAccountLevelEnd());
        map.put("showLeafAccount", condition.isShowLeafAccount());
        return map;
    }

    protected GLRptBaseCondition getSimpleCustomCondition(Context ctx, Map map) {
        GLRptBaseCondition cond = super.getSimpleCustomCondition(ctx, map);
        Map accountStartMap = (Map)map.get("accountStart");
        this.setAccountStartValue(this.assembleInfoObject(accountStartMap, AccountViewInfo.class), cond);
        Map accountEndMap = (Map)map.get("accountEnd");
        this.setAccountEndValue(this.assembleInfoObject(accountEndMap, AccountViewInfo.class), cond);
        cond.setAccountLevelStart(1);
        cond.setAccountLevelEnd(1);
        return cond;
    }

    protected GLRptBaseCondition getAdvanceCustomCondition(Context ctx, Map map) {
        GLRptBaseCondition cond = super.getAdvanceCustomCondition(ctx, map);
        Map accountStartMap = (Map)map.get("accountStart");
        this.setAccountStartValue(this.assembleInfoObject(accountStartMap, AccountViewInfo.class), cond);
        Map accountEndMap = (Map)map.get("accountEnd");
        this.setAccountEndValue(this.assembleInfoObject(accountEndMap, AccountViewInfo.class), cond);
        cond.setAccountLevelStart(1);
        Object accountLevel = map.get("accountLevel");
        if (accountLevel != null) {
            cond.setAccountLevelEnd(Double.valueOf(accountLevel.toString()).intValue());
        }
        if (map.get("showLeafAccount") != null) {
            cond.setShowLeafAccount(((Boolean)map.get("showLeafAccount")).booleanValue());
        } else {
            cond.setShowLeafAccount(false);
        }
        return cond;
    }

    private void setAccountStartValue(AccountViewInfo accountStart, GLRptBaseCondition cond) {
        cond.setAccountCodeStart(null);
        if (accountStart != null) {
            this.setAccountStartValue(new AccountViewInfo[]{accountStart}, cond);
        }
    }

    private void setAccountStartValue(AccountViewInfo[] accountStarts, GLRptBaseCondition cond) {
        cond.setAccountCodeStart(null);
        if (accountStarts != null) {
            String accountNumber = "";
            for (int i = 0; i < accountStarts.length; ++i) {
                AccountViewInfo account = accountStarts[i];
                if (account == null) continue;
                accountNumber = accountNumber + account.getNumber() + ",";
            }
            if (!accountNumber.equals("")) {
                accountNumber = accountNumber.substring(0, accountNumber.length() - 1);
            }
            cond.setAccountCodeStart(accountNumber);
            cond.setAccountViewStart((Object)accountStarts);
        }
    }

    private void setAccountEndValue(AccountViewInfo accountEnd, GLRptBaseCondition cond) {
        cond.setAccountCodeEnd(null);
        if (accountEnd != null) {
            this.setAccountEndValue(new AccountViewInfo[]{accountEnd}, cond);
        }
    }

    private void setAccountEndValue(AccountViewInfo[] accountEnds, GLRptBaseCondition cond) {
        cond.setAccountCodeEnd(null);
        if (accountEnds != null) {
            String accountNumber = "";
            for (int i = 0; i < accountEnds.length; ++i) {
                AccountViewInfo account = accountEnds[i];
                if (account == null) continue;
                accountNumber = accountNumber + account.getNumber() + ",";
            }
            if (!accountNumber.equals("")) {
                accountNumber = accountNumber.substring(0, accountNumber.length() - 1);
            }
            cond.setAccountCodeEnd(accountNumber);
            cond.setAccountViewEnd((Object)accountEnds);
        }
    }
}

