/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.pcc.bsf.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.bsf.annotation.Param;
import com.kingdee.bos.cdo.CommonDataObject;
import com.kingdee.bos.cdo.ICommonDataObject;
import com.kingdee.bos.cdo.utils.CDOUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.pcc.FIClosingCenterFacadeFactory;
import com.kingdee.eas.fi.pcc.IStage;
import com.kingdee.eas.fi.pcc.IStageTask;
import com.kingdee.eas.fi.pcc.ITask;
import com.kingdee.eas.fi.pcc.ITaskExecution;
import com.kingdee.eas.fi.pcc.ITaskSchedule;
import com.kingdee.eas.fi.pcc.PCCException;
import com.kingdee.eas.fi.pcc.StageCollection;
import com.kingdee.eas.fi.pcc.StageFactory;
import com.kingdee.eas.fi.pcc.StageInfo;
import com.kingdee.eas.fi.pcc.StageStatusEnum;
import com.kingdee.eas.fi.pcc.StageTaskFactory;
import com.kingdee.eas.fi.pcc.StageTaskInfo;
import com.kingdee.eas.fi.pcc.TaskCollection;
import com.kingdee.eas.fi.pcc.TaskExecutionFactory;
import com.kingdee.eas.fi.pcc.TaskExecutionInfo;
import com.kingdee.eas.fi.pcc.TaskFactory;
import com.kingdee.eas.fi.pcc.TaskInfo;
import com.kingdee.eas.fi.pcc.TaskScheduleCollection;
import com.kingdee.eas.fi.pcc.TaskScheduleFactory;
import com.kingdee.eas.fi.pcc.TaskScheduleInfo;
import com.kingdee.eas.fi.pcc.bsf.IBaseDataSerivce;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;

@Component(value={"com.kingdee.eas.fi.pcc.bsf.IBaseDataSerivce"})
public class BaseDataServiceImp
extends BusinessServices
implements IBaseDataSerivce {
    public BaseDataServiceImp(Context context) {
        super(context);
    }

    public void initCompanyData(String companyId) throws BOSException, EASBizException {
        IStage stageCtrl = StageFactory.getLocalInstance((Context)this.getContext());
        boolean bExisted = stageCtrl.exists("select id where company.id = '" + companyId + "'");
        if (bExisted) {
            return;
        }
        CoreBaseCollection cols = stageCtrl.getCollection("select * where company.id is null order by seq asc");
        if (cols.size() > 0) {
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)companyId));
            CoreBaseCollection companyStageCol = new CoreBaseCollection();
            CoreBaseCollection taskScheduleCol = new CoreBaseCollection();
            Timestamp ts = new Timestamp(Calendar.getInstance().getTimeInMillis());
            for (int index = 0; index < cols.size(); ++index) {
                StageInfo cStage = (StageInfo)cols.get(index);
                StageInfo stageInfo = new StageInfo();
                stageInfo.setId(BOSUuid.create((String)"F4DC3C8D"));
                stageInfo.setCompany(company);
                stageInfo.setNumber(cStage.getNumber());
                stageInfo.setName(cStage.getName());
                stageInfo.setSeq(cStage.getSeq());
                stageInfo.setCreateTime(ts);
                companyStageCol.add((CoreBaseInfo)stageInfo);
                IStageTask stageTaskCtrl = StageTaskFactory.getLocalInstance((Context)this.getContext());
                CoreBaseCollection stCol = stageTaskCtrl.getCollection("select * where stage.id = '" + cStage.getId().toString() + "' order by seq asc ");
                if (stCol.size() <= 0) continue;
                for (int j = 0; j < stCol.size(); ++j) {
                    StageTaskInfo stInfo = (StageTaskInfo)stCol.get(j);
                    TaskScheduleInfo tsInfo = new TaskScheduleInfo();
                    tsInfo.setSeq((j + 1) * 10);
                    tsInfo.setId(BOSUuid.create((String)"708C4ECD"));
                    tsInfo.setCompany(company);
                    tsInfo.setStage(stageInfo);
                    tsInfo.setTask(stInfo.getTask());
                    tsInfo.setPlanDateTime("105 23:59");
                    taskScheduleCol.add((CoreBaseInfo)tsInfo);
                }
            }
            if (companyStageCol.size() > 0) {
                stageCtrl.addnewBatchData(companyStageCol);
            }
            if (taskScheduleCol.size() > 0) {
                ITaskSchedule taskScheduleCtrl = TaskScheduleFactory.getLocalInstance((Context)this.getContext());
                taskScheduleCtrl.addnewBatchData(taskScheduleCol);
            }
        }
    }

    public String saveStage(CommonDataObject stageInfo) throws BOSException, EASBizException {
        IStage stageCtrl = StageFactory.getLocalInstance((Context)this.getContext());
        StageInfo newInfo = (StageInfo)CDOUtils.convertCDOToObjectInfo((Context)this.getContext(), (ICommonDataObject)stageInfo);
        IObjectPK pk = stageCtrl.save((CoreBaseInfo)newInfo);
        return pk.toString();
    }

    public void deleteStage(String stageID) throws BOSException, EASBizException {
        IStage stageCtrl = StageFactory.getLocalInstance((Context)this.getContext());
        stageCtrl.delete((IObjectPK)new ObjectStringPK(stageID));
    }

    public TaskCollection getAllTask() throws BOSException, EASBizException {
        ITask taskCtrl = TaskFactory.getLocalInstance((Context)this.getContext());
        return (TaskCollection)taskCtrl.getCollection("select *,creator.id,creator.name,creator.number order by number").cast(TaskCollection.class);
    }

    public String saveTask(@Param(value="taskInfo") @Description(value="\u4efb\u52a1\u4fe1\u606f") CommonDataObject taskInfo) throws BOSException, EASBizException {
        taskInfo.setBosType("CE17CE16");
        TaskInfo newInfo = (TaskInfo)CDOUtils.convertCDOToObjectInfo((Context)this.getContext(), (ICommonDataObject)taskInfo);
        UserInfo creator = new UserInfo();
        creator.setId(BOSUuid.read((String)this.getContext().getCaller().toString()));
        newInfo.setCreator(creator);
        Timestamp createTime = new Timestamp(Calendar.getInstance().getTimeInMillis());
        newInfo.setCreateTime(createTime);
        ITask taskCtrl = TaskFactory.getLocalInstance((Context)this.getContext());
        String oql = "select id where number = '" + newInfo.getNumber() + "'";
        if (newInfo.getId() != null) {
            oql = oql + " and id <> '" + newInfo.getId().toString() + "'";
        }
        if (taskCtrl.exists(oql)) {
            throw new PCCException(PCCException.TASKNUMBERDUP);
        }
        IObjectPK pk = taskCtrl.save((CoreBaseInfo)newInfo);
        return pk.toString();
    }

    public StageCollection getCompanyStage(String companyId) throws BOSException, EASBizException {
        IStage stageCtrl = StageFactory.getLocalInstance((Context)this.getContext());
        CoreBaseCollection cols = stageCtrl.getCollection("select id,number,name,seq where company.id = '" + companyId + "' order by number asc");
        return (StageCollection)cols.cast(StageCollection.class);
    }

    public TaskScheduleCollection getCompanyTaskSchedule(String companyId, String stageId) throws BOSException, EASBizException {
        ITaskSchedule taskScheduleCtrl = TaskScheduleFactory.getLocalInstance((Context)this.getContext());
        CoreBaseCollection col = taskScheduleCtrl.getCollection("select *,stage.id,stage.name,principal.id,principal.name,principal.number,task.id,task.name,task.number where company.id = '" + companyId + "' and stage.id = '" + stageId + "' " + "order by seq asc ");
        return (TaskScheduleCollection)col.cast(TaskScheduleCollection.class);
    }

    public void updateCompanyTaskSchedule(CommonDataObject taskScheduleInfo) throws BOSException, EASBizException {
        TaskScheduleInfo newInfo = this.convertToInfo(taskScheduleInfo);
        this.checkScheduleInfo(newInfo);
        ITaskSchedule taskScheduleCtrl = TaskScheduleFactory.getLocalInstance((Context)this.getContext());
        ObjectStringPK pk = new ObjectStringPK(taskScheduleInfo.getString((Object)"id"));
        TaskScheduleInfo oldInfo = (TaskScheduleInfo)taskScheduleCtrl.getValue((IObjectPK)pk);
        if (oldInfo == null) {
            throw new BOSException("PK" + pk + " isn't existed");
        }
        taskScheduleCtrl.update((IObjectPK)pk, (CoreBaseInfo)newInfo);
        this.updateExecuteInfo(newInfo, oldInfo);
    }

    private TaskScheduleInfo convertToInfo(CommonDataObject cdo) throws EASBizException, BOSException {
        TaskScheduleInfo newInfo = (TaskScheduleInfo)CDOUtils.convertCDOToObjectInfo((Context)this.getContext(), (ICommonDataObject)cdo);
        if (newInfo == null) {
            throw new BOSException("parameter is error,can't be converted to TaskScheduleInfo.");
        }
        if (newInfo.getId() == null) {
            throw new BOSException("id is null");
        }
        if (newInfo.getCompany() == null) {
            throw new BOSException("Company is null");
        }
        if (newInfo.getStage() == null) {
            throw new BOSException("Stage is null");
        }
        if (newInfo.getTask() == null) {
            throw new BOSException("Task is null");
        }
        return newInfo;
    }

    private void checkScheduleInfo(TaskScheduleInfo info) throws EASBizException, BOSException {
        String sql = "select count(*) tCount from T_PCC_TaskSchedule where fcompanyid = ? and ftaskid = ? and fid <> ? ";
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql, (Object[])new Object[]{info.getCompany().getId().toString(), info.getTask().getId().toString(), info.getId().toString()});
        try {
            if (rs != null && rs.next() && rs.getInt("tCount") > 0) {
                throw new PCCException(PCCException.COMPANYTASKDUP);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void updateExecuteInfo(TaskScheduleInfo newInfo, TaskScheduleInfo oldInfo) throws EASBizException, BOSException {
        String companyId = newInfo.getCompany().getId().toString();
        String taskId = newInfo.getTask().getId().toString();
        int period = this.getCurrentPeriod(newInfo.getCompany().getId().toString());
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_PCC_TaskExecution ").append("where fcompanyid = ?  ").append("and ftaskid = ? and fperiod = ? and FLastUpdateTime is not null ");
        Object[] params = new Object[]{companyId, taskId, new Integer(period)};
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString(), (Object[])params);
        try {
            if (rs != null && rs.next()) {
                FIClosingCenterFacadeFactory.getLocalInstance((Context)this.getContext()).updateByTaskExecChange(companyId, taskId, period, rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private int getCurrentPeriod(String companyId) {
        int year = Calendar.getInstance().get(1);
        int month = Calendar.getInstance().get(2) + 1;
        return year * 100 + month;
    }

    public void deleteCompanyTaskSchedule(String taskScheduleID) throws BOSException, EASBizException {
        ITaskSchedule taskScheduleCtrl = TaskScheduleFactory.getLocalInstance((Context)this.getContext());
        taskScheduleCtrl.delete((IObjectPK)new ObjectStringPK(taskScheduleID));
    }

    public void addNewCompanyTaskSchedule(CommonDataObject taskScheduleInfo) throws BOSException, EASBizException {
        if (taskScheduleInfo.get((Object)"id") == null) {
            taskScheduleInfo.put((Object)"id", (Object)BOSUuid.create((String)"708C4ECD").toString());
        }
        TaskScheduleInfo newInfo = this.convertToInfo(taskScheduleInfo);
        this.checkScheduleInfo(newInfo);
        ITaskSchedule taskScheduleCtrl = TaskScheduleFactory.getLocalInstance((Context)this.getContext());
        taskScheduleCtrl.addnew((CoreBaseInfo)newInfo);
        String companyId = newInfo.getCompany().getId().toString();
        String stageId = newInfo.getStage().getId().toString();
        String taskId = newInfo.getTask().getId().toString();
        int period = this.getCurrentPeriod(newInfo.getCompany().getId().toString());
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_PCC_TaskSchedule ").append("where fcompanyid = ? and fstageid = ? order by FSeq ");
        Object[] params = new Object[]{companyId, stageId};
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString(), (Object[])params);
        try {
            int i = 1;
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            while (rs != null && rs.next()) {
                paramList.add(new Object[]{new Integer(i * 10), rs.getString("FID")});
                ++i;
            }
            String updateSql = "update T_PCC_TaskSchedule set FSeq = ? where FID = ? ";
            DbUtil.executeBatch((Context)this.getContext(), (String)updateSql, paramList);
            sql.setLength(0);
            sql.append("select count(*) exeCount from T_PCC_TaskExecution ").append("where fcompanyid = ? and fperiod = ? ");
            params = new Object[]{companyId, new Integer(period)};
            rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString(), (Object[])params);
            if (rs.next() && rs.getInt("exeCount") > 0) {
                sql.setLength(0);
                sql.append("select count(*) exeCount from T_PCC_TaskExecution ").append("where fcompanyid = ? ").append("and fperiod = ? ").append("and ftaskid in (select ftaskid ").append("from T_PCC_TaskSchedule ").append("where fcompanyid = ? ").append("and fstageid = ?)");
                rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString(), (Object[])new Object[]{companyId, new Integer(period), companyId, stageId});
                StageStatusEnum stageStaus = StageStatusEnum.UNTREATED;
                if (rs.next() && rs.getInt("exeCount") > 0) {
                    stageStaus = StageStatusEnum.UNDERWAY;
                }
                TaskExecutionInfo teInfo = new TaskExecutionInfo();
                teInfo.setId(BOSUuid.create((BOSObjectType)teInfo.getBOSType()));
                teInfo.setCompany(newInfo.getCompany());
                teInfo.setTask(newInfo.getTask());
                teInfo.setPeriod(period);
                teInfo.setStageStatus(stageStaus);
                teInfo.setScheduleStatus(StageStatusEnum.UNDERWAY);
                ITaskExecution taskExeCtrl = TaskExecutionFactory.getLocalInstance((Context)this.getContext());
                taskExeCtrl.addnew((CoreBaseInfo)teInfo);
                sql.setLength(0);
                sql.append("update T_PCC_TaskExecution ").append("set FStageStatus = ? ").append("where fcompanyid = ? ").append("and fperiod = ? ").append("and ftaskid in (select ftaskid ").append("from T_PCC_TaskSchedule ").append("where fcompanyid = ? ").append("and fstageid = ?)");
                DbUtil.execute((Context)this.getContext(), (String)sql.toString(), (Object[])new Object[]{new Integer(stageStaus.getValue()), companyId, new Integer(period), companyId, stageId});
                sql.setLength(0);
                sql.append("update T_PCC_TaskExecution ").append("set FScheduleStatus = ? ").append("where fcompanyid = ? and fperiod = ? ");
                DbUtil.execute((Context)this.getContext(), (String)sql.toString(), (Object[])new Object[]{new Integer(3), companyId, new Integer(period)});
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }
}

