/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.pcc.bsf.impl;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.fi.pcc.SchedulePlanDateEnum;
import com.kingdee.eas.fi.pcc.StageInfo;
import com.kingdee.eas.fi.pcc.StageStatusEnum;
import com.kingdee.eas.fi.pcc.TaskInfo;
import com.kingdee.eas.fi.pcc.TaskStatusEnum;
import com.kingdee.eas.fi.pcc.TaskTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Date;

public class SubTaskInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id = null;
    private StageInfo stageItem = null;
    private TaskInfo taskItem = null;
    private Date planDate = null;
    private Date accomplishedTime = null;
    private UserInfo user = null;
    private PersonInfo person = null;
    private TaskStatusEnum status = null;
    private StageStatusEnum stageStatus = null;
    private StageStatusEnum scheduleStatus = null;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public StageInfo getStageItem() {
        return this.stageItem;
    }

    public void setStageItem(StageInfo stageItem) {
        this.stageItem = stageItem;
    }

    public TaskInfo getTaskItem() {
        return this.taskItem;
    }

    public void setTaskItem(TaskInfo taskItem) {
        this.taskItem = taskItem;
    }

    public Date getPlanDate() {
        return this.planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }

    public Date getAccomplishedTime() {
        return this.accomplishedTime;
    }

    public void setAccomplishedTime(Date accomplishedTime) {
        this.accomplishedTime = accomplishedTime;
    }

    public UserInfo getUser() {
        return this.user;
    }

    public void setUser(UserInfo user) {
        this.user = user;
    }

    public PersonInfo getPerson() {
        return this.person;
    }

    public void setPerson(PersonInfo person) {
        this.person = person;
    }

    public TaskStatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(TaskStatusEnum status) {
        this.status = status;
    }

    public StageStatusEnum getStageStatus() {
        return this.stageStatus;
    }

    public void setStageStatus(StageStatusEnum stageStatus) {
        this.stageStatus = stageStatus;
    }

    public StageStatusEnum getScheduleStatus() {
        return this.scheduleStatus;
    }

    public void setScheduleStatus(StageStatusEnum scheduleStatus) {
        this.scheduleStatus = scheduleStatus;
    }

    public static SubTaskInfo read(IRowSet rs, String periodNumber) throws SQLException {
        String personId;
        SubTaskInfo info = new SubTaskInfo();
        info.setId(rs.getString("FID"));
        if (info.getId() != null) {
            info.setAccomplishedTime(rs.getDate("FCreateTime"));
            info.setStatus(TaskStatusEnum.getEnum((int)rs.getInt("FStatus")));
            info.setStageStatus(StageStatusEnum.getEnum((int)rs.getInt("FStageStatus")));
            info.setScheduleStatus(StageStatusEnum.getEnum((int)rs.getInt("FScheduleStatus")));
        }
        if ((personId = rs.getString("FPersonId")) != null) {
            PersonInfo person = new PersonInfo();
            person.setId(BOSUuid.read((String)rs.getString("FPersonId")));
            info.setPerson(person);
        }
        UserInfo user = new UserInfo();
        user.setName(rs.getString("FUserName"));
        info.setUser(user);
        StageInfo stageItem = new StageInfo();
        stageItem.setName(rs.getString("FStageName"));
        info.setStageItem(stageItem);
        TaskInfo taskItem = new TaskInfo();
        taskItem.setId(BOSUuid.read((String)rs.getString("FTaskId")));
        taskItem.setName(rs.getString("FTaskName"));
        taskItem.setType(TaskTypeEnum.getEnum((int)rs.getInt("FType")));
        info.setTaskItem(taskItem);
        String planDateValue = rs.getString("FPlanDateTime");
        int year = Integer.parseInt(periodNumber.substring(0, 4));
        int month = Integer.parseInt(periodNumber.substring(4, 6));
        SchedulePlanDateEnum planDate = SchedulePlanDateEnum.getEnum((String)planDateValue);
        info.setPlanDate(planDate.getRepresentCalendarByPeriod(planDateValue, year, month).getTime());
        if (info.getStatus() == null || TaskStatusEnum.UNDERWAY.equals((Object)info.getStatus())) {
            info.setStatus(TaskStatusEnum.UNDERWAY);
            if (info.getPlanDate() != null && new Date().compareTo(info.getPlanDate()) >= 0) {
                info.setStatus(TaskStatusEnum.UNDERWAY_DELAY);
            }
        }
        return info;
    }
}

