/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.vc.bsf.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.IService;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.service.ServiceFactory;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.vc.BillTypeCollection;
import com.kingdee.eas.fi.vc.BillTypeFactory;
import com.kingdee.eas.fi.vc.BillTypeInfo;
import com.kingdee.eas.fi.vc.IVoucherCenterFacade;
import com.kingdee.eas.fi.vc.SubSystemItemCollection;
import com.kingdee.eas.fi.vc.SubSystemItemFactory;
import com.kingdee.eas.fi.vc.SubSystemItemInfo;
import com.kingdee.eas.fi.vc.UnVoucheredFilterFactory;
import com.kingdee.eas.fi.vc.UnVoucheredFilterInfo;
import com.kingdee.eas.fi.vc.VoucherCenterFacadeFactory;
import com.kingdee.eas.fi.vc.app.dap.VcDapUtil;
import com.kingdee.eas.fi.vc.bsf.VoucherCenterService;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.fi.vc.bsf.VoucherCenterService"})
public class VoucherCenterServiceImpl
extends BusinessServices
implements VoucherCenterService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.vc.bsf.impl.VoucherCenterServiceImpl");

    public VoucherCenterServiceImpl(Context context) {
        super(context);
    }

    private IVoucherCenterFacade getVcFacade() throws BOSException, EASBizException {
        return VoucherCenterFacadeFactory.getLocalInstance((Context)this.getContext());
    }

    @Override
    public OrgUnitInfo[] getVCCompanyCollection() throws EASBizException, BOSException {
        IService service = ServiceFactory.getLocalInstance((Context)this.getContext());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("permissionItem", "fi_voucher_center");
        String result = service.invoke("EAS_BIZ_FICenterBaseService", "getFuncPermissionOrgUnitCollection", JSONUtils.convertObjectToJson((Context)this.getContext(), param));
        OrgUnitInfo[] orgUnitInfo = new OrgUnitInfo[1];
        return (OrgUnitInfo[])JSONUtils.convertJsonToObject((Context)this.getContext(), (String)result, orgUnitInfo.getClass());
    }

    @Override
    public List<SystemEnum> getSubSystemCollection() throws EASBizException, BOSException {
        ArrayList<SystemEnum> result = new ArrayList<SystemEnum>();
        String sql = "select FSubSystem from T_VC_SubSystem order by FSeq asc";
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
        try {
            while (rs.next()) {
                int subSystemValue = rs.getInt("FSubSystem");
                SystemEnum subSystemEnum = SystemEnum.getEnum((int)subSystemValue);
                result.add(subSystemEnum);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    public BillTypeCollection getBillTypeCollection(int subSystemValue) throws EASBizException, BOSException {
        return BillTypeFactory.getLocalInstance((Context)this.getContext()).getBillTypeCollection(subSystemValue);
    }

    @Override
    public List<SystemEnum> getSubSystemItemList() throws EASBizException, BOSException {
        ArrayList<SystemEnum> result = new ArrayList<SystemEnum>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("seq"));
        selector.add(new SelectorItemInfo("subSystem"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("user", (Object)this.getContext().getCaller(), CompareType.EQUALS));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("seq"));
        view.setSelector(selector);
        view.setFilter(filter);
        view.setSorter(sorter);
        SubSystemItemCollection subSystemItemColl = SubSystemItemFactory.getLocalInstance((Context)this.getContext()).getSubSystemItemCollection(view);
        for (SubSystemItemInfo subSystemItemInfo : subSystemItemColl) {
            SystemEnum systemEnum = subSystemItemInfo.getSubSystem();
            result.add(systemEnum);
        }
        return result;
    }

    @Override
    public Map getSubSystemData() throws EASBizException, BOSException {
        HashMap<String, List<SystemEnum>> result = new HashMap<String, List<SystemEnum>>();
        List<SystemEnum> systems = this.getSubSystemCollection();
        result.put("systems", systems);
        List<SystemEnum> customs = this.getSubSystemItemList();
        result.put("customs", customs);
        return result;
    }

    @Override
    public void saveSubSystemItem(List<Map> data) throws EASBizException, BOSException {
        CoreBaseCollection coreBaseColl = new CoreBaseCollection();
        for (int i = 0; i < data.size(); ++i) {
            Map itemMap = data.get(i);
            Object value = itemMap.get("value");
            if (value == null) continue;
            int subSystemValue = 0;
            if (value instanceof Integer) {
                subSystemValue = (Integer)value;
            } else {
                if (!(value instanceof String)) continue;
                subSystemValue = Integer.parseInt((String)value);
            }
            SubSystemItemInfo itemInfo = new SubSystemItemInfo();
            itemInfo.setSeq(i);
            itemInfo.setSubSystem(SystemEnum.getEnum((int)subSystemValue));
            UserInfo user = new UserInfo();
            user.setId(BOSUuid.read((String)this.getContext().getCaller().toString()));
            itemInfo.setUser(user);
            coreBaseColl.add((CoreBaseInfo)itemInfo);
        }
        SubSystemItemFactory.getLocalInstance((Context)this.getContext()).delete("where user = '" + this.getContext().getCaller().toString() + "'");
        SubSystemItemFactory.getLocalInstance((Context)this.getContext()).save(coreBaseColl);
    }

    @Override
    public void saveUnVoucheredFilter(UnVoucheredFilterInfo info) throws EASBizException, BOSException {
        UnVoucheredFilterFactory.getLocalInstance((Context)this.getContext()).save((CoreBaseInfo)info);
    }

    @Override
    public int getVoucheredCount(String companyId, int period, int subSystemValue) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        PeriodInfo periodInfo = this.getPeriodInfo(companyInfo, period);
        return this.getVcFacade().getVoucheredCount(companyId, periodInfo.getId().toString(), subSystemValue);
    }

    @Override
    public List<Map> getUnVoucheredCount(String companyId, int period, int subSystemValue) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        PeriodInfo periodInfo = this.getPeriodInfo(companyInfo, period);
        return this.getVcFacade().getUnVoucheredCount(companyInfo, periodInfo, subSystemValue);
    }

    private PeriodInfo getPeriodInfo(CompanyOrgUnitInfo companyInfo, int period) throws EASBizException, BOSException {
        int PeriodYear = period / 100;
        int PeriodNumber = period % 100;
        PeriodTypeInfo periodType = companyInfo.getAccountPeriodType();
        return PeriodFactory.getLocalInstance((Context)this.getContext()).getPeriodInfo(PeriodYear, PeriodNumber, periodType);
    }

    @Override
    public String getUnVoucheredBillFilter(String companyId, int period, String bosType, int subSystemValue) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        PeriodInfo periodInfo = this.getPeriodInfo(companyInfo, period);
        return this.getVcFacade().getUnVoucheredBillFilter(companyInfo, periodInfo, bosType, subSystemValue);
    }

    @Override
    public BOTMappingCollection getBOTPMappingCollection(String companyId, String bosType) throws EASBizException, BOSException {
        return this.getVcFacade().getRulesByCompanyAndBOSType(companyId, bosType);
    }

    @Override
    public BOTMappingCollection getBOTPMappingIntersection(String companyId, String bosType, String[] billIds) throws EASBizException, BOSException {
        BOTMappingCollection col = null;
        col = this.getBOTPMappingCollection(companyId, bosType);
        col = VcDapUtil.getDAPMeetAllBills((Context)this.getContext(), (String)bosType, (String[])billIds, (BOTMappingCollection)col);
        return col;
    }

    @Override
    public void voucher(String companyId, String bosType, int period, String[] billIds, String[] botpRuleIds, int subSystemValue) throws EASBizException, BOSException {
        if ((billIds = this.getUnVoucheredBillIDs(companyId, period, bosType, subSystemValue, billIds)) == null || billIds.length <= 0) {
            return;
        }
        this.getVcFacade().voucher(companyId, bosType, subSystemValue, billIds, botpRuleIds);
    }

    @Override
    public void voucherAll(String companyId, String bosType, int period, String[] botpRuleIds, int subSystemValue) throws EASBizException, BOSException {
        String[] billIds = this.getUnVoucheredBillIDs(companyId, period, bosType, subSystemValue, null);
        if (billIds == null || billIds.length <= 0) {
            return;
        }
        this.getVcFacade().voucher(companyId, bosType, subSystemValue, billIds, botpRuleIds);
    }

    @Override
    public void voucherSingle(List<Map> list) throws EASBizException, BOSException {
        HashMap companyId_list = new HashMap();
        List<Map> tmpList = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Map record = list.get(i);
            if (record.get("botpRuleId") == null) continue;
            int subSystem = ((Double)record.get("subSystem")).intValue();
            record.put("subSystem", subSystem);
            String companyId = (String)record.get("companyId");
            if (companyId_list.containsKey(companyId)) {
                tmpList = (List)companyId_list.get(companyId);
            } else {
                tmpList = new ArrayList();
                companyId_list.put(companyId, tmpList);
            }
            tmpList.add(record);
        }
        Set keys = companyId_list.keySet();
        Iterator it = null;
        for (String companyId : keys) {
            this.getVcFacade().voucherSingle(companyId, (List)companyId_list.get(companyId));
        }
    }

    @Override
    public int getVoucheredBillCount(String companyId, String bosType, int subSystemValue) throws EASBizException, BOSException {
        return this.getVcFacade().getVoucheredBillCount(companyId, bosType, subSystemValue);
    }

    private String[] getUnVoucheredBillIDs(String companyId, int period, String bosType, int subSystemValue, String[] billIds) throws BOSException, EASBizException {
        Context ctx = this.getContext();
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        PeriodInfo periodInfo = this.getPeriodInfo(companyInfo, period);
        StringBuffer billTypeOql = new StringBuffer("select id, bosObjectType, queryPK where bosObjectType = '").append(bosType).append("' and subSystem = ").append(subSystemValue);
        BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo(billTypeOql.toString());
        String queryPK = billTypeInfo.getQueryPK();
        String filter = this.getVcFacade().getUnVoucheredBillFilter(companyInfo, periodInfo, bosType, subSystemValue);
        String queryOql = "select id where " + filter;
        if (billIds != null && billIds.length > 0) {
            StringBuffer idOql = new StringBuffer();
            idOql.append(" and id in (");
            int len = billIds.length;
            for (int i = 0; i < len; ++i) {
                idOql.append("'").append(billIds[i]).append("',");
            }
            idOql.replace(idOql.length() - 1, idOql.length(), ")");
            queryOql = queryOql + idOql.toString();
        }
        IMetaDataPK mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
        IQueryExecutor iexec = this.getQueryExecutor(ctx, mainQueryPK, queryOql);
        IRowSet rowSet = iexec.executeQuery();
        HashSet<String> ids = new HashSet<String>();
        try {
            while (rowSet.next()) {
                ids.add(rowSet.getString("id"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        String[] result = new String[]{};
        result = ids.toArray(result);
        return result;
    }

    private IQueryExecutor getQueryExecutor(Context ctx, IMetaDataPK queryPK, String oql) throws BOSException {
        IQueryExecutor exec = null;
        exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.setObjectView(oql);
        exec.option().isIgnoreOrder = true;
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().topCount = 10000;
        exec.option().isIgnoreRowCount = true;
        exec.option().pageCount = KDTDataRequestManager.defaultPageRow;
        return exec;
    }

    @Override
    public void clearPreviousDAPReport() throws EASBizException, BOSException {
        Context ctx = this.getContext();
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer buf = new StringBuffer().append("delete from T_VC_VoucherReport where ");
        buf.append("fUserID = '").append(userId).append("'");
        DbUtil.execute((Context)ctx, (String)buf.toString());
    }
}

