/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bot.engine.common;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.Null;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class BoteThirdObjectCache {
    private final Map cache = new HashMap();
    private final Map ObjNotFoundCache = new HashMap();
    private Context ctx;
    private static long lazyLoadTimes = 0L;
    private static List lazyLoadList = new ArrayList();
    private static ThreadLocal threadCtx = new ThreadLocal(){

        protected Object initialValue() {
            return new BoteThirdObjectCache();
        }
    };

    private BoteThirdObjectCache() {
    }

    private void setContext(Context ctx) {
        this.ctx = ctx;
    }

    public static BoteThirdObjectCache getInstance(Context ctx) {
        BoteThirdObjectCache botCache = (BoteThirdObjectCache)threadCtx.get();
        botCache.setContext(ctx);
        return botCache;
    }

    public void clear() {
        this.cache.clear();
        this.ObjNotFoundCache.clear();
        lazyLoadTimes = 0L;
        lazyLoadList.clear();
    }

    public void prepare(IObjectCollection col) {
        int n = col.size();
        for (int i = 0; i < n; ++i) {
            IObjectValue obj = col.getObject(i);
            this.cache.put(obj.get(obj.getPKField()).toString(), obj);
        }
    }

    public IObjectValue get(String objId) throws DataAccessException {
        BOSObjectType bosType = BOSUuid.read((String)objId).getType();
        return this.get(bosType, objId);
    }

    public Object getObject(String objId) {
        Object obj = this.cache.get(objId);
        return obj;
    }

    public void putObject(String objId, Object obj) {
        this.cache.put(objId, obj);
    }

    public IObjectValue get(BOSObjectType type, String objId) throws DataAccessException {
        IObjectValue obj = (IObjectValue)this.cache.get(objId);
        return obj;
    }

    public void prepareObjectByID(BOSObjectType type, List idList) throws DataAccessException {
        ArrayList<String> newIdList = new ArrayList<String>();
        for (int i = 0; i < idList.size(); ++i) {
            Object obj2;
            String objId = (String)idList.get(i);
            IObjectValue obj = (IObjectValue)this.cache.get(objId);
            if (obj != null || (obj2 = this.ObjNotFoundCache.get(objId)) == Null.NULL) continue;
            newIdList.add(objId);
        }
        if (newIdList.size() >= 0) {
            this.innerPrepareObjectByID(type, newIdList);
        }
    }

    public void clearSumInfo() {
        lazyLoadTimes = 0L;
        lazyLoadList.clear();
    }

    protected void innerPrepareObjectByID(BOSObjectType type, List idList) throws DataAccessException {
        HashSet idSet = new HashSet();
        idSet.addAll(idList);
        FilterItemInfo item = new FilterItemInfo("id", idSet, CompareType.INCLUDE);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo info = new FilterInfo();
        info.getFilterItems().add(item);
        view.setFilter(info);
        IObjectCollection objColl = null;
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)this.ctx);
            IORMappingDAO dao = ORMappingDAO.getInstance((BOSObjectType)type, (Context)this.ctx, (Connection)cn);
            objColl = dao.getCollection(view);
        }
        catch (SQLException sqle) {
            throw new SQLAccessException(sqle);
        }
        catch (ObjectNotFoundException da) {
            for (int i = 0; i < idList.size(); ++i) {
                this.ObjNotFoundCache.put(idList.get(i), Null.NULL);
            }
            throw da;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
        if (objColl != null && objColl.size() > 0) {
            for (int i = 0; i < objColl.size(); ++i) {
                IObjectValue val = objColl.getObject(i);
                if (val.get("id") == null) continue;
                this.cache.put(val.get("id").toString(), val);
            }
        }
    }

    public static long getLazyLoadTimes() {
        return lazyLoadTimes;
    }

    public static List getLazyLoadList() {
        return lazyLoadList;
    }
}

