/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bot.engine.common;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.kscript.dom.expr.ArrayIndexerExpr;
import com.kingdee.bos.kscript.dom.expr.BigDecimalExpr;
import com.kingdee.bos.kscript.dom.expr.BinaryOpExpr;
import com.kingdee.bos.kscript.dom.expr.BoolExpr;
import com.kingdee.bos.kscript.dom.expr.CodeExpr;
import com.kingdee.bos.kscript.dom.expr.DoubleExpr;
import com.kingdee.bos.kscript.dom.expr.FloatExpr;
import com.kingdee.bos.kscript.dom.expr.IdentifierExpr;
import com.kingdee.bos.kscript.dom.expr.IntExpr;
import com.kingdee.bos.kscript.dom.expr.LongExpr;
import com.kingdee.bos.kscript.dom.expr.MethodInvokeExpr;
import com.kingdee.bos.kscript.dom.expr.NullExpr;
import com.kingdee.bos.kscript.dom.expr.ObjectCreateExpr;
import com.kingdee.bos.kscript.dom.expr.PropertyExpr;
import com.kingdee.bos.kscript.dom.expr.StringExpr;
import com.kingdee.bos.kscript.dom.expr.UnaryExpr;
import com.kingdee.bos.kscript.dom.expr.VectorCreateExpr;
import com.kingdee.bos.kscript.dom.stmt.CodeStmt;
import com.kingdee.bos.kscript.dom.stmt.ElseIfItem;
import com.kingdee.bos.kscript.dom.stmt.ExprStmt;
import com.kingdee.bos.kscript.dom.stmt.IfStmt;
import com.kingdee.bos.kscript.dom.stmt.ReturnStmt;
import com.kingdee.bos.kscript.dom.stmt.VarDeclItem;
import com.kingdee.bos.kscript.dom.stmt.VarDeclStmt;
import com.kingdee.bos.kscript.parser.KScriptParser;
import com.kingdee.bos.metadata.bot.BOTRuleInfo;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentCollection;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentInfo;
import com.kingdee.bos.metadata.bot.exception.TODOException;
import com.kingdee.eas.base.botp.util.BotpScriptFuncDeclare;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BotpScriptFuncAnalyzer {
    private static Logger logger = Logger.getLogger(BotpScriptFuncAnalyzer.class);
    private Map funcMap = new HashMap();

    public void analyzeScriptMapping(Context ctx, BOTRuleInfo botRuleInfo) throws KScriptException, DataAccessException {
        BOTRuleSegmentCollection segmentCol = botRuleInfo.getRuleSegments();
        int size = segmentCol.size();
        for (int i = 0; i < size; ++i) {
            BOTRuleSegmentInfo segment = segmentCol.get(i);
            String srcExpr = segment.getSrcPropertyName();
            if (StringUtils.isEmpty((String)srcExpr)) {
                srcExpr = segment.getExpression();
            } else if (!srcExpr.startsWith("__src.")) {
                srcExpr = "__src." + srcExpr;
            }
            this.analyzeScriptStmt(srcExpr);
        }
        logger.debug((Object)("funcMap.size=" + this.funcMap.size()));
    }

    private void analyzeScriptStmt(String script) throws KScriptException {
        if (script == null) {
            return;
        }
        KScriptParser parser = new KScriptParser(script);
        parser.parse();
        List stmtList = parser.stmtList;
        int size = stmtList.size();
        for (int i = 0; i < size; ++i) {
            CodeStmt stmt = (CodeStmt)stmtList.get(i);
            if (stmt instanceof VarDeclStmt) continue;
            this.analyzeScriptCodeStmt(stmt);
        }
    }

    private void analyzeScriptCodeStmt(CodeStmt stmt) throws KScriptException {
        if (stmt instanceof ExprStmt) {
            CodeExpr expr = ((ExprStmt)stmt).expr;
            this.analyzeScriptCodeExpr(expr);
        } else if (stmt instanceof ReturnStmt) {
            CodeExpr expr = ((ReturnStmt)stmt).expr;
            this.analyzeScriptCodeExpr(expr);
        } else if (stmt instanceof VarDeclStmt) {
            VarDeclStmt declStmt = (VarDeclStmt)stmt;
            for (int i = 0; i < declStmt.varDeclList.size(); ++i) {
                VarDeclItem item = (VarDeclItem)declStmt.varDeclList.get(i);
                if (item.initExpr == null) continue;
                this.analyzeScriptCodeExpr(item.initExpr);
            }
        } else if (stmt instanceof IfStmt) {
            int i;
            IfStmt ifStmt = (IfStmt)stmt;
            this.analyzeScriptCodeExpr(ifStmt.testExpr);
            for (i = 0; i < ifStmt.trueStmtList.size(); ++i) {
                this.analyzeScriptCodeStmt((CodeStmt)ifStmt.trueStmtList.get(i));
            }
            if (ifStmt.elseStmtList != null) {
                for (i = 0; i < ifStmt.elseStmtList.size(); ++i) {
                    this.analyzeScriptCodeStmt((CodeStmt)ifStmt.elseStmtList.get(i));
                }
            }
            if (ifStmt.elseIfList != null) {
                for (i = 0; i < ifStmt.elseIfList.size(); ++i) {
                    ElseIfItem elseIf = (ElseIfItem)ifStmt.elseIfList.get(i);
                    this.analyzeScriptCodeExpr(elseIf.testExpr);
                    if (elseIf.stmtList == null) continue;
                    for (int j = 0; j < elseIf.stmtList.size(); ++j) {
                        this.analyzeScriptCodeStmt((CodeStmt)elseIf.stmtList.get(j));
                    }
                }
            }
        } else {
            throw new TODOException();
        }
    }

    private void analyzeScriptCodeExpr(CodeExpr expr) throws KScriptException {
        if (expr == null) {
            return;
        }
        if (!(expr instanceof IdentifierExpr) && !(expr instanceof PropertyExpr)) {
            if (expr instanceof UnaryExpr) {
                UnaryExpr unaryExpr = (UnaryExpr)expr;
                this.analyzeScriptCodeExpr(unaryExpr.expr);
            } else if (expr instanceof BinaryOpExpr) {
                BinaryOpExpr binaryOpExpr = (BinaryOpExpr)expr;
                this.analyzeScriptCodeExpr(binaryOpExpr.left);
                this.analyzeScriptCodeExpr(binaryOpExpr.right);
            } else if (expr instanceof MethodInvokeExpr) {
                MethodInvokeExpr methodInvokeExpr = (MethodInvokeExpr)expr;
                String methodName = methodInvokeExpr.methodName;
                List paramList = methodInvokeExpr.paramList;
                if (!"__BOTGetProperty".equalsIgnoreCase(methodName)) {
                    if (paramList.size() > 0 && methodName.startsWith("__BOT")) {
                        BotpScriptFuncDeclare func = (BotpScriptFuncDeclare)this.funcMap.get(methodName);
                        if (func == null) {
                            func = new BotpScriptFuncDeclare(methodName);
                            this.funcMap.put(methodName, func);
                        }
                        func.put(paramList);
                    }
                    for (int i = 0; i < paramList.size(); ++i) {
                        CodeExpr pramExpr = (CodeExpr)paramList.get(i);
                        this.analyzeScriptCodeExpr(pramExpr);
                    }
                }
            } else if (expr instanceof ObjectCreateExpr) {
                ObjectCreateExpr objCreateExpr = (ObjectCreateExpr)expr;
                for (CodeExpr pramExpr : objCreateExpr.paramList) {
                    this.analyzeScriptCodeExpr(pramExpr);
                }
            } else {
                if (expr instanceof BigDecimalExpr || expr instanceof StringExpr || expr instanceof IntExpr || expr instanceof FloatExpr || expr instanceof BoolExpr || expr instanceof DoubleExpr || expr instanceof LongExpr || expr instanceof NullExpr) {
                    return;
                }
                if (expr instanceof ArrayIndexerExpr) {
                    ArrayIndexerExpr arrayIndexerExpr = (ArrayIndexerExpr)expr;
                    this.analyzeScriptCodeExpr(arrayIndexerExpr.targetObjExpr);
                    this.analyzeScriptCodeExpr(arrayIndexerExpr.indexExpr);
                } else if (expr instanceof VectorCreateExpr) {
                    VectorCreateExpr newVecExpr = (VectorCreateExpr)expr;
                    for (int i = 0; i < newVecExpr.paramList.size(); ++i) {
                        CodeExpr pramExpr = (CodeExpr)newVecExpr.paramList.get(i);
                        this.analyzeScriptCodeExpr(pramExpr);
                    }
                } else {
                    throw new TODOException();
                }
            }
        }
    }

    public Map getFuncMap() {
        return this.funcMap;
    }
}

