/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.bot.engine.core;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bot.engine.core.BotObjectCacheLoader;
import com.kingdee.bos.bot.engine.core.BotObjectCreator;
import com.kingdee.bos.bot.engine.core.BoteParamCollection;
import com.kingdee.bos.bot.engine.core.BoteParamInfo;
import com.kingdee.bos.bot.engine.provider.IBotSQLFunctions;
import com.kingdee.bos.bot.engine.sql.BotSqlBuilder;
import com.kingdee.bos.bot.engine.sql.BotTempTableManager;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.bot.trace.TraceConstants;
import com.kingdee.eas.base.bot.trace.TraceManagerFactory;
import com.kingdee.eas.base.bot.trace.core.ITraceManager;
import com.kingdee.eas.base.bot.trace.util.TraceLevel;
import com.kingdee.eas.common.EASBizException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class BotSQLEngine {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.bos.metadata.bot.runtime.BotEngineNew");
    private final Context ctx;
    private BotTempTableManager tempTableManager = null;
    private BOTRelationCollection botRelationCols;
    private IObjectCollection destObjCols;
    private EntityObjectInfo srcEntity;
    private EntityObjectInfo destEntity;
    private List funcProviderList;
    protected ITraceManager trace = TraceManagerFactory.newInstance(TraceConstants.TRACETYPE_BOTP);
    private TraceLevel traceLevel = null;
    private List tempTableNameList = new ArrayList();
    private String mainTempTableName = null;
    private BotSqlBuilder sqlBuilder = null;
    private Connection conn = null;
    private String entityKeyField = "id";
    private BOTMappingInfo firstMappingInfo = null;
    private boolean isDAP = false;

    public BotSQLEngine(Context ctx, Connection conn) {
        this.ctx = ctx;
        this.conn = conn;
        this.init();
    }

    private void init() {
        this.tempTableManager = new BotTempTableManager(this.ctx);
    }

    public void addFunctionProvider(IBotSQLFunctions funcProvider) {
        if (this.funcProviderList == null) {
            this.funcProviderList = new ArrayList();
        }
        this.funcProviderList.add(funcProvider);
    }

    public IObjectCollection transform(String[] srcBillIDList, String[] entryNames, String[] srcEntryIDList, BOTMappingInfo botMappingInfo) throws BOSException, EASBizException {
        BoteParamCollection params = new BoteParamCollection();
        BoteParamInfo paramInfo = new BoteParamInfo(botMappingInfo, srcBillIDList, entryNames, srcEntryIDList);
        params.add(paramInfo);
        BOSObjectType destBosType = botMappingInfo.getDestEntity().getType();
        return this.transform(destBosType, params);
    }

    public IObjectCollection transform(BOSObjectType destBosType, BoteParamCollection params) throws BOSException, EASBizException {
        long ts = System.currentTimeMillis();
        try {
            this.sqlBuilder = new BotSqlBuilder(this.ctx, this.conn, params, this.funcProviderList, this.tempTableManager);
            this.sqlBuilder.setEntityKeyField(this.entityKeyField);
            this.preCheckParam(destBosType, params);
            this.mainTempTableName = this.createMainTempTable(this.conn, this.sqlBuilder);
            this.tempTableNameList.add(this.mainTempTableName);
            for (int i = 0; i < params.size(); ++i) {
                BoteParamInfo param = params.get(i);
                this.innerTransform(destBosType, param);
            }
            long t2 = System.currentTimeMillis();
            BotObjectCreator creator = new BotObjectCreator(this.conn, this.destEntity, this.mainTempTableName, this.sqlBuilder, this.ctx);
            this.destObjCols = creator.create();
            this.botRelationCols = creator.getBotRelations();
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw e;
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            BotObjectCacheLoader.getInstance(this.ctx).clear();
            this.releaseTempTable();
        }
        return this.destObjCols;
    }

    protected void preCheckParam(BOSObjectType destBosType, BoteParamCollection params) throws BOSException {
        if (destBosType == null || params == null || params.size() <= 0) {
            throw new BOSException("BOTE parameters is empty!,  destBosType=" + destBosType + ",  params=" + params);
        }
        for (int i = 0; i < params.size(); ++i) {
            BoteParamInfo param = params.get(i);
            String[] srcObjectIDList = param.getSrcBillIDList();
            String[] srcEntryIDList = param.getSrcEntryIDList();
            BOTMappingInfo mappingInfo = param.getMappingInfo();
            if (srcObjectIDList == null || mappingInfo == null) {
                throw new BOSException("BOTE parameters[" + i + "] is error!,  param=" + param);
            }
            if (destBosType != mappingInfo.getDestEntity().getType()) {
                throw new BOSException("BOTE parameters[" + i + "]'s destBosType is error!,  destBosType=" + destBosType + ",  param=" + param);
            }
            if (this.firstMappingInfo != null) continue;
            this.firstMappingInfo = mappingInfo;
        }
        if (this.firstMappingInfo == null) {
            throw new BOSException("BOTE parameters is empty!,  destBosType=" + destBosType + ",  params=" + params);
        }
        this.destEntity = this.firstMappingInfo.getDestEntity();
        this.sqlBuilder.processGroupAndAggregateSet(this.firstMappingInfo);
        if (this.firstMappingInfo.getDefineSys() == DefineSysEnum.DAP) {
            this.isDAP = true;
            this.sqlBuilder.setDAP(true);
        }
    }

    protected void innerTransform(BOSObjectType destBosType, BoteParamInfo param) throws BOSException, EASBizException {
        String[] srcBillIDList = param.getSrcBillIDList();
        String[] srcEntryIDList = param.getSrcEntryIDList();
        BOTMappingInfo mappingInfo = param.getMappingInfo();
        String[] entryNames = param.getEntryNames();
        this.innerTransform(destBosType, srcBillIDList, entryNames, srcEntryIDList, mappingInfo);
    }

    protected void innerTransform(BOSObjectType destBosType, String[] srcObjectIDList, String[] entryNames, String[] srcEntryIDList, BOTMappingInfo mappingInfo) throws BOSException, EASBizException {
        if (this.sqlBuilder == null) {
            throw new BOSException("Error , The <sqlBuilder> is null!");
        }
        this.sqlBuilder.insertTempTableData(destBosType, srcObjectIDList, entryNames, srcEntryIDList, mappingInfo, this.mainTempTableName);
    }

    protected String createMainTempTable(Connection cn, BotSqlBuilder sqlBuilder) throws BOSException, EASBizException {
        String createTableSQL = sqlBuilder.getTempTableCreateSql();
        String tmpTableName = this.tempTableManager.createNewTempTable(createTableSQL);
        sqlBuilder.setMainTableName(tmpTableName);
        return tmpTableName;
    }

    public BOTRelationCollection getBotRelationCols() {
        return this.botRelationCols;
    }

    public IObjectCollection getDestObjCols() {
        return this.destObjCols;
    }

    protected void releaseTempTable() {
        try {
            for (int i = 0; i < this.tempTableNameList.size(); ++i) {
                String tempTableName = (String)this.tempTableNameList.get(i);
                this.tempTableManager.releaseTempTable(tempTableName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getEntityKeyField() {
        return this.entityKeyField;
    }

    public void setEntityKeyField(String entityKeyField) {
        this.entityKeyField = entityKeyField;
    }
}

