/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.metadata.bot;

import com.kingdee.bos.Context;
import com.kingdee.bos.bot.engine.core.BotSQLEngine;
import com.kingdee.bos.bot.engine.provider.IBotSQLFunctions;
import com.kingdee.bos.bot.engine.sql.BotSqlUtils;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.app.BOTMappingHelper;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.util.LowTimer;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BOTTransformSQLE {
    private static Logger log = Logger.getLogger((String)"com.kingdee.bos.metadata.bot.BOTTransform");
    private static final char pointChars = '.';
    private static final String noGrouping = "noGrouping";
    private Map objectGroupingInfoMap = null;
    private Map relationInfoMap = null;
    private BOTRelationCollection relationCollection = null;
    private IObjectCollection destObjectCollection = null;
    private BOTMappingInfo botMapping = null;
    private Map aggregateInfoMap = null;
    private Context ctx = null;
    private Connection conn = null;
    protected SolutionInfo solution;
    private List funcProviderList = new ArrayList();
    private BotSqlUtils botSqlUtils = null;

    public BOTTransformSQLE(Context ctx) throws DataAccessException, IOException {
        this.ctx = ctx;
        this.botSqlUtils = new BotSqlUtils(ctx);
        this.conn = this.botSqlUtils.getConnection();
        this.solution = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
    }

    public void addFunctionProvider(IBotSQLFunctions funcProvider) throws KScriptException {
        this.funcProviderList.add(funcProvider);
    }

    public List getFunctionProviderList() {
        return this.funcProviderList;
    }

    public BOTRelationCollection getBOTRelationCollection() {
        return this.relationCollection;
    }

    public IObjectCollection businessObjectTransform(String[] srcBillIDList, String[] entryNames, String[] srcEntryIDList, BOTMappingInfo mappingInfo) throws Exception {
        LowTimer time = new LowTimer();
        if (!BOTMappingHelper.isMappingEnabled((BOTMappingInfo)mappingInfo)) {
            throw new BTPException(BTPException.MAPPINGENABLEERROR, new Object[]{mappingInfo.getName()});
        }
        BotSQLEngine botCoreEngine = new BotSQLEngine(this.ctx, this.conn);
        for (int i = 0; i < this.funcProviderList.size(); ++i) {
            botCoreEngine.addFunctionProvider((IBotSQLFunctions)this.funcProviderList.get(i));
        }
        IObjectCollection destObjCols = botCoreEngine.transform(srcBillIDList, entryNames, srcEntryIDList, mappingInfo);
        this.relationCollection = botCoreEngine.getBotRelationCols();
        long timeValue = time.msValue();
        return destObjCols;
    }
}

