/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.botp.client.AbstractBOTExportOptionUI;
import com.kingdee.eas.base.botp.client.BOTMappingImportMsgBox;
import com.kingdee.eas.base.botp.client.BOTProgressDlgUI;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipOutputStream;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BOTExportOptionUI
extends AbstractBOTExportOptionUI {
    private static final Logger logger = CoreUIObject.getLogger(BOTExportOptionUI.class);
    private static final String SUFFIX_JAR = ".jar";
    private static final String SUFFIX_XML = ".xml";
    private static final String SEPARATOR = "/";
    private static final String TMP_ZIP_FOLDER = "_TEMP_ZIP_FOLDER";
    private String currentExportDir;
    private boolean isJarFile = false;
    private File JarFile = null;

    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void kDRadioButton1_actionPerformed(ActionEvent e) throws Exception {
        this.kDRadioButton3.setEnabled(false);
        this.kDRadioButton4.setEnabled(false);
    }

    @Override
    protected void kDRadioButton2_actionPerformed(ActionEvent e) throws Exception {
        this.kDRadioButton3.setEnabled(true);
        this.kDRadioButton4.setEnabled(true);
    }

    @Override
    protected void btnExport_actionPerformed(ActionEvent e) throws Exception {
        super.btnExport_actionPerformed(e);
        this.getUIWindow().hide();
        if (this.kDRadioButton1.isSelected()) {
            this.exportAll2OneFile();
        } else {
            if (this.kDRadioButton4.isSelected()) {
                this.isJarFile = true;
            }
            this.exportOne2OneFile();
        }
    }

    private void exportOne2OneFile() throws Exception {
        File selectFile;
        String filetype = SUFFIX_JAR;
        String suffix = "jar";
        if (this.currentExportDir == null || !new File(this.currentExportDir).exists()) {
            this.currentExportDir = System.getProperty("user.home");
        }
        KDFileChooser chooser = new KDFileChooser(this.currentExportDir);
        if (!this.isJarFile) {
            chooser.setFileSelectionMode(1);
            chooser.setAcceptAllFileFilterUsed(false);
        } else {
            SimpleFileFilter f = new SimpleFileFilter(new String[]{"jar"});
            chooser.addChoosableFileFilter((FileFilter)f);
            chooser.setFileSelectionMode(0);
            chooser.setAcceptAllFileFilterUsed(false);
            filetype = chooser.getFileFilter().getDescription();
            suffix = filetype.substring(1, filetype.lastIndexOf(")"));
        }
        int rVal = chooser.showOpenDialog((Component)((Object)this));
        if (rVal != 0) {
            return;
        }
        File saveDir = selectFile = chooser.getSelectedFile();
        if (this.isJarFile) {
            saveDir = new File(this.getRootDirByFile(selectFile) + File.separator + TMP_ZIP_FOLDER);
            this.JarFile = selectFile;
        }
        String name = saveDir.getName();
        Pattern pattern = Pattern.compile("[/:\\*\\?<>\\|\"]");
        Matcher match = pattern.matcher(name);
        if ("".equals(name) || match.find()) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx.FILENAMEFORMATERROR"));
            return;
        }
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        BOTExportRun work = new BOTExportRun();
        work.setSaveDir(saveDir.getAbsolutePath());
        work.setBotMappingIdList(this.getBotMappingIdList());
        work.setOwner(this);
        work.setSuffix(suffix);
        UIContext uiContext = new UIContext((Object)this);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.base.botp.client.BOTProgressDlgUI", (Map)uiContext);
        BOTProgressDlgUI progressUI = (BOTProgressDlgUI)uiWindow.getUIObject();
        progressUI.setUITitle(EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx.BOTRULEEXPORT"));
        work.setProgressDlgUI(progressUI);
        progressUI.setAction(work);
        uiWindow.show();
        if (progressUI.getResult()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx.EXPORTSUCCESS"));
            this.getUIWindow().close();
        }
    }

    private File getRootDirByFile(File saveDir) {
        if (saveDir == null) {
            return null;
        }
        String sRealDir = saveDir.getAbsolutePath();
        int idx = sRealDir.indexOf("\\");
        if (idx > 0) {
            sRealDir = sRealDir.substring(0, idx);
            saveDir = new File(sRealDir);
        }
        return saveDir;
    }

    private File processFileSuffixWithDir(File saveDir, String suffix) {
        if (saveDir.isFile() && saveDir.getAbsolutePath().endsWith(SUFFIX_JAR) && saveDir.getAbsolutePath().lastIndexOf("\\") >= 0) {
            String strRealDir = saveDir.getAbsolutePath();
            strRealDir = strRealDir.substring(0, strRealDir.lastIndexOf("."));
            saveDir = new File(strRealDir);
        }
        return saveDir;
    }

    private void exportAll2OneFile() throws BOSException, IOException {
        if (this.currentExportDir == null || !new File(this.currentExportDir).exists()) {
            this.currentExportDir = System.getProperty("user.home");
        }
        KDFileChooser chooser = new KDFileChooser(this.currentExportDir);
        SimpleFileFilter ff = new SimpleFileFilter(new String[]{"xml"});
        chooser.addChoosableFileFilter((FileFilter)ff);
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(false);
        String fileName = null;
        int rVal = chooser.showOpenDialog((Component)((Object)this));
        if (rVal == 0) {
            fileName = chooser.getSelectedFile().getPath();
            this.currentExportDir = fileName.substring(0, fileName.lastIndexOf("\\"));
            String name = chooser.getSelectedFile().getName();
            String filetype = chooser.getFileFilter().getDescription();
            String suffix = filetype.substring(1, filetype.lastIndexOf(")"));
            Pattern pattern = Pattern.compile("[/:\\*\\?<>\\|\"]");
            Matcher match = pattern.matcher(name);
            if ("".equals(name) || match.find()) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx.FILENAMEFORMATERROR"));
                return;
            }
            int dotIndex = fileName.lastIndexOf(SUFFIX_XML);
            if (dotIndex == -1) {
                fileName = fileName + suffix;
            }
            BOTExportAllRun work = new BOTExportAllRun();
            work.setBotMappingIdList(this.getBotMappingIdList());
            work.setOwner(this);
            work.setSuffix(suffix);
            work.setFileName(fileName);
            UIContext uiContext = new UIContext((Object)this);
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.base.botp.client.BOTProgressDlgUI", (Map)uiContext);
            BOTProgressDlgUI progressUI = (BOTProgressDlgUI)uiWindow.getUIObject();
            progressUI.setUITitle(EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx.BOTRULEEXPORT"));
            work.setProgressDlgUI(progressUI);
            progressUI.setAction(work);
            uiWindow.show();
            if (progressUI.getResult()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx.EXPORTSUCCESS"));
                this.getUIWindow().close();
            }
        }
    }

    private List getBotMappingIdList() {
        List botMappingIdList = new ArrayList();
        botMappingIdList = (List)this.getUIContext().get("idList");
        return botMappingIdList;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recurseFiles(JarOutputStream jos, File file, String basePath) throws IOException, FileNotFoundException {
        JarEntry jarEntry = null;
        FileInputStream fin = null;
        BufferedInputStream in = null;
        try {
            if (file.getAbsolutePath().indexOf(basePath) != -1) {
                int len;
                String parentPath = file.getParent();
                if (basePath.endsWith(Character.toString(File.separatorChar))) {
                    parentPath = parentPath + File.separatorChar;
                }
                String curPath = parentPath.substring(basePath.length());
                jarEntry = new JarEntry(curPath + file.getName());
                fin = new FileInputStream(file);
                in = new BufferedInputStream(fin);
                jos.putNextEntry(jarEntry);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) >= 0) {
                    jos.write(buf, 0, len);
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                fin.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                jos.closeEntry();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeFilesToZip(File[] files, String basePath, String zipFileName, int level) throws IOException, FileNotFoundException {
        FileOutputStream zipFile = null;
        ZipOutputStream jos = null;
        try {
            level = BOTExportOptionUI.checkZipLevel(level);
            zipFile = new FileOutputStream(zipFileName);
            jos = new JarOutputStream((OutputStream)zipFile, new Manifest());
            jos.setLevel(level);
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    BOTExportOptionUI.recurseFiles((JarOutputStream)jos, files[i], basePath);
                }
            }
        }
        finally {
            try {
                jos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                zipFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static int checkZipLevel(int level) {
        if (level < 0 || level > 9) {
            level = 7;
        }
        return level;
    }

    public static void deleteDirFile(String sDirFilePath) throws IOException {
        if (sDirFilePath != null && !sDirFilePath.trim().equals("")) {
            File tDirFile = new File(sDirFilePath);
            if (tDirFile.exists()) {
                if (tDirFile.isDirectory()) {
                    File[] arrFiles = tDirFile.listFiles();
                    for (int i = 0; i < arrFiles.length; ++i) {
                        if (!arrFiles[i].getName().endsWith(SUFFIX_XML) && !arrFiles[i].getName().endsWith(SUFFIX_JAR)) {
                            return;
                        }
                        BOTExportOptionUI.deleteDirFile(arrFiles[i].getAbsolutePath());
                    }
                    arrFiles = null;
                    tDirFile.delete();
                } else if (tDirFile.getName().endsWith(SUFFIX_XML) || tDirFile.getName().endsWith(SUFFIX_JAR)) {
                    tDirFile.delete();
                } else {
                    return;
                }
            }
            Object var1_1 = null;
        }
    }

    class BOTExportRun
    implements Runnable {
        String saveDir;
        List botMappingIdList;
        BOTExportOptionUI owner;
        BOTProgressDlgUI progressDlgUI;
        String suffix;

        BOTExportRun() {
        }

        @Override
        public void run() {
            try {
                this.exec();
            }
            catch (Exception e) {
                try {
                    logger.error((Object)e);
                    BOTExportOptionUI.this.handleException(e);
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BOTExportRun.this.progressDlgUI.stop();
                            BOTExportRun.this.progressDlgUI.getUIWindow().close();
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        public void exec() throws Exception {
            int i;
            IUIWindow uiWindow = null;
            if (this.botMappingIdList == null || this.botMappingIdList.size() == 0) {
                throw new BOTPException(BOTPException.FILEHASNOMAPPING);
            }
            int count = this.botMappingIdList.size();
            IBOTMapping iBotMapping = BOTMappingFactory.getRemoteInstance();
            String botMappingId = null;
            String botMappingName = null;
            String fileName = null;
            File[] files = new File[count];
            for (i = 0; i < count; ++i) {
                File fileTMP;
                botMappingId = (String)this.botMappingIdList.get(i);
                BOTMappingInfo botMappingInfo = iBotMapping.getBOTMappingInfo((IObjectPK)new ObjectStringPK(botMappingId));
                botMappingName = botMappingInfo.getName();
                botMappingName = botMappingName.replaceAll("[/:\\*\\?<>\\|\"]", "-");
                fileName = this.saveDir.replace('\\', '/') + BOTExportOptionUI.SEPARATOR + botMappingName + BOTExportOptionUI.SUFFIX_XML;
                fileName = this.saveDir + BOTExportOptionUI.SEPARATOR + botMappingName + BOTExportOptionUI.SUFFIX_XML;
                File file = new File(fileName);
                if (file.exists()) {
                    BOTMappingImportMsgBox msgBox;
                    if (uiWindow == null) {
                        UIContext uiContext = new UIContext((Object)this.progressDlgUI);
                        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                        uiWindow = uiFactory.create("com.kingdee.eas.base.botp.client.BOTMappingImportMsgBox", (Map)uiContext);
                        uiWindow.getUIObject().setUITitle(EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx.BOTRULEEXPORT"));
                    }
                    if ((msgBox = (BOTMappingImportMsgBox)uiWindow.getUIObject()).isNextShow()) {
                        String msgForShow = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx.BOTPMAPPINGDUPALARM"), botMappingName);
                        msgBox.setMsgForShow(msgForShow);
                        uiWindow.show();
                    }
                    if (msgBox.getResult() == BOTMappingImportMsgBox.EXIT) break;
                    if (msgBox.getResult() == BOTMappingImportMsgBox.SKIP) continue;
                    if (msgBox.getResult() == BOTMappingImportMsgBox.CONFIRM) {
                        BOTMappingInfo.writerBOTMappingInfoToFile(botMappingInfo, fileName);
                    }
                } else {
                    BOTMappingInfo.writerBOTMappingInfoToFile(botMappingInfo, fileName);
                }
                files[i] = fileTMP = new File(fileName);
            }
            if (BOTExportOptionUI.this.isJarFile) {
                String zipFileName = BOTExportOptionUI.this.JarFile.getAbsolutePath();
                if (!zipFileName.endsWith(BOTExportOptionUI.SUFFIX_JAR)) {
                    zipFileName = zipFileName + BOTExportOptionUI.SUFFIX_JAR;
                }
                BOTExportOptionUI.makeFilesToZip(files, this.saveDir + File.separatorChar, zipFileName, 7);
                BOTExportOptionUI.deleteDirFile(this.saveDir);
            }
            if (i == count && count > 0) {
                this.progressDlgUI.setResult(true);
            }
        }

        public BOTExportOptionUI getOwner() {
            return this.owner;
        }

        public void setOwner(BOTExportOptionUI owner) {
            this.owner = owner;
        }

        public String getSaveDir() {
            return this.saveDir;
        }

        public void setSaveDir(String saveDir) {
            this.saveDir = saveDir;
        }

        public List getBotMappingIdList() {
            return this.botMappingIdList;
        }

        public void setBotMappingIdList(List idList) {
            this.botMappingIdList = idList;
        }

        public BOTProgressDlgUI getProgressDlgUI() {
            return this.progressDlgUI;
        }

        public void setProgressDlgUI(BOTProgressDlgUI progressDlgUI) {
            this.progressDlgUI = progressDlgUI;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }
    }

    class BOTExportAllRun
    implements Runnable {
        String saveDir;
        List botMappingIdList;
        BOTExportOptionUI owner;
        BOTProgressDlgUI progressDlgUI;
        String suffix;
        String fileName;

        BOTExportAllRun() {
        }

        @Override
        public void run() {
            try {
                this.exec();
            }
            catch (Exception e) {
                try {
                    logger.error((Object)e);
                    BOTExportOptionUI.this.handleException(e);
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BOTExportAllRun.this.progressDlgUI.stop();
                            BOTExportAllRun.this.progressDlgUI.getUIWindow().close();
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        public void exec() throws Exception {
            if (this.botMappingIdList == null || this.botMappingIdList.size() == 0) {
                throw new BOTPException(BOTPException.FILEHASNOMAPPING);
            }
            int SIZEPER = 30;
            int size = this.botMappingIdList.size();
            ArrayList botMappingColsList = new ArrayList();
            IBOTMapping iBotMapping = BOTMappingFactory.getRemoteInstance();
            File file = new File(this.fileName);
            if (file.exists()) {
                file.delete();
            }
            for (int i = 0; i <= size / SIZEPER; ++i) {
                BOTMappingCollection botMappingCols = new BOTMappingCollection();
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                evi.setFilter(filter);
                StringBuffer mask = new StringBuffer();
                for (int j = 0; j < SIZEPER && i * SIZEPER + j < size; ++j) {
                    String botId = (String)this.botMappingIdList.get(i * SIZEPER + j);
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)botId));
                    if (j == 0) {
                        mask.append("#");
                    } else {
                        mask.append(" or #");
                    }
                    mask.append(j);
                }
                if (mask.toString().length() <= 0) continue;
                filter.setMaskString(mask.toString());
                botMappingCols = iBotMapping.getBOTMappingCollection(evi);
                BOTMappingInfo.appendInfoToXml(botMappingCols, this.fileName);
            }
            this.progressDlgUI.setResult(true);
        }

        public BOTExportOptionUI getOwner() {
            return this.owner;
        }

        public void setOwner(BOTExportOptionUI owner) {
            this.owner = owner;
        }

        public String getSaveDir() {
            return this.saveDir;
        }

        public void setSaveDir(String saveDir) {
            this.saveDir = saveDir;
        }

        public List getBotMappingIdList() {
            return this.botMappingIdList;
        }

        public void setBotMappingIdList(List idList) {
            this.botMappingIdList = idList;
        }

        public BOTProgressDlgUI getProgressDlgUI() {
            return this.progressDlgUI;
        }

        public void setProgressDlgUI(BOTProgressDlgUI progressDlgUI) {
            this.progressDlgUI = progressDlgUI;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
        }
    }
}

