/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDScrollBar;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataNotFoundException;
import com.kingdee.bos.metadata.bot.BOTAggregateCollection;
import com.kingdee.bos.metadata.bot.BOTAggregateInfo;
import com.kingdee.bos.metadata.bot.BOTExtSetRuleCollection;
import com.kingdee.bos.metadata.bot.BOTExtSetRuleInfo;
import com.kingdee.bos.metadata.bot.BOTGroupingCollection;
import com.kingdee.bos.metadata.bot.BOTGroupingInfo;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTMergeCharsCollection;
import com.kingdee.bos.metadata.bot.BOTMergeCharsInfo;
import com.kingdee.bos.metadata.bot.BOTRevRuleInfo;
import com.kingdee.bos.metadata.bot.BOTRevRuleSegmentCollection;
import com.kingdee.bos.metadata.bot.BOTRevRuleSegmentInfo;
import com.kingdee.bos.metadata.bot.BOTRuleCollection;
import com.kingdee.bos.metadata.bot.BOTRuleInfo;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentCollection;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.botp.client.AbstractBOTMappingCompareUI;
import com.kingdee.eas.base.botp.client.util.BotpNumberDocument;
import com.kingdee.eas.base.botp.client.util.MetaDataUtil;
import com.kingdee.eas.base.botp.util.BotpMetaDataFactory;
import com.kingdee.eas.base.botp.util.IBotpMetaData;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JScrollBar;
import javax.swing.text.Document;

public class BOTMappingCompareUI
extends AbstractBOTMappingCompareUI {
    private EntityObjectInfo srcEntity;
    private EntityObjectInfo destEntity;
    private IBotpMetaData srcBotpEntity;
    private IBotpMetaData destBotpEntity;
    private boolean isSupportCompositeRelate = false;
    private ArrayList destDetailEntryList = new ArrayList();
    private ArrayList srcDetailEntryList = new ArrayList();
    private static final String ISFORMAPPING = "isForMapping";
    private static final String ISFORGROUPING = "isForGrouping";
    private static final String ISFORWRITTENBACK = "isForWrittenBack";
    private static final String HEADKEY = "headkey";
    private static final String HEADVALUE = "headvalue";
    private static final String GROUPKEY = "groupkey";
    private static final String GROUPLEVEL = "grouplevel";
    private static final String GROUPVALUE = "groupvalue";
    private static final String AGGREGATEKEY = "aggregateKey";
    private static final String AGGREGATELEVEL = "aggregateLevel";
    private static final String AGGREGATEVALUE = "aggregateValue";
    private static final String REVKEY = "revkey";
    private static final String REVVALUE = "revvalue";
    private static final String MERGECHARSKEY = "mergeCharsKey";
    private static final String MERGECHARSLEVEL = "mergeCharsLevel";
    private static final String MERGECHARSVALUE = "mergeCharsValue";
    private static final String MERGECHARSSIGN = "mergeCharsSign";
    private static final String COMPAREKEY = "compare";
    private static final String RESXFILENAME = "com.kingdee.eas.base.botp.BotpResx";
    private static final String SELECTLEVEL2 = "SELECTLEVEL2";
    private static final String UNSELECTLEVEL2 = "UNSELECTLEVEL2";
    private static final String DIFFERENCE = "COMPAREDIFF";
    private static final String UPDATE = EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx", (String)"COMPAREDIFF");
    private static final String ACCOUNTNAME = "entries.account";
    private static final String CURRENCYNAME = "entries.currency";
    private static final String ENTRYDCNAME = "entries.entryDC";
    private boolean isDAPTrans = false;
    private static Locale zh_en = LocaleUtils.locale_en_US;
    private static Locale zh_cn = LocaleUtils.locale_zh_CN;
    private static Locale zh_hk = LocaleUtils.locale_zh_TW;
    private Map botDetailEntryMap = new HashMap();
    private BOTMappingInfo newmappingInfo = null;
    BOTRuleSegmentCollection oldruleSegs = new BOTRuleSegmentCollection();
    BOTRuleSegmentCollection newruleSegs = new BOTRuleSegmentCollection();

    public BOTMappingCompareUI() throws Exception {
        this.txtCode.setDocument((Document)new BotpNumberDocument());
        this.tblHeadRule.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblHeadRule.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        this.tblDetailRule.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblDetailRule.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        this.tblRevRule.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblRevRule.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        KDScrollBar vsb = new KDScrollBar(1);
        this.tblDetailRule.getLayoutManager().setVerticalScrollBar((JScrollBar)vsb);
        KDScrollBar hsb = new KDScrollBar(0);
        this.tblDetailRule.getLayoutManager().setHorizonScrollBar((JScrollBar)hsb);
        this.tfCode.setDocument((Document)new BotpNumberDocument());
        this.tblHeadRule1.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblHeadRule1.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        this.tblDetailRule1.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblDetailRule1.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        this.tblRevRule1.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        this.tblRevRule1.getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        KDScrollBar vsb1 = new KDScrollBar(1);
        this.tblDetailRule1.getLayoutManager().setVerticalScrollBar((JScrollBar)vsb1);
        KDScrollBar hsb1 = new KDScrollBar(0);
        this.tblDetailRule1.getLayoutManager().setHorizonScrollBar((JScrollBar)hsb1);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        for (Map.Entry entry : this.botDetailEntryMap.entrySet()) {
            ((BOTDetailEntryInfo)entry.getValue()).setInGrp(false);
            ((BOTDetailEntryInfo)entry.getValue()).setInRule(false);
        }
        this.loadRuleFields();
        this.loadGroupFields();
        this.loadAggregateFields();
        this.loadRevRuleFields();
        this.loadMergeCharsFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblHeadRule.checkParsed();
        this.tblDetailRule.checkParsed();
        this.tblGroupingRule.checkParsed();
        this.tblAggregate.checkParsed();
        this.tblRevRule.checkParsed();
        this.tblMergeCharsTop.checkParsed();
        this.tblHeadRule1.checkParsed();
        this.tblDetailRule1.checkParsed();
        this.tblGroupingRule1.checkParsed();
        this.tblAggregate1.checkParsed();
        this.tblRevRule1.checkParsed();
        this.tblMergeCharsBottom.checkParsed();
        BOTMappingInfo oldData = (BOTMappingInfo)this.getUIContext().get("oldMappingInfo");
        this.newmappingInfo = (BOTMappingInfo)this.getUIContext().get("newMappingInfo");
        this.isDAPTrans = oldData.getDefineSys().getValue() == 10;
        this.setDataObject((IObjectValue)oldData);
        if (oldData.getDefineSys() != null) {
            this.setUITitle(oldData.getDefineSys().getAlias());
        } else {
            this.setUITitle(DefineSysEnum.BTP.getAlias());
        }
        this.tfCode.setText(this.newmappingInfo.getName());
        this.tfName.setItemData(new LanguageInfo(SysContext.getSysContext().getOriginLocale()), (Object)this.newmappingInfo.getAlias());
        LanguageInfo lang = new LanguageInfo(SysContext.getSysContext().getOriginLocale());
        this.tfName.setSelectedLanguage(lang);
        if (DefineSysEnum.DAP.equals((Object)oldData.getDefineSys())) {
            this.ctnRevRule.setVisible(false);
            this.tab.removeTabAt(4);
        }
        this.loadStructure();
        this.loadFields();
    }

    public void onShow() throws Exception {
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
    }

    protected IBOTMapping getBizInterface() throws Exception {
        return BOTMappingFactory.getRemoteInstance();
    }

    private void loadStructure() throws BOTPException {
        this.initEntity();
        this.loadRuleStructure();
        this.loadGroupStructure();
        this.loadAggregateStructure();
        this.loadRevRuleStructure();
        this.loadMergeCharsStructure();
    }

    private void initEntity() {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        try {
            this.srcEntity = loader.getEntity(BOSObjectType.create((String)this.mappingInfo.getSrcEntityName()));
        }
        catch (MetaDataNotFoundException e) {
            MsgBox.showError((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx.SRCENTITYNOTEXISTINBOTMAPPING"), this.mappingInfo.getSrcEntityName()));
            SysUtil.abort();
        }
        try {
            this.destEntity = loader.getEntity(BOSObjectType.create((String)this.mappingInfo.getDestEntityName()));
        }
        catch (MetaDataNotFoundException e) {
            MsgBox.showError((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx.DESTENTITYNOTEXISTINBOTMAPPING"), this.mappingInfo.getDestEntityName()));
            SysUtil.abort();
        }
        this.srcBotpEntity = BotpMetaDataFactory.createEntity(this.srcEntity);
        this.destBotpEntity = BotpMetaDataFactory.createEntity(this.destEntity);
        this.mappingInfo.setSrcEntityAlias(this.srcBotpEntity.getDisplayName(zh_en), zh_en);
        this.mappingInfo.setSrcEntityAlias(this.srcBotpEntity.getDisplayName(zh_cn), zh_cn);
        this.mappingInfo.setSrcEntityAlias(this.srcBotpEntity.getDisplayName(zh_hk), zh_hk);
        this.mappingInfo.setDestEntityAlias(this.destBotpEntity.getDisplayName(zh_en), zh_en);
        this.mappingInfo.setDestEntityAlias(this.destBotpEntity.getDisplayName(zh_cn), zh_cn);
        this.mappingInfo.setDestEntityAlias(this.destBotpEntity.getDisplayName(zh_hk), zh_hk);
        this.mappingInfo.setSrcEntityFullName(this.srcEntity.getFullName());
        this.mappingInfo.setDestEntityFullName(this.destEntity.getFullName());
        this.newmappingInfo.setSrcEntityAlias(this.srcBotpEntity.getDisplayName(zh_en), zh_en);
        this.newmappingInfo.setSrcEntityAlias(this.srcBotpEntity.getDisplayName(zh_cn), zh_cn);
        this.newmappingInfo.setSrcEntityAlias(this.srcBotpEntity.getDisplayName(zh_hk), zh_hk);
        this.newmappingInfo.setDestEntityAlias(this.destBotpEntity.getDisplayName(zh_en), zh_en);
        this.newmappingInfo.setDestEntityAlias(this.destBotpEntity.getDisplayName(zh_cn), zh_cn);
        this.newmappingInfo.setDestEntityAlias(this.destBotpEntity.getDisplayName(zh_hk), zh_hk);
        this.newmappingInfo.setSrcEntityFullName(this.srcEntity.getFullName());
        this.newmappingInfo.setDestEntityFullName(this.destEntity.getFullName());
        this.initDestDetailEntry(this.destBotpEntity);
        ArrayList srcBotpChildrenPropertyList = this.srcBotpEntity.getChildren();
        for (IBotpMetaData childProperty : srcBotpChildrenPropertyList) {
            if (childProperty.getDetailEntity() == null) continue;
            this.srcDetailEntryList.add(childProperty);
        }
    }

    private void initDestDetailEntry(IBotpMetaData destBotpMetadata) {
        ArrayList destBotpChildrenPropertyList = destBotpMetadata.getChildren();
        for (IBotpMetaData childProperty : destBotpChildrenPropertyList) {
            if (childProperty.getDetailEntity() != null) {
                boolean isTopDetailEntry = true;
                String[] propsArray = StringUtils.split((String)childProperty.getLongName(), (String)".");
                if (propsArray.length > 1) {
                    if (this.isSupportCompositeRelate) {
                        StringBuffer propsBuffer = new StringBuffer();
                        int size = propsArray.length;
                        for (int i = 0; i < size - 1; ++i) {
                            propsBuffer.append(propsArray[i]);
                            if (!this.botDetailEntryMap.containsKey(propsBuffer.toString())) continue;
                            isTopDetailEntry = false;
                            break;
                        }
                    } else {
                        isTopDetailEntry = false;
                    }
                }
                if (isTopDetailEntry) {
                    this.destDetailEntryList.add(childProperty);
                }
                BOTDetailEntryInfo detailEntryInfo = new BOTDetailEntryInfo(childProperty);
                this.botDetailEntryMap.put(childProperty.getLongName(), detailEntryInfo);
                this.initDestDetailEntry(childProperty);
                continue;
            }
            if (!this.isSupportCompositeRelate || childProperty.getCompositeRelateEntity() == null) continue;
            this.initDestDetailEntry(childProperty);
        }
    }

    private void loadRuleStructure() {
        this.loadHeadRuleStructure();
        this.loadBodyRuleStructure();
    }

    private void loadHeadRuleStructure() {
        IRow headRow = this.tblHeadRule.getHeadRow(0);
        ICell headKeyCell = headRow.getCell(HEADKEY);
        headKeyCell.setValue((Object)this.destBotpEntity.getDisplayName());
        this.buildHeadRuleRow(this.tblHeadRule, this.destBotpEntity);
        IRow headRow1 = this.tblHeadRule1.getHeadRow(0);
        ICell headKeyCell1 = headRow1.getCell(HEADKEY);
        headKeyCell1.setValue((Object)this.destBotpEntity.getDisplayName());
        this.buildHeadRuleRow(this.tblHeadRule1, this.destBotpEntity);
    }

    private void buildHeadRuleRow(KDTable tblRule, IBotpMetaData destBotpProperty) {
        ArrayList destBotpChildrenPropertyList = destBotpProperty.getChildren();
        for (IBotpMetaData childProperty : destBotpChildrenPropertyList) {
            if (this.isSupportCompositeRelate && childProperty.getCompositeRelateEntity() != null) {
                this.buildHeadRuleRow(tblRule, childProperty);
                continue;
            }
            if (this.destDetailEntryList.contains(childProperty) || !Boolean.TRUE.toString().equalsIgnoreCase(childProperty.getProperty().getExtendedProperty(ISFORMAPPING))) continue;
            IRow row = tblRule.addRow();
            ICell cellKey = row.getCell(HEADKEY);
            cellKey.getStyleAttributes().setLocked(true);
            cellKey.setValue((Object)childProperty.getDisplayName());
            cellKey.setUserObject((Object)childProperty);
        }
    }

    private void loadBodyRuleStructure() {
        ICell compareHeadCell;
        IRow head;
        IColumn compareColumn;
        KDTable tblDetailEntry;
        KDTabbedPane detailTabPane;
        IBotpMetaData detailData;
        int i;
        if (this.kDTabbedPane1.getTabCount() == 1) {
            this.kDTabbedPane1.setTitleAt(0, "");
        }
        int count = this.destDetailEntryList.size();
        for (i = 0; i < count; ++i) {
            detailData = (IBotpMetaData)this.destDetailEntryList.get(i);
            detailTabPane = this.kDTabbedPane1;
            if (i == 0 && detailTabPane.getTabCount() == 1) {
                detailTabPane.setTitleAt(i, detailData.getAlias());
            }
            if (i < detailTabPane.getTabCount()) {
                tblDetailEntry = (KDTable)detailTabPane.getComponentAt(i);
            } else {
                tblDetailEntry = new KDTable();
                tblDetailEntry.addHeadRow();
                detailTabPane.addTab(detailData.getAlias(), (Component)tblDetailEntry);
            }
            compareColumn = tblDetailEntry.addColumn();
            compareColumn.setWidth(50);
            compareColumn.setKey(COMPAREKEY);
            head = tblDetailEntry.getHeadRow(0);
            compareHeadCell = head.getCell(COMPAREKEY);
            compareHeadCell.setValue((Object)EASResource.getString((String)RESXFILENAME, (String)"0_BOTMappingCompareUI"));
            this.buildDetailColumn(tblDetailEntry, detailData, this.srcEntity, (IUIObject)this);
        }
        if (this.kDTabbedPane2.getTabCount() == 1) {
            this.kDTabbedPane2.setTitleAt(0, "");
        }
        count = this.destDetailEntryList.size();
        for (i = 0; i < count; ++i) {
            detailData = (IBotpMetaData)this.destDetailEntryList.get(i);
            detailTabPane = this.kDTabbedPane2;
            if (i == 0 && detailTabPane.getTabCount() == 1) {
                detailTabPane.setTitleAt(i, detailData.getAlias());
            }
            if (i < detailTabPane.getTabCount()) {
                tblDetailEntry = (KDTable)detailTabPane.getComponentAt(i);
            } else {
                tblDetailEntry = new KDTable();
                tblDetailEntry.addHeadRow();
                detailTabPane.addTab(detailData.getAlias(), (Component)tblDetailEntry);
            }
            compareColumn = tblDetailEntry.addColumn();
            compareColumn.setWidth(50);
            compareColumn.setKey(COMPAREKEY);
            head = tblDetailEntry.getHeadRow(0);
            compareHeadCell = head.getCell(COMPAREKEY);
            compareHeadCell.setValue((Object)EASResource.getString((String)RESXFILENAME, (String)"0_BOTMappingCompareUI"));
            this.buildDetailColumn(tblDetailEntry, detailData, this.srcEntity, (IUIObject)this);
        }
    }

    private void buildDetailColumn(KDTable table, IBotpMetaData propertyData, EntityObjectInfo srcEntity, IUIObject owner) {
        ArrayList destBotpChildrenPropertyList = propertyData.getChildren();
        Iterator iter = destBotpChildrenPropertyList.iterator();
        IRow head = table.getHeadRow(0);
        while (iter.hasNext()) {
            IBotpMetaData childProperty = (IBotpMetaData)iter.next();
            if (childProperty.getDetailEntity() != null || this.isSupportCompositeRelate && childProperty.getCompositeRelateEntity() != null) {
                this.buildDetailColumn(table, childProperty, srcEntity, owner);
                continue;
            }
            if (!Boolean.TRUE.toString().equalsIgnoreCase(childProperty.getProperty().getExtendedProperty(ISFORMAPPING))) continue;
            IColumn column = table.addColumn();
            column.setWidth(150);
            column.setUserObject((Object)childProperty);
            column.setKey(childProperty.getLongName());
            ICell headCell = head.getCell(childProperty.getLongName());
            String title = childProperty.getLongDisplayName().substring(childProperty.getLongDisplayName().indexOf(".") + 1);
            headCell.setValue((Object)title);
        }
    }

    private void loadAggregateStructure() {
        this.buildAggregateRow(this.tblAggregate, this.destBotpEntity);
        this.buildAggregateRow(this.tblAggregate1, this.destBotpEntity);
    }

    private void loadMergeCharsStructure() {
        this.buildMergeCharsRow(this.tblMergeCharsTop, this.destBotpEntity);
        this.buildMergeCharsRow(this.tblMergeCharsBottom, this.destBotpEntity);
    }

    private void buildAggregateRow(KDTable table, IBotpMetaData metaData) {
        ArrayList destBotpChildrenPropertyList = metaData.getChildren();
        Iterator iter = destBotpChildrenPropertyList.iterator();
        int level1AggregateCount = 0;
        while (iter.hasNext()) {
            String key;
            IBotpMetaData childProperty = (IBotpMetaData)iter.next();
            if (childProperty.getDetailEntity() != null || this.isSupportCompositeRelate && childProperty.getCompositeRelateEntity() != null) {
                this.buildAggregateRow(table, childProperty);
                continue;
            }
            if (!(childProperty.getProperty() instanceof OwnPropertyInfo) || !MetaDataUtil.isNumric(((OwnPropertyInfo)childProperty.getProperty()).getDataType()) || (key = childProperty.getLongName()).equals("entries.reportingAmount") || key.equals("entries.assistRecords.reportingAmount")) continue;
            int level = StringUtils.split((String)key, (String)".").length;
            if (level == 1) {
                ++level1AggregateCount;
            }
            IRow row = table.addRow();
            ICell cellkey = row.getCell(AGGREGATEKEY);
            cellkey.setValue((Object)childProperty.getLongDisplayName());
            cellkey.setUserObject((Object)childProperty);
            ICell celllevel = row.getCell(AGGREGATELEVEL);
            celllevel.setValue((Object)new Integer(level));
        }
    }

    private void buildMergeCharsRow(KDTable table, IBotpMetaData metaData) {
        ArrayList destBotpChildrenPropertyList = metaData.getChildren();
        Iterator iter = destBotpChildrenPropertyList.iterator();
        int level1MergeCharsCount = 0;
        while (iter.hasNext()) {
            IBotpMetaData childProperty = (IBotpMetaData)iter.next();
            if (childProperty.getDetailEntity() != null || this.isSupportCompositeRelate && childProperty.getCompositeRelateEntity() != null) {
                this.buildMergeCharsRow(table, childProperty);
                continue;
            }
            if (!(childProperty.getProperty() instanceof OwnPropertyInfo) || !DataType.STRING.equals((Object)((OwnPropertyInfo)childProperty.getProperty()).getDataType())) continue;
            String key = childProperty.getLongName();
            int level = StringUtils.split((String)key, (String)".").length;
            if (level == 1) {
                ++level1MergeCharsCount;
            }
            IRow row = table.addRow();
            ICell cellkey = row.getCell(MERGECHARSKEY);
            cellkey.setValue((Object)childProperty.getLongDisplayName());
            cellkey.setUserObject((Object)childProperty);
            ICell celllevel = row.getCell(MERGECHARSLEVEL);
            celllevel.setValue((Object)new Integer(level));
        }
    }

    private void loadGroupStructure() throws BOTPException {
        if (this.buildGroupRow(this.tblGroupingRule, this.destBotpEntity) == 0) {
            throw new BOTPException(BOTPException.MNOLEVEL1GROUP);
        }
        if (DefineSysEnum.DAP.equals((Object)this.mappingInfo.getDefineSys())) {
            this.buildDapGroupRow(this.tblGroupingRule);
        }
        if (this.buildGroupRow(this.tblGroupingRule1, this.destBotpEntity) == 0) {
            throw new BOTPException(BOTPException.MNOLEVEL1GROUP);
        }
        if (DefineSysEnum.DAP.equals((Object)this.newmappingInfo.getDefineSys())) {
            this.buildDapGroupRow(this.tblGroupingRule1);
        }
    }

    private void buildDapGroupRow(final KDTable table) throws BOTPException {
        IRow accountRow = null;
        IRow currencyRow = null;
        IRow entryDcRow = null;
        for (int i = 0; i < table.getRowCount(); ++i) {
            IRow row = table.getRow(i);
            ICell cellkey = row.getCell(GROUPKEY);
            IBotpMetaData childProperty = (IBotpMetaData)cellkey.getUserObject();
            if (childProperty.getLongName().equals(ACCOUNTNAME)) {
                accountRow = row;
                continue;
            }
            if (childProperty.getLongName().equals(CURRENCYNAME)) {
                currencyRow = row;
                continue;
            }
            if (!childProperty.getLongName().equals(ENTRYDCNAME)) continue;
            entryDcRow = row;
        }
        if (accountRow == null || currencyRow == null || entryDcRow == null) {
            throw new BOTPException(BOTPException.MNOACOUNT);
        }
        final ICell accountValueCell = accountRow.getCell(GROUPVALUE);
        final ICell currencyValueCell = currencyRow.getCell(GROUPVALUE);
        final ICell entryDcValueCell = entryDcRow.getCell(GROUPVALUE);
        JCheckBox checkBox = (JCheckBox)table.getDefaultEditor(Boolean.class).getComponent();
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBox cbxSource = (JCheckBox)e.getSource();
                int row = table.getEditManager().getEditRowIndex();
                IRow currentRow = table.getRow(row);
                ICell currentKeyCell = currentRow.getCell(BOTMappingCompareUI.GROUPKEY);
                ICell currentLevelCell = currentRow.getCell(BOTMappingCompareUI.GROUPLEVEL);
                Integer level2 = new Integer(2);
                if (currentLevelCell.getValue().equals(level2)) {
                    IBotpMetaData childProperty = (IBotpMetaData)currentKeyCell.getUserObject();
                    if (childProperty.getLongName().equals(BOTMappingCompareUI.ACCOUNTNAME) || childProperty.getLongName().equals(BOTMappingCompareUI.CURRENCYNAME) || childProperty.getLongName().equals(BOTMappingCompareUI.ENTRYDCNAME)) {
                        if (cbxSource.isSelected()) {
                            if (MsgBox.showConfirm2((String)EASResource.getString((String)BOTMappingCompareUI.RESXFILENAME, (String)BOTMappingCompareUI.SELECTLEVEL2)) == 0) {
                                if (!childProperty.getLongName().equals(BOTMappingCompareUI.ACCOUNTNAME)) {
                                    accountValueCell.setValue((Object)Boolean.TRUE);
                                }
                                if (!childProperty.getLongName().equals(BOTMappingCompareUI.CURRENCYNAME)) {
                                    currencyValueCell.setValue((Object)Boolean.TRUE);
                                }
                                if (!childProperty.getLongName().equals(BOTMappingCompareUI.ENTRYDCNAME)) {
                                    entryDcValueCell.setValue((Object)Boolean.TRUE);
                                }
                            } else {
                                cbxSource.setSelected(false);
                            }
                        } else if (MsgBox.showConfirm2((String)EASResource.getString((String)BOTMappingCompareUI.RESXFILENAME, (String)BOTMappingCompareUI.UNSELECTLEVEL2)) == 0) {
                            for (int i = 0; i < table.getRowCount(); ++i) {
                                IRow theRow = table.getRow(i);
                                ICell theKeyCell = theRow.getCell(BOTMappingCompareUI.GROUPKEY);
                                IBotpMetaData theProperty = (IBotpMetaData)theKeyCell.getUserObject();
                                ICell theLevelCell = theRow.getCell(BOTMappingCompareUI.GROUPLEVEL);
                                ICell theValueCell = theRow.getCell(BOTMappingCompareUI.GROUPVALUE);
                                if (!theLevelCell.getValue().equals(level2) || theProperty.getLongName().equals(childProperty.getLongName())) continue;
                                theValueCell.setValue((Object)Boolean.FALSE);
                            }
                        } else {
                            cbxSource.setSelected(true);
                        }
                    } else if (cbxSource.isSelected()) {
                        if (MsgBox.showConfirm2((String)EASResource.getString((String)BOTMappingCompareUI.RESXFILENAME, (String)BOTMappingCompareUI.SELECTLEVEL2)) == 0) {
                            accountValueCell.setValue((Object)Boolean.TRUE);
                            currencyValueCell.setValue((Object)Boolean.TRUE);
                            entryDcValueCell.setValue((Object)Boolean.TRUE);
                        } else {
                            cbxSource.setSelected(false);
                        }
                    }
                }
            }
        });
    }

    private int buildGroupRow(KDTable table, IBotpMetaData metaData) {
        ArrayList destBotpChildrenPropertyList = metaData.getChildren();
        Iterator iter = destBotpChildrenPropertyList.iterator();
        int level1GroupCount = 0;
        while (iter.hasNext()) {
            IBotpMetaData childProperty = (IBotpMetaData)iter.next();
            if (childProperty.getDetailEntity() != null || this.isSupportCompositeRelate && childProperty.getCompositeRelateEntity() != null) {
                level1GroupCount += this.buildGroupRow(table, childProperty);
                continue;
            }
            if (!Boolean.TRUE.toString().equalsIgnoreCase(childProperty.getProperty().getExtendedProperty(ISFORGROUPING)) && !childProperty.getLongName().equalsIgnoreCase("entries.assistRecords.assGrp")) continue;
            String key = childProperty.getLongName();
            int level = StringUtils.split((String)key, (String)".").length;
            if (level == 1) {
                ++level1GroupCount;
            }
            IRow row = table.addRow();
            ICell cellkey = row.getCell(GROUPKEY);
            cellkey.setValue((Object)childProperty.getLongDisplayName());
            cellkey.setUserObject((Object)childProperty);
            ICell celllevel = row.getCell(GROUPLEVEL);
            celllevel.setValue((Object)new Integer(level));
        }
        return level1GroupCount;
    }

    private void loadRevRuleStructure() {
        IRow headRow = this.tblRevRule.getHeadRow(0);
        ICell headKeyCell = headRow.getCell(REVKEY);
        headKeyCell.setValue((Object)this.srcBotpEntity.getDisplayName());
        this.buildRevRuleRow(this.tblRevRule, this.srcBotpEntity, this.destEntity, (IUIObject)this);
        IRow headRow1 = this.tblRevRule1.getHeadRow(0);
        ICell headKeyCell1 = headRow1.getCell(REVKEY);
        headKeyCell1.setValue((Object)this.srcBotpEntity.getDisplayName());
        this.buildRevRuleRow(this.tblRevRule1, this.srcBotpEntity, this.destEntity, (IUIObject)this);
    }

    private void buildRevRuleRow(KDTable table, IBotpMetaData botpProperty, EntityObjectInfo destEntity, IUIObject owner) {
        ArrayList destBotpChildrenPropertyList = botpProperty.getChildren();
        for (IBotpMetaData childProperty : destBotpChildrenPropertyList) {
            if (childProperty.getDetailEntity() != null) {
                this.buildRevRuleRow(table, childProperty, destEntity, owner);
                continue;
            }
            if (!Boolean.TRUE.toString().equalsIgnoreCase(childProperty.getProperty().getExtendedProperty(ISFORWRITTENBACK))) continue;
            IRow row = table.addRow();
            ICell cell = row.getCell(REVKEY);
            cell.setValue((Object)childProperty.getLongDisplayName());
            cell.setUserObject((Object)childProperty);
        }
    }

    private void loadRuleFields() {
        this.loadHeadRuleFields();
        this.loadBodyRuleFields();
    }

    private void loadHeadRuleFields() {
        BOTRuleSegmentInfo ruleSeg;
        Iterator iter;
        ICell compareValue;
        ICell valueCell;
        IBotpMetaData metaData;
        ICell keyCell;
        IRow row;
        int i;
        BOTRuleInfo destRule;
        BOTRuleInfo baseRule;
        if (this.mappingInfo.getRules().size() > 0) {
            baseRule = this.mappingInfo.getRules().get(0);
        } else {
            baseRule = new BOTRuleInfo();
            this.mappingInfo.getRules().add(baseRule);
        }
        if (this.newmappingInfo.getRules().size() > 0) {
            destRule = this.newmappingInfo.getRules().get(0);
        } else {
            destRule = new BOTRuleInfo();
            this.newmappingInfo.getRules().add(destRule);
        }
        BOTRuleSegmentCollection baseRuleSegs = baseRule.getRuleSegments();
        BOTRuleSegmentCollection destRuleSegs = destRule.getRuleSegments();
        List oldRuleList = this.getDifferentElementsSegment(baseRuleSegs.toArray(), destRuleSegs.toArray());
        List newRuleList = this.getDifferentElementsSegment(destRuleSegs.toArray(), baseRuleSegs.toArray());
        for (i = 0; i < oldRuleList.size(); ++i) {
            BOTRuleSegmentInfo ruleSeg2 = (BOTRuleSegmentInfo)oldRuleList.get(i);
            this.oldruleSegs.add(ruleSeg2);
        }
        for (i = 0; i < newRuleList.size(); ++i) {
            BOTRuleSegmentInfo ruleSeg1 = (BOTRuleSegmentInfo)newRuleList.get(i);
            this.newruleSegs.add(ruleSeg1);
        }
        block2: for (i = 0; i < this.tblHeadRule.getRowCount(); ++i) {
            row = this.tblHeadRule.getRow(i);
            keyCell = row.getCell(HEADKEY);
            metaData = (IBotpMetaData)keyCell.getUserObject();
            valueCell = row.getCell(HEADVALUE);
            valueCell.setValue(null);
            compareValue = row.getCell(COMPAREKEY);
            compareValue.setValue(null);
            iter = this.oldruleSegs.iterator();
            while (iter.hasNext()) {
                ruleSeg = (BOTRuleSegmentInfo)iter.next();
                ruleSeg.setIsRegInRelation(false);
                if (!metaData.getLongName().equals(ruleSeg.getDestPropertyName())) continue;
                valueCell.setValue((Object)ruleSeg);
                compareValue.setValue((Object)UPDATE);
                continue block2;
            }
        }
        block4: for (i = 0; i < this.tblHeadRule1.getRowCount(); ++i) {
            row = this.tblHeadRule1.getRow(i);
            keyCell = row.getCell(HEADKEY);
            metaData = (IBotpMetaData)keyCell.getUserObject();
            valueCell = row.getCell(HEADVALUE);
            valueCell.setValue(null);
            compareValue = row.getCell(COMPAREKEY);
            compareValue.setValue(null);
            iter = this.newruleSegs.iterator();
            while (iter.hasNext()) {
                ruleSeg = (BOTRuleSegmentInfo)iter.next();
                ruleSeg.setIsRegInRelation(false);
                if (!metaData.getLongName().equals(ruleSeg.getDestPropertyName())) continue;
                valueCell.setValue((Object)ruleSeg);
                compareValue.setValue((Object)UPDATE);
                continue block4;
            }
        }
        this.removeRedundantRows(HEADKEY, this.tblHeadRule, this.tblHeadRule1);
    }

    private boolean loadExtRuleSegMentFields(BOTRuleInfo rule, IColumn column, IRow row) {
        boolean isSameDetail = false;
        IBotpMetaData metaData = (IBotpMetaData)column.getUserObject();
        BOTExtSetRuleCollection extSetRules = rule.getExtSetRules();
        if (extSetRules != null && extSetRules.size() > 0) {
            ICell cell = row.getCell(column.getKey());
            cell.setValue(null);
            for (int j = 0; j < extSetRules.size(); ++j) {
                BOTExtSetRuleInfo extSetInfo = extSetRules.get(j);
                if (!metaData.getLongName().equals(extSetInfo.getDestPropertyName())) continue;
                cell.setValue((Object)extSetInfo);
                isSameDetail = true;
                break;
            }
        }
        return isSameDetail;
    }

    private void loadRules(int entryCount, KDTabbedPane tabbedPane, BOTMappingInfo mappingInfo) {
        KDTabbedPane detailTabPane = tabbedPane;
        if (entryCount >= detailTabPane.getTabCount()) {
            return;
        }
        KDTable tblDetailEntry = (KDTable)detailTabPane.getComponentAt(entryCount);
        tblDetailEntry.removeRows();
        BOTRuleCollection ruleCol = mappingInfo.getRules();
        Iterator iter = ruleCol.iterator();
        boolean isSameDetail = false;
        while (iter.hasNext()) {
            BOTRuleInfo rule = (BOTRuleInfo)iter.next();
            IRow row = tblDetailEntry.addRow();
            isSameDetail = false;
            for (int i = 1; i < tblDetailEntry.getColumnCount(); ++i) {
                IColumn column = tblDetailEntry.getColumn(i);
                IBotpMetaData metaData = (IBotpMetaData)column.getUserObject();
                ICell cell = row.getCell(column.getKey());
                cell.setValue(null);
                BOTRuleSegmentCollection ruleSegCol = rule.getRuleSegments();
                Iterator iterSeg = ruleSegCol.iterator();
                boolean isFoundSegment = false;
                while (iterSeg.hasNext()) {
                    BOTRuleSegmentInfo ruleSeg = (BOTRuleSegmentInfo)iterSeg.next();
                    if (!metaData.getLongName().equals(ruleSeg.getDestPropertyName())) continue;
                    cell.setValue((Object)ruleSeg);
                    isSameDetail = true;
                    isFoundSegment = true;
                    break;
                }
                if (isFoundSegment || !this.loadExtRuleSegMentFields(rule, column, row)) continue;
                isSameDetail = true;
            }
            if (isSameDetail || tblDetailEntry.getRowCount() <= 0) continue;
            tblDetailEntry.removeRow(tblDetailEntry.getRowCount() - 1);
        }
    }

    public void compareRules(int entryCount) {
        int i;
        if (entryCount >= this.kDTabbedPane1.getTabCount() || entryCount >= this.kDTabbedPane2.getTabCount()) {
            return;
        }
        KDTable tblDetailEntry1 = (KDTable)this.kDTabbedPane1.getComponentAt(entryCount);
        KDTable tblDetailEntry2 = (KDTable)this.kDTabbedPane2.getComponentAt(entryCount);
        for (i = 0; i < tblDetailEntry1.getRowCount(); ++i) {
            IRow row1;
            if (i >= tblDetailEntry2.getRowCount()) {
                row1 = tblDetailEntry1.getRow(i);
                row1.getCell(COMPAREKEY).setValue((Object)UPDATE);
                continue;
            }
            row1 = tblDetailEntry1.getRow(i);
            IRow row2 = tblDetailEntry2.getRow(i);
            for (int j = 1; j < tblDetailEntry1.getColumnCount(); ++j) {
                ICell cell1 = row1.getCell(j);
                ICell cell2 = row2.getCell(j);
                if (cell1.getValue() != null && cell2.getValue() != null) {
                    boolean different = false;
                    BOTRuleSegmentInfo destRuleSeg = (BOTRuleSegmentInfo)cell1.getValue();
                    BOTRuleSegmentInfo baseRuleSeg = (BOTRuleSegmentInfo)cell2.getValue();
                    String destSrcProperty = destRuleSeg.getSrcPropertyName();
                    String baseSrcProperty = baseRuleSeg.getSrcPropertyName();
                    String destExpression = destRuleSeg.getExpression();
                    String baseExpression = baseRuleSeg.getExpression();
                    if (baseSrcProperty == null) {
                        if (destExpression != null && baseExpression != null) {
                            if (!this.analysisExpression(baseExpression, "//").equals(this.analysisExpression(destExpression, "//"))) {
                                different = true;
                            }
                        } else if (destExpression != null || baseExpression != null) {
                            different = true;
                        }
                    } else {
                        if (destSrcProperty != null && !destSrcProperty.equals(baseSrcProperty)) {
                            different = true;
                        }
                        if (destSrcProperty == null) {
                            different = true;
                        }
                    }
                    if (!different) {
                        cell1.setValue(null);
                        cell2.setValue(null);
                        continue;
                    }
                    row1.getCell(COMPAREKEY).setValue((Object)UPDATE);
                    row2.getCell(COMPAREKEY).setValue((Object)UPDATE);
                    continue;
                }
                if (cell1.getValue() == null && cell2.getValue() == null) continue;
                row1.getCell(COMPAREKEY).setValue((Object)UPDATE);
                row2.getCell(COMPAREKEY).setValue((Object)UPDATE);
            }
        }
        if (tblDetailEntry1.getRowCount() < tblDetailEntry2.getRowCount()) {
            for (i = tblDetailEntry1.getRowCount(); i < tblDetailEntry2.getRowCount(); ++i) {
                IRow row = tblDetailEntry2.getRow(i);
                row.getCell(COMPAREKEY).setValue((Object)UPDATE);
            }
        }
    }

    private void loadBodyRuleFields() {
        int count = this.destDetailEntryList.size();
        for (int k = 0; k < count; ++k) {
            this.loadRules(k, this.kDTabbedPane1, this.mappingInfo);
            this.loadRules(k, this.kDTabbedPane2, this.newmappingInfo);
            this.compareRules(k);
        }
    }

    private void loadAggregateFields() {
        if (this.mappingInfo.getAggregateCollection() != null && this.newmappingInfo.getAggregateCollection() != null) {
            BOTAggregateInfo botAggregateInfo;
            Iterator iter;
            ICell compareValue;
            ICell valueCell;
            IBotpMetaData metaData;
            ICell keyCell;
            IRow row;
            int i;
            BOTAggregateCollection botAggregateCols = this.mappingInfo.getAggregateCollection();
            BOTAggregateCollection botAggregateCols1 = this.newmappingInfo.getAggregateCollection();
            BOTAggregateCollection oldAggregateCols = new BOTAggregateCollection();
            BOTAggregateCollection newAggregateCols = new BOTAggregateCollection();
            List oldAggregateRuleList = this.getDifferentElementsOther(botAggregateCols.toArray(), botAggregateCols1.toArray());
            List newAggregateRuleList = this.getDifferentElementsOther(botAggregateCols1.toArray(), botAggregateCols.toArray());
            for (i = 0; i < oldAggregateRuleList.size(); ++i) {
                BOTAggregateInfo aggregateRuleSeg = (BOTAggregateInfo)oldAggregateRuleList.get(i);
                oldAggregateCols.add(aggregateRuleSeg);
            }
            for (i = 0; i < newAggregateRuleList.size(); ++i) {
                BOTAggregateInfo aggregateRuleSeg1 = (BOTAggregateInfo)newAggregateRuleList.get(i);
                newAggregateCols.add(aggregateRuleSeg1);
            }
            int count = this.tblAggregate.getRowCount();
            block2: for (i = 0; i < count; ++i) {
                row = this.tblAggregate.getRow(i);
                keyCell = row.getCell(AGGREGATEKEY);
                metaData = (IBotpMetaData)keyCell.getUserObject();
                valueCell = row.getCell(AGGREGATEVALUE);
                valueCell.setValue((Object)Boolean.FALSE);
                compareValue = row.getCell(COMPAREKEY);
                compareValue.setValue(null);
                iter = oldAggregateCols.iterator();
                while (iter.hasNext()) {
                    botAggregateInfo = (BOTAggregateInfo)iter.next();
                    if (!metaData.getLongName().equals(botAggregateInfo.getPropertyName())) continue;
                    valueCell.setValue((Object)Boolean.TRUE);
                    compareValue.setValue((Object)UPDATE);
                    continue block2;
                }
            }
            count = this.tblAggregate1.getRowCount();
            block4: for (i = 0; i < count; ++i) {
                row = this.tblAggregate1.getRow(i);
                keyCell = row.getCell(AGGREGATEKEY);
                metaData = (IBotpMetaData)keyCell.getUserObject();
                valueCell = row.getCell(AGGREGATEVALUE);
                valueCell.setValue((Object)Boolean.FALSE);
                compareValue = row.getCell(COMPAREKEY);
                compareValue.setValue(null);
                iter = newAggregateCols.iterator();
                while (iter.hasNext()) {
                    botAggregateInfo = (BOTAggregateInfo)iter.next();
                    if (!metaData.getLongName().equals(botAggregateInfo.getPropertyName())) continue;
                    valueCell.setValue((Object)Boolean.TRUE);
                    compareValue.setValue((Object)UPDATE);
                    continue block4;
                }
            }
        }
        this.removeRedundantRows(AGGREGATEKEY, this.tblAggregate, this.tblAggregate1);
    }

    private void loadMergeCharsFields() {
        if (this.mappingInfo.getMergeCharsCollection() != null && this.newmappingInfo.getMergeCharsCollection() != null) {
            String mergeCharsExpression;
            BOTMergeCharsInfo botMergeCharsInfo;
            Iterator iter;
            ICell compareValue;
            ICell signCell;
            ICell valueCell;
            IBotpMetaData metaData;
            ICell keyCell;
            IRow row;
            int i;
            BOTMergeCharsCollection botMergeCharsCols = this.mappingInfo.getMergeCharsCollection();
            BOTMergeCharsCollection botMergeCharsCols1 = this.newmappingInfo.getMergeCharsCollection();
            BOTMergeCharsCollection oldMergeCharsCols = new BOTMergeCharsCollection();
            BOTMergeCharsCollection newMergeCharsCols = new BOTMergeCharsCollection();
            List oldMergeCharsRuleList = this.getDifferentElementsOther(botMergeCharsCols.toArray(), botMergeCharsCols1.toArray());
            List newMergeCharsRuleList = this.getDifferentElementsOther(botMergeCharsCols1.toArray(), botMergeCharsCols.toArray());
            for (i = 0; i < oldMergeCharsRuleList.size(); ++i) {
                BOTMergeCharsInfo MergeCharsRuleSeg = (BOTMergeCharsInfo)oldMergeCharsRuleList.get(i);
                oldMergeCharsCols.add(MergeCharsRuleSeg);
            }
            for (i = 0; i < newMergeCharsRuleList.size(); ++i) {
                BOTMergeCharsInfo MergeCharsRuleSeg1 = (BOTMergeCharsInfo)newMergeCharsRuleList.get(i);
                newMergeCharsCols.add(MergeCharsRuleSeg1);
            }
            int count = this.tblMergeCharsTop.getRowCount();
            block2: for (i = 0; i < count; ++i) {
                row = this.tblMergeCharsTop.getRow(i);
                keyCell = row.getCell(MERGECHARSKEY);
                metaData = (IBotpMetaData)keyCell.getUserObject();
                valueCell = row.getCell(MERGECHARSVALUE);
                valueCell.setValue((Object)Boolean.FALSE);
                signCell = row.getCell(MERGECHARSSIGN);
                compareValue = row.getCell(COMPAREKEY);
                compareValue.setValue(null);
                iter = oldMergeCharsCols.iterator();
                while (iter.hasNext()) {
                    botMergeCharsInfo = (BOTMergeCharsInfo)iter.next();
                    if (!metaData.getLongName().equals(botMergeCharsInfo.getMergeCharsKey())) continue;
                    valueCell.setValue((Object)Boolean.TRUE);
                    mergeCharsExpression = botMergeCharsInfo.getMergeCharsExpression();
                    signCell.setValue((Object)mergeCharsExpression.substring(mergeCharsExpression.indexOf(",") + 1, mergeCharsExpression.lastIndexOf(")")));
                    compareValue.setValue((Object)UPDATE);
                    continue block2;
                }
            }
            count = this.tblMergeCharsBottom.getRowCount();
            block4: for (i = 0; i < count; ++i) {
                row = this.tblMergeCharsBottom.getRow(i);
                keyCell = row.getCell(MERGECHARSKEY);
                metaData = (IBotpMetaData)keyCell.getUserObject();
                valueCell = row.getCell(MERGECHARSVALUE);
                valueCell.setValue((Object)Boolean.FALSE);
                signCell = row.getCell(MERGECHARSSIGN);
                compareValue = row.getCell(COMPAREKEY);
                compareValue.setValue(null);
                iter = newMergeCharsCols.iterator();
                while (iter.hasNext()) {
                    botMergeCharsInfo = (BOTMergeCharsInfo)iter.next();
                    if (!metaData.getLongName().equals(botMergeCharsInfo.getMergeCharsKey())) continue;
                    valueCell.setValue((Object)Boolean.TRUE);
                    mergeCharsExpression = botMergeCharsInfo.getMergeCharsExpression();
                    signCell.setValue((Object)mergeCharsExpression.substring(mergeCharsExpression.indexOf(",") + 1, mergeCharsExpression.lastIndexOf(")")));
                    compareValue.setValue((Object)UPDATE);
                    continue block4;
                }
            }
        }
        this.removeRedundantRows(MERGECHARSKEY, this.tblMergeCharsTop, this.tblMergeCharsBottom);
    }

    private void loadGroupFields() {
        BOTGroupingInfo group;
        Iterator iter;
        ICell compareValue;
        ICell valueCell;
        IBotpMetaData metaData;
        ICell keyCell;
        IRow row;
        int i;
        BOTRuleInfo rule1;
        BOTRuleInfo rule;
        if (this.mappingInfo.getRules().size() > 0) {
            rule = this.mappingInfo.getRules().get(0);
        } else {
            rule = new BOTRuleInfo();
            this.mappingInfo.getRules().add(rule);
        }
        if (this.newmappingInfo.getRules().size() > 0) {
            rule1 = this.newmappingInfo.getRules().get(0);
        } else {
            rule1 = new BOTRuleInfo();
            this.newmappingInfo.getRules().add(rule1);
        }
        BOTGroupingCollection basegroups = rule.getGroups();
        BOTGroupingCollection destgroups = rule1.getGroups();
        BOTGroupingCollection oldGroups = new BOTGroupingCollection();
        BOTGroupingCollection newGroups = new BOTGroupingCollection();
        List oldGroupRuleList = this.getDifferentElementsOther(basegroups.toArray(), destgroups.toArray());
        List newGroupRuleList = this.getDifferentElementsOther(destgroups.toArray(), basegroups.toArray());
        for (i = 0; i < oldGroupRuleList.size(); ++i) {
            BOTGroupingInfo groupRuleSeg = (BOTGroupingInfo)oldGroupRuleList.get(i);
            oldGroups.add(groupRuleSeg);
        }
        for (i = 0; i < newGroupRuleList.size(); ++i) {
            BOTGroupingInfo groupRuleSeg1 = (BOTGroupingInfo)newGroupRuleList.get(i);
            newGroups.add(groupRuleSeg1);
        }
        block2: for (i = 0; i < this.tblGroupingRule.getRowCount(); ++i) {
            row = this.tblGroupingRule.getRow(i);
            keyCell = row.getCell(GROUPKEY);
            metaData = (IBotpMetaData)keyCell.getUserObject();
            valueCell = row.getCell(GROUPVALUE);
            valueCell.setValue((Object)Boolean.FALSE);
            compareValue = row.getCell(COMPAREKEY);
            compareValue.setValue(null);
            iter = oldGroups.iterator();
            while (iter.hasNext()) {
                group = (BOTGroupingInfo)iter.next();
                if (!metaData.getLongName().equals(group.getGroupingProperty())) continue;
                valueCell.setValue((Object)Boolean.TRUE);
                compareValue.setValue((Object)UPDATE);
                continue block2;
            }
        }
        block4: for (i = 0; i < this.tblGroupingRule1.getRowCount(); ++i) {
            row = this.tblGroupingRule1.getRow(i);
            keyCell = row.getCell(GROUPKEY);
            metaData = (IBotpMetaData)keyCell.getUserObject();
            valueCell = row.getCell(GROUPVALUE);
            valueCell.setValue((Object)Boolean.FALSE);
            compareValue = row.getCell(COMPAREKEY);
            compareValue.setValue(null);
            iter = newGroups.iterator();
            while (iter.hasNext()) {
                group = (BOTGroupingInfo)iter.next();
                if (!metaData.getLongName().equals(group.getGroupingProperty())) continue;
                valueCell.setValue((Object)Boolean.TRUE);
                compareValue.setValue((Object)UPDATE);
                continue block4;
            }
        }
        this.removeRedundantRows(GROUPKEY, this.tblGroupingRule, this.tblGroupingRule1);
    }

    private void loadRevRuleFields() {
        BOTRevRuleInfo revRule = this.mappingInfo.getRevRule();
        BOTRevRuleInfo revRule1 = this.newmappingInfo.getRevRule();
        if (revRule != null && revRule1 != null) {
            BOTRevRuleSegmentInfo revRuleSeg;
            Iterator iter;
            ICell compareValue;
            ICell valueCell;
            IBotpMetaData metaData;
            ICell keyCell;
            IRow row;
            int i;
            BOTRevRuleSegmentCollection revRuleSegs = revRule.getRevRuleSegments();
            BOTRevRuleSegmentCollection revRuleSegs1 = revRule1.getRevRuleSegments();
            BOTRevRuleSegmentCollection oldRevRuleSegs = new BOTRevRuleSegmentCollection();
            BOTRevRuleSegmentCollection newRevRuleSegs = new BOTRevRuleSegmentCollection();
            List oldRevRuleList = this.getDifferentElementsOther(revRuleSegs.toArray(), revRuleSegs1.toArray());
            List newRevRuleList = this.getDifferentElementsOther(revRuleSegs1.toArray(), revRuleSegs.toArray());
            for (i = 0; i < oldRevRuleList.size(); ++i) {
                BOTRevRuleSegmentInfo revRuleSeg2 = (BOTRevRuleSegmentInfo)oldRevRuleList.get(i);
                oldRevRuleSegs.add(revRuleSeg2);
            }
            for (i = 0; i < newRevRuleList.size(); ++i) {
                BOTRevRuleSegmentInfo revRuleSeg1 = (BOTRevRuleSegmentInfo)newRevRuleList.get(i);
                newRevRuleSegs.add(revRuleSeg1);
            }
            block2: for (i = 0; i < this.tblRevRule.getRowCount(); ++i) {
                row = this.tblRevRule.getRow(i);
                keyCell = row.getCell(REVKEY);
                metaData = (IBotpMetaData)keyCell.getUserObject();
                valueCell = row.getCell(REVVALUE);
                valueCell.setValue(null);
                compareValue = row.getCell(COMPAREKEY);
                compareValue.setValue(null);
                iter = oldRevRuleSegs.iterator();
                while (iter.hasNext()) {
                    revRuleSeg = (BOTRevRuleSegmentInfo)iter.next();
                    if (!metaData.getLongName().equals(revRuleSeg.getDestPropertyName())) continue;
                    valueCell.setValue((Object)revRuleSeg);
                    compareValue.setValue((Object)UPDATE);
                    continue block2;
                }
            }
            block4: for (i = 0; i < this.tblRevRule1.getRowCount(); ++i) {
                row = this.tblRevRule1.getRow(i);
                keyCell = row.getCell(REVKEY);
                metaData = (IBotpMetaData)keyCell.getUserObject();
                valueCell = row.getCell(REVVALUE);
                valueCell.setValue(null);
                compareValue = row.getCell(COMPAREKEY);
                compareValue.setValue(null);
                iter = newRevRuleSegs.iterator();
                while (iter.hasNext()) {
                    revRuleSeg = (BOTRevRuleSegmentInfo)iter.next();
                    if (!metaData.getLongName().equals(revRuleSeg.getDestPropertyName())) continue;
                    valueCell.setValue((Object)revRuleSeg);
                    compareValue.setValue((Object)UPDATE);
                    continue block4;
                }
            }
        }
        this.removeRedundantRows(REVKEY, this.tblRevRule, this.tblRevRule1);
    }

    private void removeRedundantRows(String key, KDTable baseTable, KDTable destTable) {
        IBotpMetaData metaData;
        ICell keyCell;
        ICell compareValue;
        IBotpMetaData metaData2;
        ICell keyCell2;
        IRow row;
        int i;
        ICell compareValue2;
        IRow row2;
        int i2;
        ArrayList<IRow> baseList = new ArrayList<IRow>();
        ArrayList<IRow> destList = new ArrayList<IRow>();
        for (i2 = 0; i2 < baseTable.getRowCount(); ++i2) {
            row2 = baseTable.getRow(i2);
            compareValue2 = row2.getCell(COMPAREKEY);
            if (compareValue2.getValue() == null) continue;
            baseList.add(row2);
        }
        for (i2 = 0; i2 < destTable.getRowCount(); ++i2) {
            row2 = destTable.getRow(i2);
            compareValue2 = row2.getCell(COMPAREKEY);
            if (compareValue2.getValue() == null) continue;
            destList.add(row2);
        }
        HashSet<String> nameSet = new HashSet<String>();
        for (i = 0; i < baseList.size(); ++i) {
            row = (IRow)baseList.get(i);
            keyCell2 = row.getCell(key);
            metaData2 = (IBotpMetaData)keyCell2.getUserObject();
            nameSet.add(metaData2.getLongName());
        }
        for (i = 0; i < destList.size(); ++i) {
            row = (IRow)destList.get(i);
            keyCell2 = row.getCell(key);
            metaData2 = (IBotpMetaData)keyCell2.getUserObject();
            nameSet.add(metaData2.getLongName());
        }
        baseList.clear();
        destList.clear();
        for (i = 0; i < baseTable.getRowCount(); ++i) {
            row = baseTable.getRow(i);
            compareValue = row.getCell(COMPAREKEY);
            keyCell = row.getCell(key);
            metaData = (IBotpMetaData)keyCell.getUserObject();
            if (compareValue.getValue() != null) {
                baseList.add(row);
            }
            if (compareValue.getValue() != null || !nameSet.contains(metaData.getLongName())) continue;
            compareValue.setValue((Object)UPDATE);
            baseList.add(row);
        }
        for (i = 0; i < destTable.getRowCount(); ++i) {
            row = destTable.getRow(i);
            compareValue = row.getCell(COMPAREKEY);
            keyCell = row.getCell(key);
            metaData = (IBotpMetaData)keyCell.getUserObject();
            if (compareValue.getValue() != null) {
                destList.add(row);
            }
            if (compareValue.getValue() != null || !nameSet.contains(metaData.getLongName())) continue;
            compareValue.setValue((Object)UPDATE);
            destList.add(row);
        }
        baseTable.removeRows();
        destTable.removeRows();
        for (i = 0; i < baseList.size(); ++i) {
            row = (IRow)baseList.get(i);
            baseTable.addRow(i, row);
        }
        for (i = 0; i < destList.size(); ++i) {
            row = (IRow)destList.get(i);
            destTable.addRow(i, row);
        }
    }

    private void removeEmptyRowsForEntry(String key, KDTabbedPane basePane, KDTabbedPane destPane) {
        for (int i = 0; i < basePane.getTabCount(); ++i) {
            ICell value;
            int k;
            IRow row;
            int j;
            KDTable baseTable = (KDTable)basePane.getComponentAt(i);
            KDTable destTable = (KDTable)destPane.getComponentAt(i);
            ArrayList<IRow> baseList = new ArrayList<IRow>();
            ArrayList<IRow> destList = new ArrayList<IRow>();
            block1: for (j = 0; j < baseTable.getRowCount(); ++j) {
                row = baseTable.getRow(j);
                for (k = 0; k < baseTable.getColumnCount(); ++k) {
                    value = row.getCell(k);
                    if (value == null || !"".equals(value.toString())) continue;
                    baseList.add(row);
                    continue block1;
                }
            }
            block3: for (j = 0; j < destTable.getRowCount(); ++j) {
                row = destTable.getRow(j);
                for (k = 0; k < destTable.getColumnCount(); ++k) {
                    value = row.getCell(k);
                    if (value == null || !"".equals(value.toString())) continue;
                    destList.add(row);
                    continue block3;
                }
            }
            baseTable.removeRows();
            destTable.removeRows();
            for (j = 0; j < baseList.size(); ++j) {
                row = (IRow)baseList.get(j);
                baseTable.addRow(j, row);
            }
            for (j = 0; j < destList.size(); ++j) {
                row = (IRow)destList.get(j);
                destTable.addRow(j, row);
            }
        }
    }

    private String analysisExpression(String expression, String noteMark) {
        StringBuffer expreStr = new StringBuffer(expression);
        while (expreStr.indexOf(noteMark) > 0) {
            int begin = expreStr.indexOf(noteMark);
            int end = expreStr.indexOf("\n", begin);
            expreStr.delete(0, end);
        }
        return expreStr.toString().replaceAll(" ", "").replaceAll("\n", "").replaceAll("\r", "");
    }

    private List getDifferentElementsSegment(Object[] baseArray, Object[] destArray) {
        boolean different = false;
        boolean bExist = false;
        ArrayList<Object> returnList = new ArrayList<Object>();
        for (int i = 0; i < baseArray.length; ++i) {
            Object base = baseArray[i];
            bExist = false;
            different = false;
            for (int j = 0; j < destArray.length; ++j) {
                String basePropertyName;
                Object dest = destArray[j];
                BOTRuleSegmentInfo destRuleSeg = (BOTRuleSegmentInfo)dest;
                BOTRuleSegmentInfo baseRuleSeg = (BOTRuleSegmentInfo)base;
                String destSrcProperty = destRuleSeg.getSrcPropertyName();
                String baseSrcProperty = baseRuleSeg.getSrcPropertyName();
                String destExpression = destRuleSeg.getExpression();
                String baseExpression = baseRuleSeg.getExpression();
                String destPropertyName = destRuleSeg.getDestPropertyName();
                if (!destPropertyName.equalsIgnoreCase(basePropertyName = baseRuleSeg.getDestPropertyName())) continue;
                bExist = true;
                if (baseSrcProperty == null) {
                    if (destExpression != null && baseExpression != null) {
                        if (this.analysisExpression(baseExpression, "//").equals(this.analysisExpression(destExpression, "//"))) continue;
                        different = true;
                        continue;
                    }
                    if (destExpression == null && baseExpression == null) continue;
                    different = true;
                    continue;
                }
                if (destSrcProperty != null && !destSrcProperty.equals(baseSrcProperty)) {
                    different = true;
                }
                if (destSrcProperty != null) continue;
                different = true;
            }
            if (bExist && !different) continue;
            returnList.add(base);
        }
        return returnList;
    }

    private List getDifferentElementsOther(Object[] baseArray, Object[] destArray) {
        int ll = 2;
        ArrayList<Object> returnList = new ArrayList<Object>();
        for (int i = 0; i < baseArray.length; ++i) {
            Object base = baseArray[i];
            boolean different = true;
            for (int j = 0; j < destArray.length; ++j) {
                Object dest = destArray[j];
                if (dest instanceof BOTGroupingInfo) {
                    if (!((BOTGroupingInfo)dest).getGroupingProperty().equals(((BOTGroupingInfo)base).getGroupingProperty())) continue;
                    different = false;
                    continue;
                }
                if (dest instanceof BOTAggregateInfo) {
                    if (!((BOTAggregateInfo)dest).getPropertyName().equals(((BOTAggregateInfo)base).getPropertyName())) continue;
                    different = false;
                    continue;
                }
                if (dest instanceof BOTRevRuleSegmentInfo) {
                    if (!((BOTRevRuleSegmentInfo)dest).getExpression().equals(((BOTRevRuleSegmentInfo)base).getExpression())) continue;
                    different = false;
                    continue;
                }
                if (!(dest instanceof BOTMergeCharsInfo) || !((BOTMergeCharsInfo)dest).getMergeCharsKey().equals(((BOTMergeCharsInfo)base).getMergeCharsKey())) continue;
                different = false;
            }
            if (!different) continue;
            returnList.add(base);
        }
        return returnList;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.ctnHeadRule.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 675, 225));
        this.ctnDetailRule.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 675, 120));
        this.ctnGroupingRule.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 675, 225));
        this.ctnAggregate.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 675, 225));
        this.ctnRevRule.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 675, 160));
        this.ctnHeadRule1.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 245, 675, 225));
        this.ctnDetailRule1.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 245, 675, 120));
        this.ctnGroupingRule1.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 245, 675, 225));
        this.ctnAggregate1.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 245, 675, 225));
        this.ctnRevRule1.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 245, 675, 160));
    }

    protected boolean checkBeforeWindowClosing() {
        return super.checkBeforeWindowClosing();
    }

    private class BOTDetailEntryInfo {
        private IBotpMetaData detailMetadata;
        private boolean isInRule;
        private boolean isInGrp;

        public BOTDetailEntryInfo(IBotpMetaData entry) {
            this.detailMetadata = entry;
            this.isInRule = false;
            this.isInGrp = false;
        }

        public IBotpMetaData getDetailMetadata() {
            return this.detailMetadata;
        }

        public void setDetailMetadata(IBotpMetaData detailMetadata) {
            this.detailMetadata = detailMetadata;
        }

        public boolean isInGrp() {
            return this.isInGrp;
        }

        public void setInGrp(boolean isInGrp) {
            this.isInGrp = isInGrp;
        }

        public boolean isInRule() {
            return this.isInRule;
        }

        public void setInRule(boolean isInRule) {
            this.isInRule = isInRule;
        }
    }
}

