/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimplePropertyCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRuleSegmentInfo;
import com.kingdee.bos.metadata.bot.MappingTypeEnum;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.botp.client.AbstractCommonRuleSegDefUI;
import com.kingdee.eas.base.botp.client.FomulaUI;
import com.kingdee.eas.base.botp.client.IRuleSegDefUI;
import com.kingdee.eas.base.botp.client.util.EntityTreeUtil;
import com.kingdee.eas.base.botp.client.util.MetaDataUtil;
import com.kingdee.eas.base.botp.util.BotpProperty;
import com.kingdee.eas.base.botp.util.IBotpMetaData;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.KeyStroke;

public class CommonRuleSegDefUI
extends AbstractCommonRuleSegDefUI
implements IRuleSegDefUI {
    protected KDCheckBox chkCanModify = new KDCheckBox();
    protected boolean cancel = true;
    protected EntityObjectInfo srcEntity = null;
    protected BOTRuleSegmentInfo ruleSeg;
    protected IBotpMetaData destBotpProperty = null;
    protected FomulaUI fomulaUi;
    protected BOTMappingInfo mappingInfo;
    public static Locale zh_en = LocaleUtils.locale_en_US;
    public static Locale zh_cn = LocaleUtils.locale_zh_CN;
    public static Locale zh_hk = LocaleUtils.locale_zh_TW;
    private boolean isShowCanModifyBox = false;

    public CommonRuleSegDefUI() throws Exception {
        this.chkCanModify.setName("chkCanModify");
        this.chkCanModify.setText(EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx", (String)"BOTRulePROPCANMODIFY"));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public BOTRuleSegmentInfo getRuleSegment() {
        return this.ruleSeg;
    }

    @Override
    public void setRuleSegment(BOTRuleSegmentInfo ruleSegment) {
        if (ruleSegment != null) {
            this.ruleSeg = ruleSegment;
        } else {
            this.ruleSeg = new BOTRuleSegmentInfo();
            this.ruleSeg.setCanModify(true);
            this.ruleSeg.setDestPropertyName(this.destBotpProperty.getLongName());
        }
        this.txtExpression.setText(this.ruleSeg.getAlias());
        this.chkCanModify.setSelected(this.ruleSeg.isCanModify());
    }

    @Override
    public boolean isCancel() {
        return this.cancel;
    }

    @Override
    protected void btnAdvance_actionPerformed(ActionEvent e) throws Exception {
        super.btnAdvance_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        if (this.mappingInfo != null && MappingTypeEnum.SqlEngine == this.mappingInfo.getMappingType()) {
            uiContext.put("runmode", MappingTypeEnum.SqlEngine);
        }
        if (this.destBotpProperty != null) {
            uiContext.put("botpMetaData", this.destBotpProperty);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(FomulaUI.class.getName(), (Map)uiContext);
        ((JDialog)uiWindow).setResizable(true);
        this.fomulaUi = (FomulaUI)uiWindow.getUIObject();
        this.fomulaUi.setAlias(this.ruleSeg.getAlias());
        IBotpMetaData destEntityInfo = this.destBotpProperty;
        while (destEntityInfo.getParent() != null) {
            destEntityInfo = destEntityInfo.getParent();
        }
        this.fomulaUi.setEntity(this.srcEntity, destEntityInfo.getEntity(), false);
        if (this.ruleSeg.getSrcPropertyName() == null) {
            this.fomulaUi.setExpression(this.ruleSeg.getExpression());
        }
        uiWindow.show();
        if (!this.fomulaUi.isCancel()) {
            this.buildRuleSegment(this.fomulaUi.getAlias(zh_cn), this.fomulaUi.getAlias(zh_hk), this.fomulaUi.getAlias(zh_en), null, this.fomulaUi.getExpression(), this.getCurLocale());
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
        this.cancel = true;
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        this.getUIWindow().close();
        if (this.ruleSeg.getSrcPropertyName() == null && this.ruleSeg.getExpression() == null) {
            this.cancel = true;
        } else {
            this.ruleSeg.setCanModify(this.chkCanModify.isSelected());
            this.cancel = false;
        }
    }

    @Override
    protected void tree_mouseClicked(MouseEvent e) throws Exception {
        super.tree_mouseClicked(e);
        if (e.getClickCount() == 2) {
            DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
            PropertyInfo destProperty = this.destBotpProperty.getProperty();
            if (treeNode != null && treeNode.getUserObject() != null && treeNode.getUserObject() instanceof BotpProperty) {
                IBotpMetaData srcBotpProperty = (IBotpMetaData)treeNode.getUserObject();
                PropertyInfo srcProperty = srcBotpProperty.getProperty();
                if (srcProperty instanceof OwnPropertyInfo && destProperty instanceof OwnPropertyInfo) {
                    if (((OwnPropertyInfo)srcProperty).getDataType().equals((Object)((OwnPropertyInfo)destProperty).getDataType()) || CommonRuleSegDefUI.canSafeTypeConverse((OwnPropertyInfo)destProperty, (OwnPropertyInfo)srcProperty)) {
                        this.buildRuleSegment(treeNode);
                    }
                } else if (srcProperty instanceof LinkPropertyInfo && destProperty instanceof LinkPropertyInfo && this.canSafeConverse(srcBotpProperty)) {
                    this.buildRuleSegment(treeNode);
                }
            }
        }
    }

    private boolean canSafeConverse(IBotpMetaData srcBotpProperty) {
        boolean isSafe = false;
        if (srcBotpProperty.getProperty() instanceof LinkPropertyInfo && this.destBotpProperty.getProperty() instanceof LinkPropertyInfo) {
            for (EntityObjectInfo srcEntity = srcBotpProperty.getEntity(); srcEntity != null; srcEntity = srcEntity.getBaseEntity()) {
                if (!srcEntity.getFullName().equals(this.destBotpProperty.getEntity().getFullName())) continue;
                isSafe = true;
                break;
            }
        }
        return isSafe;
    }

    private String getAlias(String propertyName, Locale locale) {
        SimplePropertyCollection propCol = null;
        try {
            EntitySelect select = new EntitySelect(this.srcEntity.getType());
            select.propertySelect().select(new String[]{propertyName}, new String[]{"alias"}, locale);
            propCol = MetaDataAccessFactory.getRemoteInstance().select(select).properties();
            if (propCol.size() > 0) {
                return propCol.get(0).getAlias();
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return null;
    }

    public void buildRuleSegment(DefaultKingdeeTreeNode treeNode) {
        IBotpMetaData srcBotpProperty = (IBotpMetaData)treeNode.getUserObject();
        String alias_l1 = this.getAlias(srcBotpProperty.getName(), new Locale("l1"));
        alias_l1 = srcBotpProperty.getFullDisplayName(zh_en);
        String alias_l2 = this.getAlias(srcBotpProperty.getName(), new Locale("l2"));
        alias_l2 = srcBotpProperty.getFullDisplayName(zh_cn);
        String alias_l3 = this.getAlias(srcBotpProperty.getName(), new Locale("l3"));
        alias_l3 = srcBotpProperty.getFullDisplayName(zh_hk);
        srcBotpProperty.getEntity();
        this.buildRuleSegment(alias_l2, alias_l3, alias_l1, srcBotpProperty.getLongName(), null, this.getCurLocale());
    }

    public void buildRuleSegment(String alias, String srcPropertyName, String expression) {
        this.buildRuleSegment(alias, null, srcPropertyName, expression, this.getCurLocale());
    }

    public void buildRuleSegment(String alias_zh_cn, String alias_zh_hk, String srcPropertyName, String expression, Locale curLocale) {
        this.buildRuleSegment(alias_zh_cn, alias_zh_hk, "", srcPropertyName, expression, curLocale);
    }

    public void buildRuleSegment(String alias_zh_cn, String alias_zh_hk, String alias_zh_en, String srcPropertyName, String expression, Locale curLocale) {
        if (curLocale.equals(zh_hk)) {
            this.txtExpression.setText(alias_zh_hk);
            this.ruleSeg.setAlias(alias_zh_hk);
        } else if (curLocale.equals(zh_en)) {
            this.txtExpression.setText(alias_zh_en);
            this.ruleSeg.setAlias(alias_zh_en);
        } else {
            this.txtExpression.setText(alias_zh_cn);
            this.ruleSeg.setAlias(alias_zh_cn);
        }
        this.ruleSeg.setAlias(alias_zh_en, zh_en);
        this.ruleSeg.setAlias(alias_zh_cn, zh_cn);
        this.ruleSeg.setAlias(alias_zh_hk, zh_hk);
        if (srcPropertyName != null && srcPropertyName.length() > 0) {
            this.ruleSeg.setSrcPropertyName("__src." + srcPropertyName);
        } else {
            this.ruleSeg.setSrcPropertyName(null);
        }
        this.ruleSeg.setExpression(expression);
    }

    @Override
    public EntityObjectInfo getSrcEntity() {
        return this.srcEntity;
    }

    @Override
    public void setSrcEntity(EntityObjectInfo entity) {
        this.srcEntity = entity;
        EntityTreeUtil.initEntityTree(this.tree, entity, this.destBotpProperty);
        this.tab.setTitleAt(0, MetaDataUtil.getDisplayName(entity));
    }

    @Override
    public void setDestProperty(IBotpMetaData botpProperty) {
        this.destBotpProperty = botpProperty;
        this.setUITitle(botpProperty.getLongDisplayName() + this.getUITitle());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.chkCanModify.setBounds(new Rectangle(307, 245, 180, 15));
        this.chkCanModify.setVisible(false);
        this.txtExpression.setEnabled(false);
        this.lblNotice.setBounds(new Rectangle(12, 243, 295, 19));
        this.add((Component)this.chkCanModify, null);
        this.pnlTree.setLayout((LayoutManager)new BorderLayout());
        this.pnlTree.add((Component)this.treeView, (Object)"Center");
        this.getInputMap(2).put(KeyStroke.getKeyStroke("F10"), "actionShowCanModify");
        this.getActionMap().put("actionShowCanModify", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CommonRuleSegDefUI.this.isShowCanModifyBox) {
                    CommonRuleSegDefUI.this.chkCanModify.setVisible(false);
                    CommonRuleSegDefUI.this.isShowCanModifyBox = false;
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx", (String)"hideCanModifyBox"));
                } else {
                    CommonRuleSegDefUI.this.chkCanModify.setVisible(true);
                    CommonRuleSegDefUI.this.isShowCanModifyBox = true;
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.botp.BotpResx", (String)"showCanModifyBox"));
                }
            }
        });
    }

    @Override
    public void setMappingInfo(BOTMappingInfo mappingInfo) {
        this.mappingInfo = mappingInfo;
    }

    protected JButton getDefaultButton() {
        return this.btnOK;
    }

    private static boolean canSafeTypeConverse(OwnPropertyInfo destBotpProperty, OwnPropertyInfo childBotpProperty) {
        DataType child;
        boolean result = false;
        DataType dest = destBotpProperty.getDataType();
        if (dest.equals((Object)(child = childBotpProperty.getDataType()))) {
            result = true;
        } else if (dest.equals((Object)DataType.DATE) && child.equals((Object)DataType.TIMESTAMP)) {
            result = true;
        }
        return result;
    }

    public Locale getCurLocale() {
        return SysContext.getSysContext().getOriginLocale();
    }
}

