/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.botp.client.AbstractDBLockUI;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class DBLockUI
extends AbstractDBLockUI {
    private static final Logger logger = CoreUIObject.getLogger(DBLockUI.class);
    private List<DBLock> dbLockList = new ArrayList<DBLock>();
    private int ALL = 0;
    private int BOTP = 1;
    private int DAP = 2;

    public void onLoad() throws Exception {
        super.onLoad();
        this.AllBtn.setEnabled(true);
        this.BOTPRadioBtn.setEnabled(true);
        this.DAPRedioBtn.setEnabled(true);
        this.handlePermissionForItemAction((ItemAction)this.actionOnLoad);
        this.toolBar.removeAll();
        this.toolBar.add((Component)this.btnQuery);
        this.toolBar.add((Component)this.btnRefresh);
        this.toolBar.add((Component)this.btnRemove);
        this.btnClear.setIcon(EASResource.getIcon((String)"imgTbtn_deletemultipart"));
        this.toolBar.add((Component)this.btnClear);
        this.btnClear.setEnabled(true);
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.setEditable(false);
        this.initTable();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            ArrayList idList = this.getSelectedIdValues();
            ArrayList deleteDBLockList = this.deleteDBLock(idList);
            this.initTable();
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.initTable();
    }

    @Override
    public void actionClear_actionPerformed(ActionEvent e) throws Exception {
        if (this.confirmClear()) {
            IBTPManager BTPManager2 = BTPManagerFactory.getRemoteInstance();
            BTPManager2.releaseDBLock();
            this.initTable();
        }
    }

    private void initTable() throws Exception {
        this.dbLockList.clear();
        this.tblMain.removeRows();
        this.tblMain.getColumn("number").setWidth(0);
        this.tblMain.getColumn("number").setResizeable(false);
        this.getAllDBLock();
        if (this.dbLockList.size() == 0) {
            return;
        }
        for (int i = 0; i < this.dbLockList.size(); ++i) {
            DBLock dbLock = this.dbLockList.get(i);
            IRow row = this.tblMain.addRow();
            row.getCell("lockID").setValue((Object)dbLock.getFid());
            row.getCell("user").setValue((Object)dbLock.getUserAlias());
            row.getCell("date").setValue((Object)dbLock.getDate());
        }
    }

    private ArrayList deleteDBLock(ArrayList idList) throws BOSException {
        if (idList == null || idList.size() == 0) {
            return null;
        }
        IBTPManager BTPManager2 = BTPManagerFactory.getRemoteInstance();
        ArrayList deleteList = BTPManager2.releaseDBLock(idList);
        return deleteList;
    }

    private void getAllDBLock() throws BOSException, SQLException {
        int filterValue = this.lockGroup.getValue();
        String sql = "SELECT FID,FUSER,FUSERALIAS,FDATE FROM T_BOT_DBLOCK";
        if (filterValue == this.BOTP) {
            sql = sql + " WHERE FID LIKE '%BOTP'";
        } else if (filterValue == this.DAP) {
            sql = sql + " WHERE FID LIKE '%DAP'";
        }
        SQLExecutor sqltor = new SQLExecutor(sql);
        IRowSet rowset = sqltor.executeSQL();
        while (rowset.next()) {
            String fid = rowset.getString("FID");
            String user = rowset.getString("FUSER");
            String userAlias = rowset.getString("FUSERALIAS");
            String date = rowset.getString("FDATE");
            DBLock dblock = new DBLock(fid, user, userAlias, date);
            this.dbLockList.add(dblock);
        }
    }

    protected String getKeyFieldName() {
        return "lockID";
    }

    private boolean confirmClear() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)"\u786e\u8ba4\u6e05\u7a7a\u6570\u636e\u5e93\u9501\u5417\uff1f"));
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    class DBLock {
        private String fid;
        private String user;
        private String date;
        private String userAlias;

        public DBLock(String fid, String user, String userAlias, String date) {
            this.fid = fid;
            this.user = user;
            this.userAlias = userAlias;
            this.date = date;
        }

        public String getFid() {
            return this.fid;
        }

        public void setFid(String fid) {
            this.fid = fid;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getUserAlias() {
            return this.userAlias;
        }

        public void setUserAlias(String userAlias) {
            this.userAlias = userAlias;
        }
    }
}

