/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.client;

import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.EntryFilterType;
import com.kingdee.bos.metadata.entity.FilterCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.botp.client.AbstractDataFilterUI;
import com.kingdee.eas.base.botp.client.util.BotpDataFilterEntryInfo;
import com.kingdee.eas.base.botp.util.IBotpMetaData;
import com.kingdee.eas.base.commonquery.client.CommonEntityFilterPanel;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;

public class DataFilterUI
extends AbstractDataFilterUI {
    private BOTMappingInfo mappingInfo;
    private CommonEntityFilterPanel pnlFilter;
    private static final String RESXFILENAME = "com.kingdee.eas.base.botp.BotpResx";
    private static final String FILTERERROR = "FILTERERROR";
    private static final String BotpRuleHead = "BotpRuleHead";
    private boolean noEntries = false;
    private static final String ENTRY_FILTER_PANAL = "ENTRY_FILTER_PANAL";
    private static final String ENTRY_NAMES = "ENTRY_NAMES";
    private static final String ENTRY_PK = "ENTRY_PK";
    private ArrayList entryList = new ArrayList();

    public void onLoad() throws Exception {
        super.onLoad();
        ArrayList srcDetailEntryList = (ArrayList)this.getUIContext().get("entry");
        if (srcDetailEntryList != null && srcDetailEntryList.size() > 0) {
            int n = srcDetailEntryList.size();
            for (int i = 0; i < n; ++i) {
                IBotpMetaData srcDetailBotpProperty = (IBotpMetaData)srcDetailEntryList.get(i);
                String entryName = srcDetailBotpProperty.getLongName();
                String entryAlias = srcDetailBotpProperty.getAlias();
                MetaDataPK srcEntryEntityPk = new MetaDataPK(srcDetailBotpProperty.getDetailEntity().getFullName());
                BotpDataFilterEntryInfo info = new BotpDataFilterEntryInfo(entryName, entryAlias, (IMetaDataPK)srcEntryEntityPk);
                this.entryList.add(info);
            }
        } else {
            this.noEntries = true;
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void setBotMapping(BOTMappingInfo mappingInfo) throws Exception {
        BotpDataFilterEntryInfo info;
        this.setMappingInfo(mappingInfo);
        MetaDataPK srcEntityPk = new MetaDataPK(this.mappingInfo.getSrcEntityFullName());
        FilterInfo filterInfo = null;
        boolean bExistEntryFilter = false;
        if (this.mappingInfo.getExtRule().getDataFilter() != null) {
            EntityViewInfo entityViewInfo = new EntityViewInfo(this.mappingInfo.getExtRule().getDataFilter());
            filterInfo = entityViewInfo.getFilter();
            if (entityViewInfo.getEntryFilters() != null && entityViewInfo.getEntryFilters().size() > 0) {
                bExistEntryFilter = true;
                FilterCollection fc = entityViewInfo.getEntryFilters();
                for (int i = 0; i < fc.size(); ++i) {
                    FilterInfo temp = fc.get(i);
                    BotpDataFilterEntryInfo entryInfo = this.getEntryInfoByName(temp.getEntryName());
                    if (entryInfo == null) continue;
                    entryInfo.setEntryFilterInfo(temp);
                }
            }
        }
        if (!bExistEntryFilter) {
            for (int i = 0; i < this.entryList.size(); ++i) {
                info = (BotpDataFilterEntryInfo)this.entryList.get(i);
                String entryName = info.getEntryName();
                if (entryName == null || entryName.length() <= 0) continue;
                FilterInfo entryFilterInfo = new FilterInfo(EntryFilterType.NORMAL);
                entryFilterInfo.setEntryName(entryName);
                info.setEntryFilterInfo(entryFilterInfo);
            }
        }
        this.pnlFilter = this.buildFilterPanel((IMetaDataPK)srcEntityPk, filterInfo, EASResource.getString((String)RESXFILENAME, (String)BotpRuleHead));
        for (int i = 0; i < this.entryList.size(); ++i) {
            info = (BotpDataFilterEntryInfo)this.entryList.get(i);
            CommonEntityFilterPanel pnlEntryFilter = this.buildFilterPanel(info.getSrcEntryEntityPk(), info.getEntryFilterInfo(), info.getEntryAlias());
            info.setPnlEntryFilter(pnlEntryFilter);
        }
    }

    private CommonEntityFilterPanel buildFilterPanel(IMetaDataPK entityPK, FilterInfo entryFilterInfo, String title) throws Exception {
        CommonEntityFilterPanel pnlEntryFilter = new CommonEntityFilterPanel(entityPK, entryFilterInfo, null, null, false, true, true);
        KDContainer ctnEntryFilter = new KDContainer();
        ctnEntryFilter.getContentPane().setLayout(new BorderLayout());
        ctnEntryFilter.getContentPane().add((Component)pnlEntryFilter.getKdtTable(), "Center");
        ctnEntryFilter.addButton((JButton)pnlEntryFilter.getAddRowButton());
        ctnEntryFilter.addButton((JButton)pnlEntryFilter.getDelRowButton());
        ctnEntryFilter.addButton((JButton)pnlEntryFilter.getClearButton());
        this.tabPanel.addTab(title, (Component)ctnEntryFilter);
        return pnlEntryFilter;
    }

    private BotpDataFilterEntryInfo getEntryInfoByName(String entryName) {
        for (int i = 0; i < this.entryList.size(); ++i) {
            BotpDataFilterEntryInfo info = (BotpDataFilterEntryInfo)this.entryList.get(i);
            String name = info.getEntryName();
            if (name == null || !name.equalsIgnoreCase(entryName)) continue;
            return info;
        }
        return null;
    }

    public BOTMappingInfo getMappingInfo() {
        return this.mappingInfo;
    }

    public void setMappingInfo(BOTMappingInfo mappingInfo) {
        this.mappingInfo = mappingInfo;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        if (this.pnlFilter != null && !this.pnlFilter.verify()) {
            return;
        }
        for (int i = 0; i < this.entryList.size(); ++i) {
            BotpDataFilterEntryInfo info = (BotpDataFilterEntryInfo)this.entryList.get(i);
            CommonEntityFilterPanel pnlEntryFilter = info.getPnlEntryFilter();
            if (pnlEntryFilter == null || pnlEntryFilter.verify()) continue;
            return;
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = this.pnlFilter.getFilterInfo();
        entityViewInfo.setFilter(filterInfo);
        FilterInfo entryFilterInfo = new FilterInfo();
        for (int i = 0; i < this.entryList.size(); ++i) {
            BotpDataFilterEntryInfo info = (BotpDataFilterEntryInfo)this.entryList.get(i);
            CommonEntityFilterPanel pnlEntryFilter = info.getPnlEntryFilter();
            entryFilterInfo = pnlEntryFilter.getFilterInfo();
            if (entryFilterInfo.getFilterItems().size() <= 0) continue;
            entryFilterInfo.setEntryilterType(EntryFilterType.NORMAL);
            entryFilterInfo.setEntryName(info.getEntryName());
            entityViewInfo.getEntryFilters().add(entryFilterInfo);
        }
        this.mappingInfo.getExtRule().setDataFilter(entityViewInfo.toString());
        this.getUIWindow().close();
    }
}

