/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.client;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.service.formula.builder.EnumTreeBuilder;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.botp.client.AbstractEditHelpUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class EditHelpUI
extends AbstractEditHelpUI {
    private static final String RESXFILENAME = "com.kingdee.eas.base.botp.BotpDynFunctionResource";
    private static final Logger logger = CoreUIObject.getLogger(EditHelpUI.class);
    public static String USER_HOME = System.getProperty("user.home");
    public static String FILE_SEPARATOR = System.getProperty("file.separator");
    public static String CLASSPATH = "classpath";
    public static String KEYTOKEN = "keytoken";
    public static String FILENAME = "botEditconfig.xml";

    public void onLoad() throws Exception {
        this.loadConfig();
        this.btnadd.setEnabled(true);
        this.btnsave.setEnabled(true);
        this.kDSysPathArea.setText(EditHelpUI.getSysPath());
        this.kDSysPathArea.setEditable(false);
    }

    public static String getSysPath() {
        String easHome;
        StringBuffer sysPath = new StringBuffer();
        String javaHome = System.getProperty("java.home");
        if (javaHome != null) {
            sysPath.append(javaHome + "\\lib\\rt.jar;");
        }
        if ((easHome = System.getProperty("EAS_HOME")) != null) {
            sysPath.append(easHome + "\\client\\lib\\common\\bos\\bosframework.jar;");
            sysPath.append(easHome + "\\client\\lib\\common\\bos\\common.jar;");
            sysPath.append(easHome + "\\client\\lib\\common\\bos\\metadata.jar;");
            sysPath.append(easHome + "\\client\\lib\\common\\bos\\ksql.jar;");
            sysPath.append(easHome + "\\client\\lib\\common\\bos\\invokeservice.jar;");
        }
        return sysPath.toString();
    }

    public static String getFilePath() {
        return USER_HOME + FILE_SEPARATOR + FILENAME;
    }

    private boolean verifyKeyStoken() {
        String keyword = this.kDTextField.getText();
        if (keyword == null || keyword.length() == 0) {
            MsgBox.showError((String)EASResource.getString((String)RESXFILENAME, (String)"35_EditHelpUI"));
            return false;
        }
        if ("ctrl shift Q".equals(keyword) || "F5".equals(keyword)) {
            MsgBox.showError((String)(keyword + EASResource.getString((String)RESXFILENAME, (String)"36_EditHelpUI")));
            return false;
        }
        if (KeyStroke.getKeyStroke(keyword) == null) {
            MsgBox.showError((String)(keyword + EASResource.getString((String)RESXFILENAME, (String)"37_EditHelpUI")));
            return false;
        }
        return true;
    }

    @Override
    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        StringBuffer path = new StringBuffer(this.kDUserPathArea.getText());
        KDFileChooser fileChooser = new KDFileChooser(System.getProperty("EAS_HOME") + "\\client\\lib");
        fileChooser.setMultiSelectionEnabled(true);
        Window win = EnumTreeBuilder.getWindowForComponent((Component)((Object)this));
        int openResult = fileChooser.showSaveDialog((Component)win);
        if (openResult == 0) {
            File[] files = fileChooser.getSelectedFiles();
            for (int i = 0; i < files.length; ++i) {
                path.append(files[i].getPath());
                path.append(";");
            }
        }
        this.kDUserPathArea.setText(path.toString());
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (!this.verifyKeyStoken()) {
            return;
        }
        this.updateFile();
        MsgBox.showInfo((String)EASResource.getString((String)RESXFILENAME, (String)"38_EditHelpUI"));
    }

    private void loadConfig() {
        if (!new File(EditHelpUI.getFilePath()).exists()) {
            this.createFile();
            return;
        }
        File configFile = new File(USER_HOME, FILENAME);
        SAXBuilder builder = new SAXBuilder();
        builder.setIgnoringElementContentWhitespace(false);
        try {
            org.jdom2.Document doc = builder.build(configFile);
            Element root = doc.getRootElement();
            if (root != null) {
                String classpath = root.getAttributeValue(CLASSPATH);
                String key = root.getAttributeValue(KEYTOKEN);
                if (classpath != null) {
                    this.kDTextField.setText(key);
                }
                if (key != null) {
                    this.kDUserPathArea.setText(classpath);
                }
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public void updateFile() {
        String refinedFileName = EditHelpUI.getFilePath();
        FileOutputStream fileOut = null;
        try {
            fileOut = new FileOutputStream(refinedFileName.toString());
            XMLOutputter xmlOut = new XMLOutputter();
            Element root = new Element("botEditConfig");
            root.setAttribute(CLASSPATH, this.kDUserPathArea.getText());
            root.setAttribute(KEYTOKEN, this.kDTextField.getText());
            org.jdom2.Document doc = new org.jdom2.Document();
            doc.setRootElement(root);
            Format format = Format.getRawFormat();
            format.setIndent("  ");
            format.setTextMode(Format.TextMode.PRESERVE);
            format.setLineSeparator("\r\n");
            format.setEncoding("UTF-8");
            xmlOut.setFormat(format);
            xmlOut.output(doc, (OutputStream)fileOut);
            ((OutputStream)fileOut).close();
        }
        catch (IOException e) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile() {
        String refinedFileName = EditHelpUI.getFilePath();
        Document doc = DocumentFactory.getInstance().createDocument();
        doc.setName(refinedFileName);
        org.dom4j.Element root = doc.addElement("botEditConfig");
        this.kDTextField.setText("F4");
        root.addAttribute(CLASSPATH, "");
        root.addAttribute(KEYTOKEN, this.kDTextField.getText());
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        FileOutputStream refinedFile = null;
        Writer writer = null;
        XMLWriter xmlWriter = null;
        try {
            refinedFile = new FileOutputStream(refinedFileName);
            writer = new OutputStreamWriter((OutputStream)refinedFile, "UTF-8");
            xmlWriter = new XMLWriter(writer, format);
            xmlWriter.write(doc);
        }
        catch (IOException ex) {
            logger.error((Object)ex.getStackTrace(), (Throwable)ex);
            return;
        }
        finally {
            try {
                xmlWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                refinedFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Map<String, Object> getEditConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        File configFile = new File(USER_HOME, FILENAME);
        if (!configFile.exists()) {
            try {
                new EditHelpUI().createFile();
            }
            catch (Exception e) {
                logger.error((Object)"error occur when createFile");
                return null;
            }
        }
        SAXBuilder builder = new SAXBuilder();
        builder.setIgnoringElementContentWhitespace(false);
        try {
            org.jdom2.Document doc = builder.build(configFile);
            Element root = doc.getRootElement();
            if (root != null) {
                String classpath = root.getAttributeValue(CLASSPATH);
                String key = root.getAttributeValue(KEYTOKEN);
                String[] path = classpath != null ? (EditHelpUI.getSysPath() + classpath).split(";") : EditHelpUI.getSysPath().split(";");
                config.put(CLASSPATH, path);
                if (key != null) {
                    config.put(KEYTOKEN, key);
                } else {
                    config.put(KEYTOKEN, "F4");
                }
                return config;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }
}

