/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.client.relation;

import com.kingdee.bos.rabbitmq.guava.Lists;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.define.ResponsibleCollection;
import com.kingdee.bos.workflow.define.ResponsibleDef;
import com.kingdee.eas.base.botp.client.relation.BillRelationInfo;
import com.kingdee.eas.base.botp.client.relation.IRelationImage;
import com.kingdee.util.StringUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BillRelationImage
implements IRelationImage {
    public static final int FONT_SIZE = 12;
    public static final double ARROW_ANGLE = 0.5235987755982988;
    public static final int ARROW_SIZE = 6;
    public static final double AXIS_Y = 1.5707963267948966;
    public static final Font FONT = BillRelationImage.getFont();
    private HashMap activities;
    private ArrayList responsibles;
    private String initiator;
    private transient BufferedImage image;
    private transient Graphics2D g;
    private transient FontMetrics metrics;
    private transient HashSet passedTransitions;
    private transient HashMap activityPairs;
    private ArrayList wires;
    private transient ProcessDef processDef;
    private transient Locale locale;
    private transient String[] passedTransition;
    private IRelationImage.Comment[] comments;
    private int minX = Integer.MAX_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private int offsetX;
    private int offsetY;
    private int width;
    private int height;

    public HashSet getPassedTransitions() {
        return this.passedTransitions;
    }

    public void setPassedTransitions(HashSet passedTransitions) {
        this.passedTransitions = passedTransitions;
    }

    public IRelationImage.Comment[] getComments() {
        return this.comments;
    }

    public void setComments(IRelationImage.Comment[] comments) {
        this.comments = comments;
    }

    public static BillRelationImage buildImageInfo(BillRelationInfo billRelationInfo) {
        BillRelationImage wfProcessImage2 = new BillRelationImage();
        IRelationImage.Comment[] comments = new IRelationImage.Comment[]{};
        wfProcessImage2.setComments(comments);
        wfProcessImage2.image = new BufferedImage(1, 1, 1);
        wfProcessImage2.g = (Graphics2D)wfProcessImage2.image.getGraphics();
        if (FONT != null) {
            wfProcessImage2.g.setFont(FONT);
        }
        wfProcessImage2.metrics = wfProcessImage2.g.getFontMetrics();
        wfProcessImage2.responsibles = new ArrayList();
        HashMap<Integer, List<IRelationImage.Activity>> levelMap = new HashMap<Integer, List<IRelationImage.Activity>>();
        HashSet<String> nodes = new HashSet<String>();
        BillRelationImage.buildList(billRelationInfo, 100, true, nodes, levelMap);
        BillRelationImage.buildList(billRelationInfo, 100, false, nodes, levelMap);
        BillRelationImage.dealXY(levelMap);
        HashMap<String, IRelationImage.Activity> mp = new HashMap<String, IRelationImage.Activity>();
        int minX = 0;
        int maxX = 0;
        int minY = 0;
        int maxY = 0;
        for (List value : levelMap.values()) {
            for (IRelationImage.Activity activity : value) {
                if (activity.bound.x < minX) {
                    minX = activity.bound.x;
                }
                if (activity.bound.x > maxX) {
                    maxX = activity.bound.x;
                }
                if (activity.bound.y < minY) {
                    minY = activity.bound.y;
                }
                if (activity.bound.y <= maxY) continue;
                maxY = activity.bound.y;
            }
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int moveX = (screenSize.width - 60) / 2 - (50 + (minX + maxX) / 2);
        int moveY = (screenSize.height - 180) / 2 - (42 + (minY + maxY) / 2);
        moveX = moveX > Math.abs(minX) ? moveX : Math.abs(minX);
        moveY = moveY > Math.abs(minY) ? moveY : Math.abs(minY);
        for (List value : levelMap.values()) {
            for (IRelationImage.Activity activity : value) {
                activity.bound.x += moveX;
                activity.bound.y += moveY;
                mp.put(activity.getActDefId(), activity);
            }
        }
        wfProcessImage2.setActivities(mp);
        BillRelationImage.dealWires(levelMap, wfProcessImage2);
        return wfProcessImage2;
    }

    public static void buildList(BillRelationInfo info, Integer lv, boolean isPre, Set<String> nodeSet, Map<Integer, List<IRelationImage.Activity>> levelMap) {
        List<BillRelationInfo> subBills;
        if (lv == 100 && !isPre) {
            List<BillRelationInfo> nextNodes = info.getNextNodes();
            if (nextNodes == null || nextNodes.isEmpty()) {
                return;
            }
            for (BillRelationInfo billRelationInfo : nextNodes) {
                BillRelationImage.buildList(billRelationInfo, lv + 1, isPre, nodeSet, levelMap);
            }
        }
        if (nodeSet.contains(info.getId())) {
            return;
        }
        IRelationImage.Activity act = new IRelationImage.Activity();
        act.bound = new Rectangle();
        act.bound.x = 0;
        act.bound.y = 0;
        act.bound.width = 100;
        act.bound.height = 54;
        act.name = info.getName();
        act.iconResource = "bill_view";
        if (lv == 100) {
            act.iconResource = "bill_view_cur";
        }
        if (info.getType() != null && info.getType() == 2) {
            act.iconResource = "bill_view_list";
        }
        act.actDefId = info.getId();
        if (info.getPreNodes() != null) {
            HashSet<String> pres = new HashSet<String>();
            for (BillRelationInfo preNode : info.getPreNodes()) {
                pres.add(preNode.getId());
            }
            act.setPreNodes(pres);
        }
        if (info.getNextNodes() != null) {
            HashSet<String> nexts = new HashSet<String>();
            for (BillRelationInfo preNode : info.getNextNodes()) {
                nexts.add(preNode.getId());
            }
            act.setNextNodes(nexts);
        }
        List<BillRelationInfo> list = subBills = isPre ? info.getPreNodes() : info.getNextNodes();
        if (subBills == null || subBills.isEmpty()) {
            if (levelMap.containsKey(lv)) {
                levelMap.get(lv).add(act);
                nodeSet.add(info.getId());
            } else {
                ArrayList<IRelationImage.Activity> arrayList = new ArrayList<IRelationImage.Activity>();
                arrayList.add(act);
                levelMap.put(lv, arrayList);
                nodeSet.add(info.getId());
            }
            return;
        }
        if (isPre) {
            subBills.forEach(sub -> {
                if (sub.getNextNodes() == null) {
                    HashSet<String> nextNodes = new HashSet<String>();
                    nextNodes.add(info.getId());
                    sub.setNextNodeSet(nextNodes);
                } else {
                    sub.getNextNodeSet().add(info.getId());
                }
            });
        }
        if (levelMap.containsKey(lv) && !nodeSet.contains(info.getId())) {
            levelMap.get(lv).add(act);
            nodeSet.add(info.getId());
        } else if (!levelMap.containsKey(lv) || !nodeSet.contains(info.getId())) {
            ArrayList<IRelationImage.Activity> arrayList = new ArrayList<IRelationImage.Activity>();
            arrayList.add(act);
            levelMap.put(lv, arrayList);
            nodeSet.add(info.getId());
        }
        int n = subBills.size();
        for (int i = 0; i < n; ++i) {
            BillRelationInfo nextUser = subBills.get(i);
            if (isPre) {
                BillRelationImage.buildList(nextUser, lv - 1, isPre, nodeSet, levelMap);
                continue;
            }
            BillRelationImage.buildList(nextUser, lv + 1, isPre, nodeSet, levelMap);
        }
    }

    public static void dealXY(Map<Integer, List<IRelationImage.Activity>> levelMap) {
        for (Integer integer : levelMap.keySet()) {
            List<IRelationImage.Activity> maps = levelMap.get(integer);
            int size = maps.size();
            int mid = size / 2;
            int[] midArr = new int[]{mid, mid};
            if (size % 2 == 0) {
                midArr[0] = mid - 1;
            }
            for (int i = 0; i < maps.size(); ++i) {
                int calY = 0;
                int y = 0;
                if (midArr[0] < midArr[1]) {
                    if (i < midArr[0]) {
                        calY = y + (i - midArr[0]) * 120 - 60;
                    } else if (i > midArr[1]) {
                        calY = y + (i - midArr[1]) * 120 + 60;
                    } else if (i == midArr[0]) {
                        calY = y - 60;
                    } else if (i == midArr[1]) {
                        calY = y + 60;
                    }
                } else {
                    calY = y + (i - mid) * 120;
                }
                maps.get((int)i).bound.y = calY;
                maps.get((int)i).bound.x = (integer - 100) * 150;
            }
        }
    }

    public static void dealWires(Map<Integer, List<IRelationImage.Activity>> levelMap, BillRelationImage relationImage) {
        IRelationImage.Wire wire;
        List<IRelationImage.Activity> acts;
        int i;
        ArrayList wires = Lists.newArrayList();
        ArrayList levels = Lists.newArrayList(levelMap.keySet());
        Collections.sort(levels);
        HashSet<String> wireSet = new HashSet<String>();
        for (i = 100; i > 0 && levelMap.containsKey(i); --i) {
            IRelationImage.Activity act;
            Set<String> preNodes;
            acts = levelMap.get(i);
            Iterator<IRelationImage.Activity> iterator = acts.iterator();
            while (iterator.hasNext() && (preNodes = (act = iterator.next()).getPreNodes()) != null && !preNodes.isEmpty() && levelMap.containsKey(i - 1)) {
                List<IRelationImage.Activity> preActs = levelMap.get(i - 1);
                for (IRelationImage.Activity preAct : preActs) {
                    String wireId = preAct.getActDefId() + "_" + act.getActDefId();
                    if (!preNodes.contains(preAct.getActDefId()) || wireSet.contains(wireId)) continue;
                    wire = new IRelationImage.Wire();
                    wire.isPass = true;
                    wire.hasArrow = true;
                    int fix = 5;
                    int height = preAct.getBound().height;
                    int width = preAct.getBound().width;
                    int curHeight = act.getBound().height;
                    wire.x1 = preAct.getBound().x + width;
                    wire.x2 = act.getBound().x;
                    wire.y1 = preAct.getBound().y + height / 2 - fix;
                    wire.y2 = act.getBound().y + curHeight / 2 - fix;
                    wires.add(wire);
                    wireSet.add(wireId);
                }
            }
        }
        block3: for (i = 100; i < 1000 && levelMap.containsKey(i); ++i) {
            acts = levelMap.get(i);
            for (IRelationImage.Activity act : acts) {
                Set<String> nextNodes = act.getNextNodes();
                if (!levelMap.containsKey(i + 1)) continue block3;
                if (nextNodes == null || nextNodes.isEmpty()) continue;
                List<IRelationImage.Activity> nextLevelActs = levelMap.get(i + 1);
                for (IRelationImage.Activity nextLevelAct : nextLevelActs) {
                    String wireKey = act.getActDefId() + "_" + nextLevelAct.getActDefId();
                    if (wireSet.contains(wireKey) || !nextNodes.contains(nextLevelAct.getActDefId())) continue;
                    wire = new IRelationImage.Wire();
                    wire.isPass = true;
                    wire.hasArrow = true;
                    wire.x1 = act.getBound().x + act.getBound().width;
                    wire.x2 = nextLevelAct.getBound().x;
                    wire.y1 = act.getBound().y + act.getBound().height / 2;
                    wire.y2 = nextLevelAct.getBound().y + nextLevelAct.getBound().height / 2;
                    wires.add(wire);
                    wireSet.add(wireKey);
                }
            }
        }
        relationImage.setWires(wires);
    }

    public void setWires(ArrayList wires) {
        this.wires = wires;
    }

    public void setActivities(HashMap activities) {
        this.activities = activities;
    }

    public void paintLines(Color bgColor) {
        IRelationImage.Wire w;
        int i;
        for (i = 0; i < this.wires.size(); ++i) {
            w = (IRelationImage.Wire)this.wires.get(i);
            if (w.isPass) {
                this.g.setColor(new Color(1, 59, 207));
                this.g.setStroke(new BasicStroke(2.0f));
            } else {
                this.g.setColor(new Color(0, 0, 0));
                this.g.setStroke(new BasicStroke(1.0f));
            }
            this.g.drawLine(w.x1 + this.offsetX, w.y1 + this.offsetY, w.x2 + this.offsetX, w.y2 + this.offsetY);
            if (!w.hasArrow) continue;
            BillRelationImage.drawArrow(this.g, w.x1 + this.offsetX, w.y1 + this.offsetY, w.x2 + this.offsetX, w.y2 + this.offsetY);
        }
        this.g.setColor(new Color(0, 0, 0));
        this.g.setStroke(new BasicStroke(1.0f));
        for (i = 0; i < this.wires.size(); ++i) {
            w = (IRelationImage.Wire)this.wires.get(i);
            if (w.label == null || w.label.length() == 0) continue;
            int x1 = w.x1 + this.offsetX;
            int y1 = w.y1 + this.offsetY;
            int x2 = w.x2 + this.offsetX;
            int y2 = w.y2 + this.offsetY;
            FontMetrics metrics = this.g.getFontMetrics();
            int height = 12;
            int width = metrics.stringWidth(w.label);
            int x = (x1 + x2) / 2 - width / 2;
            int y = (y1 + y2) / 2 - height / 2;
            this.drawString(bgColor, w.label, x, y, width, height);
        }
    }

    private void drawString(Color bgColor, String s, int x, int y, int width, int height) {
        this.g.setColor(bgColor);
        this.g.fillRect(x, y, width, height);
        this.g.setColor(new Color(0, 0, 0));
        int top = y + 12 - 1;
        if (StringUtils.isEmpty((String)s)) {
            this.g.drawRect(x, y, width, height);
            return;
        }
        String[] str = s.split("\n");
        if (str.length == 1) {
            this.g.drawRect(x, y, width, height);
            this.g.drawString(s, x + 1, top);
        } else {
            int size = str.length;
            for (int i = 0; i < size; ++i) {
                this.g.drawString(str[i], x + 1, top);
                top += this.g.getFontMetrics().getHeight();
            }
            this.g.drawRect(x, y, width, top - y);
        }
    }

    public void setGraphics(Graphics2D g) {
        if (FONT != null) {
            g.setFont(FONT);
        }
        this.metrics = g.getFontMetrics();
        this.g = g;
    }

    private static void drawArrow(Graphics g, int x1, int y1, int x2, int y2) {
        int x = x1 - x2;
        int y = y1 - y2;
        double angle = Math.atan2(y, x);
        double angle1 = angle + 0.5235987755982988;
        double angle2 = angle - 0.5235987755982988;
        int X1 = x2 + (int)Math.round(Math.cos(angle1) * 6.0);
        int Y1 = y2 + (int)Math.round(Math.sin(angle1) * 6.0);
        int X2 = x2 + (int)Math.round(Math.cos(angle2) * 6.0);
        int Y2 = y2 + (int)Math.round(Math.sin(angle2) * 6.0);
        int[] xa = new int[]{X1, X2, x2};
        int[] ya = new int[]{Y1, Y2, y2};
        Polygon p = new Polygon(xa, ya, 3);
        g.drawPolygon(p);
        g.fillPolygon(p);
    }

    private void generateWires(IRelationImage.Activity from, IRelationImage.Activity to, String path, boolean isPass, String desc) throws WfException {
        Point[] points = BillRelationImage.pathToPoints(path);
        if (points.length == 0) {
            this.generateDirectWire(from, to, isPass, desc);
        } else {
            for (int i = 0; i < points.length; ++i) {
                points[i] = BillRelationImage.relativePoint2Absolute(from, points[i]);
            }
            Point t = points[0];
            Point relativePos = BillRelationImage.absolutePoint2Relative(from, t);
            Point f = BillRelationImage.generateEndPoint(from, relativePos);
            IRelationImage.Wire w = this.generateWire(f.x, f.y, t.x, t.y, false, isPass, desc);
            this.wires.add(w);
            for (int i = 0; i < points.length - 1; ++i) {
                f = points[i];
                t = points[i + 1];
                w = this.generateWire(f.x, f.y, t.x, t.y, false, isPass, null);
                this.wires.add(w);
            }
            f = points[points.length - 1];
            relativePos = BillRelationImage.absolutePoint2Relative(to, f);
            t = BillRelationImage.generateEndPoint(to, relativePos);
            w = this.generateWire(f.x, f.y, t.x, t.y, true, isPass, null);
            this.wires.add(w);
        }
    }

    private static Point absolutePoint2Relative(IRelationImage.Activity act, Point absolutePos) {
        return new Point(absolutePos.x - act.bound.x - act.bound.width / 2, absolutePos.y - act.bound.y - act.bound.height / 2);
    }

    private static Point relativePoint2Absolute(IRelationImage.Activity act, Point relativePos) {
        return new Point(act.bound.x + act.bound.width / 2 + relativePos.x, act.bound.y + act.bound.height / 2 + relativePos.y);
    }

    private void generateDirectWire(IRelationImage.Activity from, IRelationImage.Activity to, boolean isPass, String desc) {
        String key = to.actDefId + ":" + from.actDefId;
        IRelationImage.Wire wire = (IRelationImage.Wire)this.activityPairs.get(key);
        if (wire != null) {
            int y = wire.y2 - wire.y1;
            int x = wire.x2 - wire.x1;
            double angle = Math.atan2(y, x);
            if (angle > 1.5707963267948966) {
                angle -= Math.PI;
            } else if (angle < -1.5707963267948966) {
                angle += Math.PI;
            }
            int offsetX = -((int)Math.round(Math.cos(angle += 1.5707963267948966) * 10.0));
            int offsetY = -((int)Math.round(Math.sin(angle) * 10.0));
            x = (wire.x2 + wire.x1) / 2 + offsetX;
            y = (wire.y2 + wire.y1) / 2 + offsetY;
            IRelationImage.Wire w = this.generateWire(wire.x2, wire.y2, x, y, false, isPass, desc);
            this.wires.add(w);
            w = this.generateWire(x, y, wire.x1, wire.y1, true, isPass, null);
            this.wires.add(w);
        } else {
            int x = to.bound.x + to.bound.width / 2 - from.bound.x - from.bound.width / 2;
            int y = to.bound.y + to.bound.height / 2 - from.bound.y - from.bound.height / 2;
            Point p = new Point(x, y);
            Point f = BillRelationImage.generateEndPoint(from, p);
            p = new Point(-x, -y);
            Point t = BillRelationImage.generateEndPoint(to, p);
            IRelationImage.Wire w = this.generateWire(f.x, f.y, t.x, t.y, true, isPass, desc);
            this.wires.add(w);
            key = from.actDefId + ":" + to.actDefId;
            this.activityPairs.put(key, w);
        }
    }

    private IRelationImage.Wire generateWire(int x1, int y1, int x2, int y2, boolean hasArrow, boolean isPass, String label) {
        IRelationImage.Wire w = new IRelationImage.Wire();
        w.x1 = x1;
        w.x2 = x2;
        w.y1 = y1;
        w.y2 = y2;
        w.hasArrow = hasArrow;
        w.isPass = isPass;
        w.label = label;
        if (x1 < this.minX) {
            this.minX = x1;
        }
        if (x1 > this.maxX) {
            this.maxX = x1;
        }
        if (x2 < this.minX) {
            this.minX = x2;
        }
        if (x2 > this.maxX) {
            this.maxX = x2;
        }
        if (y1 < this.minY) {
            this.minY = y1;
        }
        if (y1 > this.maxY) {
            this.maxY = y1;
        }
        if (y2 < this.minY) {
            this.minY = y2;
        }
        if (y2 > this.maxY) {
            this.maxY = y2;
        }
        return w;
    }

    private static Point generateEndPoint(IRelationImage.Activity activity, Point relativePos) {
        int y;
        int x;
        int Y;
        int halfWidth = activity.bound.width / 2;
        int halfHeight = activity.bound.height / 2;
        int X = Math.abs(relativePos.x);
        if (X >= (Y = Math.abs(relativePos.y))) {
            x = relativePos.x >= 0 ? halfWidth : -halfWidth;
            y = Y + 1 > halfHeight ? 0 : relativePos.y;
        } else {
            x = X > halfWidth ? 0 : relativePos.x;
            y = relativePos.y >= 0 ? halfHeight : -halfHeight;
        }
        return new Point(activity.bound.x + halfWidth + x, activity.bound.y + halfHeight + y);
    }

    private static Point[] pathToPoints(String path) {
        if (path == null || path.length() == 0) {
            return new Point[0];
        }
        String[] array = path.split(";");
        Point[] points = new Point[array.length];
        for (int i = 0; i < points.length; ++i) {
            String[] temp = array[i].split(",|\\|");
            points[i] = new Point(Integer.parseInt(temp[0]), Integer.parseInt(temp[1]));
        }
        return points;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public Graphics2D getGraphic() {
        return this.g;
    }

    private static Font getFont() {
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int i = 0; i < fonts.length; ++i) {
            if (!"\u5b8b\u4f53".equals(fonts[i].getFontName())) continue;
            return fonts[i].deriveFont(12.0f);
        }
        String tmp = System.getProperty("java.security.auth.login.config");
        if (tmp == null) {
            return BillRelationImage.getDefaultFont();
        }
        int i = tmp.lastIndexOf("/");
        if (i < 0) {
            return BillRelationImage.getDefaultFont();
        }
        String path = tmp.substring(0, i) + "/simsun.ttc";
        File file = new File(path);
        if (!file.exists()) {
            return BillRelationImage.getDefaultFont();
        }
        try {
            Font font = Font.createFont(0, file);
            return font.deriveFont(12.0f);
        }
        catch (Exception e) {
            return BillRelationImage.getDefaultFont();
        }
    }

    private static Font getDefaultFont() {
        try {
            return new Font("\u5b8b\u4f53", 0, 12);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public IRelationImage.Wire[] getWires() {
        return this.wires.toArray(new IRelationImage.Wire[this.wires.size()]);
    }

    @Override
    public void paintWires(Graphics2D g, Color bgColor) {
        this.setGraphics(g);
        this.paintLines(bgColor);
    }

    @Override
    public IRelationImage.Activity[] getActivities() {
        return this.activities.values().toArray(new IRelationImage.Activity[0]);
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getOffsetX() {
        return this.offsetX;
    }

    @Override
    public int getOffsetY() {
        return this.offsetY;
    }

    private void retrieveResponsibles() {
        this.responsibles = new ArrayList();
        ResponsibleCollection respons = this.processDef.getProcessHeader().getResponsibles();
        if (respons != null) {
            for (ResponsibleDef resDef : respons) {
                this.responsibles.add(resDef.getID());
            }
        }
    }

    @Override
    public ArrayList getResponsibles() {
        return this.responsibles;
    }

    @Override
    public String getInitiator() {
        return this.initiator;
    }

    @Override
    public IRelationImage.Comment[] getNotes() {
        return this.comments;
    }

    @Override
    public void paintComments(Graphics2D g, Color bgColor) {
        this.setGraphics(g);
        for (int i = 0; i < this.comments.length; ++i) {
            int height;
            IRelationImage.Comment c = this.comments[i];
            int width = this.metrics.stringWidth(c.content);
            if (width < c.width) {
                width = c.width;
            }
            if ((height = c.height) < 12) {
                height = 12;
            }
            this.drawString(bgColor, c.content, c.x + this.offsetX, c.y + this.offsetY, width, height);
        }
    }

    @Override
    public String getProcInstId() {
        return null;
    }

    @Override
    public String getParentProcInstId() {
        return null;
    }

    @Override
    public String getProcInstState() {
        return null;
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public Graphics2D getG() {
        return this.g;
    }

    public void setG(Graphics2D g) {
        this.g = g;
    }

    public FontMetrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(FontMetrics metrics) {
        this.metrics = metrics;
    }

    public ProcessDef getProcessDef() {
        return this.processDef;
    }

    public void setProcessDef(ProcessDef processDef) {
        this.processDef = processDef;
    }

    public String[] getPassedTransition() {
        return this.passedTransition;
    }

    public void setPassedTransition(String[] passedTransition) {
        this.passedTransition = passedTransition;
    }
}

