/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.client.relation;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.botp.BotpHelper;
import com.kingdee.eas.base.botp.client.relation.BillRelationInfo;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.log4j.Logger;

public class BotpRelationDataUtil {
    private static final Logger logger = Logger.getLogger(BotpRelationDataUtil.class);
    private String RELATIVE_BILL_ID;
    private String RELATIVE_BILL_ENTRYID;
    private String RELATIVE_BILL_TYPE;
    private String CURRENT_BILL_ID;
    private String CURRENT_ENTRY_ID;
    public static final int TRACE_UP = 0;
    public static final int TRACE_DOWN = 1;
    private static String botRelationQueryPK = "com.kingdee.bos.metadata.bot.app.BotRelationQuery";
    private int maxListCount = 10;
    private boolean needEntry = false;
    private Map<String, String> bosTypeName = new HashMap<String, String>();
    private Map uiContextMap;

    public BotpRelationDataUtil(Map uiContext) {
        this.uiContextMap = uiContext;
    }

    private void initPropertyNameByFindType(int type) {
        if (1 == type) {
            this.RELATIVE_BILL_ID = "destObjectID";
            this.RELATIVE_BILL_TYPE = "destEntityID";
            this.RELATIVE_BILL_ENTRYID = "relationEntries.destEntryID";
            this.CURRENT_BILL_ID = "srcObjectID";
            this.CURRENT_ENTRY_ID = "relationEntries.srcEntryID";
        } else {
            this.RELATIVE_BILL_ID = "srcObjectID";
            this.RELATIVE_BILL_TYPE = "srcEntityID";
            this.RELATIVE_BILL_ENTRYID = "relationEntries.srcEntryID";
            this.CURRENT_BILL_ID = "destObjectID";
            this.CURRENT_ENTRY_ID = "relationEntries.destEntryID";
        }
    }

    public BillRelationInfo getBillRelationInfo(String billID, List<String> entryIDs, boolean needEntry) throws Exception {
        this.needEntry = needEntry;
        return this.getBillRelationInfo(billID, entryIDs);
    }

    public BillRelationInfo getBillRelationInfo(String billID, List<String> entryIDs) throws Exception {
        this.intMaxListCount(null);
        BillRelationInfo diagramNode = new BillRelationInfo();
        diagramNode.setId(billID);
        diagramNode.setEntryIds(entryIDs);
        diagramNode.setBosType(BOSUuid.read((String)billID).getType().toString());
        diagramNode.setType(0);
        this.getBillListTraceDownOrUp(diagramNode, 1);
        this.getBillListTraceDownOrUp(diagramNode, 0);
        return diagramNode;
    }

    public void getBillListTraceDownOrUp(BillRelationInfo diagramNode, int type) throws Exception {
        if (diagramNode.getCurNodes() != null && diagramNode.getCurNodes().size() > this.maxListCount) {
            this.addInfoToDiagramListNode(diagramNode);
            EntityViewInfo entityViewByIdList = this.getEntityViewByIdList(type, diagramNode.getCurNodes());
            IRowSet rs = this.getRowData(entityViewByIdList);
            if (rs != null && rs.size() > 0) {
                this.handleResult(rs, diagramNode, type);
            }
        } else {
            this.addInfoToDiagramNode(diagramNode);
            String billID = diagramNode.getId();
            List<String> entryIDs = diagramNode.getEntryIds();
            EntityViewInfo viewInfo = this.getEntityView(type, billID, entryIDs, false);
            IRowSet rs = this.getRowData(viewInfo);
            if (rs != null && rs.size() > 0) {
                this.handleResult(rs, diagramNode, type);
            }
        }
    }

    private void handleResult(IRowSet rs, BillRelationInfo diagramNode, int type) throws Exception {
        Map entryRelation = new HashMap();
        if (this.needEntry) {
            entryRelation = this.getEntryRelation(type, diagramNode);
        }
        if (rs.size() <= this.maxListCount) {
            ArrayList<BillRelationInfo> diagramNodeList = new ArrayList<BillRelationInfo>();
            while (rs.next()) {
                BillRelationInfo diagramNodeChild = new BillRelationInfo();
                String relativeBillId = rs.getString(this.RELATIVE_BILL_ID);
                if (this.needEntry) {
                    List entryIds = this.getEntryIds(type, diagramNode, relativeBillId, entryRelation);
                    if (!CollectionUtils.isNotEmpty((Collection)entryIds)) continue;
                    diagramNodeChild.setEntryIds(entryIds);
                }
                if (!StringUtils.isEmpty((String)rs.getString(this.RELATIVE_BILL_ENTRYID))) {
                    diagramNodeChild.setEntryIds(Arrays.asList(rs.getString(this.RELATIVE_BILL_ENTRYID).split(",")));
                }
                if (StringUtils.isEmpty((String)rs.getString(this.RELATIVE_BILL_TYPE))) {
                    diagramNodeChild.setBosType(BOSUuid.read((String)relativeBillId).getType().toString());
                } else {
                    diagramNodeChild.setBosType(rs.getString(this.RELATIVE_BILL_TYPE));
                }
                diagramNodeChild.setId(relativeBillId);
                diagramNodeList.add(diagramNodeChild);
                this.getBillListTraceDownOrUp(diagramNodeChild, type);
            }
            if (type == 1) {
                diagramNode.setNextNodes(diagramNodeList);
            } else {
                diagramNode.setPreNodes(diagramNodeList);
            }
        } else {
            List<BillRelationInfo> diagramNodeList = this.createNextNodes(rs, entryRelation, diagramNode, type);
            if (type == 1) {
                diagramNode.setNextNodes(diagramNodeList);
            } else {
                diagramNode.setPreNodes(diagramNodeList);
            }
            for (BillRelationInfo node : diagramNodeList) {
                this.getBillListTraceDownOrUp(node, type);
            }
        }
    }

    private IRowSet getRowData(EntityViewInfo entityViewByIdList) throws BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(botRelationQueryPK));
        entityViewByIdList.setSelector(this.getDefaultSelector());
        exec.setObjectView(entityViewByIdList);
        IRowSet rs = exec.executeQuery();
        return rs;
    }

    private void addInfoToDiagramNode(BillRelationInfo diagramNode) throws BOSException, BOTPException {
        String name;
        diagramNode.setType(1);
        if (this.bosTypeName.containsKey(diagramNode.getBosType())) {
            name = this.bosTypeName.get(diagramNode.getBosType());
        } else {
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            EntityObjectInfo tempObj = loader.getEntity(BOSObjectType.create((String)diagramNode.getBosType()));
            name = tempObj.getAlias();
            this.bosTypeName.put(diagramNode.getBosType(), name);
        }
        IObjectValue objectValue = null;
        try {
            objectValue = BotpHelper.getObjectById(null, diagramNode.getId());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (objectValue != null && !StringUtils.isEmpty((String)objectValue.getString("number"))) {
            String number = objectValue.getString("number");
            diagramNode.setNumber(number);
            diagramNode.setName(name + ";" + number);
        } else {
            diagramNode.setName(name);
        }
    }

    private void addInfoToDiagramListNode(BillRelationInfo diagramNode) throws BOSException, BOTPException {
        String name;
        diagramNode.setType(2);
        ArrayList<String> idList = new ArrayList<String>();
        for (BillRelationInfo br : diagramNode.getCurNodes()) {
            idList.add(br.getId());
        }
        diagramNode.setId(StringUtils.arrayToString((Object[])idList.toArray(), (String)","));
        if (this.bosTypeName.containsKey(diagramNode.getBosType())) {
            name = this.bosTypeName.get(diagramNode.getBosType());
        } else {
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            EntityObjectInfo tempObj = loader.getEntity(BOSObjectType.create((String)diagramNode.getBosType()));
            name = tempObj.getAlias();
            this.bosTypeName.put(diagramNode.getBosType(), name);
        }
        diagramNode.setName(name + "(" + diagramNode.getCurNodes().size() + ")");
    }

    private List<BillRelationInfo> createNextNodes(IRowSet rs, Map entryRelation, BillRelationInfo diagramNode, int type) throws Exception {
        ArrayList<BillRelationInfo> diagramNodeList = new ArrayList<BillRelationInfo>();
        HashMap bosTypeDiagramNode = new HashMap();
        HashMap<String, String> idMap = new HashMap<String, String>();
        while (rs.next()) {
            BillRelationInfo diagramNodeChild = new BillRelationInfo();
            String relativeBillId = rs.getString(this.RELATIVE_BILL_ID);
            if (this.needEntry) {
                List entryIds = this.getEntryIds(type, diagramNode, relativeBillId, entryRelation);
                if (!CollectionUtils.isNotEmpty((Collection)entryIds)) continue;
                diagramNodeChild.setEntryIds(entryIds);
            }
            if (idMap.containsKey(relativeBillId)) continue;
            idMap.put(relativeBillId, relativeBillId);
            String bosType = rs.getString(this.RELATIVE_BILL_TYPE);
            if (StringUtils.isEmpty((String)bosType)) {
                bosType = BOSUuid.read((String)relativeBillId).getType().toString();
            }
            if (!StringUtils.isEmpty((String)rs.getString(this.RELATIVE_BILL_ENTRYID))) {
                diagramNodeChild.setEntryIds(Arrays.asList(rs.getString(this.RELATIVE_BILL_ENTRYID).split(",")));
            }
            diagramNodeChild.setId(relativeBillId);
            diagramNodeChild.setBosType(bosType);
            if (bosTypeDiagramNode.containsKey(bosType)) {
                ((List)bosTypeDiagramNode.get(bosType)).add(diagramNodeChild);
                continue;
            }
            ArrayList<BillRelationInfo> tmpList = new ArrayList<BillRelationInfo>();
            tmpList.add(diagramNodeChild);
            bosTypeDiagramNode.put(bosType, tmpList);
        }
        for (String next : bosTypeDiagramNode.keySet()) {
            if (((List)bosTypeDiagramNode.get(next)).size() > this.maxListCount) {
                BillRelationInfo listNode = new BillRelationInfo();
                listNode.setBosType(next);
                listNode.setCurNodes((List)bosTypeDiagramNode.get(next));
                diagramNodeList.add(listNode);
                continue;
            }
            diagramNodeList.addAll((Collection)bosTypeDiagramNode.get(next));
        }
        return diagramNodeList;
    }

    private EntityViewInfo getEntityView(int type, String billId, List entryIDs, boolean bCheckEntry) {
        this.initPropertyNameByFindType(type);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer markString = new StringBuffer("");
        int entriesNum = 0;
        if (entryIDs != null) {
            entriesNum = entryIDs.size();
        }
        filter.getFilterItems().add(new FilterItemInfo(this.CURRENT_BILL_ID, (Object)billId, CompareType.EQUALS));
        markString.append("#0 ");
        int step = 1;
        if (bCheckEntry && entriesNum > 0) {
            markString.append(" and (");
            markString.append("#" + step + " )");
            ++step;
            filter.getFilterItems().add(new FilterItemInfo("relationEntries.srcEntryPropName", (Object)"__src", CompareType.NOTEQUALS));
            markString.append(" and (");
            filter.getFilterItems().add(new FilterItemInfo(this.CURRENT_ENTRY_ID, (Object)"XXXXXX BOTP XXXXXX"));
            markString.append("#" + step + " or ");
            filter.getFilterItems().add(new FilterItemInfo(this.CURRENT_ENTRY_ID, (Object)billId, CompareType.EQUALS));
            markString.append("#" + ++step + " or ");
            ++step;
            for (int i = 0; i < entriesNum; ++i) {
                filter.getFilterItems().add(new FilterItemInfo(this.CURRENT_ENTRY_ID, (Object)entryIDs.get(i).toString(), CompareType.EQUALS));
                if (i == entriesNum - 1) {
                    markString.append("#" + (i + step) + " ");
                    markString.append(")");
                    continue;
                }
                markString.append("#" + (i + step) + " or  ");
            }
        }
        filter.setMaskString(markString.toString());
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private EntityViewInfo getEntityViewByIdList(int type, List<BillRelationInfo> nodes) {
        ArrayList<String> idList = new ArrayList<String>();
        for (BillRelationInfo node : nodes) {
            idList.add(node.getId());
        }
        this.initPropertyNameByFindType(type);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer markString = new StringBuffer("");
        filter.getFilterItems().add(new FilterItemInfo(this.CURRENT_BILL_ID, (Object)StringUtils.arrayToString((Object[])idList.toArray(), (String)","), CompareType.INCLUDE));
        markString.append("#0 ");
        filter.setMaskString(markString.toString());
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private SelectorItemCollection getDefaultSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("srcObjectID");
        sic.add("destObjectID");
        sic.add("relationEntries.srcEntryID");
        sic.add("relationEntries.destEntryID");
        sic.add(this.RELATIVE_BILL_TYPE);
        return sic;
    }

    private void intMaxListCount(Context ctx) {
        try {
            String value = ParamManager.getParamValue((Context)ctx, null, (String)"BOTP_RELATION_DIAGRAM_COUNT");
            if (!StringUtils.isEmpty((String)value)) {
                this.maxListCount = Integer.parseInt(value);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private List getEntryIds(int type, BillRelationInfo diagramNode, String relationBill, Map idEntryIdsMap) throws Exception {
        Map destBillMap;
        if (idEntryIdsMap.containsKey(relationBill)) {
            return (List)idEntryIdsMap.get(relationBill);
        }
        String billId = diagramNode.getId();
        List<String> entryIds = diagramNode.getEntryIds();
        Vector<String> ignoreEntryVec = new Vector<String>();
        ignoreEntryVec.add(relationBill);
        if (type == 1) {
            destBillMap = BTPManagerFactory.getRemoteInstance().traceDownBillFilter((IObjectPK)new ObjectUuidPK(billId), entryIds, ignoreEntryVec);
        } else {
            String sourceEntryIdProName = "entry.sourceBillEntryId";
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            EntityObjectInfo tempObj = loader.getEntity(BOSObjectType.create((String)diagramNode.getBosType()));
            if (tempObj.getExtendedProperty("listUI") != null) {
                String listUIName = tempObj.getExtendedProperty("listUI");
                try {
                    sourceEntryIdProName = (String)BOTPTools.invokeDynMethod(Class.forName(listUIName).newInstance(), "getsourceBillEntryId", null, null);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
            }
            destBillMap = BTPManagerFactory.getRemoteInstance().traceUpBillFilter((IObjectPK)new ObjectUuidPK(billId), sourceEntryIdProName, entryIds, ignoreEntryVec);
        }
        if (destBillMap != null && !CollectionUtils.isEmpty((Collection)((List)destBillMap.get("navEntryIDList"))) && !CollectionUtils.isEmpty((Collection)((List)destBillMap.get("navBillidList")))) {
            List navEntryIdList = (List)destBillMap.get("navEntryIDList");
            ArrayList<String> entryIdList = new ArrayList<String>();
            for (int i = 0; i < navEntryIdList.size(); ++i) {
                entryIdList.add(navEntryIdList.get(i).toString());
            }
            return entryIdList;
        }
        return null;
    }

    private Map getEntryRelation(int type, BillRelationInfo diagramNode) throws Exception {
        String billId = diagramNode.getId();
        List<String> entryIds = diagramNode.getEntryIds();
        EntityViewInfo viewInfo = this.getEntityView(type, billId, entryIds, true);
        IRowSet rs = this.getRowData(viewInfo);
        HashMap<String, List<String>> idEntryIdsMap = new HashMap<String, List<String>>();
        if (rs != null && rs.size() > 0) {
            while (rs.next()) {
                String relativeBillId = rs.getString(this.RELATIVE_BILL_ID);
                if (StringUtils.isEmpty((String)rs.getString(this.RELATIVE_BILL_ENTRYID))) continue;
                idEntryIdsMap.put(relativeBillId, Arrays.asList(rs.getString(this.RELATIVE_BILL_ENTRYID).split(",")));
            }
        }
        return idEntryIdsMap;
    }
}

