/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.client.relation;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.monitor.client.PermissionUtil;
import com.kingdee.eas.base.botp.client.relation.BillRelationImage;
import com.kingdee.eas.base.botp.client.relation.BillRelationInfo;
import com.kingdee.eas.base.botp.client.relation.IRelationImage;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ep.client.PlugInProxyFactory;
import com.kingdee.eas.ep.client.UIParam;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import org.apache.commons.collections4.CollectionUtils;

public class ImageBillRelationPanel
extends CoreUI {
    private static final long serialVersionUID = -3758980904202151345L;
    KDLabel label = null;
    KDLabel labeltext = null;
    ImageIcon icon = null;
    protected KDWorkButton nodepropertyButton;
    public boolean isExit = false;
    PermissionUtil permissionUtil = new PermissionUtil();
    private String[] actInstInfoIdsForToolTip = null;
    IRelationImage image;
    Map uiContextMap;
    private static Map ICON_MAP = new Hashtable();

    public ImageBillRelationPanel() throws Exception {
    }

    public ImageBillRelationPanel(Map uiContextMap) throws Exception {
        this.uiContextMap = uiContextMap;
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = (RequestContext)clientHanlder.getRequestContext();
            request.setClassName("com.kingdee.bos.workflow.monitor.app.WorkFlowMonitorPanelUIHandler");
            if (this.actInstInfoIdsForToolTip != null && this.actInstInfoIdsForToolTip.length > 0) {
                request.put("actInstIdsForToolTip", (Object)this.actInstInfoIdsForToolTip);
            }
            clientHanlder.setRequestContext((Serializable)request);
        }
        return clientHanlder;
    }

    public boolean isPrepareInit() {
        return false;
    }

    public void addAllLabel() throws Exception {
        if (this.getComponents().length > 0) {
            this.removeAll();
        }
        int maxX = 0;
        int maxY = 0;
        IRelationImage.Activity[] activities = this.image.getActivities();
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        for (int i = 0; i < activities.length; ++i) {
            final IRelationImage.Activity activity = activities[i];
            String name = activity.name;
            int x = activity.bound.x + this.image.getOffsetX();
            int y = activity.bound.y + this.image.getOffsetY();
            int height = activity.bound.height;
            int width = activity.bound.width;
            this.icon = ImageBillRelationPanel.getIcon(activity.iconResource + ".png", "");
            if (name.contains(";")) {
                String[] names = name.split(";");
                String billName = this.getNewName(names[0], width, metrics);
                this.label = new KDLabel(billName, (Icon)this.icon, 0);
                this.label.setName(activity.actDefId);
                this.label.setBounds(x + 1, y + 1, width - 1, height + 5);
                this.label.setToolTipText(names[0]);
                String billNumber = this.getNewName(names[1], width, metrics);
                this.labeltext = new KDLabel(billNumber);
                int wid = (width - metrics.stringWidth(billNumber)) / 2;
                this.labeltext.setBounds(x + 1 + wid, y + height - 4, metrics.stringWidth(billNumber), 30);
                this.labeltext.setToolTipText(names[1]);
                this.add((Component)this.labeltext);
                this.labeltext.setForeground(Color.blue);
                this.labeltext.setCursor(new Cursor(12));
                this.labeltext.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent evt) {
                        block11: {
                            try {
                                String billInfoId = activity.actDefId;
                                ImageBillRelationPanel.this.checkPermission(billInfoId);
                                UIContext map = new UIContext((Object)this);
                                map.put("srcBillID", activity.actDefId);
                                map.put("BOTPViewStatus", new Integer(1));
                                map.put("Owner", evt.getSource());
                                RealModeIDList idList = RealModeIDList.getEmptyIDList();
                                idList.add(activity.actDefId);
                                String destBillEditUIClassName = BOTPTools.getEntityObjectInfoExtendProClient(BOSUuid.read((String)activity.actDefId).getType().toString(), "editUI");
                                if (destBillEditUIClassName == null) {
                                    throw new BTPException(BTPException.BILLNOEDITUI);
                                }
                                if (idList.size() <= 0) break block11;
                                idList.setCurrentIndex(0);
                                map.put("ID", idList.getCurrentID());
                                map.put("IDList", idList);
                                try {
                                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(destBillEditUIClassName, (Map)map, null, OprtState.VIEW);
                                    uiWindow.show();
                                    if (uiWindow instanceof JFrame) {
                                        ((JFrame)uiWindow).setExtendedState(6);
                                    }
                                }
                                catch (Exception e) {
                                    if (e.getCause() instanceof ObjectNotFoundException) {
                                        throw new BTPException(BTPException.BILLNOTFOUND);
                                    }
                                    try {
                                        Vector<String> idVector = new Vector<String>();
                                        idVector.add(activity.actDefId);
                                        EntityViewInfo botpFilter = BTPUtil.initIdFilter(idVector);
                                        HashMap<String, Object> uiCtx = new HashMap<String, Object>();
                                        uiCtx.put("BOTPViewStatus", new Integer(1));
                                        uiCtx.put("BOTPFilter", botpFilter);
                                        uiCtx.put("OwnerWindow", ImageBillRelationPanel.this.getUIContext().get("OwnerWindow"));
                                        if (ImageBillRelationPanel.this.getUIContext().get("BTPNAVCTX") != null) {
                                            Map btpNavCtx = (Map)ImageBillRelationPanel.this.getUIContext().get("BTPNAVCTX");
                                            uiCtx.put("BTPNAVCTX", btpNavCtx);
                                        }
                                        String destBillListUIClassName = BOTPTools.getEntityObjectInfoExtendProClient(BOSUuid.read((String)activity.actDefId).getType().toString(), "listUI");
                                        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(destBillListUIClassName, uiCtx, null, OprtState.EDIT);
                                        uiWindow.getUIObject().getUIContext().put("BOTPUIParam", "botp");
                                        uiWindow.show();
                                        if (uiWindow instanceof JFrame) {
                                            ((JFrame)uiWindow).setExtendedState(6);
                                        }
                                    }
                                    catch (Exception e1) {
                                        throw e;
                                    }
                                }
                            }
                            catch (Exception e) {
                                ImageBillRelationPanel.this.handUIException(e);
                            }
                        }
                    }
                });
            } else {
                String newName = this.getNewName(name, width, metrics);
                this.label = new KDLabel(newName, (Icon)this.icon, 0);
                this.label.setName(activity.actDefId);
                this.label.setBounds(x + 1, y + 1, width - 1, height + 5);
                this.label.setToolTipText(name);
            }
            this.label.setFocusable(true);
            this.label.setVerticalTextPosition(3);
            this.label.setHorizontalTextPosition(0);
            if (x + width > maxX) {
                maxX = x + width;
            }
            if (y + height > maxY) {
                maxY = y + height;
            }
            this.label.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    block18: {
                        Object obj = ((KDLabel)evt.getSource()).getUserObject();
                        if (!(obj instanceof IRelationImage.Activity)) {
                            return;
                        }
                        IRelationImage.Activity act = (IRelationImage.Activity)obj;
                        if (evt.getClickCount() == 2) {
                            try {
                                String billInfoID = act.actDefId;
                                if (billInfoID.split(",").length == 1) {
                                    ImageBillRelationPanel.this.checkPermission(billInfoID);
                                    UIContext map = new UIContext((Object)this);
                                    map.put("srcBillID", billInfoID);
                                    map.put("BOTPViewStatus", new Integer(1));
                                    map.put("Owner", evt.getSource());
                                    RealModeIDList idList = RealModeIDList.getEmptyIDList();
                                    idList.add(billInfoID);
                                    String destBillEditUIClassName = BOTPTools.getEntityObjectInfoExtendProClient(BOSUuid.read((String)billInfoID).getType().toString(), "editUI");
                                    if (destBillEditUIClassName == null) {
                                        throw new BTPException(BTPException.BILLNOEDITUI);
                                    }
                                    if (idList.size() <= 0) break block18;
                                    idList.setCurrentIndex(0);
                                    map.put("ID", idList.getCurrentID());
                                    map.put("IDList", idList);
                                    try {
                                        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(destBillEditUIClassName, (Map)map, null, OprtState.VIEW);
                                        uiWindow.show();
                                        if (uiWindow instanceof JFrame) {
                                            ((JFrame)uiWindow).setExtendedState(6);
                                        }
                                        break block18;
                                    }
                                    catch (Exception e) {
                                        if (e.getCause() instanceof ObjectNotFoundException) {
                                            throw new BTPException(BTPException.BILLNOTFOUND);
                                        }
                                        try {
                                            Vector<String> idVector = new Vector<String>();
                                            idVector.add(activity.actDefId);
                                            EntityViewInfo botpFilter = BTPUtil.initIdFilter(idVector);
                                            HashMap<String, Object> uiCtx = new HashMap<String, Object>();
                                            uiCtx.put("BOTPViewStatus", new Integer(1));
                                            uiCtx.put("BOTPFilter", botpFilter);
                                            uiCtx.put("OwnerWindow", ImageBillRelationPanel.this.getUIContext().get("OwnerWindow"));
                                            if (ImageBillRelationPanel.this.getUIContext().get("BTPNAVCTX") != null) {
                                                Map btpNavCtx = (Map)ImageBillRelationPanel.this.getUIContext().get("BTPNAVCTX");
                                                uiCtx.put("BTPNAVCTX", btpNavCtx);
                                            }
                                            String destBillListUIClassName = BOTPTools.getEntityObjectInfoExtendProClient(BOSUuid.read((String)activity.actDefId).getType().toString(), "listUI");
                                            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(destBillListUIClassName, uiCtx, null, OprtState.EDIT);
                                            uiWindow.getUIObject().getUIContext().put("BOTPUIParam", "botp");
                                            uiWindow.show();
                                            if (uiWindow instanceof JFrame) {
                                                ((JFrame)uiWindow).setExtendedState(6);
                                            }
                                            break block18;
                                        }
                                        catch (Exception e1) {
                                            throw e;
                                        }
                                    }
                                }
                                if (billInfoID.split(",").length > 1) {
                                    String destBillListUIClassName;
                                    Vector<String> idVector = new Vector<String>();
                                    idVector.addAll(Arrays.asList(billInfoID.split(",")));
                                    ImageBillRelationPanel.this.checkPermission(idVector);
                                    EntityViewInfo botpFilter = BTPUtil.initIdFilter(idVector);
                                    HashMap<String, Object> uiCtx = new HashMap<String, Object>();
                                    uiCtx.put("BOTPViewStatus", new Integer(1));
                                    uiCtx.put("BOTPFilter", botpFilter);
                                    uiCtx.put("OwnerWindow", ImageBillRelationPanel.this.getUIContext().get("OwnerWindow"));
                                    if (ImageBillRelationPanel.this.getUIContext().get("BTPNAVCTX") != null) {
                                        Map btpNavCtx = (Map)ImageBillRelationPanel.this.getUIContext().get("BTPNAVCTX");
                                        uiCtx.put("BTPNAVCTX", btpNavCtx);
                                    }
                                    if ((destBillListUIClassName = BOTPTools.getEntityObjectInfoExtendProClient(BOSUuid.read((String)billInfoID.split(",")[0]).getType().toString(), "listUI")) == null) {
                                        return;
                                    }
                                    IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(destBillListUIClassName, uiCtx, null, OprtState.EDIT);
                                    uiWindow.getUIObject().getUIContext().put("BOTPUIParam", "botp");
                                    uiWindow.show();
                                    if (uiWindow instanceof JFrame) {
                                        ((JFrame)uiWindow).setExtendedState(6);
                                    }
                                }
                            }
                            catch (Exception e) {
                                ImageBillRelationPanel.this.handUIException(e);
                            }
                        }
                    }
                }
            });
            this.label.setUserObject((Object)activity);
            this.add((Component)this.label);
        }
        this.setPreferredSize(new Dimension(maxX += 40, maxY += 40));
        this.setMaximumSize(new Dimension(maxX, maxY));
        this.setMinimumSize(new Dimension(maxX, maxY));
        this.repaint();
    }

    private void checkPermission(String billInfoId) throws Exception {
        if (this.uiContextMap == null) {
            this.uiContextMap = this.getUIContext();
        }
        SysContext sysContext = (SysContext)this.uiContextMap.get("sysContext");
        ObjectUuidPK userPK = new ObjectUuidPK(sysContext.getCurrentUserInfo().getId().toString());
        MetaDataPK actionPK = new MetaDataPK("ActionOnLoad");
        ObjectUuidPK orgPK = null;
        ObjectUuidPK dataPK = new ObjectUuidPK(billInfoId);
        OrgType mainType = null;
        Method method = null;
        String listUINameStr = BOTPTools.getEntityObjectInfoExtendProClient(BOSUuid.read((String)billInfoId).getType().toString(), "listUI");
        if (listUINameStr == null) {
            return;
        }
        MetaDataPK uiPK = new MetaDataPK(listUINameStr);
        try {
            ListUI billListUI = (ListUI)PlugInProxyFactory.createUIObject((String)listUINameStr, (UIParam)new UIParam());
            Class<?> clazz = billListUI.getClass();
            while (method == null && clazz != CoreBillListUI.class) {
                try {
                    method = clazz.getDeclaredMethod("getMainBizOrgType", new Class[0]);
                    method.setAccessible(true);
                }
                catch (Exception e) {
                    clazz = clazz.getSuperclass();
                }
            }
            if (method != null && billListUI != null) {
                mainType = (OrgType)method.invoke((Object)billListUI, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        orgPK = mainType == null ? new ObjectUuidPK(sysContext.getCurrentCtrlUnit().getId().toString()) : new ObjectUuidPK(sysContext.getCurrentOrgUnit(mainType).getId().toString());
        PermissionFactory.getRemoteInstance().checkDataPermission((IObjectPK)userPK, (IObjectPK)orgPK, (IMetaDataPK)uiPK, (IMetaDataPK)actionPK, (IObjectPK)dataPK);
    }

    private void checkPermission(Vector idVector) throws Exception {
        if (this.uiContextMap == null) {
            this.uiContextMap = this.getUIContext();
        }
        if (CollectionUtils.isEmpty((Collection)idVector)) {
            return;
        }
        SysContext sysContext = (SysContext)this.uiContextMap.get("sysContext");
        ObjectUuidPK userPK = new ObjectUuidPK(sysContext.getCurrentUserInfo().getId().toString());
        MetaDataPK actionPK = new MetaDataPK("ActionOnLoad");
        ObjectUuidPK orgPK = null;
        OrgType mainType = null;
        Method method = null;
        String listUINameStr = BOTPTools.getEntityObjectInfoExtendProClient(BOSUuid.read((String)idVector.get(0).toString()).getType().toString(), "listUI");
        if (listUINameStr == null) {
            return;
        }
        MetaDataPK uiPK = new MetaDataPK(listUINameStr);
        try {
            ListUI billListUI = (ListUI)PlugInProxyFactory.createUIObject((String)listUINameStr, (UIParam)new UIParam());
            Class<?> clazz = billListUI.getClass();
            while (method == null && clazz != CoreBillListUI.class) {
                try {
                    method = clazz.getDeclaredMethod("getMainBizOrgType", new Class[0]);
                    method.setAccessible(true);
                }
                catch (Exception e) {
                    clazz = clazz.getSuperclass();
                }
            }
            if (method != null && billListUI != null) {
                mainType = (OrgType)method.invoke((Object)billListUI, new Object[0]);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        orgPK = mainType == null ? new ObjectUuidPK(sysContext.getCurrentCtrlUnit().getId().toString()) : new ObjectUuidPK(sysContext.getCurrentOrgUnit(mainType).getId().toString());
        for (int i = idVector.size() - 1; i >= 0; --i) {
            String billInfoId = idVector.get(i).toString();
            ObjectUuidPK dataPK = new ObjectUuidPK(billInfoId);
            try {
                PermissionFactory.getRemoteInstance().checkDataPermission((IObjectPK)userPK, (IObjectPK)orgPK, (IMetaDataPK)uiPK, (IMetaDataPK)actionPK, (IObjectPK)dataPK);
                continue;
            }
            catch (Exception e) {
                idVector.remove(i);
                if (idVector.size() != 0) continue;
                throw e;
            }
        }
    }

    private String getNewName(String name, int width, FontMetrics metrics) {
        if (metrics.stringWidth(name) < width) {
            return name;
        }
        String newName = "";
        for (int i = 0; i < name.length(); ++i) {
            if (metrics.stringWidth(name.substring(0, i + 1)) + 4 <= width) continue;
            newName = name.substring(0, i);
            break;
        }
        return newName + "\u2026";
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    private static ImageIcon getIcon(String name, String type) {
        ImageIcon image = (ImageIcon)ICON_MAP.get(name);
        if (image == null) {
            URL url = BillRelationImage.class.getResource("icons/" + name + type);
            image = new ImageIcon(url);
            ICON_MAP.put(name, image);
        }
        return image;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.setBackground(new Color(236, 237, 237));
        this.loadFromProcessDef(g);
    }

    public void loadFromProcessDef(Graphics g) {
        Color c = new Color(236, 237, 237);
        Graphics2D g2d = (Graphics2D)g;
        this.image.paintWires(g2d, c);
        this.image.paintComments(g2d, c);
        IRelationImage.Activity[] activities = this.image.getActivities();
        for (int i = 0; i < activities.length; ++i) {
            IRelationImage.Activity activity = activities[i];
            if (activity.isAppended) {
                int x = activity.bound.x + this.image.getOffsetX() + (activity.bound.width - 32) / 2;
                int y = activity.bound.y + this.image.getOffsetY() + 4;
                g2d.setColor(Color.BLACK);
                g.drawString("+", x + 32, y + 32);
                continue;
            }
            if (!activity.hasAppended) continue;
        }
    }

    public void onLoad(BillRelationInfo relationInfo) throws Exception {
        this.setQueryPreference(false);
        this.setLayout(null);
        this.image = BillRelationImage.buildImageInfo(relationInfo);
        this.addAllLabel();
    }

    protected boolean checkViewDiagramPermission() throws EASBizException, BOSException {
        return this.permissionUtil.checkOperate(this.image.getResponsibles(), this.image.getInitiator(), "wf_report_Monitor_ViewDiagram", true);
    }

    public static EASWfServiceClient getServiceClient() throws BOSException {
        return new EASWfServiceClient();
    }
}

