/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.client.util;

import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.botp.client.util.BotpCommonUtil;
import com.kingdee.eas.base.commonquery.CompareSignEnum;
import com.kingdee.eas.base.commonquery.CompareSignStringEnum;
import com.kingdee.eas.base.commonquery.VarEnum;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.util.StringUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BotpCommonFilterUtil {
    private static Logger logger = Logger.getLogger(BotpCommonFilterUtil.class);

    public static boolean isSameWeekDates(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(date1);
        cal2.setTime(date2);
        int subYear = cal1.get(1) - cal2.get(1);
        return 0 == subYear ? cal1.get(3) == cal2.get(3) : (1 == subYear && 11 == cal2.get(2) ? cal1.get(3) == cal2.get(3) : -1 == subYear && 11 == cal1.get(2) && cal1.get(3) == cal2.get(3));
    }

    public static boolean equalsIgnoreCase(String src, String tgt) {
        return StringUtils.equalsIgnoreCase((String)src, (String)tgt);
    }

    public static boolean isDateCompareSign(String signValue) {
        return signValue != null && (signValue.equalsIgnoreCase("YESTERDAY") || signValue.equalsIgnoreCase("TODAY") || signValue.equalsIgnoreCase("TOMORROW") || signValue.equalsIgnoreCase("LASTWEEK") || signValue.equalsIgnoreCase("THISWEEK") || signValue.equalsIgnoreCase("NEXTWEEK") || signValue.equalsIgnoreCase("LASTMONTH") || signValue.equalsIgnoreCase("THISMONTH") || signValue.equalsIgnoreCase("NEXTMONTH") || signValue.equalsIgnoreCase("BEFORETODAY") || signValue.equalsIgnoreCase("AFTERTODAY"));
    }

    public static boolean isEnumType(String typeName) {
        return typeName.equalsIgnoreCase(DataType.ENUM.getName());
    }

    public static boolean isBooleanType(String typeName) {
        return typeName.equalsIgnoreCase(DataType.BOOLEAN.getName());
    }

    public static boolean isIntType(String typeName) {
        return typeName.equals(DataType.SHORT.getName()) || typeName.equals(DataType.INTEGER.getName()) || typeName.equals(DataType.LONG.getName()) || typeName.equals(DataType.FLOAT.getName()) || typeName.equals(DataType.DOUBLE.getName()) || typeName.equals(DataType.DECIMAL.getName());
    }

    public static boolean isDateType(String typeName) {
        return typeName.equalsIgnoreCase(DataType.DATE.getName()) || typeName.equalsIgnoreCase(DataType.TIMESTAMP.getName()) || typeName.equalsIgnoreCase(DataType.TIME.getName());
    }

    public static boolean isF7Type(String typeName) {
        return typeName.equalsIgnoreCase("F7");
    }

    public static boolean isSimpleEntityType(String typeName) {
        return typeName.equalsIgnoreCase("SIMPLE_ENTITY");
    }

    public static FilterItemInfo getFieldFilter(String compare, String condition, Object compareValue) {
        CompareType compareType = null;
        if (compare.equalsIgnoreCase("FIELDEQUAL")) {
            compareType = CompareType.getEnum((String)"=");
        } else if (compare.equalsIgnoreCase("FIELDNOTEQUAL")) {
            compareType = CompareType.getEnum((String)"<>");
        } else if (compare.equalsIgnoreCase("FIELDLARGE")) {
            compareType = CompareType.getEnum((String)">");
        } else if (compare.equalsIgnoreCase("FIELDLARGEEQUAL")) {
            compareType = CompareType.getEnum((String)">=");
        } else if (compare.equalsIgnoreCase("FIELDLESS")) {
            compareType = CompareType.getEnum((String)"<");
        } else if (compare.equalsIgnoreCase("FIELDLESSEQUAL")) {
            compareType = CompareType.getEnum((String)"<=");
        }
        FilterItemInfo filterItemInfo4 = new FilterItemInfo(condition, compareValue, compareType);
        filterItemInfo4.setCompareValueIsProperty(true);
        return filterItemInfo4;
    }

    public static String filterStdCompare2Field(String compare) {
        String fieldCompare = null;
        if (compare.equalsIgnoreCase("=")) {
            fieldCompare = "FIELDEQUAL";
        } else if (compare.equalsIgnoreCase("<>")) {
            fieldCompare = "FIELDEQUAL";
        } else if (compare.equalsIgnoreCase(">")) {
            fieldCompare = "FIELDLARGE";
        } else if (compare.equalsIgnoreCase(">=")) {
            fieldCompare = "FIELDLARGEEQUAL";
        } else if (compare.equalsIgnoreCase("<")) {
            fieldCompare = "FIELDLESS";
        } else if (compare.equalsIgnoreCase("<=")) {
            fieldCompare = "FIELDLESSEQUAL";
        } else {
            logger.error((Object)("Error of FieldCompareType :" + compare));
        }
        return fieldCompare;
    }

    public static FilterInfo getEqualDateFilter(FilterInfo oldFilterInfo, String condition, Object compareValue) {
        Calendar worldTour = Calendar.getInstance();
        worldTour.setTime((Date)compareValue);
        worldTour.add(5, 0);
        Date startDay = worldTour.getTime();
        worldTour.add(5, 1);
        Date endDay = worldTour.getTime();
        FilterItemInfo filterItemInfo = new FilterItemInfo(condition, (Object)startDay, CompareType.getEnum((String)">="));
        oldFilterInfo.getFilterItems().add(filterItemInfo);
        FilterItemInfo filterItemInfo1 = new FilterItemInfo(condition, (Object)endDay, CompareType.getEnum((String)"<"));
        oldFilterInfo.getFilterItems().add(filterItemInfo1);
        return oldFilterInfo;
    }

    public static FilterInfo getNotEqualDateFilter(FilterInfo oldFilterInfo, String condition, Object compareValue) {
        Calendar worldTour = Calendar.getInstance();
        worldTour.setTime((Date)compareValue);
        worldTour.add(5, 0);
        Date startDay = worldTour.getTime();
        worldTour.add(5, 1);
        Date endDay = worldTour.getTime();
        FilterItemInfo filterItemInfo = new FilterItemInfo(condition, (Object)startDay, CompareType.getEnum((String)"<"));
        oldFilterInfo.getFilterItems().add(filterItemInfo);
        FilterItemInfo filterItemInfo1 = new FilterItemInfo(condition, (Object)endDay, CompareType.getEnum((String)">="));
        oldFilterInfo.getFilterItems().add(filterItemInfo1);
        FilterItemInfo filterItemInfo2 = new FilterItemInfo(condition, null, CompareType.EQUALS);
        oldFilterInfo.getFilterItems().add(filterItemInfo2);
        return oldFilterInfo;
    }

    public static boolean isLikeSign(Object compareSign) {
        return compareSign == CompareSignStringEnum.LEFTLIKESIGN || compareSign == CompareSignStringEnum.RIGHTLIKESIGN || compareSign == CompareSignStringEnum.LIKESIGN || compareSign == CompareSignStringEnum.NOTLIKESIGN || compareSign == CompareSignStringEnum.NOTLEFTLIKESIGN || compareSign == CompareSignEnum.LEFTLIKESIGN || compareSign == CompareSignEnum.RIGHTLIKESIGN || compareSign == CompareSignEnum.LIKESIGN || compareSign == CompareSignEnum.NOTLIKESIGN || compareSign == CompareSignEnum.NOTLEFTLIKESIGN;
    }

    public static boolean isIncludeSign(Object compareSign) {
        return CompareSignEnum.INCLUDESIGN.equals(compareSign) || CompareSignEnum.NOTINCLUDESIGN.equals(compareSign);
    }

    public static Object getLikeCompareValue(Object compareValue, Object compareSign) {
        if (compareSign == CompareSignStringEnum.LEFTLIKESIGN || compareSign == CompareSignEnum.LEFTLIKESIGN) {
            if (BotpCommonUtil.IsStringValue(compareValue.toString())) {
                Vector vect = BotpCommonUtil.processStringValue(compareValue.toString());
                Iterator it = vect.iterator();
                StringBuffer buffer = new StringBuffer();
                while (it.hasNext()) {
                    String value = (String)it.next();
                    buffer.append(value).append("%").append(",");
                }
                compareValue = buffer.deleteCharAt(buffer.length() - 1).toString();
            } else {
                compareValue = compareValue + "%";
            }
        } else if (compareSign == CompareSignStringEnum.RIGHTLIKESIGN || compareSign == CompareSignEnum.RIGHTLIKESIGN) {
            if (BotpCommonUtil.IsStringValue(compareValue.toString())) {
                Vector vect = BotpCommonUtil.processStringValue(compareValue.toString());
                Iterator it = vect.iterator();
                StringBuffer buffer = new StringBuffer();
                while (it.hasNext()) {
                    String value = (String)it.next();
                    buffer.append("%").append(value).append(",");
                }
                compareValue = buffer.deleteCharAt(buffer.length() - 1).toString();
            } else {
                compareValue = "%" + compareValue;
            }
        } else if (compareSign == CompareSignStringEnum.LIKESIGN || compareSign == CompareSignEnum.LIKESIGN) {
            if (BotpCommonUtil.IsStringValue(compareValue.toString())) {
                Vector vect = BotpCommonUtil.processStringValue(compareValue.toString());
                Iterator it = vect.iterator();
                StringBuffer buffer = new StringBuffer();
                while (it.hasNext()) {
                    String value = (String)it.next();
                    buffer.append("%").append(value).append("%").append(",");
                }
                compareValue = buffer.deleteCharAt(buffer.length() - 1).toString();
            } else {
                compareValue = "%" + compareValue + "%";
            }
        } else if (compareSign == CompareSignStringEnum.NOTLIKESIGN || compareSign == CompareSignEnum.NOTLIKESIGN) {
            if (BotpCommonUtil.IsStringValue(compareValue.toString())) {
                Vector vect = BotpCommonUtil.processStringValue(compareValue.toString());
                Iterator it = vect.iterator();
                StringBuffer buffer = new StringBuffer();
                while (it.hasNext()) {
                    String value = (String)it.next();
                    buffer.append("%").append(value).append("%").append(",");
                }
                compareValue = buffer.deleteCharAt(buffer.length() - 1).toString();
            } else {
                compareValue = "%" + compareValue + "%";
            }
        } else if (compareSign == CompareSignStringEnum.NOTLEFTLIKESIGN || compareSign == CompareSignEnum.NOTLEFTLIKESIGN) {
            if (BotpCommonUtil.IsStringValue(compareValue.toString())) {
                Vector vect = BotpCommonUtil.processStringValue(compareValue.toString());
                Iterator it = vect.iterator();
                StringBuffer buffer = new StringBuffer();
                while (it.hasNext()) {
                    String value = (String)it.next();
                    buffer.append(value).append("%").append(",");
                }
                compareValue = buffer.deleteCharAt(buffer.length() - 1).toString();
            } else {
                compareValue = compareValue + "%";
            }
        }
        return compareValue;
    }

    public static boolean isFieldJudge(String compare) {
        return compare != null && (compare.equalsIgnoreCase(CompareSignStringEnum.FIELDEQUAL.toString()) || compare.equalsIgnoreCase(CompareSignStringEnum.FIELDNOTEQUAL.toString()) || compare.equalsIgnoreCase("FIELDEQUAL") || compare.equalsIgnoreCase("FIELDNOTEQUAL") || compare.equalsIgnoreCase("FIELDLARGE") || compare.equalsIgnoreCase(CompareSignStringEnum.FIELDLARGE.toString()) || compare.equalsIgnoreCase("FIELDLARGEEQUAL") || compare.equalsIgnoreCase(CompareSignStringEnum.FIELDLARGEEQUAL.toString()) || compare.equalsIgnoreCase("FIELDLESS") || compare.equalsIgnoreCase(CompareSignStringEnum.FIELDLESS.toString()) || compare.equalsIgnoreCase("FIELDLESSEQUAL") || compare.equalsIgnoreCase(CompareSignStringEnum.FIELDLESSEQUAL.toString()));
    }

    public static boolean isVarJudge(String compare) {
        return compare != null && (compare.equalsIgnoreCase(CompareSignEnum.VAREQUAL.toString()) || compare.equalsIgnoreCase("VAREQUAL".toString()) || compare.equalsIgnoreCase("VARNOTEQUAL".toString()) || compare.equalsIgnoreCase(CompareSignEnum.VARNOTEQUAL.toString()));
    }

    public static FilterItemInfo getVarFilterForSave(String compare, String condition, Object compareValue) {
        FilterItemInfo filterItemInfo = new FilterItemInfo();
        Object compareType = null;
        if (compare.equalsIgnoreCase("VAREQUAL".toString())) {
            filterItemInfo = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)"="));
        } else if (compare.equalsIgnoreCase("VARNOTEQUAL".toString())) {
            filterItemInfo = new FilterItemInfo(condition, compareValue, CompareType.getEnum((String)"<>"));
        }
        return filterItemInfo;
    }

    public static FilterItemInfo getVarFilterForQuery(String compare, String condition, Object compareValue) {
        FilterItemInfo filterItemInfo = new FilterItemInfo();
        Object compareType = null;
        String conditionid = BotpCommonFilterUtil.getConditionId(condition);
        Object currentValue = BotpCommonFilterUtil.getVarCurrentValue(compareValue);
        if (compare.equalsIgnoreCase("VAREQUAL".toString())) {
            filterItemInfo = new FilterItemInfo(conditionid, currentValue, CompareType.getEnum((String)"="));
        } else if (compare.equalsIgnoreCase("VARNOTEQUAL".toString())) {
            filterItemInfo = new FilterItemInfo(conditionid, currentValue, CompareType.getEnum((String)"<>"));
        }
        return filterItemInfo;
    }

    private static String getConditionId(String condition) {
        if (condition.indexOf(".") > 0) {
            String[] arr = condition.split("//.");
            StringBuffer tmp = new StringBuffer();
            for (int i = 0; i <= arr.length - 1; ++i) {
                if (i < arr.length - 1) {
                    tmp.append(arr[i]).append(".");
                    continue;
                }
                tmp.append("id");
            }
            return tmp.toString();
        }
        return "id";
    }

    public static boolean isVarValue(String str) {
        if (str == null) {
            return false;
        }
        return str.equalsIgnoreCase("$currentUser$") || str.equalsIgnoreCase(VarEnum.CURRENTUSER.getAlias());
    }

    private static Object getVarCurrentValue(Object compareValue) {
        if ("$currentUser$".toString().equals(compareValue.toString())) {
            return BotpCommonFilterUtil.getCurrentUserId();
        }
        return null;
    }

    private static String getCurrentUserId() {
        return SysContext.getSysContext().getCurrentUserInfo().getId().toString();
    }
}

