/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.botp.client.util;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.eas.base.botp.client.util.VirtualTreeNode;
import com.kingdee.eas.base.botp.util.BotpMetaDataFactory;
import com.kingdee.eas.base.botp.util.IBotpMetaData;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class EntityTreeUtil {
    private static final int DAFAULTMAXLEVEL = 10;
    private static final String RESXFILENAME = "com.kingdee.eas.base.botp.BotpResx";
    private static final String MAXLEVELINFO = "MAXLEVELINFO";
    private static Icon icon = EASResource.getIcon((String)"imgTbtn_distributelog");

    public static void initEntityTree(KDTree tree, EntityObjectInfo entity) {
        EntityTreeUtil.initEntityTree(tree, entity, null);
    }

    public static void initEntityTree(KDTree tree, EntityObjectInfo entity, int maxLevel) {
        EntityTreeUtil.initEntityTree(tree, entity, null, maxLevel);
    }

    public static void initEntityTree(KDTree tree, IBotpMetaData rootBotpEntity) {
        EntityTreeUtil.initEntityTree(tree, rootBotpEntity, null);
    }

    public static void initEntityTree(KDTree tree, IBotpMetaData rootBotpEntity, int maxLevel) {
        EntityTreeUtil.initEntityTree(tree, rootBotpEntity, null, maxLevel);
    }

    public static void initEntityTree(KDTree tree, EntityObjectInfo entity, IBotpMetaData destBotpProperty) {
        EntityTreeUtil.initEntityTree(tree, entity, destBotpProperty, 10);
    }

    public static void initEntityTree(KDTree tree, EntityObjectInfo entity, IBotpMetaData destBotpProperty, int maxLevel) {
        IBotpMetaData rootBotpEntity = BotpMetaDataFactory.createEntity(entity);
        EntityTreeUtil.initEntityTree(tree, rootBotpEntity, destBotpProperty, maxLevel);
    }

    public static void initEntityTree(KDTree tree, IBotpMetaData rootBotpEntity, IBotpMetaData destBotpProperty) {
        EntityTreeUtil.initEntityTree(tree, rootBotpEntity, destBotpProperty, 10);
    }

    public static void initEntityTree(KDTree tree, IBotpMetaData rootBotpEntity, final IBotpMetaData destBotpProperty, final int maxLevel) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)rootBotpEntity);
        root.setText(rootBotpEntity.getDisplayName());
        EntityTreeUtil.getChildren(root, destBotpProperty);
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                EntityTreeUtil.expandVitualNode(event, destBotpProperty);
            }
        });
        if (maxLevel > 1) {
            tree.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeCollapsed(TreeExpansionEvent event) {
                }

                @Override
                public void treeExpanded(TreeExpansionEvent event) {
                    KDTree tree = (KDTree)event.getSource();
                    TreePath path = event.getPath();
                    if (path.getPathCount() > maxLevel) {
                        tree.collapsePath(path);
                        MsgBox.showInfo((Component)tree, (String)EASResource.getString((String)EntityTreeUtil.RESXFILENAME, (String)EntityTreeUtil.MAXLEVELINFO));
                    }
                }
            });
        }
        ((KingdeeTreeModel)tree.getModel()).setRoot((TreeNode)root);
    }

    private static void expandVitualNode(TreeExpansionEvent event, IBotpMetaData destBotpProperty) {
        KDTree tree = (KDTree)event.getSource();
        DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
        if (treeNode.getChildCount() == 1 && treeNode.getChildAt(0) instanceof VirtualTreeNode) {
            tree.removeAllChildrenFromParent((MutableTreeNode)treeNode);
            EntityTreeUtil.getChildren(treeNode, destBotpProperty);
        }
    }

    private static void getChildren(DefaultKingdeeTreeNode treeNode, IBotpMetaData destBotpProperty) {
        IBotpMetaData parentData = (IBotpMetaData)treeNode.getUserObject();
        EntityObjectInfo entity = parentData.getEntity();
        if (entity != null) {
            ArrayList childPropertyList = parentData.getChildren();
            for (IBotpMetaData childBotpProperty : childPropertyList) {
                DefaultKingdeeTreeNode childTreeNode = new DefaultKingdeeTreeNode((Object)childBotpProperty);
                childTreeNode.setText(childBotpProperty.getDisplayName());
                if ("false".equals(childBotpProperty.getProperty().getExtendedProperty("isShowInSrcProperty"))) continue;
                if (childBotpProperty.getProperty() instanceof LinkPropertyInfo) {
                    if (destBotpProperty != null && destBotpProperty.getProperty() instanceof LinkPropertyInfo && EntityTreeUtil.canSafeConverse(childBotpProperty, destBotpProperty)) {
                        childTreeNode.setCustomIcon(icon);
                    }
                    childTreeNode.add((MutableTreeNode)((Object)new VirtualTreeNode()));
                    treeNode.add((MutableTreeNode)childTreeNode);
                    continue;
                }
                if (destBotpProperty == null) {
                    treeNode.add((MutableTreeNode)childTreeNode);
                    continue;
                }
                if (destBotpProperty.getProperty() instanceof LinkPropertyInfo) {
                    String isAcctCussent;
                    DataType dataType;
                    if (!destBotpProperty.getEntity().getFullName().equals("com.kingdee.eas.basedata.master.account.app.AccountView") || !(dataType = ((OwnPropertyInfo)childBotpProperty.getProperty()).getDataType()).equals((Object)DataType.STRING) && !dataType.equals((Object)DataType.BOSUUID) || (isAcctCussent = childBotpProperty.getProperty().getExtendedProperty("ISACCTCUSSENT")) == null || !isAcctCussent.equalsIgnoreCase("true")) continue;
                    treeNode.add((MutableTreeNode)childTreeNode);
                    continue;
                }
                if (!EntityTreeUtil.canSafeTypeConverse(destBotpProperty, childBotpProperty)) continue;
                treeNode.add((MutableTreeNode)childTreeNode);
            }
        }
    }

    private static boolean canSafeConverse(IBotpMetaData srcBotpProperty, IBotpMetaData destBotpProperty) {
        boolean isSafe = false;
        if (srcBotpProperty.getProperty() instanceof LinkPropertyInfo && destBotpProperty.getProperty() instanceof LinkPropertyInfo) {
            for (EntityObjectInfo srcEntity = srcBotpProperty.getEntity(); srcEntity != null; srcEntity = srcEntity.getBaseEntity()) {
                if (!srcEntity.getFullName().equals(destBotpProperty.getEntity().getFullName())) continue;
                isSafe = true;
                break;
            }
        }
        return isSafe;
    }

    private static boolean canSafeTypeConverse(IBotpMetaData destBotpProperty, IBotpMetaData childBotpProperty) {
        DataType child;
        boolean result = false;
        DataType dest = ((OwnPropertyInfo)destBotpProperty.getProperty()).getDataType();
        if (dest.equals((Object)(child = ((OwnPropertyInfo)childBotpProperty.getProperty()).getDataType()))) {
            result = true;
        } else if (dest.equals((Object)DataType.DATE) && child.equals((Object)DataType.TIMESTAMP)) {
            result = true;
        }
        return result;
    }
}

