/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.btp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class BTPUtil {
    private static final String FIVOUCHEREDPROPERTYNAME = "fiVouchered";

    public static boolean hasBotMapping(Context ctx, IObjectCollection srcBillCols) throws BOTPException, BOSException {
        if (srcBillCols == null || srcBillCols.size() < 1) {
            return false;
        }
        IBOTMapping iBotMapping = ctx == null ? BOTMappingFactory.getRemoteInstance() : BOTMappingFactory.getLocalInstance(ctx);
        BOTMappingCollection botMappingCols = iBotMapping.getMappingCollectionForSelect((CoreBillBaseCollection)srcBillCols, null, DefineSysEnum.BTP);
        return botMappingCols != null && botMappingCols.size() > 0;
    }

    public static boolean hasUpBill(Context ctx, IObjectCollection srcBillCols) throws BOSException {
        if (srcBillCols == null || srcBillCols.size() < 1) {
            return false;
        }
        IBOTRelation iBotRelation = ctx == null ? BOTRelationFactory.getRemoteInstance() : BOTRelationFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = evi.getSelector();
        sic.add("srcObjectID");
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        StringBuffer mask = new StringBuffer();
        int size = srcBillCols.size();
        for (int i = 0; i < size; ++i) {
            filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)srcBillCols.getObject(i).get("id").toString()));
            if (i == 0) {
                mask.append("#");
            } else {
                mask.append(" or #");
            }
            mask.append(i);
        }
        filter.setMaskString(mask.toString());
        BOTRelationCollection botRelationCols = iBotRelation.getCollection(evi);
        return botRelationCols != null && botRelationCols.size() > 0;
    }

    public static boolean hasDownBill(Context ctx, IObjectCollection srcBillCols) throws BOSException {
        if (srcBillCols == null || srcBillCols.size() < 1) {
            return false;
        }
        IBOTRelation iBotRelation = ctx == null ? BOTRelationFactory.getRemoteInstance() : BOTRelationFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = evi.getSelector();
        sic.add("destObjectID");
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        StringBuffer mask = new StringBuffer();
        int size = srcBillCols.size();
        for (int i = 0; i < size; ++i) {
            filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)srcBillCols.getObject(i).get("id").toString()));
            if (i == 0) {
                mask.append("#");
            } else {
                mask.append(" or #");
            }
            mask.append(i);
        }
        filter.setMaskString(mask.toString());
        BOTRelationCollection botRelationCols = iBotRelation.getCollection(evi);
        return botRelationCols != null && botRelationCols.size() > 0;
    }

    public static void checkBillVouchered(IObjectCollection sourceBillCollection, String targetBillType, DefineSysEnum defineSys) throws BOTPException {
        if (defineSys.equals((Object)DefineSysEnum.DAP) && targetBillType != null && targetBillType.equals("2652E01E")) {
            for (IObjectValue sourceBill : sourceBillCollection) {
                if (!sourceBill.getBoolean(FIVOUCHEREDPROPERTYNAME)) continue;
                throw new BOTPException(BOTPException.BILLVOUCHERED);
            }
        }
    }

    public static void acceptMapping(IObjectCollection sourceBillCollection, BOTMappingInfo mappingInfo) throws BOSException, BOTPException {
        int i;
        IObjectValue sourceBill0 = sourceBillCollection.getObject(0);
        boolean hasEntryFilter = false;
        EntityViewInfo evi = BTPUtil.getBOTMappingFilter(mappingInfo);
        evi.getSelector().add("id");
        FilterInfo filterInfo = evi.getFilter();
        if (evi.getEntryFilters() != null && evi.getEntryFilters().size() > 0) {
            hasEntryFilter = true;
            int count = evi.getEntryFilters().size();
            for (int i2 = 0; i2 < count; ++i2) {
                FilterInfo entryFilter = evi.getEntryFilters().get(i2);
                String entryName = entryFilter.getEntryName();
                evi.getSelector().add(entryName + ".id");
            }
        }
        if (!(filterInfo != null && filterInfo.getFilterItems().size() != 0 || evi.getEntryFilters() != null && evi.getEntryFilters().size() != 0)) {
            return;
        }
        ArrayList<Object> billIdList = new ArrayList<Object>();
        int count = sourceBillCollection.size();
        for (int i3 = 0; i3 < count; ++i3) {
            billIdList.add(sourceBillCollection.getObject(i3).get("id"));
        }
        FilterInfo newHeadFilterInfo = BTPUtil.mergeFilterWithIdList(billIdList, filterInfo);
        if (filterInfo == null) {
            filterInfo = newHeadFilterInfo;
            evi.setFilter(newHeadFilterInfo);
        }
        if (hasEntryFilter) {
            int es = evi.getEntryFilters().size();
            for (int e = 0; e < es; ++e) {
                FilterInfo entryFilterInfo = evi.getEntryFilters().get(e);
                String entryName = entryFilterInfo.getEntryName();
                ArrayList<Object> entryIdList = new ArrayList<Object>();
                int count2 = sourceBillCollection.size();
                for (i = 0; i < count2; ++i) {
                    IObjectValue srcBillInfo = sourceBillCollection.getObject(i);
                    if (srcBillInfo.get(entryName) == null || !(srcBillInfo.get(entryName) instanceof IObjectCollection)) continue;
                    IObjectCollection entryCols = (IObjectCollection)srcBillInfo.get(entryName);
                    int entryCount = entryCols.size();
                    for (int j = 0; j < entryCount; ++j) {
                        entryIdList.add(entryCols.getObject(j).get("id"));
                    }
                }
                BTPUtil.mergeFilterWithIdList(entryIdList, entryFilterInfo);
            }
        }
        ArrayList<CoreBillBaseInfo> errorBillCollection = new ArrayList<CoreBillBaseInfo>();
        IDynamicObject iDynObj = DynamicObjectFactory.getRemoteInstance();
        IObjectCollection filteredCols = iDynObj.getCollection(sourceBill0.getBOSType(), evi);
        ArrayList<String> filteredIdList = new ArrayList<String>();
        int count3 = filteredCols.size();
        for (int i4 = 0; i4 < count3; ++i4) {
            IObjectValue filteredInfo = filteredCols.getObject(i4);
            boolean flag = true;
            if (hasEntryFilter) {
                int es = evi.getEntryFilters().size();
                for (int e = 0; e < es; ++e) {
                    FilterInfo entryFilterInfo = evi.getEntryFilters().get(e);
                    String entryName = entryFilterInfo.getEntryName();
                    if (filteredInfo.get(entryName) != null && filteredInfo.get(entryName) instanceof IObjectCollection && ((IObjectCollection)filteredInfo.get(entryName)).size() > 0) continue;
                    flag = false;
                    break;
                }
                if (!flag) continue;
                filteredIdList.add(filteredInfo.get("id").toString());
                continue;
            }
            filteredIdList.add(filteredInfo.get("id").toString());
        }
        HashMap pkListMap = new HashMap();
        for (i = 0; i < filteredIdList.size(); ++i) {
            pkListMap.put(filteredIdList.get(i), null);
        }
        for (CoreBillBaseInfo sourceBillInfo : sourceBillCollection) {
            if (pkListMap.containsKey(sourceBillInfo.getId().toString())) continue;
            errorBillCollection.add(sourceBillInfo);
        }
        if (errorBillCollection.size() > 0) {
            StringBuffer billNumberList = new StringBuffer();
            for (CoreBillBaseInfo sourceBillInfo : errorBillCollection) {
                billNumberList.append(sourceBillInfo.getNumber());
                billNumberList.append(" ");
            }
            throw new BOTPException(BOTPException.ILLEGALBILLLIST, new Object[]{billNumberList.toString()});
        }
    }

    public static EntityViewInfo getBOTMappingFilter(BOTMappingInfo mappingInfo) throws BOSException {
        EntityViewInfo entityViewInfo;
        if (StringUtils.isEmpty((String)mappingInfo.getExtRule().getFilter())) {
            entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            entityViewInfo.setFilter(filterInfo);
        } else {
            try {
                entityViewInfo = BOTPTools.getEntityViewInfoFromMapping(mappingInfo, 0);
            }
            catch (BOSException exc) {
                throw new BOSException(exc.getMessage(), (Throwable)exc);
            }
        }
        return entityViewInfo;
    }

    private static FilterInfo mergeFilterWithIdList(List idList, FilterInfo filterInfo) {
        int index = 0;
        StringBuffer sbMaskString = new StringBuffer();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        if (filterInfo.getMaskString() == null || filterInfo.getMaskString().length() == 0) {
            Iterator iterFilter = filterInfo.getFilterItems().iterator();
            while (iterFilter.hasNext()) {
                if (index != 0) {
                    sbMaskString.append(" and ");
                }
                iterFilter.next();
                sbMaskString.append("#" + String.valueOf(index));
                ++index;
            }
            filterInfo.setMaskString(sbMaskString.toString());
        }
        StringBuffer sbNewMaskString = new StringBuffer();
        index = 0;
        String strIdLists = StringUtils.arrayToString((Object[])idList.toArray(), (String)",");
        sbNewMaskString.append("#" + String.valueOf(filterInfo.getFilterItems().size()));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        if (filterInfo.getMaskString() == null || filterInfo.getMaskString().length() == 0) {
            filterInfo.setMaskString(sbNewMaskString.toString());
        } else {
            filterInfo.setMaskString("(" + filterInfo.getMaskString() + ") and (" + sbNewMaskString.toString() + ")");
        }
        return filterInfo;
    }

    public static EntityViewInfo initIdFilter(Vector idList) throws Exception {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer maskString = new StringBuffer();
        maskString.append("(");
        for (int i = 0; i < idList.size(); ++i) {
            if (i != 0) {
                maskString.append(" or ");
            }
            maskString.append("#" + i);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)((String)idList.get(i)), CompareType.EQUALS));
        }
        maskString.append(")");
        filter.setMaskString(maskString.toString());
        entityViewInfo.setFilter(filter);
        return entityViewInfo;
    }
}

