/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.btp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutor;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.QueryFieldCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.botp.util.BOTPTools;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.client.AbstractBTPRelationNavUI;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ep.client.PlugInProxyFactory;
import com.kingdee.eas.ep.client.UIParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.IObjectBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.service.PrintServiceSet;
import com.kingdee.eas.framework.util.StringUtility;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class BTPRelationNavUI
extends AbstractBTPRelationNavUI {
    private static Logger logger = Logger.getLogger(BTPRelationNavUI.class);
    private static final String multiLangResources = "com.kingdee.eas.base.botp.client.BOTP.";
    protected Map tabMaps = new HashMap();
    private String billInfoID = null;
    private List entryIDs = null;
    private Vector BOSTypeVector = new Vector();
    private ListUI curentBillListUI = null;
    private String sourceEntryIdProName = null;
    private static final String RESXFILENAME = "com.kingdee.eas.base.btp.btpResource";
    private static String handlerName = "com.kingdee.eas.base.btp.app.BTPRelationNavUIHandler";
    private static String botRelationQueryPK = "com.kingdee.bos.metadata.bot.app.BotRelationQuery";
    private Hashtable billTypes = null;
    private Hashtable entryTypes = null;
    private Map billTitle = new HashMap();
    private boolean isNeedRefreshTab = false;
    private Map<String, Boolean> hasRefreshTab = new HashMap<String, Boolean>();
    protected KDWorkButton btnDesensitization = null;
    private String RELATIVE_BILL_ID;
    private String RELATIVE_BILL_ENTRYID;
    private String RELATIVE_BILL_TYPE;
    private String CURRENT_BILL_ID;
    private String CURRENT_ENTRY_ID;
    private Hashtable newBillTypes = new Hashtable();

    private void initPropertyNameByFindType() {
        if (this.isTraceDown()) {
            this.RELATIVE_BILL_ID = "destObjectID";
            this.RELATIVE_BILL_TYPE = "destEntityID";
            this.RELATIVE_BILL_ENTRYID = "relationEntries.destEntryID";
            this.CURRENT_BILL_ID = "srcObjectID";
            this.CURRENT_ENTRY_ID = "relationEntries.srcEntryID";
        } else {
            this.RELATIVE_BILL_ID = "srcObjectID";
            this.RELATIVE_BILL_TYPE = "srcEntityID";
            this.RELATIVE_BILL_ENTRYID = "relationEntries.srcEntryID";
            this.CURRENT_BILL_ID = "destObjectID";
            this.CURRENT_ENTRY_ID = "relationEntries.destEntryID";
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.KDBtNext.setIcon(EASResource.getIcon((String)"imgTbtn_downview"));
        this.KDBtPrev.setIcon(EASResource.getIcon((String)"imgTbtn_topview"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionAttachment.setEnabled(false);
        this.actionAttachment.setVisible(false);
        this.actionSubmit.setEnabled(false);
    }

    public boolean isViewRelateEntry() {
        try {
            String value = ParamManager.getParamValue(null, null, (String)"BOTP_VIEWRELATEENTRY");
            if ("TRUE".equalsIgnoreCase(value)) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public void onLoad() throws Exception {
        this.billInfoID = (String)this.getUIContext().get("billInfoID");
        this.entryIDs = (List)this.getUIContext().get("selectedEntries");
        this.tpRelatedBills.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                BTPRelationNavUI.this.curentBillListUI = null;
                KDTabbedPane tabpane = (KDTabbedPane)e.getSource();
                KDPanel panel = (KDPanel)tabpane.getSelectedComponent();
                if (panel != null && panel.getComponents().length > 0 && panel.getComponent(0) != null && panel.getComponent(0) instanceof ListUI) {
                    BTPRelationNavUI.this.curentBillListUI = (ListUI)panel.getComponent(0);
                    if (BTPRelationNavUI.this.isNeedRefreshTab) {
                        int currentSelectedIndex = BTPRelationNavUI.this.tpRelatedBills.getSelectedIndex();
                        TabRelationNavData navData = (TabRelationNavData)BTPRelationNavUI.this.tabMaps.get(new Integer(currentSelectedIndex));
                        String bostype = navData.getBosType();
                        BTPRelationNavUI.this.hideUnSelectEntry((CoreBillListUI)BTPRelationNavUI.this.curentBillListUI, bostype);
                        BTPRelationNavUI.this.hasRefreshTab.put(bostype, true);
                        Set keySet = BTPRelationNavUI.this.hasRefreshTab.keySet();
                        Iterator iterator = keySet.iterator();
                        boolean flag = true;
                        while (iterator.hasNext()) {
                            String next = (String)iterator.next();
                            Boolean hasRefresh = (Boolean)BTPRelationNavUI.this.hasRefreshTab.get(next);
                            if (hasRefresh.booleanValue()) continue;
                            flag = false;
                            break;
                        }
                        if (!flag) {
                            BTPRelationNavUI.this.isNeedRefreshTab = true;
                        } else {
                            BTPRelationNavUI.this.isNeedRefreshTab = false;
                        }
                    }
                }
            }
        });
        this.tpRelatedBills.addChangeListener((ChangeListener)new TabbedPaneChangeEventHandler());
        this.init();
        this.btnIncludeRelativeEntry.setSelected(this.isViewRelateEntry());
        if (this.entryIDs == null) {
            this.btnIncludeRelativeEntry.setEnabled(false);
            this.btnIncludeRelativeEntry.setVisible(false);
        } else {
            this.btnIncludeRelativeEntry.setEnabled(true);
            this.btnIncludeRelativeEntry.setVisible(true);
        }
    }

    private void init() throws Exception {
        this.billTypes = new Hashtable();
        this.entryTypes = new Hashtable();
        this.initPropertyNameByFindType();
        this.prefindBill();
        Iterator itr = this.billTypes.keySet().iterator();
        String bostype = null;
        boolean hasBill = false;
        while (itr.hasNext()) {
            bostype = (String)itr.next();
            this.getNavBillIDsByBostype(bostype);
            if (this.billTypes.get(bostype) == null || ((Vector)this.billTypes.get(bostype)).size() <= 0) continue;
            hasBill = true;
        }
        if (!hasBill) {
            this.throwNoBillError();
        }
        this.refreshTP();
        this.loadBtnDesensitization();
    }

    private void prefindBill() throws Exception {
        if (this.billTypes == null) {
            this.billTypes = new Hashtable();
        }
        Vector tmpVecForRelation = new Vector();
        IRowSet rs = null;
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(botRelationQueryPK));
        EntityViewInfo viewInfo = this.getEntityView4Nav(false);
        viewInfo.setSelector(this.getDefaultSelector());
        exec.setObjectView(viewInfo);
        rs = exec.executeQuery();
        if (rs != null && rs.size() > 0) {
            while (rs.next()) {
                String relativeBillId = rs.getString(this.RELATIVE_BILL_ID).toString();
                String BOSTypeString = BOSUuid.read((String)relativeBillId).getType().toString();
                if (this.newBillTypes.size() == 0) {
                    tmpVecForRelation.add(relativeBillId);
                    this.newBillTypes.put(BOSTypeString, tmpVecForRelation);
                } else if (!this.newBillTypes.containsKey(BOSTypeString)) {
                    Vector<String> newTmpVecForRelation = new Vector<String>();
                    newTmpVecForRelation.add(relativeBillId);
                    this.newBillTypes.put(BOSTypeString, newTmpVecForRelation);
                } else if (((Vector)this.newBillTypes.get(BOSTypeString)).indexOf(relativeBillId) < 0) {
                    tmpVecForRelation = (Vector)this.newBillTypes.get(BOSTypeString);
                    tmpVecForRelation.add(relativeBillId);
                    this.newBillTypes.put(BOSTypeString, tmpVecForRelation);
                }
                if (this.billTypes.containsKey(BOSTypeString)) continue;
                Vector vector = new Vector();
                this.billTypes.put(BOSTypeString, vector);
                this.getBOTPBillUITitleByID(relativeBillId);
            }
        } else {
            this.throwNoBillError();
        }
    }

    private EntityViewInfo getEntityView4Nav(boolean bCheckEntry) {
        Map btpNavCtx;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer markString = new StringBuffer("");
        int entriesNum = 0;
        if (this.entryIDs != null) {
            entriesNum = this.entryIDs.size();
        }
        filter.getFilterItems().add(new FilterItemInfo(this.CURRENT_BILL_ID, (Object)this.billInfoID, CompareType.EQUALS));
        markString.append("#0 ");
        int step = 1;
        if (this.getUIContext().get("BTPNAVCTX") != null && (btpNavCtx = this.getBizContext()).get("NAVBOSTYPE") != null) {
            String srcBosType = btpNavCtx.get("NAVBOSTYPE").toString();
            filter.getFilterItems().add(new FilterItemInfo(this.RELATIVE_BILL_TYPE, (Object)srcBosType));
            markString.append(" and #1");
            ++step;
        }
        if (bCheckEntry && entriesNum > 0) {
            markString.append(" and (");
            markString.append("#" + step + " )");
            ++step;
            filter.getFilterItems().add(new FilterItemInfo("relationEntries.srcEntryPropName", (Object)"__src", CompareType.NOTEQUALS));
            markString.append(" and (");
            filter.getFilterItems().add(new FilterItemInfo(this.CURRENT_ENTRY_ID, (Object)"XXXXXX BOTP XXXXXX"));
            markString.append("#" + step + " or ");
            filter.getFilterItems().add(new FilterItemInfo(this.CURRENT_ENTRY_ID, (Object)this.billInfoID, CompareType.EQUALS));
            markString.append("#" + ++step + " or ");
            ++step;
            for (int i = 0; i < entriesNum; ++i) {
                filter.getFilterItems().add(new FilterItemInfo(this.CURRENT_ENTRY_ID, (Object)this.entryIDs.get(i).toString(), CompareType.EQUALS));
                if (i == entriesNum - 1) {
                    markString.append("#" + (i + step) + " ");
                    markString.append(")");
                    continue;
                }
                markString.append("#" + (i + step) + " or  ");
            }
        }
        filter.setMaskString(markString.toString());
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private void refreshTP() throws Exception {
        block27: {
            int compnentNum;
            this.tabMaps.clear();
            for (int i = compnentNum = this.tpRelatedBills.getTabCount(); i > 0; --i) {
                Component obj = this.tpRelatedBills.getComponentAt(i - 1);
                if (obj != null && obj instanceof ListUI) {
                    ((ListUI)obj).destroyWindow();
                }
                this.tpRelatedBills.remove(i - 1);
            }
            this.BOSTypeVector = new Vector();
            Iterator itr = this.billTypes.keySet().iterator();
            int curIndex = 0;
            String displayString = null;
            String listUIName = null;
            while (itr.hasNext()) {
                String bostype = (String)itr.next();
                this.BOSTypeVector.add(bostype);
                IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
                EntityObjectInfo tempObj = loader.getEntity(BOSObjectType.create((String)bostype));
                displayString = tempObj.getAlias();
                if (this.billTitle.containsKey(bostype)) {
                    displayString = this.billTitle.get(bostype).toString();
                }
                listUIName = tempObj.getExtendedProperty("listUI") == null ? null : tempObj.getExtendedProperty("listUI").toString();
                try {
                    Class<?> listUIClass = Class.forName(listUIName);
                    displayString = (String)BOTPTools.invokeDynMethod(listUIClass.newInstance(), "getUITitle", null, null);
                }
                catch (Exception e) {
                    logger.error((Object)"error occurs when getting ListUI's title");
                }
                if (listUIName != null && listUIName.trim().length() > 0) {
                    KDPanel panel = new KDPanel(false);
                    panel.setBounds(new Rectangle(10, 10, 780, 570));
                    panel.setBackground(Color.RED);
                    this.tpRelatedBills.addTab(displayString, (Component)panel);
                    TabRelationNavData navData = new TabRelationNavData();
                    navData.setEnityAlias(displayString);
                    navData.setListUIName(listUIName);
                    HashMap uiCtx = new HashMap();
                    uiCtx.put("OwnerWindow", this.getUIContext().get("OwnerWindow"));
                    uiCtx.put("BOTPViewStatus", new Integer(1));
                    if (this.getBizContext() != null) {
                        uiCtx.put("BTPNAVCTX", this.getBizContext());
                    }
                    uiCtx.put("EAS_UI_NOPERMISSION_ABORT", false);
                    navData.setUiCtx(uiCtx);
                    navData.setPanel(panel);
                    navData.setBosType(bostype);
                    this.tabMaps.put(new Integer(curIndex), navData);
                    ++curIndex;
                    continue;
                }
                String isSupportWeb = tempObj.getExtendedProperty("isSupportWeb");
                if ("true".equals(isSupportWeb)) {
                    MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.base.botp.client.BOTP.queryInBrowser") + displayString));
                    continue;
                }
                MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.base.botp.client.BOTP.listui1") + displayString + EASResource.getString((String)"com.kingdee.eas.base.botp.client.BOTP.listui2")));
            }
            ArrayList<Integer> removeIndex = new ArrayList<Integer>();
            ArrayList<String> removeBOSType = new ArrayList<String>();
            try {
                SysContext sysContext = (SysContext)this.getUIContext().get("sysContext");
                ObjectUuidPK userPK = new ObjectUuidPK(sysContext.getCurrentUserInfo().getId().toString());
                MetaDataPK actionPK = new MetaDataPK("ActionOnLoad");
                int navBosTypeSize = this.tabMaps.keySet().size();
                TabRelationNavData navData = null;
                ObjectUuidPK orgPK = null;
                ObjectUuidPK dataPK = null;
                block12: for (int i = 0; i < navBosTypeSize; ++i) {
                    OrgType mainType = null;
                    Method method = null;
                    CoreBillBaseInfo billForGetBizDefineUI = null;
                    navData = (TabRelationNavData)this.tabMaps.get(i);
                    String listUINameStr = navData.getListUIName();
                    MetaDataPK uiPK = new MetaDataPK(listUINameStr);
                    ListUI billListUI = (ListUI)PlugInProxyFactory.createUIObject((String)listUINameStr, (UIParam)new UIParam());
                    Class<?> clazz = billListUI.getClass();
                    while (method == null && clazz != CoreBillListUI.class) {
                        try {
                            method = clazz.getDeclaredMethod("getMainBizOrgType", new Class[0]);
                            method.setAccessible(true);
                        }
                        catch (Exception e) {
                            clazz = clazz.getSuperclass();
                        }
                    }
                    if (method != null && billListUI != null) {
                        mainType = (OrgType)method.invoke((Object)billListUI, new Object[0]);
                    }
                    orgPK = mainType == null ? new ObjectUuidPK(sysContext.getCurrentCtrlUnit().getId().toString()) : new ObjectUuidPK(sysContext.getCurrentOrgUnit(mainType).getId().toString());
                    Vector billIDList = (Vector)this.billTypes.get(navData.getBosType().toString());
                    for (int j = 0; j < billIDList.size(); ++j) {
                        dataPK = new ObjectUuidPK(((String)billIDList.get(j)).toString());
                        BOSObjectType bostype = dataPK.getObjectType();
                        try {
                            String listUI;
                            SelectorItemCollection sic = new SelectorItemCollection();
                            sic.add("id");
                            IObjectBase iObjectBase = (IObjectBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bostype, IObjectBase.class);
                            CoreBaseInfo value = iObjectBase.getValue((IObjectPK)dataPK);
                            if (value instanceof CoreBillBaseInfo && billForGetBizDefineUI == null && !StringUtils.isEmpty((String)(listUI = (billForGetBizDefineUI = (CoreBillBaseInfo)value).getBOTPListUI()))) {
                                navData.setListUIName(listUI);
                            }
                            PermissionFactory.getRemoteInstance().checkDataPermission((IObjectPK)userPK, (IObjectPK)orgPK, (IMetaDataPK)uiPK, (IMetaDataPK)actionPK, (IObjectPK)dataPK);
                            continue block12;
                        }
                        catch (Exception e) {
                            logger.error((Object)("fail to getBill! bostype:" + bostype.toString() + ";billID:" + (String)billIDList.get(j) + ";" + e.getMessage()));
                            if (j != billIDList.size() - 1) continue;
                            removeIndex.add(i);
                            removeBOSType.add(navData.getBosType().toString());
                            continue;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (removeIndex.size() > 0 && removeBOSType.size() > 0) {
                for (int i = 0; i < removeIndex.size(); ++i) {
                    this.tabMaps.remove(removeIndex.get(i));
                    this.billTypes.remove(removeBOSType.get(i));
                    this.tpRelatedBills.removeTabAt((Integer)removeIndex.get(i) - i);
                }
                if (this.billTypes.size() == 0) {
                    throw new BTPException(BTPException.DESTBILLNOACCESS);
                }
                Set keySet = this.tabMaps.keySet();
                HashMap<Integer, TabRelationNavData> newTabMaps = new HashMap<Integer, TabRelationNavData>();
                Iterator iterator = keySet.iterator();
                int key = 0;
                while (iterator.hasNext()) {
                    Integer index = (Integer)iterator.next();
                    TabRelationNavData navData = (TabRelationNavData)this.tabMaps.get(index);
                    newTabMaps.put(key, navData);
                    ++key;
                }
                this.tabMaps = newTabMaps;
            }
            try {
                this.loadTabBillListUI(0);
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
                if (this.billTypes.size() != 1) break block27;
                SysUtil.abort();
            }
        }
        if (this.innerGetListUIComponent() != null && this.innerGetListUIComponent() instanceof ListUI) {
            this.curentBillListUI = (ListUI)this.innerGetListUIComponent();
        }
    }

    private void getNavBillIDsByBostype(String bostype) throws EASBizException, BOSException, SQLException {
        BOSObjectType curBostype = BOSUuid.getBOSObjectType((String)this.billInfoID, (boolean)true);
        boolean needSaveEntries = this.isNeedSaveEntries(BOSObjectType.create((String)bostype), curBostype);
        IRowSet rs = null;
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.bos.metadata.bot.app.BotRelationQuery"));
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem(this.RELATIVE_BILL_TYPE, (Object)bostype);
        List<String> navEntryIdList = new ArrayList<String>();
        EntityViewInfo viewInfo = this.getEntityView4Nav(true);
        viewInfo.setSelector(this.getDefaultSelector());
        viewInfo.getFilter().mergeFilter(filter, "and");
        exec.setObjectView(viewInfo);
        rs = exec.executeQuery();
        Vector<String> tmpVecForRelation = new Vector<String>();
        if (rs != null && rs.size() > 0) {
            while (rs.next()) {
                tmpVecForRelation.add(rs.getString(this.RELATIVE_BILL_ID));
                String entryid = rs.getString(this.RELATIVE_BILL_ENTRYID);
                if (entryid == null) continue;
                navEntryIdList.add(rs.getString(this.RELATIVE_BILL_ENTRYID));
            }
            this.billTypes.put(bostype, tmpVecForRelation);
            if (curBostype != null && !"2652E01E".equals(curBostype.toString()) && !"2652E01E".equals(bostype.toString())) {
                this.entryTypes.put(bostype, navEntryIdList);
            }
            if (this.isTraceDown()) {
                String sql = "select fdestobjectid from t_bot_relation where fsrcobjectid ='" + this.billInfoID + "' and fdestEntityID='" + bostype + "' and fid not in (select fkeyid from t_bot_relationentry where fsrcEntryPropName <> '__src')";
                SQLExecutor se = new SQLExecutor(sql);
                IRowSet rowset = se.executeSQL();
                while (rowset.next()) {
                    tmpVecForRelation.add(rowset.getString("fdestobjectid"));
                }
            }
            return;
        }
        Vector ignoreEntryVec = new Vector();
        viewInfo = this.getEntityView4Nav(false);
        viewInfo.getFilter().mergeFilter(filter, "and");
        exec.setObjectView(viewInfo);
        rs = exec.executeQuery();
        if (rs != null) {
            while (rs.next()) {
                ignoreEntryVec.add(rs.getString(this.RELATIVE_BILL_ID));
            }
        }
        if (this.getBizContext().get("igornEntryRelation") == null && !needSaveEntries && !"2652E01E".equals(bostype)) {
            Vector v;
            Map destBillMap;
            Vector tmpCloneVec = (Vector)ignoreEntryVec.clone();
            if (!this.isTraceDown()) {
                if (this.getUIContext().get("sourceEntryIdProName") != null) {
                    this.sourceEntryIdProName = this.getUIContext().get("sourceEntryIdProName").toString();
                }
                destBillMap = BTPManagerFactory.getRemoteInstance().traceUpBillFilter((IObjectPK)new ObjectUuidPK(this.billInfoID), this.sourceEntryIdProName, this.entryIDs, ignoreEntryVec);
            } else {
                destBillMap = BTPManagerFactory.getRemoteInstance().traceDownBillFilter((IObjectPK)new ObjectUuidPK(this.billInfoID), this.entryIDs, ignoreEntryVec);
            }
            if (destBillMap != null && (v = (Vector)destBillMap.get("navBillidList")) != null && v.size() > 0) {
                ignoreEntryVec = (Vector)destBillMap.get("navBillidList");
                navEntryIdList = (List)destBillMap.get("navEntryIDList");
            }
            if (ignoreEntryVec.size() > 0) {
                ignoreEntryVec.addAll(tmpVecForRelation);
                ((Vector)this.billTypes.get(bostype)).addAll(ignoreEntryVec);
                if (navEntryIdList != null && navEntryIdList.size() > 0) {
                    this.entryTypes.put(bostype, navEntryIdList);
                }
            } else {
                tmpCloneVec.addAll(tmpVecForRelation);
                ((Vector)this.billTypes.get(bostype)).addAll(tmpCloneVec);
            }
        } else {
            ignoreEntryVec.addAll(tmpVecForRelation);
            this.billTypes.put(bostype, ignoreEntryVec);
        }
    }

    private void getBOTPBillUITitleByID(String billID) throws Exception {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        String listui = null;
        BOSObjectType bostype = null;
        try {
            bostype = BOSUuid.getBOSObjectType((String)billID, (boolean)true);
            EntityObjectInfo tempObj = loader.getEntity(bostype);
            listui = tempObj.getExtendedProperty("listUI") == null ? null : tempObj.getExtendedProperty("listUI").toString();
        }
        catch (Exception e) {
            logger.error((Object)"error when getExtendedProperty()");
            return;
        }
        if (listui != null) {
            try {
                String title;
                Class<?> listUIClass = Class.forName(listui);
                Object uiObject = listUIClass.newInstance();
                if (uiObject instanceof CoreBillListUI && (title = ((CoreBillListUI)uiObject).getBOTPBillUITitleByID(billID)) != null) {
                    this.billTitle.put(bostype.toString(), title.toString());
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                if (e instanceof AbortException) {
                    throw e;
                }
                logger.error((Object)"error invoke method getBOTPBillUITitleByID");
            }
        }
    }

    private EntityViewInfo getEntityObjectInfo4Trace(String bostype, String listUIName, Vector idList) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (bostype == null || idList == null) {
            return entityViewInfo;
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo tempObj = loader.getEntity(BOSObjectType.create((String)bostype));
        IMetaDataPK pk = null;
        String fieldName = "id";
        boolean fetchPK = false;
        if (pk != null) {
            try {
                QueryInfo queryInfo = loader.getQuery(pk);
                QueryFieldCollection fields = queryInfo.getUnits().getQueryFields();
                for (int i = 0; i < fields.size(); ++i) {
                    QueryFieldInfo field = fields.get(i);
                    if (field.getPropertyRefs().get(0).getSubEntity() == null || field.getPropertyRefs().get(0).getRefProperty() == null || fetchPK || !field.getPropertyRefs().get(0).getSubEntity().getEntityRef().equals((Object)tempObj) || !field.getPropertyRefs().get(0).getRefProperty().getName().equals("id")) continue;
                    fieldName = field.getName().toString();
                    fetchPK = true;
                }
            }
            catch (Exception e) {
                logger.error((Object)"error when getEntityObjectInfo4Trace");
            }
        }
        String strIdLists = StringUtils.arrayToString((Object[])idList.toArray(), (String)",");
        filter.getFilterItems().add(new FilterItemInfo(fieldName, (Object)strIdLists, CompareType.INCLUDE));
        entityViewInfo.setFilter(filter);
        return entityViewInfo;
    }

    private void loadTabBillListUI(int index) throws Exception {
        String entityAlias = "";
        String listUIName = "";
        Map uiCtx = null;
        KDPanel panel = null;
        EntityViewInfo botpFilter = null;
        TabRelationNavData navData = (TabRelationNavData)this.tabMaps.get(new Integer(index));
        if (navData == null || navData.isInited()) {
            return;
        }
        if (navData.getBotpFilter() == null) {
            this.getNavBillIDsByBostype(navData.getBosType());
            String bostype = navData.getBosType();
            Vector vec = (Vector)this.billTypes.get(bostype);
            if (vec == null || vec.size() == 0) {
                MsgBox.showWarning((String)MessageFormat.format(EASResource.getString((String)RESXFILENAME, (String)"noRelateBills"), navData.getEnityAlias()));
                SysUtil.abort();
            }
            botpFilter = this.getEntityObjectInfo4Trace(bostype, navData.getListUIName(), (Vector)this.billTypes.get(bostype));
            uiCtx = navData.getUiCtx();
            uiCtx.put("BOTPFilter", botpFilter);
            navData.setBotpFilter(botpFilter);
        }
        entityAlias = navData.getEnityAlias();
        listUIName = navData.getListUIName();
        botpFilter = navData.getBotpFilter();
        panel = navData.getPanel();
        panel.removeAll();
        navData.setInited(true);
        IObjectPK userPK = this.getUserPk();
        IObjectPK orgPK = this.getOrgPK(null);
        MetaDataPK actionPK = new MetaDataPK("ActionOnLoad");
        MetaDataPK metaPK = new MetaDataPK(listUIName);
        try {
            try {
                String paramCount = ParamManager.getParamValue(null, (String)"BOTP_NAV_MaxReturnRowCount");
                int maxReturnRowCount = new Integer(paramCount);
                uiCtx.put("maxReturnRowCount", maxReturnRowCount);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ListUI billListUI = (ListUI)UIFactoryHelper.initUIObject((String)listUIName, (Map)uiCtx, null, (String)"FINDVIEW");
            panel.setLayout((LayoutManager)new BorderLayout());
            billListUI.getUIContentPane().setSize(new Dimension(790, 580));
            KDTable kdTable = billListUI.getMainTable();
            kdTable.setBounds(new Rectangle(10, 10, 780, 570));
            billListUI.setVisible(true);
            panel.add((Component)billListUI, (Object)"Center");
            panel.validate();
            if (billListUI instanceof CoreBillListUI) {
                this.hideUnSelectEntry((CoreBillListUI)billListUI, navData.getBosType());
            }
        }
        catch (UIException e) {
            logger.error((Object)("BOTP navigate faild!    listUIName=" + listUIName + ",  botpFilter=" + botpFilter), (Throwable)e);
            Throwable t = e.getCause();
            if (t == null || t instanceof AbortException) {
                throw e;
            }
            if (t instanceof PermissionException || t.getCause() != null && t.getCause() instanceof PermissionException) {
                throw new BOTPException(BOTPException.NOLISTPERM, new Object[]{entityAlias});
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        logger.info((Object)("BOTP navigate finished!    listUIName=" + listUIName + ",  botpFilter=" + botpFilter));
    }

    private void loadBtnDesensitization() {
        this.toolBar.remove((Component)this.btnDesensitization);
        this.btnDesensitization = null;
        if (this.innerGetListUIComponent() != null && this.innerGetListUIComponent() instanceof ListUI) {
            ListUI listUI = (ListUI)this.innerGetListUIComponent();
            this.btnDesensitization = listUI.getBtnDesensitization();
            if (this.btnDesensitization != null) {
                this.toolBar.addComponentAfterComponent((Component)this.btnDesensitization, (Component)this.KDBtNext);
            }
        }
        this.toolBar.doLayout();
        this.toolBar.repaint();
    }

    protected void validateTree() {
        super.validateTree();
        try {
            this.btnIncludeRelativeEntry_itemStateChanged(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hideUnSelectEntry(CoreBillListUI billListUI, String bostype) {
        KDTable kdTable = billListUI.getMainTable();
        String entryName = billListUI.getEntriesPKName();
        List navEntryIdList = (List)this.entryTypes.get(bostype);
        if (navEntryIdList != null && navEntryIdList.size() > 0) {
            ArrayList<BOSObjectType> entryBosType = new ArrayList<BOSObjectType>();
            for (int i = 0; i < kdTable.getRowCount(); ++i) {
                String entryId;
                BOSObjectType bosType;
                ICell cell = kdTable.getRow(i).getCell(entryName);
                if (cell == null || cell.getValue() == null || (bosType = BOSUuid.getBOSObjectType((String)(entryId = cell.getValue().toString()), (boolean)true)) == null || entryBosType.contains(bosType)) continue;
                entryBosType.add(bosType);
            }
            boolean flag = false;
            for (int j = 0; j < navEntryIdList.size(); ++j) {
                String navEntryId = navEntryIdList.get(j).toString();
                BOSObjectType navEntryBosType = BOSUuid.getBOSObjectType((String)navEntryId, (boolean)true);
                if (!entryBosType.contains(navEntryBosType)) continue;
                flag = true;
                break;
            }
            if (!flag) {
                return;
            }
            for (int i = 0; i < kdTable.getRowCount(); ++i) {
                ICell cell = kdTable.getRow(i).getCell(entryName);
                if (cell == null || cell.getValue() == null) continue;
                String entryId = cell.getValue().toString();
                boolean include = false;
                for (int j = 0; j < navEntryIdList.size(); ++j) {
                    if (!entryId.equals(navEntryIdList.get(j).toString())) continue;
                    include = true;
                    break;
                }
                if (!include && this.btnIncludeRelativeEntry.isSelected()) {
                    kdTable.getRow(i).getStyleAttributes().setHided(true);
                    continue;
                }
                kdTable.getRow(i).getStyleAttributes().setHided(false);
            }
            this.appendFootRow(billListUI);
        } else if (this.entryIDs != null && this.entryIDs.size() > 0) {
            for (int i = 0; i < kdTable.getRowCount(); ++i) {
                if (this.btnIncludeRelativeEntry.isSelected()) {
                    kdTable.getRow(i).getStyleAttributes().setHided(true);
                    continue;
                }
                kdTable.getRow(i).getStyleAttributes().setHided(false);
            }
            this.appendFootRow(billListUI);
        }
    }

    private Component innerGetListUIComponent() {
        if (this.tpRelatedBills == null || (KDPanel)this.tpRelatedBills.getSelectedComponent() == null || ((KDPanel)this.tpRelatedBills.getSelectedComponent()).getComponentCount() <= 0) {
            return null;
        }
        return ((KDPanel)this.tpRelatedBills.getSelectedComponent()).getComponent(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getSelectedBillID() throws BTPException, Exception {
        HashMap columnFieldTOName = new HashMap();
        HashMap columnNameTOField = new HashMap();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        if (this.innerGetListUIComponent() == null) throw new BTPException(BTPException.NOSELECTROW);
        ListUI billListUI = (ListUI)this.innerGetListUIComponent();
        KDTable kdTable = billListUI.getMainTable();
        this.getColumnFieldNameVector(kdTable, columnFieldTOName, columnNameTOField);
        if (kdTable.getSelectManager().getActiveRowIndex() < 0) throw new BTPException(BTPException.NOSELECTROW);
        String selectedBOSType = (String)this.BOSTypeVector.get(this.tpRelatedBills.getSelectedIndex());
        IRow iRow = kdTable.getRow(kdTable.getSelectManager().getActiveRowIndex());
        EntityObjectInfo tempObj = loader.getEntity(BOSObjectType.create((String)selectedBOSType));
        QueryInfo queryInfo = loader.getQuery(billListUI.getMainQueryPK());
        String fieldName = "id";
        QueryFieldCollection fields = queryInfo.getUnits().getQueryFields();
        for (int i = 0; i < fields.size(); ++i) {
            QueryFieldInfo field = fields.get(i);
            if (!field.getPropertyRefs().get(0).getSubEntity().getEntityRef().equals((Object)tempObj) || !field.getPropertyRefs().get(0).getRefProperty().getName().equals("id")) continue;
            fieldName = field.getName().toString();
            break;
        }
        this.billInfoID = iRow.getCell((String)columnFieldTOName.get(fieldName)).getValue().toString();
        this.entryIDs = new ArrayList();
        ArrayList idList = new ArrayList();
        String sourceBillEntryId = null;
        this.sourceEntryIdProName = null;
        if (this.innerGetListUIComponent() instanceof CoreBillListUI) {
            ((CoreBillListUI)this.innerGetListUIComponent()).getBillIdList(idList, this.entryIDs);
            sourceBillEntryId = ((CoreBillListUI)this.innerGetListUIComponent()).getsourceBillEntryId();
        }
        this.getUIContext().put("sourceEntryIdProName", sourceBillEntryId);
    }

    private void getColumnFieldNameVector(KDTable kdTable, HashMap columnFieldTOName, HashMap columnNameTOField) {
        for (int i = 0; i < kdTable.getColumnCount(); ++i) {
            columnFieldTOName.put(kdTable.getColumn(i).getFieldName(), kdTable.getColumn(i).getKey());
            columnNameTOField.put(kdTable.getColumn(i).getKey(), kdTable.getColumn(i).getFieldName());
        }
    }

    @Override
    public void actionNavView_actionPerformed(ActionEvent e) throws Exception {
        if (this.curentBillListUI != null && this.curentBillListUI.getTableForBOTP().getRowCount() > 0) {
            this.curentBillListUI.actionView_actionPerformed(e);
        }
    }

    @Override
    public void actionViewNext_actionPerformed(ActionEvent e) throws Exception {
        if (this.innerGetListUIComponent() == null) {
            throw new BTPException(BTPException.NOSELECTROW);
        }
        Class<?> listUIclass = this.innerGetListUIComponent().getClass();
        try {
            Method method = listUIclass.getMethod("actionTraceDown_actionPerformed", ActionEvent.class);
            method.invoke((Object)this.innerGetListUIComponent(), e);
            this.getUIWindow().close();
        }
        catch (InvocationTargetException ee) {
            if (ee.getTargetException() instanceof AbortException) {
                SysUtil.abort();
            }
            throw new Exception(ee.getTargetException());
        }
        catch (NoSuchMethodException ee) {
            this.getUIContext().put("findType", 1);
            this.getSelectedBillID();
            this.init();
        }
    }

    @Override
    public void actionViewPrev_actionPerformed(ActionEvent e) throws Exception {
        if (this.innerGetListUIComponent() == null) {
            throw new BTPException(BTPException.NOSELECTROW);
        }
        Class<?> listUIclass = this.innerGetListUIComponent().getClass();
        try {
            Method method = listUIclass.getMethod("actionTraceUp_actionPerformed", ActionEvent.class);
            method.invoke((Object)this.innerGetListUIComponent(), e);
            this.getUIWindow().close();
        }
        catch (InvocationTargetException ee) {
            if (ee.getTargetException() instanceof AbortException) {
                SysUtil.abort();
            }
            throw new Exception(ee.getTargetException());
        }
        catch (NoSuchMethodException ee) {
            this.getUIContext().put("findType", 0);
            this.getSelectedBillID();
            this.init();
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.curentBillListUI != null && this.curentBillListUI.getMainTable() != null) {
            PrintServiceSet printService = new PrintServiceSet((CoreUI)this.curentBillListUI);
            printService.preparePrintPage(this.curentBillListUI.getMainTable());
            this.curentBillListUI.getMainTable().getPrintManager().print();
        }
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (this.curentBillListUI != null && this.curentBillListUI.getMainTable() != null) {
            PrintServiceSet printService = new PrintServiceSet((CoreUI)this.curentBillListUI);
            printService.preparePrintPage(this.curentBillListUI.getMainTable());
            this.curentBillListUI.getMainTable().getPrintManager().printPreview();
        }
    }

    public boolean destroyWindow() {
        int count = this.tpRelatedBills.getTabCount();
        for (int i = 0; i < count; ++i) {
            Component obj = this.tpRelatedBills.getComponentAt(i);
            if (obj == null || !(obj instanceof ListUI)) continue;
            ((ListUI)obj).destroyWindow();
        }
        return super.destroyWindow();
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public RequestContext prepareAction(RequestContext request) throws Exception {
        RequestContext superRequest = (RequestContext)super.prepareInit().getRequestContext();
        request.putAll(superRequest);
        request.setReleasNet(true);
        request.setNetParam((MutexParameter)this.getUIContext().get("MUTEXPARA"));
        return request;
    }

    public IUIActionPostman prepareRPC(RequestContext request) {
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        handler.setAvailabe(true);
        request.setClassName(handlerName);
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    @Override
    public RequestContext prepareActionViewPrev(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionViewPrev(itemAction);
        return request;
    }

    @Override
    public RequestContext prepareActionViewNext(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionViewPrev(itemAction);
        return request;
    }

    private boolean isNeedSaveEntries(BOSObjectType srcBosType, BOSObjectType destBosType) throws EASBizException, BOSException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo srcEntity = loader.getEntity(srcBosType);
        EntityObjectInfo destEntity = loader.getEntity(destBosType);
        return BOTPTools.getExtendPropertyBooleanValue(null, srcEntity, "IsSaveBotpEntryRelation", true) || BOTPTools.getExtendPropertyBooleanValue(null, destEntity, "IsSaveBotpEntryRelation", true);
    }

    private Map getBizContext() {
        return (Map)this.getUIContext().get("BTPNAVCTX");
    }

    private void throwNoBillError() throws BTPException {
        if (this.isTraceDown()) {
            throw new BTPException(BTPException.DESTBILLNULL);
        }
        throw new BTPException(BTPException.SRCBILLTYPENULL);
    }

    private boolean isTraceDown() {
        if (this.getUIContext().get("findType") != null) {
            return new Integer(1).equals(new Integer(this.getUIContext().get("findType").toString()));
        }
        return true;
    }

    private SelectorItemCollection getDefaultSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("srcObjectID");
        sic.add("destObjectID");
        sic.add("relationEntries.srcEntryID");
        sic.add("relationEntries.destEntryID");
        return sic;
    }

    @Override
    protected void btnIncludeRelativeEntry_itemStateChanged(ItemEvent e) throws Exception {
        try {
            this.isNeedRefreshTab = true;
            if (this.curentBillListUI instanceof CoreBillListUI) {
                int currentSelectedIndex = this.tpRelatedBills.getSelectedIndex();
                TabRelationNavData navData = (TabRelationNavData)this.tabMaps.get(new Integer(currentSelectedIndex));
                String bostype = navData.getBosType();
                this.hideUnSelectEntry((CoreBillListUI)this.curentBillListUI, bostype);
                Iterator iterator = this.tabMaps.keySet().iterator();
                while (iterator.hasNext()) {
                    int next = (Integer)iterator.next();
                    TabRelationNavData navData2 = (TabRelationNavData)this.tabMaps.get(next);
                    String bosType2 = navData2.getBosType();
                    if (bosType2.equals(bostype)) {
                        this.hasRefreshTab.put(bosType2, true);
                        continue;
                    }
                    this.hasRefreshTab.put(bosType2, false);
                }
            }
        }
        catch (Exception ee) {
            logger.error((Object)ee.getMessage());
        }
    }

    private void appendFootRow(CoreBillListUI billListUI) {
        HashMap<String, String> columnMap = new HashMap<String, String>();
        List fieldInfos = billListUI.getFieldSumList();
        KDTable kDTable1 = billListUI.getTableForBOTP();
        if (fieldInfos != null && fieldInfos.size() > 0) {
            for (String field : fieldInfos) {
                BigDecimal dbSum = new BigDecimal("0.00");
                String key = this.queryNameToKDTableName(billListUI.getTableForBOTP(), field);
                String[] mergeStr = billListUI.getMergeColumnKeys();
                boolean isMergeStr = false;
                if (mergeStr != null) {
                    for (int kk = 0; kk < mergeStr.length; ++kk) {
                        if (!key.equals(mergeStr[kk])) continue;
                        isMergeStr = true;
                        break;
                    }
                }
                HashSet<String> idsSet = new HashSet<String>();
                for (int r = 0; r <= kDTable1.getRowCount() - 1; ++r) {
                    String cellValue;
                    ICell cell;
                    IRow row = kDTable1.getRow(r);
                    if (row.getStyleAttributes().isHided() || (cell = row.getCell(key)) == null) continue;
                    if (isMergeStr) {
                        String billID = kDTable1.getCellDisplayText(kDTable1.getRow(r).getCell("id"));
                        if (idsSet.contains(billID)) continue;
                        idsSet.add(billID);
                    }
                    if ((cellValue = kDTable1.getCellDisplayText(cell)) != null) {
                        cellValue = cellValue.toString().replaceAll(",", "");
                    }
                    if (!StringUtility.isNumber((String)cellValue)) {
                        Object cellObj = cell.getValue();
                        if (cellObj != null) {
                            cellValue = cellObj.toString();
                        }
                        if (!StringUtility.isNumber((String)cellValue)) continue;
                    }
                    BigDecimal bigdem = new BigDecimal(String.valueOf(cellValue).trim());
                    dbSum = dbSum.add(bigdem);
                }
                String strSum = dbSum.toString();
                columnMap.put(key, strSum);
            }
            IRow footRow = null;
            KDTFootManager footRowManager = kDTable1.getFootManager();
            if (footRowManager == null) {
                footRowManager = new KDTFootManager(kDTable1);
                footRowManager.addFootView();
                kDTable1.setFootManager(footRowManager);
            }
            if ((footRow = footRowManager.getFootRow(0)) == null) {
                footRow = footRowManager.addFootRow(0);
            }
            String colFormat = "%{0.##########}f";
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            kDTable1.getIndexColumn().setWidthAdjustMode((short)1);
            kDTable1.getIndexColumn().setWidth(30);
            footRowManager.addIndexText(0, total);
            footRow.getStyleAttributes().setBackground(new Color(246, 246, 191));
            for (Map.Entry colEntry : columnMap.entrySet()) {
                if (colEntry.getKey() == null) continue;
                String strColName = String.valueOf(colEntry.getKey());
                String strColValue = (String)colEntry.getValue();
                if (footRow.getCell(strColName) == null) continue;
                footRow.getCell(strColName).setValue((Object)strColValue);
                footRow.getCell(strColName).getStyleAttributes().setNumberFormat(colFormat);
                footRow.getCell(strColName).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                footRow.getCell(strColName).getStyleAttributes().setFontColor(Color.BLACK);
            }
        }
    }

    private String queryNameToKDTableName(KDTable topTable, String queryFieldName) {
        String colNum = "";
        KDTColumns cols = topTable.getColumns();
        for (int i = 0; i <= topTable.getColumnCount() - 1; ++i) {
            KDTColumn col = cols.getColumn(i);
            if (col.getFieldName() == null || !col.getFieldName().equalsIgnoreCase(queryFieldName)) continue;
            colNum = col.getKey();
            break;
        }
        return colNum;
    }

    class TabRelationNavData {
        String enityAlias = "";
        String listUIName = "";
        String bostype = null;
        Map uiCtx = null;
        boolean inited = false;
        EntityViewInfo botpFilter = null;
        KDPanel panel = null;

        TabRelationNavData() {
        }

        public KDPanel getPanel() {
            return this.panel;
        }

        public void setPanel(KDPanel panel) {
            this.panel = panel;
        }

        public EntityViewInfo getBotpFilter() {
            return this.botpFilter;
        }

        public void setBotpFilter(EntityViewInfo botpFilter) {
            this.botpFilter = botpFilter;
        }

        public boolean isInited() {
            return this.inited;
        }

        public void setInited(boolean inited) {
            this.inited = inited;
        }

        public String getEnityAlias() {
            return this.enityAlias;
        }

        public void setEnityAlias(String enityAlias) {
            this.enityAlias = enityAlias;
        }

        public String getListUIName() {
            return this.listUIName;
        }

        public void setListUIName(String listUIName) {
            this.listUIName = listUIName;
        }

        public Map getUiCtx() {
            return this.uiCtx;
        }

        public void setUiCtx(Map uiCtx) {
            this.uiCtx = uiCtx;
        }

        public String getBosType() {
            return this.bostype;
        }

        public void setBosType(String bostype) {
            this.bostype = bostype;
        }
    }

    class TabbedPaneChangeEventHandler
    implements ChangeListener {
        TabbedPaneChangeEventHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            KDTabbedPane tabbedPane = (KDTabbedPane)e.getSource();
            int currentSelectedIndex = tabbedPane.getSelectedIndex();
            try {
                BTPRelationNavUI.this.loadTabBillListUI(currentSelectedIndex);
                BTPRelationNavUI.this.loadBtnDesensitization();
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Component)((Object)BTPRelationNavUI.this), (Throwable)ex);
                SysUtil.abort();
            }
        }
    }
}

